/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.concurrent.atomic.AtomicInteger;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyProvider;

public class IntegerPropertyProvider
implements PropertyProvider<Integer> {
    public final PropertyKey<Integer> key;
    public final AtomicInteger value;

    public IntegerPropertyProvider(PropertyKey<Integer> key) {
        this.key = key;
        this.value = new AtomicInteger(key.getDefaultValue());
    }

    public void reset() {
        this.value.set(this.key.getDefaultValue());
    }

    public int increment() {
        return this.value.incrementAndGet();
    }

    public int intValue() {
        return this.value.get();
    }

    @Override
    public Integer get() {
        return this.value.get();
    }

    @Override
    public Integer set(Integer value) {
        return this.value.getAndSet(value);
    }

    public String toString() {
        return this.value.toString();
    }
}

