/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.Comparator;

public class PropertyKey<T> {
    private final String name;
    private final Class<T> type;
    private final T defValue;
    private final boolean boundable;
    private final boolean readonly;
    public static Comparator<PropertyKey<?>> NAME_COMPARATOR = new Comparator<PropertyKey<?>>(){

        @Override
        public int compare(PropertyKey<?> o1, PropertyKey<?> o2) {
            return ((PropertyKey)o1).name.compareTo(((PropertyKey)o2).name);
        }
    };

    public static <T> Builder<T> builder(String name, Class<T> type) {
        return new Builder(name, type);
    }

    private PropertyKey(Builder<T> builder) {
        this.name = ((Builder)builder).name;
        this.type = ((Builder)builder).type;
        this.defValue = ((Builder)builder).defValue;
        this.boundable = ((Builder)builder).boundable;
        this.readonly = ((Builder)builder).readonly;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defValue;
    }

    public boolean isBoundable() {
        return this.boundable;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String toString() {
        return this.name;
    }

    public static class Builder<T> {
        private final String name;
        private final Class<T> type;
        private T defValue;
        private boolean boundable;
        private boolean readonly;

        private Builder(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        public T defaultValue() {
            return this.defValue;
        }

        public Builder<T> defaultValue(T defValue) {
            this.defValue = defValue;
            return this;
        }

        public boolean boundable() {
            return this.boundable;
        }

        public Builder<T> boundable(boolean boundable) {
            this.boundable = boundable;
            return this;
        }

        public boolean readonly() {
            return this.readonly;
        }

        public Builder<T> readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public PropertyKey<T> build() {
            return new PropertyKey(this);
        }
    }
}

