/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.timing;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jsoar.util.Arguments;
import org.jsoar.util.timing.AbstractExecutionTimer;
import org.jsoar.util.timing.ExecutionTimeSource;
import org.jsoar.util.timing.ExecutionTimer;

public class DefaultExecutionTimer
extends AbstractExecutionTimer {
    private ExecutionTimeSource source;
    private long start;
    private long total;

    public static ExecutionTimer newInstance() {
        return new DefaultExecutionTimer();
    }

    public static ExecutionTimer newInstance(ExecutionTimeSource source) {
        return new DefaultExecutionTimer(source);
    }

    private DefaultExecutionTimer() {
        ServiceLoader<ExecutionTimeSource> loader = ServiceLoader.load(ExecutionTimeSource.class);
        Iterator<ExecutionTimeSource> it = loader.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Could not locate an implementation of ExecutionTimeSource");
        }
        this.source = it.next();
    }

    private DefaultExecutionTimer(ExecutionTimeSource source) {
        Arguments.checkNotNull(source, "source");
        this.source = source;
    }

    @Override
    public long getTotalMicroseconds() {
        return this.total;
    }

    @Override
    public void pause() {
        this.total += this.source.getMicroseconds() - this.start;
    }

    @Override
    public void start() {
        this.start = this.source.getMicroseconds();
    }

    @Override
    public void reset() {
        this.total = 0L;
    }

    ExecutionTimeSource __testGetSource() {
        return this.source;
    }
}

