@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  soar-language-server startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and SOAR_LANGUAGE_SERVER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\soar-language-server-0.9.0.jar;%APP_HOME%\lib\jsoar-tcl-4.0-SNAPSHOT.jar;%APP_HOME%\lib\jsoar-core-4.0-SNAPSHOT.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\org.eclipse.lsp4j-0.7.1.jar;%APP_HOME%\lib\org.eclipse.lsp4j.generator-0.7.1.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.16.0.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.16.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.16.0.jar;%APP_HOME%\lib\guava-27.1-jre.jar;%APP_HOME%\lib\commons-lang3-3.9.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.5.jar;%APP_HOME%\lib\slf4j-api-1.7.25.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-2.5.2.jar;%APP_HOME%\lib\error_prone_annotations-2.2.0.jar;%APP_HOME%\lib\j2objc-annotations-1.1.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.17.jar;%APP_HOME%\lib\org.eclipse.lsp4j.jsonrpc-0.7.1.jar;%APP_HOME%\lib\commons-beanutils-1.8.3.jar;%APP_HOME%\lib\sqlite-jdbc-3.7.2.jar;%APP_HOME%\lib\commons-math3-3.2.jar;%APP_HOME%\lib\json-simple-1.1.1.jar;%APP_HOME%\lib\spring-core-4.3.2.RELEASE.jar;%APP_HOME%\lib\picocli-3.9.2.jar;%APP_HOME%\lib\commons-io-2.6.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\jtcl-2.9.3.jar;%APP_HOME%\lib\gson-2.7.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\scala-library-2.12.7.jar;%APP_HOME%\lib\janino-3.0.11.jar;%APP_HOME%\lib\commons-compiler-3.0.11.jar

@rem Execute soar-language-server
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %SOAR_LANGUAGE_SERVER_OPTS%  -classpath "%CLASSPATH%" com.soartech.soarls.App %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable SOAR_LANGUAGE_SERVER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%SOAR_LANGUAGE_SERVER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
