/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.tcl;

import com.google.common.collect.MapMaker;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.LoadCommand;
import org.jsoar.kernel.commands.PopdCommand;
import org.jsoar.kernel.commands.PushdCommand;
import org.jsoar.kernel.commands.PwdCommand;
import org.jsoar.kernel.commands.SaveCommand;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.SourceCommandAdapter;
import org.jsoar.kernel.commands.StandardCommands;
import org.jsoar.kernel.exceptions.TclInterpreterException;
import org.jsoar.kernel.rhs.functions.CmdRhsFunction;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.tcl.SoarTclCommandAdapter;
import org.jsoar.tcl.TclRhsFunction;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.UrlTools;
import org.jsoar.util.commands.DefaultSoarCommandContext;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarTclExceptionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;
import tcl.lang.cmd.InterpAliasCmd;

public class SoarTclInterface
implements SoarCommandInterpreter {
    private static final String DEFAULT_TCL_CODE = "/org/jsoar/tcl/jsoar.tcl";
    private static final Logger logger = LoggerFactory.getLogger(SoarTclInterface.class);
    private static final ConcurrentMap<Agent, SoarTclInterface> interfaces = new MapMaker().weakKeys().makeMap();
    private SoarCommandContext context = DefaultSoarCommandContext.empty();
    private SoarTclExceptionsManager exceptionsManager;
    private Agent agent;
    private final Interp interp = new Interp();
    private final SourceCommand sourceCommand;
    private LoadCommand loadCommand;
    private SaveCommand saveCommand;
    private final TclRhsFunction tclRhsFunction = new TclRhsFunction(this);
    private final CmdRhsFunction cmdRhsFunction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoarTclInterface find(Agent agent) {
        ConcurrentMap<Agent, SoarTclInterface> concurrentMap = interfaces;
        synchronized (concurrentMap) {
            return (SoarTclInterface)interfaces.get(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoarTclInterface findOrCreate(Agent agent) {
        ConcurrentMap<Agent, SoarTclInterface> concurrentMap = interfaces;
        synchronized (concurrentMap) {
            SoarTclInterface ifc = (SoarTclInterface)interfaces.get(agent);
            if (ifc == null) {
                ifc = new SoarTclInterface(agent);
                interfaces.put(agent, ifc);
            }
            return ifc;
        }
    }

    public static void dispose(SoarTclInterface ifc) {
        if (ifc != null) {
            ifc.dispose();
        }
    }

    private SoarTclInterface(Agent agent) {
        this.agent = agent;
        this.cmdRhsFunction = new CmdRhsFunction((SoarCommandInterpreter)this, agent);
        this.exceptionsManager = new SoarTclExceptionsManager();
        this.initializeEnv();
        this.agent.getRhsFunctions().registerHandler((RhsFunctionHandler)this.tclRhsFunction);
        this.agent.getRhsFunctions().registerHandler((RhsFunctionHandler)this.cmdRhsFunction);
        this.sourceCommand = new SourceCommand((SourceCommandAdapter)new MySourceCommandAdapter(), agent.getEvents());
        this.addCommand("source", (SoarCommand)this.sourceCommand);
        this.addCommand("pushd", (SoarCommand)new PushdCommand(this.sourceCommand, agent));
        this.addCommand("popd", (SoarCommand)new PopdCommand(this.sourceCommand, agent));
        this.addCommand("pwd", (SoarCommand)new PwdCommand(this.sourceCommand));
        this.loadCommand = new LoadCommand(this.sourceCommand, agent);
        this.addCommand("load", (SoarCommand)this.loadCommand);
        this.saveCommand = new SaveCommand(this.sourceCommand, agent);
        this.addCommand("save", (SoarCommand)this.saveCommand);
        StandardCommands.addToInterpreter((Agent)agent, (SoarCommandInterpreter)this);
        try {
            this.interp.evalResource(DEFAULT_TCL_CODE);
        }
        catch (TclException e) {
            String message = "Failed to load resource /org/jsoar/tcl/jsoar.tcl. Some commands may not work as expected: " + this.interp.getResult();
            logger.error(message);
            agent.getPrinter().error(message);
        }
    }

    private void initializeEnv() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            try {
                this.interp.setVar("env", e.getKey().toUpperCase(), e.getValue(), 1);
            }
            catch (TclException ex) {
                String message = "Failed to set environment variable '" + e + "': " + this.interp.getResult();
                logger.error(message);
                this.agent.getPrinter().error(message);
            }
        }
    }

    private Command adapt(SoarCommand c) {
        return new SoarTclCommandAdapter(c, this);
    }

    public SoarCommandContext getContext() {
        return this.context;
    }

    private void updateLastKnownSourceLocation(String location) {
        if (location != null) {
            try {
                DefaultSourceLocation sourceLocation = DefaultSourceLocation.newBuilder().file(new File(location).getCanonicalPath()).build();
                this.context = new DefaultSoarCommandContext((SourceLocation)sourceLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return "tcl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ConcurrentMap<Agent, SoarTclInterface> concurrentMap = interfaces;
        synchronized (concurrentMap) {
            interfaces.remove(this.agent);
            try {
                this.interp.dispose();
            }
            catch (TclRuntimeError e) {
                logger.warn("In dispose(): " + e.getMessage());
            }
            this.agent.getRhsFunctions().unregisterHandler(this.tclRhsFunction.getName());
            this.agent = null;
        }
    }

    public Collection<String> getSourcedFiles() {
        return this.sourceCommand.getSourcedFiles();
    }

    public Agent getAgent() {
        return this.agent;
    }

    public SoarTclExceptionsManager getTclContext() {
        return this.exceptionsManager;
    }

    public void source(File file) throws SoarException {
        this.sourceCommand.source(file.getPath());
    }

    public void source(URL url) throws SoarException {
        this.sourceCommand.source(url.toExternalForm());
    }

    public void loadRete(File file) throws SoarException {
        this.loadCommand.execute(DefaultSoarCommandContext.empty(), new String[]{file.getPath()});
    }

    public void loadRete(URL url) throws SoarException {
        this.loadCommand.execute(DefaultSoarCommandContext.empty(), new String[]{url.toExternalForm()});
    }

    public void saveRete(File file) throws SoarException {
        this.saveCommand.execute(DefaultSoarCommandContext.empty(), new String[]{file.getPath()});
    }

    public String getWorkingDirectory() {
        return this.sourceCommand.getWorkingDirectory();
    }

    public synchronized String eval(String command) throws SoarException {
        command = command.replaceAll("\r\n", "\n");
        command = command.replaceAll("\r", "\n");
        try {
            this.interp.eval(command);
            return this.interp.getResult().toString();
        }
        catch (TclException e) {
            throw new TclInterpreterException(this.interp.getResult().toString());
        }
    }

    public void addCommand(String name, SoarCommand handler) {
        this.interp.createCommand(name, this.adapt(handler));
    }

    public SoarCommand getCommand(String name, SourceLocation srcLoc) throws SoarException {
        Command command = this.interp.getCommand(name);
        while (command instanceof InterpAliasCmd) {
            try {
                command = ((InterpAliasCmd)command).getTargetCmd((Interp)this.interp).cmd;
            }
            catch (TclException e) {
                e.printStackTrace();
            }
        }
        if (command instanceof SoarTclCommandAdapter) {
            SoarTclCommandAdapter commandAdapter = (SoarTclCommandAdapter)command;
            return commandAdapter.getSoarCommand();
        }
        if (command instanceof SoarCommand) {
            return (SoarCommand)command;
        }
        throw new SoarException(srcLoc + ": Unknown command '" + name + "'");
    }

    public String[] getCompletionList(String command, int cursorPosition) {
        String[] commands = null;
        try {
            String commandsStr = this.eval("info commands") + " " + this.eval("info procs");
            ArrayList<String> commandsList = new ArrayList<String>();
            for (String s : commandsStr.split(" ")) {
                if (!s.startsWith(command)) continue;
                commandsList.add(s);
            }
            commands = commandsList.toArray(new String[0]);
        }
        catch (SoarException e) {
            e.printStackTrace();
        }
        return commands;
    }

    public ParsedCommand getParsedCommand(String name, SourceLocation srcLoc) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(name.split("\\s+")));
        String result = "";
        try {
            result = this.eval("interp alias {} " + (String)args.get(0));
        }
        catch (Exception e) {
            logger.error("Tcl exception", (Throwable)e);
        }
        if (result.length() == 0) {
            return new ParsedCommand(srcLoc, args);
        }
        ArrayList<String> aliasArgs = new ArrayList<String>(Arrays.asList(result.split("\\s")));
        aliasArgs.addAll(args.subList(1, args.size()));
        return new ParsedCommand(srcLoc, aliasArgs);
    }

    public List<String> getCommandStrings() throws SoarException {
        String[] commandNames = this.eval("info commands").split("\\s");
        ArrayList<String> soarCommandNames = new ArrayList<String>();
        for (String commandName : commandNames) {
            Command command = this.interp.getCommand(commandName);
            if (!(command instanceof SoarTclCommandAdapter) && !(command instanceof SoarCommand)) continue;
            soarCommandNames.add(commandName);
        }
        Collections.sort(soarCommandNames);
        return soarCommandNames;
    }

    public SoarTclExceptionsManager getExceptionsManager() {
        return this.exceptionsManager;
    }

    private class MySourceCommandAdapter
    implements SourceCommandAdapter {
        private MySourceCommandAdapter() {
        }

        public void eval(File file) throws SoarException {
            SoarTclInterface.this.updateLastKnownSourceLocation(file.getPath());
            try {
                SoarTclInterface.this.interp.evalFile(file.getAbsolutePath());
            }
            catch (TclException e) {
                String errLocation = "In file: " + file.getAbsolutePath() + " line " + SoarTclInterface.this.interp.getErrorLine() + ".";
                throw new SoarException(errLocation + System.getProperty("line.separator") + SoarTclInterface.this.interp.getResult().toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eval(URL url) throws SoarException {
            try {
                url = UrlTools.normalize((URL)url);
                SoarTclInterface.this.updateLastKnownSourceLocation(url.getPath());
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                    this.eval(out.toString());
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new SoarException(e.getMessage(), (Throwable)e);
            }
        }

        public String eval(String code) throws SoarException {
            return SoarTclInterface.this.eval(code);
        }
    }
}

