/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

public class CallFrame {
    Interp interp;
    public Namespace ns;
    public boolean isProcCallFrame;
    public TclObject[] objv;
    public CallFrame caller;
    public CallFrame callerVar;
    public int level;
    public HashMap varTable;
    public Var[] compiledLocals;
    public String[] compiledLocalsNames;

    public CallFrame(Interp interp) {
        this.interp = interp;
        this.ns = interp.globalNs;
        this.varTable = null;
        this.compiledLocals = null;
        this.compiledLocalsNames = null;
        this.caller = null;
        this.callerVar = null;
        this.objv = null;
        this.level = 0;
        this.isProcCallFrame = true;
    }

    CallFrame(Interp interp, Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        this(interp);
        try {
            this.chain(procedure, tclObjectArray);
        }
        catch (TclException tclException) {
            this.dispose();
            throw tclException;
        }
    }

    void chain(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        int n;
        this.ns = procedure.wcmd.ns;
        this.objv = tclObjectArray;
        this.level = this.interp.varFrame == null ? 1 : this.interp.varFrame.level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int n2 = procedure.argList.length;
        int n3 = n = procedure.isLambda() ? 2 : 1;
        if (!procedure.isVarArgs && tclObjectArray.length - n > n2) {
            this.wrongNumProcArgs(tclObjectArray, procedure);
        }
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            TclObject tclObject = procedure.argList[n4][0];
            TclObject tclObject2 = null;
            if (n4 == n2 - 1 && procedure.isVarArgs) {
                tclObject2 = TclList.newInstance();
                tclObject2.preserve();
                for (int i = n5; i < tclObjectArray.length; ++i) {
                    TclList.append(this.interp, tclObject2, tclObjectArray[i]);
                }
                this.interp.setVar(tclObject, tclObject2, 0);
                tclObject2.release();
            } else {
                if (n5 < tclObjectArray.length) {
                    tclObject2 = tclObjectArray[n5];
                } else if (procedure.argList[n4][1] != null) {
                    tclObject2 = procedure.argList[n4][1];
                } else {
                    this.wrongNumProcArgs(tclObjectArray, procedure);
                }
                this.interp.setVar(tclObject, tclObject2, 0);
            }
            ++n4;
            ++n5;
        }
    }

    private String wrongNumProcArgs(TclObject[] tclObjectArray, Procedure procedure) throws TclException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("wrong # args: should be \"");
        TclObject tclObject = TclList.newInstance();
        if (procedure.isLambda()) {
            TclList.append(this.interp, tclObject, tclObjectArray, 0, 2);
        } else {
            TclList.append(this.interp, tclObject, tclObjectArray[0]);
        }
        stringBuffer.append(tclObject.toString());
        for (int i = 0; i < procedure.argList.length; ++i) {
            TclObject tclObject2 = procedure.argList[i][0];
            TclObject tclObject3 = procedure.argList[i][1];
            stringBuffer.append(" ");
            if (tclObject3 != null) {
                stringBuffer.append("?");
            }
            stringBuffer.append(tclObject2.toString());
            if (tclObject3 == null) continue;
            stringBuffer.append("?");
        }
        stringBuffer.append("\"");
        throw new TclException(this.interp, stringBuffer.toString());
    }

    static boolean exists(Interp interp, String string) {
        try {
            Var[] varArray = Var.lookupVar(interp, string, null, 0, "lookup", false, false);
            if (varArray == null) {
                return false;
            }
            return !varArray[0].isVarUndefined();
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    ArrayList getVarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.varTable == null) {
            return arrayList;
        }
        for (Map.Entry entry : this.varTable.entrySet()) {
            Var var = (Var)entry.getValue();
            if (var.isVarUndefined()) continue;
            arrayList.add(var.hashKey);
        }
        return arrayList;
    }

    ArrayList getLocalVarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.varTable == null) {
            return arrayList;
        }
        for (Map.Entry entry : this.varTable.entrySet()) {
            Var var = (Var)entry.getValue();
            if (var.isVarUndefined() || var.isVarLink()) continue;
            arrayList.add(var.hashKey);
        }
        return arrayList;
    }

    public static int getFrame(Interp interp, String string, CallFrame[] callFrameArray) throws TclException {
        CallFrame callFrame;
        int n;
        int n2;
        int n3 = 1;
        int n4 = n2 = interp.varFrame == null ? 0 : interp.varFrame.level;
        if (string.length() > 0 && string.charAt(0) == '#') {
            n = (int)Util.getInt(interp, string.substring(1));
            if (n < 0) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            n = (int)Util.getInt(interp, string);
            n = n2 - n;
        } else {
            n = n2 - 1;
            n3 = 0;
        }
        if (n == 0) {
            callFrame = null;
        } else {
            callFrame = interp.varFrame;
            while (callFrame != null && callFrame.level != n) {
                callFrame = callFrame.callerVar;
            }
            if (callFrame == null) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        }
        callFrameArray[0] = callFrame;
        return n3;
    }

    public void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        if (this.varTable != null) {
            Var.deleteVars(this.interp, this.varTable);
            this.varTable = null;
        }
        if (this.compiledLocals != null) {
            Var.deleteVars(this.interp, this.compiledLocals);
            this.compiledLocals = null;
            this.compiledLocalsNames = null;
        }
    }
}

