/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEvent;

public class ConsoleThread
extends Thread {
    Interp interp;
    StringBuffer sbuf;
    private Channel out;
    private Channel err;
    private static final boolean debug = false;

    public ConsoleThread(Interp interp) {
        this.setName("ConsoleThread");
        this.interp = interp;
        this.sbuf = new StringBuffer(100);
        this.out = TclIO.getStdChannel(1);
        this.err = TclIO.getStdChannel(2);
    }

    @Override
    public synchronized void run() {
        FileEvent.setStdinUsedForCommandInput(true);
        if (this.isInteractive()) {
            this.put(this.out, "% ");
        }
        while (true) {
            this.getLine();
            final String string = this.sbuf.toString();
            TclEvent tclEvent = new TclEvent(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public int processEvent(int var1_1) {
                    if (Interp.commandComplete(string)) {
                        var2_2 = true;
                        var3_4 = TclString.newInstance(string);
                        try {
                            var3_4.preserve();
                            ConsoleThread.this.interp.recordAndEval(var3_4, 0);
                            var2_2 = false;
                        }
                        catch (TclException var4_7) {
                            ConsoleThread.this.interp.addErrorInfo("");
                            var5_9 = var4_7.getCompletionCode();
                            switch (var5_9) {
                                case 1: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), ConsoleThread.this.interp.getResult().toString());
                                    ** break;
lbl16:
                                    // 1 sources

                                    break;
                                }
                                case 3: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "invoked \"break\" outside of a loop");
                                    ** break;
lbl20:
                                    // 1 sources

                                    break;
                                }
                                case 4: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "invoked \"continue\" outside of a loop");
                                    ** break;
lbl24:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "command returned bad code: " + var5_9);
                                    break;
                                }
                            }
                        }
                        finally {
                            var3_4.release();
                        }
                        if (!var2_2 && (var4_8 = ConsoleThread.this.interp.getResult().toString()).length() > 0 && ConsoleThread.access$200(ConsoleThread.this)) {
                            ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$300(ConsoleThread.this), (String)var4_8);
                        }
                        ConsoleThread.this.sbuf.setLength(0);
                        try {
                            var4_8 = ConsoleThread.this.interp.getVar("tcl_prompt1", 1);
                        }
                        catch (TclException var5_10) {
                            var4_8 = null;
                        }
                        if (var4_8 != null) {
                            try {
                                ConsoleThread.this.interp.eval(var4_8.toString(), 131072);
                            }
                            catch (TclException var5_11) {
                                if (ConsoleThread.access$200(ConsoleThread.this)) {
                                    ConsoleThread.access$400(ConsoleThread.this, ConsoleThread.access$300(ConsoleThread.this), "% ");
                                }
                            }
                        } else if (ConsoleThread.access$200(ConsoleThread.this)) {
                            ConsoleThread.access$400(ConsoleThread.this, ConsoleThread.access$300(ConsoleThread.this), "% ");
                        }
                        return 1;
                    }
                    try {
                        var2_3 = ConsoleThread.this.interp.getVar("tcl_prompt2", 1);
                    }
                    catch (TclException var3_5) {
                        var2_3 = null;
                    }
                    if (var2_3 != null) {
                        try {
                            ConsoleThread.this.interp.eval(var2_3.toString(), 131072);
                        }
                        catch (TclException var3_6) {
                            if (ConsoleThread.access$200(ConsoleThread.this)) {
                                ConsoleThread.access$400(ConsoleThread.this, ConsoleThread.access$300(ConsoleThread.this), "");
                            }
                        }
                    } else if (ConsoleThread.access$200(ConsoleThread.this)) {
                        ConsoleThread.access$400(ConsoleThread.this, ConsoleThread.access$300(ConsoleThread.this), "");
                    }
                    return 1;
                }
            };
            this.interp.getNotifier().queueEvent(tclEvent, 0);
            tclEvent.sync();
        }
    }

    private void getLine() {
        char c = ' ';
        char c2 = ' ';
        do {
            try {
                int n = System.in.read();
                if (n == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                if ((c2 = (char)((char)n)) == '\r') {
                    n = System.in.read();
                    if (n == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c = (char)((char)n)) == '\n') {
                        c2 = c;
                    } else {
                        this.sbuf.append(c2);
                        c2 = c;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c2);
        } while (c2 != 10);
    }

    private boolean isInteractive() {
        TclObject tclObject = null;
        try {
            tclObject = this.interp.getVar("tcl_interactive", 1);
            return TclBoolean.get(this.interp, tclObject);
        }
        catch (TclException tclException) {
            return true;
        }
    }

    private void putLine(Channel channel, String string) {
        try {
            channel.write(this.interp, string);
            channel.write(this.interp, "\n");
            channel.flush(this.interp);
        }
        catch (IOException iOException) {
            System.err.println("IOException in Shell.putLine()");
            iOException.printStackTrace(System.err);
        }
        catch (TclException tclException) {
            System.err.println("TclException in Shell.putLine()");
            tclException.printStackTrace(System.err);
        }
    }

    private void put(Channel channel, String string) {
        try {
            channel.write(this.interp, string);
            channel.flush(this.interp);
        }
        catch (IOException iOException) {
            System.err.println("IOException in Shell.put()");
            iOException.printStackTrace(System.err);
        }
        catch (TclException tclException) {
            System.err.println("TclException in Shell.put()");
            tclException.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Channel access$000(ConsoleThread consoleThread) {
        return consoleThread.err;
    }

    static /* synthetic */ void access$100(ConsoleThread consoleThread, Channel channel, String string) {
        consoleThread.putLine(channel, string);
    }

    static /* synthetic */ boolean access$200(ConsoleThread consoleThread) {
        return consoleThread.isInteractive();
    }

    static /* synthetic */ Channel access$300(ConsoleThread consoleThread) {
        return consoleThread.out;
    }

    static /* synthetic */ void access$400(ConsoleThread consoleThread, Channel channel, String string) {
        consoleThread.put(channel, string);
    }
}

