/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class ExecutionTrace {
    public static final int ENTER = 0;
    public static final int LEAVE = 1;
    public static final int ENTERSTEP = 2;
    public static final int LEAVESTEP = 3;
    private static final String[] op = new String[]{"enter", "leave", "enterstep", "leavestep"};
    private String callbackCmd;
    protected int type;
    protected boolean deleted = false;

    public ExecutionTrace(Interp interp, int n, TclObject tclObject) throws TclException {
        this.type = n;
        this.callbackCmd = tclObject.toString();
    }

    public int getType() {
        return this.type;
    }

    public String getCallbackCmd() {
        return this.callbackCmd;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void trace(Interp interp, int n, String string, int n2, TclObject tclObject) throws TclException {
        if (n == this.type && !this.deleted) {
            StringBuffer stringBuffer = new StringBuffer(this.callbackCmd.length() + string.length() + (tclObject == null ? 0 : tclObject.toString().length()) + 16);
            stringBuffer.append(this.callbackCmd).append(" {").append(string).append("} ");
            switch (n) {
                case 0: 
                case 2: {
                    stringBuffer.append(op[n]);
                    break;
                }
                case 1: 
                case 3: {
                    String string2 = tclObject.toString();
                    if (string2.length() == 0) {
                        string2 = "{}";
                    }
                    stringBuffer.append(n2).append(" ").append(string2).append(" ").append(op[n]);
                }
            }
            interp.eval(stringBuffer.toString(), 0);
        }
    }
}

