/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;

class ParseExpr {
    static final int LITERAL = 0;
    static final int FUNC_NAME = 1;
    static final int OPEN_BRACKET = 2;
    static final int OPEN_BRACE = 3;
    static final int OPEN_PAREN = 4;
    static final int CLOSE_PAREN = 5;
    static final int DOLLAR = 6;
    static final int QUOTE = 7;
    static final int COMMA = 8;
    static final int END = 9;
    static final int UNKNOWN = 10;
    static final int UNKNOWN_CHAR = 11;
    static final int MULT = 12;
    static final int DIVIDE = 13;
    static final int MOD = 14;
    static final int PLUS = 15;
    static final int MINUS = 16;
    static final int LEFT_SHIFT = 17;
    static final int RIGHT_SHIFT = 18;
    static final int LESS = 19;
    static final int GREATER = 20;
    static final int LEQ = 21;
    static final int GEQ = 22;
    static final int EQUAL = 23;
    static final int NEQ = 24;
    static final int BIT_AND = 25;
    static final int BIT_XOR = 26;
    static final int BIT_OR = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int QUESTY = 30;
    static final int COLON = 31;
    static final int NOT = 32;
    static final int BIT_NOT = 33;
    static final int STREQ = 34;
    static final int STRNEQ = 35;
    static String[] lexemeStrings = new String[]{"LITERAL", "FUNCNAME", "[", "{", "(", ")", "$", "\"", ",", "END", "UNKNOWN", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "!", "~", "eq", "ne"};

    ParseExpr() {
    }

    static TclParse parseExpr(Interp interp, char[] cArray, int n, int n2) {
        int n3;
        String string = "unknown";
        int n4 = 0;
        int n5 = cArray.length - 1;
        if (n2 < 0) {
            n2 = n5 - n;
        }
        if ((n3 = n + n2) > n5) {
            n3 = n5;
        }
        TclParse tclParse = new TclParse(interp, cArray, n3, string, n4);
        ParseInfo parseInfo = new ParseInfo(tclParse, cArray, n, n2);
        try {
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseCondExpr(interp, parseInfo);
            if (parseInfo.lexeme != 9) {
                ParseExpr.LogSyntaxError(parseInfo, "extra tokens at end of expression");
            }
        }
        catch (TclException tclException) {
            tclParse.result = 1;
            return tclParse;
        }
        if (tclParse.result != 0) {
            throw new TclRuntimeError("non TCL.OK parse result in parseExpr():  TclException should have been raised");
        }
        tclParse.result = 0;
        return tclParse;
    }

    static void ParseCondExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseLorExpr(interp, parseInfo);
        if (parseInfo.lexeme == 30) {
            tclParse.insertInTokenArray(n2, 2);
            tclParse.numTokens += 2;
            TclToken tclToken = tclParse.getToken(n2);
            tclToken.type = 64;
            tclToken.script_array = parseInfo.originalExpr;
            tclToken.script_index = n;
            tclToken.size = 0;
            tclToken = tclParse.getToken(n2 + 1);
            tclToken.type = 128;
            tclToken.script_array = parseInfo.originalExpr;
            tclToken.script_index = parseInfo.start;
            tclToken.size = 1;
            tclToken.numComponents = 0;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseCondExpr(interp, parseInfo);
            if (parseInfo.lexeme != 31) {
                ParseExpr.LogSyntaxError(parseInfo, "missing colon from ternary conditional");
            }
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseCondExpr(interp, parseInfo);
            TclToken tclToken2 = tclParse.getToken(n2);
            tclToken2.script_array = parseInfo.originalExpr;
            tclToken2.size = parseInfo.prevEnd - n;
            tclToken2.numComponents = tclParse.numTokens - (n2 + 1);
        }
    }

    static void ParseLorExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseLandExpr(interp, parseInfo);
        while (parseInfo.lexeme == 29) {
            int n3 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseLandExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n3, 2, n, parseInfo.prevEnd - n, n2, parseInfo);
        }
    }

    static void ParseLandExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseBitOrExpr(interp, parseInfo);
        while (parseInfo.lexeme == 28) {
            int n3 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseBitOrExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n3, 2, n, parseInfo.prevEnd - n, n2, parseInfo);
        }
    }

    static void ParseBitOrExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseBitXorExpr(interp, parseInfo);
        while (parseInfo.lexeme == 27) {
            int n3 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseBitXorExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n3, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
        }
    }

    static void ParseBitXorExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseBitAndExpr(interp, parseInfo);
        while (parseInfo.lexeme == 26) {
            int n3 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseBitAndExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n3, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
        }
    }

    static void ParseBitAndExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseEqualityExpr(interp, parseInfo);
        while (parseInfo.lexeme == 25) {
            int n3 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseEqualityExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n3, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
        }
    }

    static void ParseEqualityExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseRelationalExpr(interp, parseInfo);
        int n3 = parseInfo.lexeme;
        while (n3 == 23 || n3 == 24 || n3 == 34 || n3 == 35) {
            int n4 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseRelationalExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, 2, n, parseInfo.prevEnd - n, n2, parseInfo);
            n3 = parseInfo.lexeme;
        }
    }

    static void ParseRelationalExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseShiftExpr(interp, parseInfo);
        int n3 = parseInfo.lexeme;
        while (n3 == 19 || n3 == 20 || n3 == 21 || n3 == 22) {
            int n4 = parseInfo.start;
            int n5 = n3 == 21 || n3 == 22 ? 2 : 1;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseShiftExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, n5, n, parseInfo.prevEnd - n, n2, parseInfo);
            n3 = parseInfo.lexeme;
        }
    }

    static void ParseShiftExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseAddExpr(interp, parseInfo);
        int n3 = parseInfo.lexeme;
        while (n3 == 17 || n3 == 18) {
            int n4 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseAddExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, 2, n, parseInfo.prevEnd - n, n2, parseInfo);
            n3 = parseInfo.lexeme;
        }
    }

    static void ParseAddExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseMultiplyExpr(interp, parseInfo);
        int n3 = parseInfo.lexeme;
        while (n3 == 15 || n3 == 16) {
            int n4 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseMultiplyExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
            n3 = parseInfo.lexeme;
        }
    }

    static void ParseMultiplyExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        ParseExpr.ParseUnaryExpr(interp, parseInfo);
        int n3 = parseInfo.lexeme;
        while (n3 == 12 || n3 == 13 || n3 == 14) {
            int n4 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseUnaryExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
            n3 = parseInfo.lexeme;
        }
    }

    static void ParseUnaryExpr(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        int n = parseInfo.start;
        int n2 = tclParse.numTokens;
        int n3 = parseInfo.lexeme;
        if (n3 == 15 || n3 == 16 || n3 == 33 || n3 == 32) {
            int n4 = parseInfo.start;
            ParseExpr.GetLexeme(interp, parseInfo);
            ParseExpr.ParseUnaryExpr(interp, parseInfo);
            ParseExpr.PrependSubExprTokens(n4, 1, n, parseInfo.prevEnd - n, n2, parseInfo);
        } else {
            ParseExpr.ParsePrimaryExpr(interp, parseInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void ParsePrimaryExpr(Interp var0, ParseInfo var1_1) throws TclException {
        var2_2 = var1_1.parseObj;
        var10_3 = var1_1.lexeme;
        if (var10_3 == 4) {
            ParseExpr.GetLexeme(var0, var1_1);
            ParseExpr.ParseCondExpr(var0, var1_1);
            if (var1_1.lexeme != 5) {
                ParseExpr.LogSyntaxError(var1_1, "looking for close parenthesis");
            }
            ParseExpr.GetLexeme(var0, var1_1);
            return;
        }
        if (var2_2.numTokens == var2_2.tokensAvailable) {
            var2_2.expandTokenArray(var2_2.numTokens);
        }
        var11_4 = var2_2.numTokens++;
        var4_5 = var2_2.getToken(var11_4);
        var4_5.type = 64;
        var4_5.script_array = var1_1.originalExpr;
        var4_5.script_index = var1_1.start;
        var12_6 = var2_2.numTokens;
        switch (var10_3) {
            case 0: {
                if (var2_2.numTokens == var2_2.tokensAvailable) {
                    var2_2.expandTokenArray(var2_2.numTokens);
                }
                var3_7 = var2_2.getToken(var2_2.numTokens);
                var3_7.type = 4;
                var3_7.script_array = var1_1.originalExpr;
                var3_7.script_index = var1_1.start;
                var3_7.size = var1_1.size;
                var1_1.next = var1_1.start + var1_1.size;
                var3_7.numComponents = 0;
                ++var2_2.numTokens;
                var4_5.script_array = var1_1.originalExpr;
                var4_5.size = var1_1.size;
                var4_5.numComponents = 1;
                break;
            }
            case 6: {
                var6_13 = var1_1.next - 1;
                var2_2 = Parser.parseVarName(var0, var1_1.originalExpr, var6_13, var1_1.lastChar - var6_13, var2_2, true);
                if (var2_2.result != 0) {
                    throw new TclException(var2_2.result);
                }
                var1_1.next = var6_13 + var2_2.getToken((int)var12_6).size;
                var4_5 = var2_2.getToken(var11_4);
                var4_5.size = var2_2.getToken((int)var12_6).size;
                var4_5.numComponents = var2_2.getToken((int)var12_6).numComponents + 1;
                var4_5.script_array = var1_1.originalExpr;
                break;
            }
            case 7: {
                var7_14 = var1_1.next;
                var2_2 = Parser.ParseQuotedString(var0, var1_1.originalExpr, var1_1.next - 1, var1_1.lastChar - var7_14, var2_2, true);
                var1_1.next = var8_15 = var2_2.extra;
                var4_5 = var2_2.getToken(var11_4);
                var4_5.size = var8_15 - var4_5.script_index;
                var4_5.numComponents = var2_2.numTokens - var12_6;
                var4_5.script_array = var1_1.originalExpr;
                if (var4_5.numComponents <= 1) break;
                if (var2_2.numTokens >= var2_2.tokensAvailable) {
                    var2_2.expandTokenArray(var2_2.numTokens + 1);
                }
                var2_2.insertInTokenArray(var12_6, 1);
                ++var2_2.numTokens;
                var3_8 = var2_2.getToken(var12_6);
                var4_5 = var2_2.getToken(var11_4);
                ++var4_5.numComponents;
                var4_5.script_array = var1_1.originalExpr;
                var3_8.type = 1;
                var3_8.script_array = var1_1.originalExpr;
                var3_8.script_index = var4_5.script_index;
                var3_8.size = var4_5.size;
                var3_8.numComponents = var4_5.numComponents - 1;
                break;
            }
            case 2: {
                if (var2_2.numTokens == var2_2.tokensAvailable) {
                    var2_2.expandTokenArray(var2_2.numTokens);
                }
                var3_9 = var2_2.getToken(var2_2.numTokens);
                var3_9.type = 16;
                var3_9.script_array = var1_1.originalExpr;
                var3_9.script_index = var1_1.start;
                var3_9.numComponents = 0;
                ++var2_2.numTokens;
                var9_17 = var1_1.next;
                do {
                    var5_18 = Parser.parseCommand(var0, var1_1.originalExpr, var9_17, var2_2.endIndex - var9_17, var2_2.fileName, var2_2.lineNum, true);
                    if (var5_18.result != 0) {
                        var2_2.termIndex = var5_18.termIndex;
                        var2_2.errorType = var5_18.errorType;
                        var2_2.incomplete = var5_18.incomplete;
                        var2_2.result = var5_18.result;
                    }
                    var9_17 = var5_18.commandStart + var5_18.commandSize;
                    if (var5_18.termIndex < var2_2.endIndex && var1_1.originalExpr[var5_18.termIndex] == ']' && !var5_18.incomplete) ** GOTO lbl92
                } while (var9_17 != var2_2.endIndex);
                var2_2.termIndex = var3_9.script_index;
                var2_2.incomplete = true;
                var2_2.result = 1;
                throw new TclException(var2_2.interp, "missing close-bracket");
lbl92:
                // 1 sources

                var3_9.size = var9_17 - var3_9.script_index;
                var1_1.next = var9_17;
                var4_5 = var2_2.getToken(var11_4);
                var4_5.size = var9_17 - var3_9.script_index;
                var4_5.numComponents = 1;
                var4_5.script_array = var1_1.originalExpr;
                break;
            }
            case 3: {
                var2_2 = Parser.ParseBraces(var0, var1_1.originalExpr, var1_1.start, var1_1.lastChar - var1_1.start, var2_2, true);
                var1_1.next = var8_16 = var2_2.extra;
                var4_5 = var2_2.getToken(var11_4);
                var4_5.size = var8_16 - var1_1.start;
                var4_5.numComponents = var2_2.numTokens - var12_6;
                if (var4_5.numComponents <= 1) break;
                if (var2_2.numTokens >= var2_2.tokensAvailable) {
                    var2_2.expandTokenArray(var2_2.numTokens + 1);
                }
                var2_2.insertInTokenArray(var12_6, 1);
                ++var2_2.numTokens;
                var3_10 = var2_2.getToken(var12_6);
                var4_5 = var2_2.getToken(var11_4);
                ++var4_5.numComponents;
                var3_10.type = 1;
                var3_10.script_array = var4_5.script_array;
                var3_10.script_index = var4_5.script_index;
                var3_10.size = var4_5.size;
                var3_10.numComponents = var4_5.numComponents - 1;
                break;
            }
            case 1: {
                var15_19 = var1_1.duplicate();
                ParseExpr.GetLexeme(var0, var1_1);
                if (var1_1.lexeme == 4) ** GOTO lbl149
                var16_20 = TclString.newInstance(new String(var15_19.originalExpr, var15_19.start, var15_19.size));
                var16_20.preserve();
                try {
                    TclBoolean.get(var0, var16_20);
                    var1_1 = var15_19;
                    if (var2_2.numTokens == var2_2.tokensAvailable) {
                        var2_2.expandTokenArray(var2_2.numTokens);
                    }
                    var3_11 = var2_2.getToken(var2_2.numTokens);
                    var3_11.type = 4;
                    var3_11.script_array = var1_1.originalExpr;
                    var3_11.script_index = var1_1.start;
                    var3_11.size = var1_1.size;
                    var1_1.next = var1_1.start + var1_1.size;
                    var3_11.numComponents = 0;
                    ++var2_2.numTokens;
                    var4_5.script_array = var1_1.originalExpr;
                    var4_5.size = var1_1.size;
                    var4_5.numComponents = 1;
                    break;
                }
                catch (TclException var17_22) {
                }
                finally {
                    var16_20.release();
                }
                ParseExpr.LogSyntaxError(var1_1, null);
lbl149:
                // 2 sources

                if (var2_2.numTokens == var2_2.tokensAvailable) {
                    var2_2.expandTokenArray(var2_2.numTokens);
                }
                var3_12 = var2_2.getToken(var2_2.numTokens);
                var3_12.type = 128;
                var3_12.script_array = var15_19.originalExpr;
                var3_12.script_index = var15_19.start;
                var3_12.size = var15_19.size;
                var3_12.numComponents = 0;
                ++var2_2.numTokens;
                ParseExpr.GetLexeme(var0, var1_1);
                while (var1_1.lexeme != 5) {
                    ParseExpr.ParseCondExpr(var0, var1_1);
                    if (var1_1.lexeme == 8) {
                        ParseExpr.GetLexeme(var0, var1_1);
                        continue;
                    }
                    if (var1_1.lexeme == 5) continue;
                    ParseExpr.LogSyntaxError(var1_1, "missing close parenthesis at end of function call");
                }
                var4_5 = var2_2.getToken(var11_4);
                var4_5.size = var1_1.next - var4_5.script_index;
                var4_5.numComponents = var2_2.numTokens - var12_6;
                var4_5.script_array = var1_1.originalExpr;
                break;
            }
            case 8: {
                ParseExpr.LogSyntaxError(var1_1, "commas can only separate function arguments");
            }
            case 9: {
                ParseExpr.LogSyntaxError(var1_1, "premature end of expression");
            }
            case 10: {
                ParseExpr.LogSyntaxError(var1_1, "single equality character not legal in expressions");
            }
            case 11: {
                ParseExpr.LogSyntaxError(var1_1, "character not legal in expressions");
            }
            case 30: {
                ParseExpr.LogSyntaxError(var1_1, "unexpected ternary 'then' separator");
            }
            case 31: {
                ParseExpr.LogSyntaxError(var1_1, "unexpected ternary 'else' separator");
            }
            case 5: {
                ParseExpr.LogSyntaxError(var1_1, "unexpected close parenthesis");
            }
            default: {
                var16_21 = "unexpected operator " + ParseExpr.lexemeStrings[var10_3];
                ParseExpr.LogSyntaxError(var1_1, var16_21);
            }
        }
        ParseExpr.GetLexeme(var0, var1_1);
        var2_2.termIndex = var1_1.next;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void GetLexeme(Interp interp, ParseInfo parseInfo) throws TclException {
        TclParse tclParse = parseInfo.parseObj;
        parseInfo.lexeme = 10;
        parseInfo.prevEnd = parseInfo.next;
        int n = parseInfo.next;
        if (n >= parseInfo.lastChar) {
            parseInfo.lexeme = 9;
            parseInfo.next = n;
            return;
        }
        char c = parseInfo.originalExpr[n];
        while (c == ' ' || Character.isWhitespace(c) || c == '\\') {
            if (c == '\\') {
                if (parseInfo.originalExpr[n + 1] != '\n') break;
                n += 2;
            } else {
                ++n;
            }
            c = parseInfo.originalExpr[n];
        }
        tclParse.termIndex = n;
        if (n >= parseInfo.lastChar) {
            parseInfo.lexeme = 9;
            parseInfo.next = n;
            return;
        }
        if (c != '+' && c != '-') {
            boolean bl = Character.isDigit(c);
            String string = new String(parseInfo.originalExpr, n, parseInfo.lastChar - n);
            if (bl && Expression.looksLikeInt(string, string.length(), 0, false)) {
                StrtoulResult strtoulResult = interp.strtoulResult;
                Util.strtoul(string, 0, 0, strtoulResult);
                if (strtoulResult.errno == 0) {
                    int n2 = n + strtoulResult.index;
                    parseInfo.lexeme = 0;
                    parseInfo.start = n;
                    parseInfo.size = n2 - n;
                    parseInfo.next = n2;
                    tclParse.termIndex = n2;
                    return;
                }
                tclParse.errorType = 9;
                if (strtoulResult.errno != -2) throw new TclException(interp, "parse bad number");
                Expression.IntegerTooLarge(interp);
            } else {
                int n3 = ParseExpr.ParseMaxDoubleLength(parseInfo.originalExpr, n, parseInfo.lastChar);
                if (n3 > 0) {
                    string = new String(parseInfo.originalExpr, n, n3);
                    StrtodResult strtodResult = interp.strtodResult;
                    Util.strtod(string, 0, -1, strtodResult);
                    if (strtodResult.index > 0) {
                        if (strtodResult.errno != 0) {
                            tclParse.errorType = 9;
                            if (strtodResult.errno != -4) throw new TclException(interp, "parse bad number");
                            if (strtodResult.value != 0.0) {
                                Expression.DoubleTooLarge(interp);
                            } else {
                                Expression.DoubleTooSmall(interp);
                            }
                        }
                        int n4 = n + strtodResult.index;
                        parseInfo.lexeme = 0;
                        parseInfo.start = n;
                        parseInfo.size = n4 - n;
                        if (parseInfo.size > n3) {
                            parseInfo.size = n3;
                        }
                        tclParse.termIndex = parseInfo.next = n + parseInfo.size;
                        return;
                    }
                }
            }
        }
        c = parseInfo.originalExpr[n];
        char c2 = parseInfo.originalExpr[n + 1];
        parseInfo.start = n;
        parseInfo.size = 1;
        tclParse.termIndex = parseInfo.next = n + 1;
        switch (c) {
            case '[': {
                parseInfo.lexeme = 2;
                return;
            }
            case '{': {
                parseInfo.lexeme = 3;
                return;
            }
            case '(': {
                parseInfo.lexeme = 4;
                return;
            }
            case ')': {
                parseInfo.lexeme = 5;
                return;
            }
            case '$': {
                parseInfo.lexeme = 6;
                return;
            }
            case '\"': {
                parseInfo.lexeme = 7;
                return;
            }
            case ',': {
                parseInfo.lexeme = 8;
                return;
            }
            case '*': {
                parseInfo.lexeme = 12;
                return;
            }
            case '/': {
                parseInfo.lexeme = 13;
                return;
            }
            case '%': {
                parseInfo.lexeme = 14;
                return;
            }
            case '+': {
                parseInfo.lexeme = 15;
                return;
            }
            case '-': {
                parseInfo.lexeme = 16;
                return;
            }
            case '?': {
                parseInfo.lexeme = 30;
                return;
            }
            case ':': {
                parseInfo.lexeme = 31;
                return;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        parseInfo.lexeme = 17;
                        parseInfo.size = 2;
                        parseInfo.next = n + 2;
                        break;
                    }
                    case '=': {
                        parseInfo.lexeme = 21;
                        parseInfo.size = 2;
                        parseInfo.next = n + 2;
                        break;
                    }
                    default: {
                        parseInfo.lexeme = 19;
                    }
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        parseInfo.lexeme = 18;
                        parseInfo.size = 2;
                        parseInfo.next = n + 2;
                        break;
                    }
                    case '=': {
                        parseInfo.lexeme = 22;
                        parseInfo.size = 2;
                        parseInfo.next = n + 2;
                        break;
                    }
                    default: {
                        parseInfo.lexeme = 20;
                    }
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '=': {
                if (c2 == '=') {
                    parseInfo.lexeme = 23;
                    parseInfo.size = 2;
                    parseInfo.next = n + 2;
                } else {
                    parseInfo.lexeme = 10;
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '!': {
                if (c2 == '=') {
                    parseInfo.lexeme = 24;
                    parseInfo.size = 2;
                    parseInfo.next = n + 2;
                } else {
                    parseInfo.lexeme = 32;
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '&': {
                if (c2 == '&') {
                    parseInfo.lexeme = 28;
                    parseInfo.size = 2;
                    parseInfo.next = n + 2;
                } else {
                    parseInfo.lexeme = 25;
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '^': {
                parseInfo.lexeme = 26;
                return;
            }
            case '|': {
                if (c2 == '|') {
                    parseInfo.lexeme = 29;
                    parseInfo.size = 2;
                    parseInfo.next = n + 2;
                } else {
                    parseInfo.lexeme = 27;
                }
                tclParse.termIndex = parseInfo.next;
                return;
            }
            case '~': {
                parseInfo.lexeme = 33;
                return;
            }
            case 'e': {
                if (c2 == 'q') {
                    parseInfo.lexeme = 34;
                    parseInfo.size = 2;
                    tclParse.termIndex = parseInfo.next = n + 2;
                    return;
                }
                ParseExpr.checkFuncName(interp, parseInfo, n);
                return;
            }
            case 'n': {
                if (c2 == 'e') {
                    parseInfo.lexeme = 35;
                    parseInfo.size = 2;
                    tclParse.termIndex = parseInfo.next = n + 2;
                    return;
                }
                ParseExpr.checkFuncName(interp, parseInfo, n);
                return;
            }
        }
        ParseExpr.checkFuncName(interp, parseInfo, n);
    }

    static void checkFuncName(Interp interp, ParseInfo parseInfo, int n) {
        char c = parseInfo.originalExpr[n];
        if (Character.isLetter(c)) {
            parseInfo.lexeme = 1;
            while (Character.isLetterOrDigit(c) || c == '_') {
                c = parseInfo.originalExpr[++n];
            }
            parseInfo.size = n - parseInfo.start;
            parseInfo.parseObj.termIndex = parseInfo.next = n;
            String string = new String(parseInfo.originalExpr, parseInfo.start, parseInfo.size);
            c = parseInfo.originalExpr[parseInfo.start];
            switch (c) {
                case 'f': {
                    if (parseInfo.size != 5 || !string.equals("false")) break;
                    parseInfo.lexeme = 0;
                    return;
                }
                case 'n': {
                    if (parseInfo.size != 2 || !string.equals("no")) break;
                    parseInfo.lexeme = 0;
                    return;
                }
                case 'o': {
                    if (parseInfo.size == 3 && string.equals("off")) {
                        parseInfo.lexeme = 0;
                        return;
                    }
                    if (parseInfo.size != 2 || !string.equals("on")) break;
                    parseInfo.lexeme = 0;
                    return;
                }
                case 't': {
                    if (parseInfo.size != 4 || !string.equals("true")) break;
                    parseInfo.lexeme = 0;
                    return;
                }
                case 'y': {
                    if (parseInfo.size != 3 || !string.equals("yes")) break;
                    parseInfo.lexeme = 0;
                    return;
                }
            }
        } else {
            parseInfo.lexeme = 11;
        }
    }

    static void PrependSubExprTokens(int n, int n2, int n3, int n4, int n5, ParseInfo parseInfo) {
        TclParse tclParse = parseInfo.parseObj;
        if (tclParse.numTokens + 1 >= tclParse.tokensAvailable) {
            tclParse.expandTokenArray(tclParse.numTokens + 1);
        }
        tclParse.insertInTokenArray(n5, 2);
        tclParse.numTokens += 2;
        TclToken tclToken = tclParse.getToken(n5);
        tclToken.type = 64;
        tclToken.script_index = n3;
        tclToken.script_array = parseInfo.originalExpr;
        tclToken.size = n4;
        tclToken.numComponents = tclParse.numTokens - (n5 + 1);
        tclToken = tclParse.getToken(n5 + 1);
        tclToken.type = 128;
        tclToken.script_index = n;
        tclToken.script_array = parseInfo.originalExpr;
        tclToken.size = n2;
        tclToken.numComponents = 0;
    }

    static void LogSyntaxError(ParseInfo parseInfo, String string) throws TclException {
        String string2 = parseInfo.getOriginalExpr();
        if (string2.length() > 60) {
            string2 = string2.substring(0, 60) + "...";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("syntax error in expression \"");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
        parseInfo.parseObj.errorType = 8;
        parseInfo.parseObj.termIndex = parseInfo.start;
        if (parseInfo.parseObj.interp != null) {
            parseInfo.parseObj.interp.resetResult();
        }
        throw new TclException(parseInfo.parseObj.interp, stringBuffer.toString());
    }

    static int ParseMaxDoubleLength(char[] cArray, int n, int n2) {
        int n3;
        block3: for (n3 = n; n3 < n2; ++n3) {
            switch (cArray[n3]) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'I': 
                case 'N': 
                case 'P': 
                case 'X': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'i': 
                case 'n': 
                case 'p': 
                case 'x': {
                    continue block3;
                }
            }
            break;
        }
        return n3 - n;
    }

    static class ParseInfo {
        TclParse parseObj;
        int lexeme;
        int start;
        int size;
        int next;
        int prevEnd;
        char[] originalExpr;
        int originalExprStart;
        int originalExprSize;
        int lastChar;

        ParseInfo() {
        }

        ParseInfo(TclParse tclParse, char[] cArray, int n, int n2) {
            this.parseObj = tclParse;
            this.lexeme = 10;
            this.originalExpr = cArray;
            this.originalExprStart = n;
            this.start = -1;
            this.originalExprSize = n2;
            this.size = n2;
            this.next = n;
            this.prevEnd = n;
            this.lastChar = n + n2;
        }

        String getOriginalExpr() {
            return new String(this.originalExpr, this.originalExprStart, this.originalExprSize);
        }

        ParseInfo duplicate() {
            ParseInfo parseInfo = new ParseInfo();
            parseInfo.parseObj = this.parseObj;
            parseInfo.lexeme = this.lexeme;
            parseInfo.start = this.start;
            parseInfo.size = this.size;
            parseInfo.next = this.next;
            parseInfo.prevEnd = this.prevEnd;
            parseInfo.originalExpr = this.originalExpr;
            parseInfo.originalExprStart = this.originalExprStart;
            parseInfo.originalExprSize = this.originalExprSize;
            parseInfo.lastChar = this.lastChar;
            return parseInfo;
        }
    }
}

