/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.UnaryMathFunction;

class TanhFunction
extends UnaryMathFunction {
    TanhFunction() {
    }

    @Override
    void apply(Interp interp, ExprValue[] exprValueArray) throws TclException {
        ExprValue exprValue = exprValueArray[0];
        double d = exprValue.getDoubleValue();
        if (d == 0.0) {
            return;
        }
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        Expression.checkDoubleRange(interp, d2);
        Expression.checkDoubleRange(interp, d3);
        exprValue.setDoubleValue((d2 - d3) / (d2 + d3));
    }
}

