/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclBoolean
implements InternalRep {
    private static final TclBoolean trueRep = new TclBoolean(true);
    private static final TclBoolean falseRep = new TclBoolean(false);
    private final boolean value;

    private TclBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public InternalRep duplicate() {
        return this;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        if (this.value) {
            return "1";
        }
        return "0";
    }

    public static TclObject newInstance(boolean bl) {
        return new TclObject(bl ? trueRep : falseRep);
    }

    private static void setBooleanFromAny(Interp interp, TclObject tclObject) throws TclException {
        String string = tclObject.toString();
        if (tclObject.isIntType()) {
            long l = TclInteger.getLong(interp, tclObject);
            if (l == 0L) {
                tclObject.setInternalRep(falseRep);
            } else {
                tclObject.setInternalRep(trueRep);
            }
        } else if (tclObject.isDoubleType()) {
            double d = TclDouble.get(interp, tclObject);
            if (d == 0.0) {
                tclObject.setInternalRep(falseRep);
            } else {
                tclObject.setInternalRep(trueRep);
            }
        } else {
            boolean bl;
            boolean bl2;
            block19: {
                string = string.toLowerCase();
                String string2 = string.toLowerCase();
                bl2 = false;
                try {
                    bl = Util.getBoolean(interp, string2);
                }
                catch (TclException tclException) {
                    bl2 = true;
                    bl = false;
                    if (interp != null) {
                        interp.resetResult();
                    }
                    try {
                        bl = Util.getInt(interp, string2) != 0L;
                        bl2 = false;
                    }
                    catch (TclException tclException2) {
                        // empty catch block
                    }
                    if (!bl2) break block19;
                    try {
                        bl = Util.getDouble(interp, string2) != 0.0;
                        bl2 = false;
                    }
                    catch (TclException tclException3) {
                        // empty catch block
                    }
                }
            }
            if (bl2) {
                if (interp != null) {
                    interp.resetResult();
                }
                throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
            }
            if (bl) {
                tclObject.setInternalRep(trueRep);
            } else {
                tclObject.setInternalRep(falseRep);
            }
        }
    }

    public static boolean get(Interp interp, TclObject tclObject) throws TclException {
        TclBoolean tclBoolean;
        InternalRep internalRep;
        if (tclObject.isIntType()) {
            long l = tclObject.ivalue;
            if (l == 0L) {
                return false;
            }
            if (l == 1L) {
                return true;
            }
        }
        if (!((internalRep = tclObject.getInternalRep()) instanceof TclBoolean)) {
            TclBoolean.setBooleanFromAny(interp, tclObject);
            tclBoolean = (TclBoolean)tclObject.getInternalRep();
        } else {
            tclBoolean = (TclBoolean)internalRep;
        }
        return tclBoolean.value;
    }
}

