/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
implements InternalRep {
    private ArrayList<TclObject> alist;

    private TclList() {
        this.alist = new ArrayList();
    }

    private TclList(int n) {
        this.alist = new ArrayList(n);
    }

    @Override
    public void dispose() {
        int n = this.alist.size();
        for (int i = 0; i < n; ++i) {
            this.alist.get(i).release();
        }
        this.alist.clear();
    }

    @Override
    public InternalRep duplicate() {
        int n = this.alist.size();
        TclList tclList = new TclList(n);
        for (int i = 0; i < n; ++i) {
            TclObject tclObject = this.alist.get(i);
            tclObject.preserve();
            tclList.alist.add(tclObject);
        }
        return tclList;
    }

    public String toString() {
        int n = this.alist.size();
        if (n == 0) {
            return "";
        }
        int n2 = n * 4;
        StringBuffer stringBuffer = new StringBuffer(n2 > 64 ? n2 : 64);
        try {
            for (int i = 0; i < n; ++i) {
                TclObject tclObject = this.alist.get(i);
                if (tclObject != null) {
                    Util.appendElement(null, stringBuffer, tclObject.toString());
                    continue;
                }
                Util.appendElement(null, stringBuffer, "");
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        return stringBuffer.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    public static TclObject copy(Interp interp, TclObject tclObject) {
        if (!tclObject.isListType()) {
            try {
                TclList.setListFromAny(interp, tclObject);
            }
            catch (TclException tclException) {
                return null;
            }
        }
        TclObject tclObject2 = TclList.newInstance();
        tclObject2.invalidateStringRep();
        tclObject2 = tclObject.duplicate();
        return tclObject2;
    }

    private static void setListFromAny(Interp interp, TclObject tclObject) throws TclException {
        TclList tclList = new TclList();
        TclList.splitList(interp, tclList.alist, tclObject.toString());
        tclObject.setInternalRep(tclList);
    }

    private static final void splitList(Interp interp, ArrayList<TclObject> arrayList, String string) throws TclException {
        int n = string.length();
        int n2 = 0;
        FindElemResult findElemResult = new FindElemResult();
        while (n2 < n && Util.findElement(interp, string, n2, n, findElemResult)) {
            TclObject tclObject = TclString.newInstance(findElemResult.elem);
            tclObject.preserve();
            arrayList.add(tclObject);
            n2 = findElemResult.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tclObject, TclObject tclObject2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        tclObject2.preserve();
        ((TclList)tclObject.getInternalRep()).alist.add(tclObject2);
    }

    public static final void append(Interp interp, TclObject tclObject, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        ArrayList<TclObject> arrayList = ((TclList)tclObject.getInternalRep()).alist;
        for (int i = n; i < n2; ++i) {
            TclObject tclObject2 = tclObjectArray[i];
            tclObject2.preserve();
            arrayList.add(tclObject2);
        }
    }

    public static final int getLength(Interp interp, TclObject tclObject) throws TclException {
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        return tclList.alist.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tclObject) throws TclException {
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        int n = tclList.alist.size();
        TclObject[] tclObjectArray = new TclObject[n];
        for (int i = 0; i < n; ++i) {
            tclObjectArray[i] = tclList.alist.get(i);
        }
        return tclObjectArray;
    }

    public static ArrayList getElementsList(Interp interp, TclObject tclObject) throws TclException {
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        return tclList.alist;
    }

    public static void setElement(Interp interp, TclObject tclObject, int n, TclObject tclObject2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclListObjSetElement called with shared object");
        }
        if (!tclObject.isListType()) {
            if (tclObject.toString().length() == 0) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(0);
            }
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        TclObject[] tclObjectArray = tclList.alist.toArray(new TclObject[tclList.alist.size()]);
        int n2 = tclList.alist.size();
        if (n < 0 || n >= n2) {
            if (interp != null) {
                interp.setResult(TclString.newInstance("list index out of range"));
            }
            throw new TclRuntimeError("list index out of range");
        }
        if (tclObject.getRefCount() > 1) {
            TclList tclList2 = tclList;
            TclObject[] tclObjectArray2 = tclObjectArray;
            tclList = new TclList(n2);
            if (tclList == null) {
                throw new TclRuntimeError("Not enough memory to allocate list");
            }
            tclObjectArray = (TclObject[])tclList.alist.toArray();
            for (int i = 0; i < n2; ++i) {
                tclObjectArray[i] = tclObjectArray2[i];
                tclObjectArray[i].preserve();
            }
            tclList.duplicate();
            tclObject.setInternalRep(tclList);
            tclList2.dispose();
        }
        --tclObjectArray[n].refCount;
        tclObjectArray[n] = tclObject2;
        TclList.replace(interp, tclObject, 0, TclList.getLength(interp, tclObject), tclObjectArray, 0, tclObjectArray.length - 1);
    }

    public static void lsetElement(Interp interp, TclObject tclObject, int n, TclObject tclObject2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclListObjSetElement called with shared object");
        }
        if (!tclObject.isListType()) {
            if (tclObject.toString().length() == 0) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(0);
            }
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        ArrayList<TclObject> arrayList = tclList.alist;
        int n2 = arrayList.size();
        if (n < 0 || n >= n2) {
            if (interp != null) {
                interp.setResult(TclString.newInstance("list index out of range"));
            }
            throw new TclRuntimeError("list index out of range");
        }
        if (tclObject.getRefCount() > 1) {
            TclList tclList2 = tclList;
            tclList = new TclList(n2);
            if (tclList == null) {
                throw new TclRuntimeError("Not enough memory to allocate list");
            }
            tclList.duplicate();
            tclObject.setInternalRep(tclList);
            tclList2.dispose();
            arrayList = tclList.alist;
        }
        --arrayList.get((int)n).refCount;
        arrayList.set(n, tclObject2);
        tclObject2.preserve();
    }

    public static final TclObject index(Interp interp, TclObject tclObject, int n) throws TclException {
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        TclList tclList = (TclList)tclObject.getInternalRep();
        if (n < 0 || n >= tclList.alist.size()) {
            return null;
        }
        return tclList.alist.get(n);
    }

    public static final void insert(Interp interp, TclObject tclObject, int n, TclObject[] tclObjectArray, int n2, int n3) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclList.insert() called with shared object");
        }
        TclList.replace(interp, tclObject, n, 0, tclObjectArray, n2, n3);
    }

    public static final void replace(Interp interp, TclObject tclObject, int n, int n2, TclObject[] tclObjectArray, int n3, int n4) throws TclException {
        int n5;
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclList.replace() called with shared object");
        }
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        TclList tclList = (TclList)tclObject.getInternalRep();
        int n6 = tclList.alist.size();
        if (n >= n6) {
            n = n6;
        } else {
            if (n < 0) {
                n = 0;
            }
            if (n2 > n6 - n) {
                n2 = n6 - n;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                TclObject tclObject2 = tclList.alist.get(n);
                tclList.alist.remove(n);
            }
        }
        for (n5 = n3; n5 <= n4; ++n5) {
            tclObjectArray[n5].preserve();
            tclList.alist.add(n++, tclObjectArray[n5]);
        }
    }

    public static void sort(Interp interp, TclObject tclObject, int n, int n2, boolean bl, boolean bl2, String string) throws TclException {
        if (!tclObject.isListType()) {
            TclList.setListFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        TclList tclList = (TclList)tclObject.getInternalRep();
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        tclList.alist.clear();
        QSort qSort = new QSort();
        qSort.sort(interp, tclObjectArray, n, n2, bl, string);
        for (int i = 0; i < tclObjectArray.length; ++i) {
            TclObject tclObject2;
            TclObject tclObject3;
            if (bl2 && i < tclObjectArray.length - 1 && qSort.compare(tclObject3 = tclObjectArray[i], tclObject2 = tclObjectArray[i + 1]) == 0) continue;
            tclList.alist.add(tclObjectArray[i]);
            tclObjectArray[i] = null;
        }
    }
}

