/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class TimerHandler {
    Notifier notifier;
    long atTime;
    boolean isCancelled;
    int generation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerHandler(Notifier notifier, long l) {
        this.atTime = System.currentTimeMillis() + l;
        this.notifier = notifier;
        this.isCancelled = false;
        Notifier notifier2 = this.notifier;
        synchronized (notifier2) {
            int n;
            this.generation = this.notifier.timerGeneration;
            for (n = 0; n < this.notifier.timerList.size(); ++n) {
                TimerHandler timerHandler = this.notifier.timerList.get(n);
                if (this.atTime < timerHandler.atTime) break;
            }
            this.notifier.timerList.add(n, this);
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            for (int i = 0; i < this.notifier.timerList.size(); ++i) {
                if (this.notifier.timerList.get(i) != this) continue;
                this.notifier.timerList.remove(i);
                return;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processTimerEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processTimerEvent();
}

