/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.TraceRecord;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Var {
    static final int SCALAR = 1;
    static final int ARRAY = 2;
    static final int LINK = 4;
    static final int UNDEFINED = 8;
    static final int IN_HASHTABLE = 16;
    static final int TRACE_ACTIVE = 32;
    static final int ARRAY_ELEMENT = 64;
    static final int NAMESPACE_VAR = 128;
    static final int NO_CACHE = 256;
    static final int NON_LOCAL = 512;
    static final int TRACE_EXISTS = 1024;
    public static final int EXPLICIT_LOCAL_NAME = 4096;
    private TclObject tobj;
    private Map<String, Var> arraymap;
    Var linkto;
    public ArrayList traces;
    public ArrayList sidVec;
    int flags;
    public Map table;
    public String hashKey;
    public int refCount;
    public Namespace ns;
    static final String noSuchVar = "no such variable";
    static final String isArray = "variable is array";
    static final String needArray = "variable isn't array";
    static final String noSuchElement = "no such element in array";
    static final String danglingElement = "upvar refers to element in deleted array";
    static final String danglingVar = "upvar refers to variable in deleted namespace";
    static final String badNamespace = "parent namespace doesn't exist";
    static final String missingName = "missing variable name";

    public final boolean isVarScalar() {
        return (this.flags & 1) != 0;
    }

    public final boolean isVarLink() {
        return (this.flags & 4) != 0;
    }

    public final boolean isVarArray() {
        return (this.flags & 2) != 0;
    }

    public final boolean isVarUndefined() {
        return (this.flags & 8) != 0;
    }

    public final boolean isVarArrayElement() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isVarNamespace() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean isVarInHashtable() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean isVarTraceExists() {
        return (this.flags & 0x400) != 0;
    }

    public final boolean isVarNoCache() {
        return (this.flags & 0x100) != 0;
    }

    final boolean isVarNonLocal() {
        return (this.flags & 0x200) != 0;
    }

    final void setVarScalar() {
        this.flags = this.flags & 0xFFFFFFF9 | 1;
    }

    final void setVarArray() {
        this.flags = this.flags & 0xFFFFFFFA | 2;
    }

    final void setVarLink() {
        this.flags = this.flags & 0xFFFFFFFC | 4;
    }

    final void setVarArrayElement() {
        this.flags = this.flags & 0xFFFFFFFD | 0x40;
    }

    final void setVarUndefined() {
        this.flags |= 8;
    }

    public final void setVarNamespace() {
        this.flags |= 0x80;
    }

    final void setVarInHashtable() {
        this.flags |= 0x10;
    }

    final void setVarNonLocal() {
        this.flags |= 0x200;
    }

    final void setVarNoCache() {
        this.flags |= 0x100;
    }

    final void setVarTraceExists() {
        this.flags |= 0x400;
    }

    final void clearVarUndefined() {
        this.flags &= 0xFFFFFFF7;
    }

    public final void clearVarInHashtable() {
        this.flags &= 0xFFFFFFEF;
    }

    final void clearVarTraceExists() {
        this.flags &= 0xFFFFFBFF;
    }

    public Var() {
        this.setValue(null);
        this.deleteArrayMap();
        this.linkto = null;
        this.ns = null;
        this.hashKey = null;
        this.table = null;
        this.refCount = 0;
        this.traces = null;
        this.sidVec = null;
        this.flags = 25;
    }

    public void setValue(TclObject tclObject) {
        this.tobj = tclObject;
    }

    public TclObject getValue() {
        return this.tobj;
    }

    public Map<String, Var> getArrayMap() {
        return this.arraymap;
    }

    public void createArrayMap() {
        this.arraymap = new HashMap<String, Var>();
    }

    public void deleteArrayMap() {
        this.arraymap = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ns != null) {
            stringBuffer.append(this.ns.fullName);
            if (this.ns.fullName.equals("::")) {
                stringBuffer.append(this.hashKey);
            } else {
                stringBuffer.append("::");
                stringBuffer.append(this.hashKey);
            }
        } else {
            stringBuffer.append(this.hashKey);
        }
        if (this.isVarScalar()) {
            stringBuffer.append(" ");
            stringBuffer.append("SCALAR");
        }
        if (this.isVarLink()) {
            stringBuffer.append(" ");
            stringBuffer.append("LINK");
        }
        if (this.isVarArray()) {
            stringBuffer.append(" ");
            stringBuffer.append("ARRAY");
        }
        if (this.isVarUndefined()) {
            stringBuffer.append(" ");
            stringBuffer.append("UNDEFINED");
        }
        if (this.isVarArrayElement()) {
            stringBuffer.append(" ");
            stringBuffer.append("ARRAY_ELEMENT");
        }
        if (this.isVarNamespace()) {
            stringBuffer.append(" ");
            stringBuffer.append("NAMESPACE_VAR");
        }
        if (this.isVarInHashtable()) {
            stringBuffer.append(" ");
            stringBuffer.append("IN_HASHTABLE");
        }
        if (this.isVarTraceExists()) {
            stringBuffer.append(" ");
            stringBuffer.append("TRACE_EXISTS");
        }
        if (this.isVarNoCache()) {
            stringBuffer.append(" ");
            stringBuffer.append("NO_CACHE");
        }
        return stringBuffer.toString();
    }

    public int getNextIndex() {
        int n = this.sidVec.size();
        if (n == 0) {
            return 1;
        }
        SearchId searchId = (SearchId)this.sidVec.get(n - 1);
        return searchId.getIndex() + 1;
    }

    public Iterator getSearch(String string) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId searchId = (SearchId)this.sidVec.get(i);
            if (!searchId.equals(string)) continue;
            return searchId.getIterator();
        }
        return null;
    }

    public boolean removeSearch(String string) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId searchId = (SearchId)this.sidVec.get(i);
            if (!searchId.equals(string)) continue;
            this.sidVec.remove(i);
            return true;
        }
        return false;
    }

    public static final boolean isArrayVarname(String string) {
        int n = string.length() - 1;
        return n > 1 && string.charAt(n) == ')' && string.indexOf(40) > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Var[] lookupVar(Interp interp, String string, String string2, int n, String string3, boolean bl, boolean bl2) throws TclException {
        String[] stringArray;
        Var[] varArray;
        CallFrame callFrame = interp.varFrame;
        Var var = null;
        Namespace namespace = null;
        String string4 = string2;
        int n2 = -1;
        int n3 = string.length() - 1;
        if (n3 > 0 && string.charAt(n3) == ')') {
            n2 = string.indexOf(40);
        }
        if (n2 != -1) {
            if (string2 != null) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, string3, needArray);
                }
                return null;
            }
            string2 = string4 = string.substring(n2 + 1, n3);
            string = string.substring(0, n2);
        }
        Namespace namespace2 = (n & 1) != 0 || interp.varFrame == null ? interp.globalNs : interp.varFrame.ns;
        if (namespace2.resolver != null || interp.resolvers != null) {
            try {
                if (namespace2.resolver != null) {
                    var = namespace2.resolver.resolveVar(interp, string, namespace2, n);
                    if (var != null) {
                        var.setVarNoCache();
                    }
                } else {
                    var = null;
                }
                if (var == null && interp.resolvers != null) {
                    varArray = interp.resolvers.listIterator();
                    while (var == null && varArray.hasNext()) {
                        Interp.ResolverScheme resolverScheme = (Interp.ResolverScheme)varArray.next();
                        var = resolverScheme.resolver.resolveVar(interp, string, namespace2, n);
                        if (var == null) continue;
                        var.setVarNoCache();
                    }
                }
            }
            catch (TclException tclException) {
                var = null;
            }
        }
        if ((n & 3) != 0 || callFrame == null || !callFrame.isProcCallFrame || string.indexOf("::") != -1) {
            var = Namespace.findNamespaceVar(interp, string, null, n & 0xFFFFFDFF);
            if (var == null) {
                if (bl) {
                    stringArray = interp.getnfqnResult;
                    Namespace.getNamespaceForQualName(interp, string, null, n, (Namespace.GetNamespaceForQualNameResult)stringArray);
                    namespace = stringArray.ns;
                    varArray = stringArray.simpleName;
                    if (namespace == null) {
                        if ((n & 0x200) != 0) {
                            throw new TclVarException(interp, string, string2, string3, badNamespace);
                        }
                        return null;
                    }
                    if (varArray == null) {
                        if ((n & 0x200) != 0) {
                            throw new TclVarException(interp, string, string2, string3, missingName);
                        }
                        return null;
                    }
                    var = new Var();
                    namespace.varTable.put((String)varArray, var);
                    var.hashKey = varArray;
                    var.table = namespace.varTable;
                    var.ns = namespace;
                } else {
                    if ((n & 0x200) != 0) {
                        throw new TclVarException(interp, string, string2, string3, noSuchVar);
                    }
                    return null;
                }
            }
        } else {
            if (callFrame.compiledLocals != null) {
                varArray = callFrame.compiledLocals;
                stringArray = callFrame.compiledLocalsNames;
                int n4 = varArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    Var var2 = varArray[i];
                    if (var2 == null) {
                        if (!bl) break;
                        var = new Var();
                        var.hashKey = string;
                        var.clearVarInHashtable();
                        varArray[i] = var;
                        break;
                    }
                    if (var2.isVarNonLocal()) {
                        throw new TclRuntimeError("can't lookup scoped variable \"" + string + "\" in local table");
                    }
                    var = var2;
                    break;
                }
            }
            if (var == null) {
                HashMap<String, Var> hashMap = callFrame.varTable;
                if (bl) {
                    if (hashMap == null) {
                        callFrame.varTable = hashMap = new HashMap<String, Var>();
                    }
                    if ((var = (Var)hashMap.get(string)) == null) {
                        var = new Var();
                        hashMap.put(string, var);
                        var.hashKey = string;
                        var.table = hashMap;
                    }
                } else {
                    if (hashMap != null) {
                        var = (Var)hashMap.get(string);
                    }
                    if (var == null) {
                        if ((n & 0x200) != 0) {
                            throw new TclVarException(interp, string, string2, string3, noSuchVar);
                        }
                        return null;
                    }
                }
            }
        }
        while (var.isVarLink()) {
            var = var.linkto;
        }
        if (string4 == null) {
            varArray = interp.lookupVarResult;
            varArray[0] = var;
            varArray[1] = null;
            return varArray;
        }
        return Var.lookupArrayElement(interp, string, string4, n, string3, bl, bl2, var);
    }

    static Var[] lookupArrayElement(Interp interp, String string, String string2, int n, String string3, boolean bl, boolean bl2, Var var) throws TclException {
        Var[] varArray;
        if (var.isVarUndefined() && !var.isVarArrayElement()) {
            if (!bl) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, string3, noSuchVar);
                }
                return null;
            }
            if ((var.flags & 0x10) != 0 && var.table == null) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, string3, danglingVar);
                }
                return null;
            }
            var.setVarArray();
            var.clearVarUndefined();
            var.createArrayMap();
        } else if (!var.isVarArray()) {
            if ((n & 0x200) != 0) {
                throw new TclVarException(interp, string, string2, string3, needArray);
            }
            return null;
        }
        Var var2 = var;
        Map<String, Var> map = var.getArrayMap();
        if (bl2) {
            varArray = map.get(string2);
            if (varArray == null) {
                if (var.sidVec != null) {
                    Var.deleteSearches(var);
                }
                var = new Var();
                map.put(string2, var);
                var.hashKey = string2;
                var.table = map;
                var.ns = var2.ns;
                var.setVarArrayElement();
            } else {
                var = varArray;
            }
        } else {
            var = map.get(string2);
            if (var == null) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, string3, noSuchElement);
                }
                return null;
            }
        }
        varArray = interp.lookupVarResult;
        varArray[0] = var;
        varArray[1] = var2;
        return varArray;
    }

    public static TclObject getVar(Interp interp, String string, String string2, int n) throws TclException {
        Var[] varArray = Var.lookupVar(interp, string, string2, n, "read", false, true);
        if (varArray == null) {
            return null;
        }
        return Var.getVarPtr(interp, varArray[0], varArray[1], string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject getVarPtr(Interp interp, Var var, Var var2, String string, String string2, int n) throws TclException {
        try {
            Object object;
            if ((var.traces != null || var2 != null && var2.traces != null) && (object = Var.callTraces(interp, var2, var, string, string2, n & 3 | 0x10)) != null) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, "read", (String)object);
                }
                TclObject tclObject = null;
                return tclObject;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                object = var.getValue();
                return object;
            }
            if ((n & 0x200) != 0) {
                object = var.isVarUndefined() && var2 != null && !var2.isVarUndefined() ? noSuchElement : (var.isVarArray() ? isArray : noSuchVar);
                throw new TclVarException(interp, string, string2, "read", (String)object);
            }
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, var2);
            }
        }
        return null;
    }

    public static TclObject setVar(Interp interp, String string, String string2, TclObject tclObject, int n) throws TclException {
        Var[] varArray = Var.lookupVar(interp, string, string2, n, "set", true, true);
        if (varArray == null) {
            return null;
        }
        return Var.setVarPtr(interp, varArray[0], varArray[1], string, string2, tclObject, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject setVarPtr(Interp interp, Var var, Var var2, String string, String string2, TclObject tclObject, int n) throws TclException {
        if ((var.flags & 0x10) != 0 && var.table == null) {
            if ((n & 0x200) != 0) {
                if (var.isVarArrayElement()) {
                    throw new TclVarException(interp, string, string2, "set", danglingElement);
                }
                throw new TclVarException(interp, string, string2, "set", danglingVar);
            }
            return null;
        }
        if (var.isVarArray() && !var.isVarUndefined()) {
            if ((n & 0x200) != 0) {
                throw new TclVarException(interp, string, string2, "set", isArray);
            }
            return null;
        }
        try {
            StringBuffer stringBuffer;
            Object object;
            TclObject tclObject2 = var.getValue();
            if ((n & 4) != 0) {
                if (var.isVarUndefined() && tclObject2 != null) {
                    tclObject2.release();
                    var.setValue(null);
                    tclObject2 = null;
                }
                if ((n & 8) != 0) {
                    if (tclObject2 == null) {
                        tclObject2 = TclList.newInstance();
                        var.setValue(tclObject2);
                        tclObject2.preserve();
                    } else if (tclObject2.isShared()) {
                        var.setValue(tclObject2.duplicate());
                        tclObject2.release();
                        tclObject2 = var.getValue();
                        tclObject2.preserve();
                    }
                    TclList.append(interp, tclObject2, tclObject);
                } else {
                    String string3 = tclObject.toString();
                    if (tclObject2 == null) {
                        object = TclString.newInstance(string3);
                        var.setValue((TclObject)object);
                        ((TclObject)object).preserve();
                    } else {
                        if (tclObject2.isShared()) {
                            var.setValue(tclObject2.duplicate());
                            tclObject2.release();
                            tclObject2 = var.getValue();
                            tclObject2.preserve();
                        }
                        TclString.append(tclObject2, string3);
                    }
                }
            } else if ((n & 8) != 0) {
                if (tclObject2 != null) {
                    tclObject2.release();
                }
                String string4 = tclObject.toString();
                int n2 = Util.scanElement(interp, string4);
                stringBuffer = new StringBuffer(64);
                Util.convertElement(string4, n2, stringBuffer);
                tclObject2 = TclString.newInstance(stringBuffer.toString());
                var.setValue(tclObject2);
                var.getValue().preserve();
            } else if (tclObject != tclObject2) {
                var.setValue(tclObject);
                tclObject.preserve();
                if (tclObject2 != null) {
                    tclObject2.release();
                }
            }
            var.setVarScalar();
            var.clearVarUndefined();
            if (var2 != null) {
                var2.clearVarUndefined();
            }
            if ((var.traces != null || var2 != null && var2.traces != null) && (object = Var.callTraces(interp, var2, var, string, string2, n & 3 | 0x20)) != null) {
                if ((n & 0x200) != 0) {
                    throw new TclVarException(interp, string, string2, "set", (String)object);
                }
                stringBuffer = null;
                return stringBuffer;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                object = var.getValue();
                return object;
            }
            object = TclString.newInstance("");
            return object;
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, var2);
            }
        }
    }

    public static TclObject initVarCompiledLocalScalar(Interp interp, String string, TclObject tclObject, Var[] varArray, int n) throws TclException {
        Var var = new Var();
        var.flags = 1;
        var.hashKey = string;
        var.setValue(tclObject);
        tclObject.preserve();
        varArray[n] = var;
        return tclObject;
    }

    public static TclObject setVarCompiledLocalScalarInvalid(Interp interp, String string, TclObject tclObject) throws TclException {
        return Var.setVar(interp, string, null, tclObject, 512);
    }

    public static TclObject getVarCompiledLocalScalarInvalid(Interp interp, String string) throws TclException {
        return Var.getVar(interp, string, null, 512);
    }

    public static TclObject initVarCompiledLocalArray(Interp interp, String string, String string2, TclObject tclObject, Var[] varArray, int n) throws TclException {
        Var var = new Var();
        var.clearVarInHashtable();
        var.hashKey = string;
        varArray[n] = var;
        return Var.setVar(interp, string, string2, tclObject, 512);
    }

    public static TclObject setVarCompiledLocalArrayInvalid(Interp interp, String string, String string2, TclObject tclObject) throws TclException {
        return Var.setVar(interp, string, string2, tclObject, 512);
    }

    public static TclObject getVarCompiledLocalArrayInvalid(Interp interp, String string, String string2) throws TclException {
        return Var.getVar(interp, string, string2, 512);
    }

    public static TclObject getVarCompiledLocalArray(Interp interp, String string, String string2, Var var, boolean bl) throws TclException {
        Var[] varArray;
        int n = 0;
        if (bl) {
            n = 512;
        }
        if ((varArray = Var.lookupArrayElement(interp, string, string2, n, "read", false, false, var)) == null) {
            return null;
        }
        return Var.getVarPtr(interp, varArray[0], varArray[1], string, string2, 512);
    }

    public static TclObject setVarCompiledLocalArray(Interp interp, String string, String string2, TclObject tclObject, Var var) throws TclException {
        Var[] varArray = Var.lookupArrayElement(interp, string, string2, 512, "set", false, true, var);
        return Var.setVarPtr(interp, varArray[0], varArray[1], string, string2, tclObject, 512);
    }

    public static TclObject incrVar(Interp interp, String string, String string2, long l, int n) throws TclException {
        TclObject tclObject = null;
        boolean bl = false;
        try {
            tclObject = Var.getVar(interp, string, string2, n);
        }
        catch (TclException tclException) {
            bl = true;
            throw tclException;
        }
        finally {
            if (bl || tclObject == null) {
                interp.addErrorInfo("\n    (reading value of variable to increment)");
            }
        }
        boolean bl2 = false;
        if (tclObject.isShared()) {
            tclObject = tclObject.duplicate();
            bl2 = true;
        }
        try {
            TclInteger.incr(interp, tclObject, l);
        }
        catch (TclException tclException) {
            if (bl2) {
                tclObject.release();
            }
            throw tclException;
        }
        return Var.setVar(interp, string, string2, tclObject, n);
    }

    static void unsetVar(Interp interp, String string, String string2, int n) throws TclException {
        boolean bl;
        Var[] varArray = Var.lookupVar(interp, string, string2, n, "unset", false, false);
        if (varArray == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        Var var = varArray[0];
        Var var2 = varArray[1];
        boolean bl2 = bl = var.isVarUndefined();
        if (var2 != null && var2.sidVec != null) {
            Var.deleteSearches(var2);
        }
        Var var3 = new Var();
        var3.setValue(var.getValue());
        if (var.getArrayMap() != null) {
            var3.createArrayMap();
            var3.getArrayMap().putAll(var.getArrayMap());
        }
        var3.linkto = var.linkto;
        var3.traces = var.traces;
        var3.flags = var.flags;
        var3.hashKey = var.hashKey;
        var3.table = var.table;
        var3.refCount = var.refCount;
        var3.ns = var.ns;
        var.setVarUndefined();
        var.setVarScalar();
        var.setValue(null);
        var.deleteArrayMap();
        var.linkto = null;
        var.traces = null;
        var.sidVec = null;
        if (var3.traces != null || var2 != null && var2.traces != null) {
            ++var.refCount;
            var3.flags &= 0xFFFFFFDF;
            Var.callTraces(interp, var2, var3, string, string2, n & 3 | 0x40);
            var3.traces = null;
            --var.refCount;
        }
        if (var3.isVarArray() && !var3.isVarUndefined()) {
            Var.deleteArray(interp, string, var3, n & 3 | 0x40);
        }
        if (var3.isVarScalar() && var3.getValue() != null) {
            TclObject tclObject = var3.getValue();
            tclObject.release();
            var3.setValue(null);
        }
        if ((var.flags & 0x80) != 0) {
            var.flags &= 0xFFFFFF7F;
            --var.refCount;
        }
        Var.cleanupVar(var, var2);
        Var.setUndefinedToNull(interp, string, string2);
        if (bl && (n & 0x200) != 0) {
            throw new TclVarException(interp, string, string2, "unset", var2 == null ? noSuchVar : noSuchElement);
        }
    }

    public static void traceVar(Interp interp, String string, String string2, int n, VarTrace varTrace) throws TclException {
        Var[] varArray = Var.lookupVar(interp, string, string2, n | 0x200, "trace", true, true);
        if (varArray == null) {
            throw new TclException(interp, "");
        }
        Var var = varArray[0];
        if (var.traces == null) {
            var.setVarTraceExists();
            var.traces = new ArrayList();
        }
        TraceRecord traceRecord = new TraceRecord();
        traceRecord.trace = varTrace;
        traceRecord.flags = n & 0x870;
        var.traces.add(0, traceRecord);
    }

    public static void untraceVar(Interp interp, String string, String string2, int n, VarTrace varTrace) {
        Var[] varArray = null;
        try {
            varArray = Var.lookupVar(interp, string, string2, n & 3, null, false, false);
            if (varArray == null) {
                return;
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Var var = varArray[0];
        if (var.traces != null) {
            int n2 = var.traces.size();
            for (int i = 0; i < n2; ++i) {
                TraceRecord traceRecord = (TraceRecord)var.traces.get(i);
                if (traceRecord.trace != varTrace) continue;
                var.traces.remove(i);
                break;
            }
            if (var.traces.size() == 0) {
                var.traces = null;
                var.clearVarTraceExists();
            }
        }
        if (var.isVarUndefined()) {
            Var.cleanupVar(var, null);
        }
    }

    public static ArrayList getTraces(Interp interp, String string, String string2, int n) throws TclException {
        Var[] varArray = Var.lookupVar(interp, string, string2, n & 3, null, false, false);
        if (varArray == null) {
            return null;
        }
        return varArray[0].traces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeUpvar(Interp interp, CallFrame callFrame, String string, String string2, int n, String string3, int n2, int n3) throws TclException {
        Var var;
        int n4;
        Var[] varArray = null;
        CallFrame callFrame2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Var[] varArray2 = null;
        try {
            if ((n & 2) == 0) {
                callFrame2 = interp.varFrame;
                interp.varFrame = callFrame;
            }
            n4 = n | 0x200;
            if ((n2 & 0x1000) != 0) {
                n4 = n;
            }
            varArray = Var.lookupVar(interp, string, string2, n4, "access", true, true);
        }
        finally {
            if ((n & 2) == 0) {
                interp.varFrame = callFrame2;
            }
        }
        if (varArray == null) {
            return;
        }
        Var var2 = varArray[0];
        Var var3 = varArray[1];
        if (var2 == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        if (var2.isVarLink()) {
            throw new TclRuntimeError("other var resolved to a link var");
        }
        CallFrame callFrame3 = interp.varFrame;
        if ((n2 & 3) != 0 || callFrame3 == null || !callFrame3.isProcCallFrame || string3.indexOf("::") != -1 && (n2 & 0x1000) == 0) {
            Namespace.GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, string3, null, n2, getNamespaceForQualNameResult);
            Namespace namespace = getNamespaceForQualNameResult.ns;
            Namespace namespace2 = getNamespaceForQualNameResult.altNs;
            String string4 = getNamespaceForQualNameResult.simpleName;
            if (namespace == null) {
                namespace = namespace2;
            }
            if (namespace == null) {
                throw new TclException(interp, "can't create \"" + string3 + "\": parent namespace doesn't exist");
            }
            if ((string2 != null ? var3.ns : var2.ns) == null) {
                throw new TclException(interp, "bad variable name \"" + string3 + "\": upvar won't create namespace variable that refers to procedure variable");
            }
            var = namespace.varTable.get(string4);
            if (var == null) {
                bl = true;
                var = new Var();
                namespace.varTable.put(string4, var);
                var.hashKey = string4;
                var.table = namespace.varTable;
                var.ns = namespace;
            }
        } else {
            var = null;
            varArray2 = callFrame3.compiledLocals;
            if (varArray2 != null) {
                if (n3 == -1) {
                    n4 = varArray2.length;
                    String[] stringArray = callFrame3.compiledLocalsNames;
                    for (int i = 0; i < n4; ++i) {
                        if (!stringArray[i].equals(string3)) continue;
                        bl2 = true;
                        n3 = i;
                        var = varArray2[i];
                        break;
                    }
                } else {
                    bl2 = true;
                    var = varArray2[n3];
                }
            }
            if (!bl2) {
                HashMap<String, Var> hashMap = callFrame3.varTable;
                if (hashMap == null) {
                    callFrame3.varTable = hashMap = new HashMap<String, Var>();
                }
                if (hashMap != null) {
                    var = (Var)hashMap.get(string3);
                }
                if (var == null) {
                    bl = true;
                    var = new Var();
                    hashMap.put(string3, var);
                    var.hashKey = string3;
                    var.table = hashMap;
                }
                if (var != null) {
                    bl3 = true;
                }
            }
            if (bl2 && var == null) {
                bl = true;
                var = new Var();
                var.hashKey = string3;
                var.clearVarInHashtable();
            }
        }
        if (!bl) {
            if (var == var2) {
                throw new TclException(interp, "can't upvar from variable to itself");
            }
            if (var.isVarLink()) {
                Var var4 = var.linkto;
                if (var4 == var2) {
                    return;
                }
                --var4.refCount;
                if (var4.isVarUndefined()) {
                    Var.cleanupVar(var4, null);
                }
            } else {
                if (!var.isVarUndefined()) {
                    throw new TclException(interp, "variable \"" + string3 + "\" already exists");
                }
                if (var.traces != null) {
                    throw new TclException(interp, "variable \"" + string3 + "\" has traces: can't use for upvar");
                }
            }
        }
        var.setVarLink();
        var.clearVarUndefined();
        var.linkto = var2;
        ++var2.refCount;
        if (bl2) {
            if (bl) {
                varArray2[n3] = var;
            }
            if ((n2 & 0x1000) != 0) {
                var.setVarNonLocal();
            }
        }
    }

    public static String getVariableFullName(Interp interp, Var var) {
        StringBuffer stringBuffer = new StringBuffer();
        if (var != null && !var.isVarArrayElement()) {
            if (var.ns != null) {
                stringBuffer.append(var.ns.fullName);
                if (var.ns != interp.globalNs) {
                    stringBuffer.append("::");
                }
            }
            if (var.hashKey != null) {
                stringBuffer.append(var.hashKey);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callTraces(Interp interp, Var var, Var var2, String string, String string2, int n) {
        int n2;
        int n3;
        if ((var2.flags & 0x20) != 0) {
            return null;
        }
        var2.flags |= 0x20;
        ++var2.refCount;
        if (string2 == null && (n3 = string.length()) > 0 && string.charAt(n3 - 1) == ')') {
            for (n2 = 0; n2 < n3 - 1 && string.charAt(n2) != '('; ++n2) {
            }
            if (n2 < n3 - 1 && n2 < n3 - 2) {
                string2 = string.substring(n2 + 1, n3 - 1);
                string = string.substring(0, n2);
            }
        }
        TclObject tclObject = interp.getResult();
        tclObject.preserve();
        interp.resetResult();
        try {
            if (var != null) {
                ++var.refCount;
            }
            if (var != null && var.traces != null) {
                for (n2 = 0; var.traces != null && n2 < var.traces.size(); ++n2) {
                    TraceRecord traceRecord = (TraceRecord)var.traces.get(n2);
                    if ((traceRecord.flags & n) == 0) continue;
                    try {
                        traceRecord.trace.traceProc(interp, string, string2, n);
                        continue;
                    }
                    catch (TclException tclException) {
                        if ((n & 0x40) != 0) continue;
                        String string3 = interp.getResult().toString();
                        if (var != null) {
                            --var.refCount;
                        }
                        var2.flags &= 0xFFFFFFDF;
                        --var2.refCount;
                        interp.setResult(tclObject);
                        tclObject.release();
                        return string3;
                    }
                }
            }
            if ((n & 0x40) != 0) {
                n |= 0x80;
            }
            for (n2 = 0; var2.traces != null && n2 < var2.traces.size(); ++n2) {
                TraceRecord traceRecord = (TraceRecord)var2.traces.get(n2);
                if ((traceRecord.flags & n) == 0) continue;
                try {
                    traceRecord.trace.traceProc(interp, string, string2, n);
                    continue;
                }
                catch (TclException tclException) {
                    if ((n & 0x40) != 0) continue;
                    String string4 = interp.getResult().toString();
                    if (var != null) {
                        --var.refCount;
                    }
                    var2.flags &= 0xFFFFFFDF;
                    --var2.refCount;
                    interp.setResult(tclObject);
                    tclObject.release();
                    return string4;
                }
            }
            String string5 = null;
            return string5;
        }
        finally {
            if (var != null) {
                --var.refCount;
            }
            var2.flags &= 0xFFFFFFDF;
            --var2.refCount;
            interp.setResult(tclObject);
            tclObject.release();
        }
    }

    protected static void deleteSearches(Var var) {
        var.sidVec = null;
    }

    public static void deleteVars(Interp interp, HashMap hashMap) {
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        int n = 64;
        if (hashMap == interp.globalNs.varTable) {
            n |= 0x101;
        } else if (hashMap == namespace.varTable) {
            n |= 2;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Var.deleteVar(interp, (Var)entry.getValue(), n);
        }
        hashMap.clear();
    }

    protected static void deleteVars(Interp interp, Var[] varArray) {
        for (Var var : varArray) {
            if (var == null) continue;
            Var.deleteVar(interp, var, 64);
            varArray[var4_3] = null;
        }
    }

    protected static void deleteVar(Interp interp, Var var, int n) {
        Object object;
        if ((var.flags & 4) != 0) {
            object = var.linkto;
            --((Var)object).refCount;
            if (((Var)object).refCount == 0 && ((Var)object).traces == null && (((Var)object).flags & 0x18) == 24) {
                if (((Var)object).hashKey == null) {
                    var.linkto = null;
                } else if (((Var)object).table != var.table) {
                    ((Var)object).table.remove(((Var)object).hashKey);
                    ((Var)object).table = null;
                    var.linkto = null;
                }
            }
        }
        var.setVarUndefined();
        if (var.traces != null) {
            object = Var.getVariableFullName(interp, var);
            Var.callTraces(interp, null, var, (String)object, null, n);
        }
        if ((var.flags & 2) != 0) {
            Var.deleteArray(interp, var.hashKey, var, n);
            var.deleteArrayMap();
        } else if ((var.flags & 1) != 0 && var.getValue() != null) {
            object = var.getValue();
            ((TclObject)object).release();
            var.setValue(null);
        }
        var.hashKey = null;
        var.table = null;
        var.traces = null;
        var.setVarUndefined();
        var.setVarScalar();
        if ((var.flags & 0x80) != 0) {
            var.flags &= 0xFFFFFF7F;
            --var.refCount;
        }
    }

    protected static void deleteArray(Interp interp, String string, Var var, int n) {
        Var.deleteSearches(var);
        Map<String, Var> map = var.getArrayMap();
        for (Map.Entry<String, Var> entry : map.entrySet()) {
            Var var2 = entry.getValue();
            if (var2.isVarScalar() && var2.getValue() != null) {
                TclObject tclObject = var2.getValue();
                tclObject.release();
                var2.setValue(null);
            }
            String string2 = var2.hashKey;
            var2.hashKey = null;
            var2.table = null;
            if (var2.traces != null) {
                var2.flags &= 0xFFFFFFDF;
                Var.callTraces(interp, null, var2, string, string2, n);
                var2.traces = null;
            }
            var2.setVarUndefined();
            var2.setVarScalar();
            if (var2.refCount != 0) continue;
        }
        map.clear();
        var.deleteArrayMap();
    }

    protected static void cleanupVar(Var var, Var var2) {
        if (var.isVarUndefined() && var.refCount == 0 && var.traces == null && (var.flags & 0x10) != 0 && var.table != null) {
            var.table.remove(var.hashKey);
            var.table = null;
            var.hashKey = null;
        }
        if (var2 != null && var2.isVarUndefined() && var2.refCount == 0 && var2.traces == null && (var2.flags & 0x10) != 0 && var2.table != null) {
            var2.table.remove(var2.hashKey);
            var2.table = null;
            var2.hashKey = null;
        }
    }

    public static Var resolveScalar(Var var) {
        int n = var.flags;
        if ((n & 4) != 0) {
            var = var.linkto;
            n = var.flags;
        }
        if ((n & 0x54E) != 0) {
            return null;
        }
        return var;
    }

    public static Var resolveArray(Var var) {
        int n = var.flags;
        if ((n & 4) != 0) {
            var = var.linkto;
            n = var.flags;
        }
        if ((n & 0x10D) != 0) {
            return null;
        }
        return var;
    }

    static void setUndefinedToNull(Interp interp, String string, String string2) {
        CallFrame callFrame = interp.varFrame;
        if (callFrame == null) {
            return;
        }
        if (callFrame.compiledLocals != null) {
            for (Var var : callFrame.compiledLocals) {
                if (var == null || var.isVarNonLocal() || !var.hashKey.equals(string)) continue;
                if (!var.isVarLink() && var.isVarUndefined() && var.refCount == 0) {
                    var4_4[var6_6] = null;
                }
                return;
            }
        }
    }

    public static void AppendLocals(Interp interp, TclObject tclObject, String string, boolean bl) throws TclException {
        Object object;
        String string2;
        Object object2;
        CallFrame callFrame = interp.varFrame;
        HashMap hashMap = callFrame.varTable;
        if (hashMap != null) {
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = (Map.Entry)object2.next();
                string2 = (String)entry.getKey();
                object = (Var)entry.getValue();
                if (((Var)object).isVarUndefined() || !bl && ((Var)object).isVarLink() || string != null && !Util.stringMatch(string2, string)) continue;
                TclList.append(interp, tclObject, TclString.newInstance(string2));
            }
        }
        if ((object2 = callFrame.compiledLocals) != null) {
            for (Object object3 : object2) {
                if (object3 == null || ((Var)object3).isVarNonLocal()) continue;
                object = object3;
                string2 = ((Var)object).hashKey;
                if (((Var)object).isVarUndefined() || !bl && ((Var)object).isVarLink() || string != null && !Util.stringMatch(string2, string)) continue;
                TclList.append(interp, tclObject, TclString.newInstance(string2));
            }
        }
    }
}

