/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.io.Writer;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.EofInputFilter;
import tcl.lang.channel.EofOutputFilter;
import tcl.lang.channel.EolInputFilter;
import tcl.lang.channel.EolOutputFilter;
import tcl.lang.channel.InputBuffer;
import tcl.lang.channel.MarkableInputStream;
import tcl.lang.channel.NonBlockingOutputStream;
import tcl.lang.channel.OutputBuffer;
import tcl.lang.channel.UnicodeDecoder;
import tcl.lang.channel.UnicodeEncoder;
import tcl.lang.cmd.EncodingCmd;

public abstract class Channel {
    protected int mode;
    private String chanName;
    public int refCount = 0;
    protected boolean blocking = true;
    protected InputBuffer inputBuffer = null;
    protected InputStream rawInputStream = null;
    protected OutputStream rawOutputStream = null;
    protected EolInputFilter eolInputFilter = null;
    protected EofInputFilter eofInputFilter = null;
    protected UnicodeDecoder unicodeDecoder = null;
    protected InputStream finalInputStream = null;
    protected MarkableInputStream markableInputStream = null;
    protected Reader finalReader = null;
    protected EolOutputFilter eolOutputFilter = null;
    protected UnicodeEncoder unicodeEncoder = null;
    protected OutputBuffer outputBuffer = null;
    protected EofOutputFilter eofOutputFilter = null;
    protected NonBlockingOutputStream nonBlockingOutputStream = null;
    protected Writer firstWriter = null;
    protected OutputStream firstOutputStream = null;
    protected int buffering = 0;
    protected int bufferSize = 4096;
    protected String encoding;
    protected int inputTranslation = 0;
    protected int outputTranslation = TclIO.TRANS_PLATFORM;
    protected char inputEofChar = '\u0000';
    protected char outputEofChar = '\u0000';
    boolean eofSeen = false;
    long readOwningThread = -1L;
    long writeOwningThread = -1L;
    public static final int READ_OWNERSHIP = 1;
    public static final int WRITE_OWNERSHIP = 2;
    Object ownershipNotifier = new Object();
    volatile boolean closed = false;
    boolean encodingChangedSinceLastRead = false;

    Channel() {
        this.setEncoding(EncodingCmd.systemJavaEncoding);
    }

    public int read(Interp interp, TclObject tclObject, int n, int n2) throws IOException, TclException {
        if (!this.setOwnership(true, 1)) {
            throw new TclException(interp, "channel is busy");
        }
        try {
            boolean bl;
            this.checkRead(interp);
            this.initInput();
            this.encodingChangedSinceLastRead = false;
            if (this.eofSeen) {
                this.setOwnership(false, 1);
                int n3 = -1;
                return n3;
            }
            boolean bl2 = bl = this.encoding != null || this.inputTranslation != 1 && this.inputTranslation != 2;
            if (bl) {
                TclString.empty(tclObject);
            } else {
                TclByteArray.setLength(interp, tclObject, 0);
            }
            switch (n) {
                case 1: {
                    n2 = Integer.MAX_VALUE;
                }
                case 3: {
                    int n4;
                    int n5;
                    int n6 = 0;
                    int n7 = 0;
                    char[] cArray = null;
                    int n8 = n5 = n2 < 8192 ? n2 : 8192;
                    if (bl) {
                        cArray = new char[n5];
                    } else {
                        TclByteArray.setLength(interp, tclObject, 0);
                    }
                    while (n7 < n2) {
                        if (bl) {
                            n6 = this.finalReader.read(cArray, 0, Math.min(cArray.length, n2 - n7));
                        } else {
                            n4 = TclByteArray.getLength(interp, tclObject);
                            if (n4 < n7 + n5) {
                                TclByteArray.setLength(interp, tclObject, n4 + n5);
                            }
                            n6 = this.finalInputStream.read(TclByteArray.getBytes(interp, tclObject), n7, Math.min(n5, n2 - n7));
                        }
                        if (n6 == -1) {
                            this.eofSeen = true;
                            break;
                        }
                        if (n6 == 0 && !this.blocking) {
                            this.setEofSeenWithoutRead();
                            break;
                        }
                        if (bl) {
                            TclString.append(tclObject, cArray, 0, n6);
                        }
                        n7 += n6;
                    }
                    if (!bl) {
                        TclByteArray.setLength(interp, tclObject, n7);
                    }
                    if (this.eofSeen && n7 == 0) {
                        this.setOwnership(false, 1);
                        n4 = -1;
                        return n4;
                    }
                    this.setOwnership(false, 1);
                    n4 = n7;
                    return n4;
                }
                case 2: {
                    if (this.finalReader != this.eolInputFilter) {
                        throw new TclRuntimeError("finalReader != eolInputFilter, programmer error!");
                    }
                    StringBuffer stringBuffer = new StringBuffer(64);
                    int n9 = this.eolInputFilter.readLine(stringBuffer, this.blocking);
                    TclString.empty(tclObject);
                    this.setOwnership(false, 1);
                    switch (n9) {
                        case 0: {
                            TclString.append(tclObject, stringBuffer.toString());
                            this.eofSeen = this.eolInputFilter.eofSeen();
                            int n10 = stringBuffer.length();
                            return n10;
                        }
                        case -1: {
                            this.eofSeen = true;
                            int n11 = -1;
                            return n11;
                        }
                        case -2: {
                            this.setEofSeenWithoutRead();
                            int n12 = -1;
                            return n12;
                        }
                    }
                }
            }
            throw new TclRuntimeError("Channel.read: Invalid read mode.");
        }
        finally {
            this.setOwnership(false, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Interp interp, TclObject tclObject) throws IOException, TclException {
        block9: {
            if (!this.setOwnership(true, 2)) {
                throw new TclException(interp, "channel is busy");
            }
            try {
                char[] cArray;
                this.checkWrite(interp);
                this.initOutput();
                if (tclObject.isByteArrayType() && this.encoding == null && (this.outputTranslation == 1 || this.outputTranslation == 2)) {
                    byte[] byArray;
                    this.firstOutputStream.write(TclByteArray.getBytes(interp, tclObject), 0, TclByteArray.getLength(interp, tclObject));
                    if (this.buffering != 1) break block9;
                    for (byte by : byArray = TclByteArray.getBytes(interp, tclObject)) {
                        if (by != 10) continue;
                        this.firstOutputStream.flush();
                        break block9;
                    }
                    break block9;
                }
                if (tclObject.isByteArrayType() && this.encoding != null) {
                    cArray = TclByteArray.decodeToString(interp, tclObject, EncodingCmd.systemTclEncoding).toCharArray();
                    if (cArray.length == 0 && TclByteArray.getLength(interp, tclObject) > 0) {
                        throw new TclException(interp, "error writing \"" + this.getChanName() + "\": invalid argument");
                    }
                } else {
                    cArray = tclObject.toString().toCharArray();
                }
                this.firstWriter.write(cArray, 0, cArray.length);
            }
            finally {
                this.setOwnership(false, 2);
            }
        }
    }

    public void write(Interp interp, String string) throws IOException, TclException {
        this.write(interp, TclString.newInstance(string));
    }

    public synchronized boolean setOwnership(boolean bl, int n) {
        return this.setOwnership(bl, n, Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOwnership(boolean bl, int n, long l) {
        Object object = this.ownershipNotifier;
        synchronized (object) {
            long l2;
            long l3 = l2 = n == 1 ? this.readOwningThread : this.writeOwningThread;
            if (n != 1 && n != 2) {
                return false;
            }
            if (l2 < 0L || l == l2) {
                if (bl) {
                    if (n == 1) {
                        this.readOwningThread = l;
                    }
                    if (n == 2) {
                        this.writeOwningThread = l;
                    }
                } else {
                    if (n == 1) {
                        this.readOwningThread = -1L;
                    }
                    if (n == 2) {
                        this.writeOwningThread = -1L;
                    }
                    this.ownershipNotifier.notifyAll();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOwnership(int n) throws InterruptedException {
        long l = Thread.currentThread().getId();
        Object object = this.ownershipNotifier;
        synchronized (object) {
            while (!this.setOwnership(true, n, l)) {
                this.ownershipNotifier.wait();
            }
        }
    }

    abstract void implClose() throws IOException;

    public synchronized void close() throws IOException {
        IOException iOException = null;
        boolean bl = false;
        this.closed = true;
        if (this.finalReader != null) {
            try {
                this.finalReader.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            this.finalReader = null;
            this.finalInputStream = null;
            this.eolInputFilter = null;
            this.unicodeDecoder = null;
            this.markableInputStream = null;
            this.inputBuffer = null;
            this.eofInputFilter = null;
        }
        if (this.firstWriter != null) {
            try {
                this.firstWriter.close();
                bl = true;
            }
            catch (IOException iOException3) {
                iOException = iOException3;
            }
            this.firstWriter = null;
            this.firstOutputStream = null;
            this.eolOutputFilter = null;
            this.unicodeEncoder = null;
            this.outputBuffer = null;
            this.eofOutputFilter = null;
            this.nonBlockingOutputStream = null;
        }
        if (!bl) {
            this.implClose();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public void flush(Interp interp) throws IOException, TclException {
        this.checkWrite(interp);
        if (!this.setOwnership(true, 2)) {
            throw new TclException(interp, "channel is busy");
        }
        try {
            if (this.firstWriter != null) {
                this.firstWriter.flush();
            }
        }
        finally {
            this.setOwnership(false, 2);
        }
    }

    void sync() throws SyncFailedException, IOException {
    }

    public void seek(Interp interp, long l, int n) throws IOException, TclException {
        throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
    }

    public long tell() throws IOException {
        return -1L;
    }

    void setEofSeenWithoutRead() {
    }

    protected void initInput() throws IOException {
        if (this.finalReader != null) {
            return;
        }
        this.rawInputStream = this.getInputStream();
        this.eofInputFilter = new EofInputFilter(this.rawInputStream, (byte)(this.inputEofChar & 0xFF));
        this.inputBuffer = new InputBuffer(this.eofInputFilter, this.bufferSize, this.buffering, this.blocking, this);
        this.markableInputStream = new MarkableInputStream(this.inputBuffer);
        this.unicodeDecoder = new UnicodeDecoder(this.markableInputStream, this.encoding);
        this.eolInputFilter = new EolInputFilter(this.unicodeDecoder, this.inputTranslation);
        this.finalReader = this.eolInputFilter;
        this.finalInputStream = this.markableInputStream;
        this.encodingChangedSinceLastRead = false;
        this.closed = false;
    }

    protected void initOutput() throws IOException {
        if (this.firstWriter != null) {
            return;
        }
        this.rawOutputStream = this.getOutputStream();
        this.eofOutputFilter = new EofOutputFilter(this.rawOutputStream, (byte)(this.outputEofChar & 0xFF));
        this.nonBlockingOutputStream = new NonBlockingOutputStream(this.eofOutputFilter, this.blocking, this);
        this.outputBuffer = new OutputBuffer(this.nonBlockingOutputStream, this.bufferSize, this.buffering);
        this.unicodeEncoder = new UnicodeEncoder(this.outputBuffer, this.encoding);
        this.eolOutputFilter = new EolOutputFilter(this.unicodeEncoder, this.outputTranslation);
        this.firstWriter = this.eolOutputFilter;
        this.firstOutputStream = this.outputBuffer;
        this.closed = false;
    }

    boolean isWritable() {
        if (this.outputBuffer == null && !this.closed) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        return this.outputBuffer.getBufferedByteCount() < this.bufferSize;
    }

    boolean isReadable() {
        if (this.inputBuffer == null) {
            return false;
        }
        if (this.encodingChangedSinceLastRead) {
            return true;
        }
        if (this.inputBuffer.eof()) {
            return true;
        }
        try {
            if (this.buffering == 1 && !this.inputBuffer.lastReadWouldHaveBlocked() && this.inputBuffer.isRefillInProgress()) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return this.inputBuffer.available() > 0;
        }
        catch (IOException iOException) {
            return !iOException.getMessage().toLowerCase().contains("closed");
        }
    }

    void fillInputBuffer() throws IOException {
        if ((this.isReadOnly() || this.isReadWrite()) && !this.closed) {
            this.initInput();
            if (this.inputBuffer != null) {
                this.inputBuffer.requestRefill(false);
            }
        }
    }

    public boolean eof() {
        return this.eofSeen;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    public String getChanName() {
        return this.chanName;
    }

    abstract String getChanType();

    int getRefCount() {
        return this.refCount;
    }

    void setChanName(String string) {
        this.chanName = string;
    }

    public boolean isReadOnly() {
        return (this.mode & 1) != 0;
    }

    public boolean isWriteOnly() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadWrite() {
        return (this.mode & 4) != 0;
    }

    protected void checkRead(Interp interp) throws TclException {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for reading");
        }
    }

    protected void checkWrite(Interp interp) throws TclException {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean bl) {
        this.blocking = bl;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBlockingMode(this.blocking);
        }
        if (this.nonBlockingOutputStream != null) {
            this.nonBlockingOutputStream.setBlocking(this.blocking);
        }
    }

    public int getBuffering() {
        return this.buffering;
    }

    public void setBuffering(int n) {
        if (n < 0 || n > 2) {
            throw new TclRuntimeError("invalid buffering mode in Channel.setBuffering()");
        }
        this.buffering = n;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBuffering(n);
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.setBuffering(n);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (n < 1 || n > 0x100000) {
            return;
        }
        this.bufferSize = n;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBufferSize(n);
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.setBufferSize(n);
        }
    }

    int getNumBufferedInputBytes() {
        if (this.inputBuffer != null) {
            try {
                return this.unicodeDecoder.available() - this.rawInputStream.available();
            }
            catch (IOException iOException) {
                return 0;
            }
        }
        return 0;
    }

    int getNumBufferedOutputBytes() {
        if (this.outputBuffer != null) {
            return this.outputBuffer.getBufferedByteCount();
        }
        return 0;
    }

    public boolean isBlocked(Interp interp) throws TclException {
        this.checkRead(interp);
        if (this.inputBuffer != null) {
            return this.inputBuffer.lastReadWouldHaveBlocked() && !this.eof();
        }
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.setEncoding(this.encoding);
            this.encodingChangedSinceLastRead = true;
        }
        if (this.unicodeEncoder != null) {
            this.unicodeEncoder.setEncoding(this.encoding);
        }
    }

    public int getInputTranslation() {
        return this.inputTranslation;
    }

    public void setInputTranslation(int n) {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            return;
        }
        this.inputTranslation = n;
        if (this.eolInputFilter != null) {
            this.eolInputFilter.setTranslation(n);
        }
    }

    public int getOutputTranslation() {
        return this.outputTranslation;
    }

    public void setOutputTranslation(int n) {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            return;
        }
        this.outputTranslation = n == 0 ? TclIO.TRANS_PLATFORM : n;
        if (this.eolOutputFilter != null) {
            this.eolOutputFilter.setTranslation(this.outputTranslation);
        }
    }

    public char getInputEofChar() {
        return this.inputEofChar;
    }

    public void setInputEofChar(char c) {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            return;
        }
        if ((c = (char)(c & 0xFF)) == this.inputEofChar) {
            return;
        }
        this.inputEofChar = (char)(c & 0xFF);
        if (this.eofInputFilter != null) {
            this.eofInputFilter.setEofChar((byte)this.inputEofChar);
        }
        if (this.inputBuffer != null) {
            this.inputBuffer.cancelEof();
        }
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.cancelEof();
        }
        this.eofSeen = false;
    }

    public char getOutputEofChar() {
        return this.outputEofChar;
    }

    public void setOutputEofChar(char c) {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            return;
        }
        this.outputEofChar = (char)(c & 0xFF);
        if (this.eofOutputFilter != null) {
            this.eofOutputFilter.setEofChar((byte)this.outputEofChar);
        }
    }
}

