/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterReader;
import java.io.IOException;
import tcl.lang.channel.UnicodeDecoder;

class EolInputFilter
extends FilterReader {
    static final int EOF = -1;
    static final int INCOMPLETE_LINE = -2;
    static final int COMPLETE_LINE = 0;
    private int translation;
    private boolean eofSeen = false;
    private UnicodeDecoder unicodeDecoder = null;

    EolInputFilter(UnicodeDecoder unicodeDecoder, int n) {
        super(unicodeDecoder);
        this.setTranslation(n);
        this.unicodeDecoder = unicodeDecoder;
    }

    void setTranslation(int n) {
        this.translation = n;
    }

    void seekReset() {
        this.eofSeen = false;
    }

    boolean eofSeen() {
        return this.eofSeen;
    }

    int readLine(StringBuffer stringBuffer, boolean bl) throws IOException {
        char[] cArray = new char[1];
        boolean bl2 = false;
        if (!bl) {
            this.unicodeDecoder.mark(1024);
        }
        while (true) {
            int n;
            if ((n = super.read(cArray, 0, 1)) == -1) {
                this.eofSeen = true;
                break;
            }
            if (n == 0) {
                if (!bl) break;
                continue;
            }
            char c = cArray[0];
            if (this.isEolChar(c)) {
                bl2 = true;
                break;
            }
            if (this.mightBeEol2CharSequence(c)) {
                int n2;
                if (bl) {
                    n2 = this.unicodeDecoder.peek(false);
                } else {
                    if (this.unicodeDecoder.available() <= 0) break;
                    n2 = this.unicodeDecoder.peek(false);
                }
                if (this.isEol1CharSequence(c, n2)) {
                    bl2 = true;
                    break;
                }
                if (this.isEol2CharSequence(c, n2)) {
                    bl2 = true;
                    this.unicodeDecoder.peek(true);
                    break;
                }
            }
            stringBuffer.append(c);
        }
        if (this.eofSeen && stringBuffer.length() == 0) {
            return -1;
        }
        if (bl) {
            return 0;
        }
        if (bl2 || this.eofSeen) {
            this.unicodeDecoder.mark(0);
            return 0;
        }
        this.unicodeDecoder.reset();
        return -2;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.isEolChar(n)) {
            return 10;
        }
        if (this.mightBeEol2CharSequence(n)) {
            int n2 = this.unicodeDecoder.peek(false);
            boolean bl = this.eofSeen = n2 == -1;
            if (this.isEol1CharSequence(n, n2)) {
                return 10;
            }
            if (this.isEol2CharSequence(n, n2)) {
                this.unicodeDecoder.peek(true);
                return 10;
            }
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 < 1 || this.translation == 1 || this.translation == 2) {
            this.eofSeen = n3 == -1;
            return n3;
        }
        if (this.translation == 3) {
            for (int i = n; i < n + n3; ++i) {
                if (cArray[i] != '\r') continue;
                cArray[i] = 10;
            }
            return n3;
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (n4 < n3 - 1) {
            if (this.isEol1CharSequence(cArray[n4 + n], cArray[n4 + n + 1])) {
                cArray[n5 + n] = 10;
                ++n5;
                ++n4;
                continue;
            }
            if (this.isEol2CharSequence(cArray[n4 + n], cArray[n4 + n + 1])) {
                cArray[n5 + n] = 10;
                ++n5;
                n4 += 2;
                bl = true;
                continue;
            }
            if (bl) {
                cArray[n5 + n] = cArray[n4 + n];
            }
            ++n5;
            ++n4;
        }
        if (n4 >= n3) {
            return n5;
        }
        char c = cArray[n + n3 - 1];
        if (this.isEolChar(c)) {
            cArray[n5 + n] = 10;
            return ++n5;
        }
        if (this.mightBeEol2CharSequence(c)) {
            int n6 = this.unicodeDecoder.peek(false);
            boolean bl2 = this.eofSeen = n6 == -1;
            if (this.isEol1CharSequence(c, n6)) {
                cArray[n5 + n] = 10;
                return ++n5;
            }
            if (this.isEol2CharSequence(c, n6)) {
                this.unicodeDecoder.peek(true);
                cArray[n5 + n] = 10;
                return ++n5;
            }
        }
        cArray[n5 + n] = c;
        return ++n5;
    }

    private final boolean isEolChar(int n) {
        switch (this.translation) {
            case 0: 
            case 1: 
            case 2: {
                return n == 10;
            }
            case 3: {
                return n == 13;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    private final boolean mightBeEol2CharSequence(int n) {
        return n == 13 && (this.translation == 0 || this.translation == 4);
    }

    private final boolean isEol1CharSequence(int n, int n2) {
        if (this.isEolChar(n)) {
            return true;
        }
        return this.translation == 0 && n == 13 && n2 != 10 && n2 != -1;
    }

    private final boolean isEol2CharSequence(int n, int n2) {
        switch (this.translation) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return n == 13 && n2 == 10;
            }
            case 0: {
                return n == 13 && (n2 == 10 || n2 == -1);
            }
        }
        return false;
    }
}

