/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import tcl.lang.AssocData;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEvent;

public class FileEventScript
implements AssocData {
    TclObject script;

    private FileEventScript(TclObject tclObject) {
        this.script = tclObject;
        this.script.preserve();
    }

    public static void register(Interp interp, Channel channel, int n, TclObject tclObject) {
        FileEventScript fileEventScript = new FileEventScript(tclObject);
        interp.setAssocData(FileEventScript.getName(channel, n), fileEventScript);
        FileEvent.queueFileEvent(interp, channel, n);
    }

    public TclObject getScript() {
        return this.script;
    }

    @Override
    public void disposeAssocData(Interp interp) {
        this.script.release();
    }

    private static String getName(Channel channel, int n) {
        String string = channel.getChanName();
        return string + (n == 0 ? " readable " : " writeable ") + FileEventScript.class.getName();
    }

    public static FileEventScript find(Interp interp, Channel channel, int n) {
        String string = FileEventScript.getName(channel, n);
        AssocData assocData = interp.getAssocData(string);
        if (assocData != null && assocData instanceof FileEventScript) {
            return (FileEventScript)assocData;
        }
        return null;
    }

    public static void dispose(Interp interp, Channel channel, int n) {
        String string = FileEventScript.getName(channel, n);
        interp.deleteAssocData(string);
    }
}

