/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import tcl.lang.channel.Channel;
import tcl.lang.channel.SeekableChannel;

class NonBlockingOutputStream
extends FilterOutputStream
implements Runnable {
    private boolean blocking;
    private ConcurrentLinkedQueue<Transaction> queue;
    private Thread bkgndWriter = null;
    private Object notifier = new Object();
    private Channel channel = null;
    private volatile IOException ioException = null;
    private boolean closed = false;

    NonBlockingOutputStream(OutputStream outputStream, boolean bl, Channel channel) {
        super(outputStream);
        this.setBlocking(bl);
        this.channel = channel;
        this.queue = new ConcurrentLinkedQueue();
        this.bkgndWriter = new Thread(this);
        this.bkgndWriter.setDaemon(true);
        this.bkgndWriter.setName("NonBlockingOutputStream: " + channel.getChanName());
        this.bkgndWriter.start();
    }

    void setBlocking(boolean bl) {
        this.blocking = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(1));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            if (this.blocking) {
                this.queue.offer(new Transaction(byArray, n, n2));
            } else {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                this.queue.offer(new Transaction(byArray2, 0, n2));
            }
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAssumingExclusiveBufferUse(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(byArray, n, n2));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.writeAssumingExclusiveBufferUse(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(2));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is already closed");
        }
    }

    private void throwExceptionIfCaught() throws IOException {
        if (this.ioException != null) {
            IOException iOException = this.ioException;
            this.ioException = null;
            throw iOException;
        }
    }

    boolean isQueueEmpty() {
        return this.queue.peek() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEmptyQueue() {
        while (true) {
            Object object = this.notifier;
            synchronized (object) {
                if (this.isQueueEmpty()) {
                    return;
                }
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Transaction transaction;
            Object object = this.notifier;
            synchronized (object) {
                transaction = this.queue.peek();
                if (transaction == null) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.closed = true;
                        return;
                    }
                }
            }
            try {
                transaction.perform();
            }
            catch (IOException iOException) {
                this.ioException = iOException;
            }
            object = this.notifier;
            synchronized (object) {
                this.queue.poll();
                if (transaction.type == 2) {
                    this.closed = true;
                    this.channel = null;
                    this.queue.clear();
                    this.notifier.notifyAll();
                    return;
                }
                if (this.isQueueEmpty()) {
                    this.notifier.notifyAll();
                }
            }
        }
    }

    private class Transaction {
        byte[] b;
        int off;
        int len;
        int type;
        static final int Write = 0;
        static final int Flush = 1;
        static final int Close = 2;

        Transaction(int n) {
            this.type = n;
        }

        Transaction(byte[] byArray, int n, int n2) {
            this.b = byArray;
            this.off = n;
            this.len = n2;
            this.type = 0;
        }

        void perform() throws IOException {
            if (NonBlockingOutputStream.this.channel instanceof SeekableChannel && (((NonBlockingOutputStream)NonBlockingOutputStream.this).channel.mode & 8) != 0) {
                ((SeekableChannel)NonBlockingOutputStream.this.channel).prepareForAppendWrite();
            }
            switch (this.type) {
                case 0: {
                    NonBlockingOutputStream.this.out.write(this.b, this.off, this.len);
                    break;
                }
                case 1: {
                    NonBlockingOutputStream.this.out.flush();
                    NonBlockingOutputStream.this.channel.sync();
                    break;
                }
                case 2: {
                    NonBlockingOutputStream.this.out.close();
                    NonBlockingOutputStream.this.channel.implClose();
                }
            }
        }
    }
}

