/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterOutputStream;
import java.io.IOException;
import tcl.lang.channel.NonBlockingOutputStream;

class OutputBuffer
extends FilterOutputStream {
    private int requestedSize = 0;
    private int bufferingMode;
    private byte[] buffer = null;
    private int position = 0;
    private NonBlockingOutputStream nonBlockingOutputStream = null;
    private long receivedByteCount = 0L;

    OutputBuffer(NonBlockingOutputStream nonBlockingOutputStream, int n, int n2) {
        super(nonBlockingOutputStream);
        this.nonBlockingOutputStream = nonBlockingOutputStream;
        this.setBufferSize(n);
        this.setBuffering(n2);
    }

    void setBuffering(int n) {
        this.bufferingMode = n;
        this.resizeBuffer();
    }

    void setBufferSize(int n) {
        this.requestedSize = n;
        this.resizeBuffer();
    }

    private void resizeBuffer() {
        if (this.position != 0) {
            return;
        }
        int n = this.bufferingMode == 2 ? 0 : this.requestedSize;
        this.buffer = new byte[n];
    }

    int getBufferedByteCount() {
        return this.position;
    }

    long getReceivedByteCount() {
        return this.receivedByteCount;
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.nonBlockingOutputStream.writeAssumingExclusiveBufferUse(this.buffer, 0, this.position);
        }
        this.nonBlockingOutputStream.flush();
        this.position = 0;
        this.resizeBuffer();
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.receivedByteCount += (long)n2;
        if (this.bufferingMode == 2 && this.buffer.length > 0) {
            this.flush();
        }
        if (this.buffer.length == 0) {
            this.nonBlockingOutputStream.write(byArray, n, n2);
            this.nonBlockingOutputStream.flush();
            return;
        }
        int n4 = Math.min(n2, this.buffer.length - this.position);
        System.arraycopy(byArray, n, this.buffer, this.position, n4);
        this.position += n4;
        n2 -= n4;
        n += n4;
        if (this.position == this.buffer.length) {
            this.flush();
        }
        if (this.buffer.length > 0 && (n3 = n2 / this.buffer.length) > 0) {
            n4 = n3 * this.buffer.length;
            this.nonBlockingOutputStream.write(byArray, n, n4);
            this.nonBlockingOutputStream.flush();
            n2 -= n4;
            n += n4;
        }
        System.arraycopy(byArray, n, this.buffer, this.position, n2);
        this.position += n2;
        if (this.position == this.buffer.length) {
            this.flush();
        }
        if (this.bufferingMode == 1) {
            for (n3 = this.position - 1; n3 >= 0; --n3) {
                if (this.buffer[n3] != 10 && this.buffer[n3] != 13) continue;
                this.flush();
                break;
            }
        }
    }
}

