/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public abstract class SeekableChannel
extends Channel {
    abstract void implSeek(long var1) throws IOException;

    abstract long implTell() throws IOException;

    abstract long getMaxSeek() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(Interp interp, long l, int n) throws IOException, TclException {
        if (!this.setOwnership(true, 1)) {
            throw new TclException(interp, "channel is busy");
        }
        if (!this.setOwnership(true, 2)) {
            this.setOwnership(false, 1);
            throw new TclException(interp, "channel is busy");
        }
        try {
            long l2;
            int n2 = this.getNumBufferedInputBytes();
            int n3 = this.getNumBufferedOutputBytes();
            if (n2 != 0 && n3 != 0) {
                throw new TclPosixException(interp, 14, true, "error during seek on \"" + this.getChanName() + "\"");
            }
            if (n == 2) {
                l -= (long)n2;
            }
            this.seekReset();
            boolean bl = false;
            if (!this.getBlocking()) {
                bl = true;
                this.setBlocking(true);
            }
            if (this.firstWriter != null) {
                this.flush(interp);
            }
            switch (n) {
                case 1: {
                    l2 = l;
                    break;
                }
                case 2: {
                    l2 = this.implTell() + l;
                    break;
                }
                case 3: {
                    l2 = this.getMaxSeek() + l;
                    break;
                }
                default: {
                    throw new TclRuntimeError("invalid seek mode");
                }
            }
            if (l2 < 0L) {
                throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
            }
            this.implSeek(l2);
            if (bl) {
                this.setBlocking(false);
            }
        }
        finally {
            this.setOwnership(false, 2);
            this.setOwnership(false, 1);
        }
    }

    @Override
    public long tell() throws IOException {
        long l = this.implTell();
        int n = this.getNumBufferedInputBytes();
        int n2 = this.getNumBufferedOutputBytes();
        if (n != 0 && n2 != 0) {
            return -1L;
        }
        if (l == -1L) {
            return -1L;
        }
        if (n != 0) {
            return l - (long)n;
        }
        return l + (long)n2;
    }

    void seekReset() {
        if (this.inputBuffer != null) {
            this.inputBuffer.seekReset();
        }
        if (this.eolInputFilter != null) {
            this.eolInputFilter.seekReset();
        }
        if (this.eofInputFilter != null) {
            this.eofInputFilter.seekReset();
        }
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.seekReset();
        }
        if (this.markableInputStream != null) {
            this.markableInputStream.seekReset();
        }
        this.eofSeen = false;
    }

    void prepareForAppendWrite() throws IOException {
        this.implSeek(this.getMaxSeek());
    }

    @Override
    void setEofSeenWithoutRead() {
        try {
            if (this.getNumBufferedInputBytes() == 0 && this.implTell() >= this.getMaxSeek()) {
                this.eofSeen = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

