/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.channel.SocketChannel;

public class SocketConnectionEvent
extends TclEvent {
    Interp cbInterp;
    TclObject callbackCmd;
    Socket sock;
    ServerSocket serverSock;

    public SocketConnectionEvent(Interp interp, TclObject tclObject, Socket socket, ServerSocket serverSocket) {
        this.cbInterp = interp;
        this.callbackCmd = tclObject;
        this.sock = socket;
        this.serverSock = serverSocket;
    }

    @Override
    public int processEvent(int n) {
        if (this.serverSock.isClosed()) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 1;
        }
        SocketChannel socketChannel = null;
        try {
            socketChannel = new SocketChannel(this.cbInterp, this.sock);
        }
        catch (IOException iOException) {
            new TclException(this.cbInterp, iOException.getMessage());
            this.cbInterp.backgroundError();
            return 1;
        }
        catch (TclException tclException) {
            this.cbInterp.backgroundError();
            return 1;
        }
        TclIO.registerChannel(this.cbInterp, socketChannel);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.callbackCmd.toString());
        stringBuffer.append(" ");
        stringBuffer.append(socketChannel.getChanName());
        stringBuffer.append(" ");
        stringBuffer.append("" + this.sock.getInetAddress().getHostAddress());
        stringBuffer.append(" ");
        stringBuffer.append("" + this.sock.getPort());
        try {
            this.cbInterp.eval(stringBuffer.toString(), 131072);
        }
        catch (TclException tclException) {
            this.cbInterp.addErrorInfo("\n  during server socket callback \n");
            this.cbInterp.backgroundError();
        }
        return 1;
    }
}

