/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import tcl.lang.channel.MarkableInputStream;
import tcl.lang.cmd.EncodingCmd;

class UnicodeDecoder
extends Reader {
    MarkableInputStream in = null;
    CharsetDecoder csd = null;
    String encoding = null;
    String requestedEncoding = null;
    boolean eofSeen = false;

    UnicodeDecoder(MarkableInputStream markableInputStream, String string) {
        this.in = markableInputStream;
        this.setEncoding(string);
    }

    void setEncoding(String string) {
        this.requestedEncoding = string;
    }

    private void setEncoding() {
        if (this.encoding == null && this.requestedEncoding == null) {
            return;
        }
        if (this.encoding != null && this.encoding.equals(this.requestedEncoding)) {
            return;
        }
        this.encoding = this.requestedEncoding;
        if (this.encoding != null && !"symbol".equals(this.encoding)) {
            Charset charset = Charset.forName(this.encoding);
            this.csd = charset.newDecoder();
            this.csd.onMalformedInput(CodingErrorAction.REPLACE);
            this.csd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        } else {
            this.csd = null;
        }
    }

    void seekReset() {
        if (this.csd != null) {
            this.csd.reset();
        }
        this.eofSeen = false;
    }

    void cancelEof() {
        this.eofSeen = false;
        if (this.csd != null) {
            this.csd.reset();
        }
    }

    int peek(boolean bl) throws IOException {
        if (this.eofSeen) {
            return -1;
        }
        int n = this.in.read();
        if (!bl) {
            this.in.unread(n);
        }
        return n;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int n) throws IOException {
        this.in.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        if (this.csd != null) {
            this.csd.reset();
        }
    }

    private int flushDecoder(CharBuffer charBuffer, int n) {
        CoderResult coderResult = this.csd.flush(charBuffer);
        int n2 = charBuffer.position() - n;
        if (coderResult == CoderResult.OVERFLOW) {
            return n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.setEncoding();
        if (this.csd != null) {
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            if (this.eofSeen) {
                return this.flushDecoder(charBuffer, n);
            }
            int n3 = n2 < 16 ? 16 : n2;
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            boolean bl = false;
            while (charBuffer.position() - n == 0 && n2 > 0 && !bl) {
                if (byteBuffer.remaining() > 0 && !this.eofSeen) {
                    int n4 = this.in.read(byArray, byteBuffer.position(), charBuffer.remaining() > byteBuffer.remaining() ? byteBuffer.remaining() : charBuffer.remaining());
                    if (n4 == -1) {
                        this.eofSeen = true;
                    } else {
                        byteBuffer.position(byteBuffer.position() + n4);
                    }
                    bl = n4 == 0;
                }
                byteBuffer.flip();
                CoderResult coderResult = this.csd.decode(byteBuffer, charBuffer, this.eofSeen);
                if (coderResult == CoderResult.UNDERFLOW && this.eofSeen) {
                    return this.flushDecoder(charBuffer, n);
                }
                byteBuffer.compact();
            }
            byteBuffer.flip();
            while (byteBuffer.remaining() > 0) {
                this.eofSeen = false;
                this.in.unread(byteBuffer.get());
            }
            return charBuffer.position() - n;
        }
        byte[] byArray = new byte[n2];
        int n5 = this.in.read(byArray, 0, n2);
        if (n5 == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.encoding != null) {
            EncodingCmd.decodeSymbol(byArray, cArray, n, n5);
        } else {
            for (int i = 0; i < n5; ++i) {
                cArray[i + n] = (char)(byArray[i] & 0xFF);
            }
        }
        return n5;
    }
}

