/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TimerHandler;
import tcl.lang.Util;

public class AfterCmd
implements Command {
    AfterAssocData assocData = null;
    private static final String[] validOpts = new String[]{"cancel", "idle", "info"};
    static final int OPT_CANCEL = 0;
    static final int OPT_IDLE = 1;
    static final int OPT_INFO = 2;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        Object object;
        Notifier notifier = interp.getNotifier();
        if (this.assocData == null) {
            this.assocData = (AfterAssocData)interp.getAssocData("tclAfter");
            if (this.assocData == null) {
                this.assocData = new AfterAssocData();
                interp.setAssocData("tclAfter", this.assocData);
            }
        }
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        boolean bl = false;
        long l = 0L;
        if (tclObjectArray[1].isIntType()) {
            l = TclInteger.getLong(interp, tclObjectArray[1]);
            bl = true;
        } else {
            object = tclObjectArray[1].toString();
            if (((String)object).length() > 0 && (Character.isDigit(((String)object).charAt(0)) || ((String)object).charAt(0) == '-')) {
                l = TclInteger.getLong(interp, tclObjectArray[1]);
                bl = true;
            }
        }
        if (bl) {
            if (l < 0L) {
                l = 0L;
            }
            if (tclObjectArray.length == 2) {
                long l2 = System.currentTimeMillis() + l;
                while (true) {
                    try {
                        Thread.sleep(l);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        long l3 = System.currentTimeMillis();
                        if (l3 >= l2) {
                            return;
                        }
                        l = l2 - l3;
                        continue;
                    }
                    break;
                }
            }
            object = this.getCmdObject(tclObjectArray);
            ((TclObject)object).preserve();
            ++this.assocData.lastAfterId;
            TimerInfo timerInfo = new TimerInfo(notifier, l);
            timerInfo.interp = interp;
            timerInfo.command = object;
            timerInfo.id = this.assocData.lastAfterId;
            this.assocData.handlers.add(timerInfo);
            interp.setResult("after#" + timerInfo.id);
            return;
        }
        try {
            n = TclIndex.get(interp, tclObjectArray[1], validOpts, "option", 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "bad argument \"" + tclObjectArray[1] + "\": must be cancel, idle, info, or a number");
        }
        switch (n) {
            case 0: {
                Object object2;
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "id|command");
                }
                TclObject tclObject = this.getCmdObject(tclObjectArray);
                tclObject.preserve();
                Object object3 = null;
                for (int i = 0; i < this.assocData.handlers.size(); ++i) {
                    TclObject tclObject2;
                    object2 = this.assocData.handlers.get(i);
                    if (object2 instanceof TimerInfo) {
                        tclObject2 = ((TimerInfo)object2).command;
                        if (tclObject2 != tclObject && !tclObject2.toString().equals(tclObject.toString())) continue;
                        object3 = object2;
                        break;
                    }
                    tclObject2 = ((IdleInfo)object2).command;
                    if (tclObject2 != tclObject && !tclObject2.toString().equals(tclObject.toString())) continue;
                    object3 = object2;
                    break;
                }
                if (object3 == null) {
                    object3 = this.getAfterEvent(interp, tclObject.toString());
                }
                tclObject.release();
                if (object3 == null) break;
                if (object3 instanceof TimerInfo) {
                    object2 = (TimerInfo)object3;
                    ((TimerHandler)object2).cancel();
                    ((TimerInfo)object2).command.release();
                } else {
                    object2 = (IdleInfo)object3;
                    ((IdleHandler)object2).cancel();
                    ((IdleInfo)object2).command.release();
                }
                int n2 = this.assocData.handlers.indexOf(object3);
                if (n2 == -1) {
                    throw new TclRuntimeError("info " + object3 + " has no handler");
                }
                if (this.assocData.handlers.remove(n2) != null) break;
                throw new TclRuntimeError("cound not remove handler " + n2);
            }
            case 1: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "script script ...");
                }
                TclObject tclObject = this.getCmdObject(tclObjectArray);
                tclObject.preserve();
                ++this.assocData.lastAfterId;
                IdleInfo idleInfo = new IdleInfo(notifier);
                idleInfo.interp = interp;
                idleInfo.command = tclObject;
                idleInfo.id = this.assocData.lastAfterId;
                this.assocData.handlers.add(idleInfo);
                interp.setResult("after#" + idleInfo.id);
                break;
            }
            case 2: {
                if (tclObjectArray.length == 2) {
                    TclObject tclObject = TclList.newInstance();
                    for (int i = 0; i < this.assocData.handlers.size(); ++i) {
                        Object e = this.assocData.handlers.get(i);
                        int n3 = e instanceof TimerInfo ? ((TimerInfo)e).id : ((IdleInfo)e).id;
                        TclList.append(interp, tclObject, TclString.newInstance("after#" + n3));
                    }
                    interp.setResult(tclObject);
                    return;
                }
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?id?");
                }
                Object object4 = this.getAfterEvent(interp, tclObjectArray[2].toString());
                if (object4 == null) {
                    throw new TclException(interp, "event \"" + tclObjectArray[2] + "\" doesn't exist");
                }
                TclObject tclObject = TclList.newInstance();
                TclList.append(interp, tclObject, object4 instanceof TimerInfo ? ((TimerInfo)object4).command : ((IdleInfo)object4).command);
                TclList.append(interp, tclObject, TclString.newInstance(object4 instanceof TimerInfo ? "timer" : "idle"));
                interp.setResult(tclObject);
            }
        }
    }

    private TclObject getCmdObject(TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 3) {
            return tclObjectArray[2];
        }
        TclObject tclObject = Util.concat(2, tclObjectArray.length - 1, tclObjectArray);
        return tclObject;
    }

    private Object getAfterEvent(Interp interp, String string) {
        if (!string.startsWith("after#")) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(6));
        }
        catch (Exception exception) {
            return null;
        }
        for (int i = 0; i < this.assocData.handlers.size(); ++i) {
            Object e = this.assocData.handlers.get(i);
            if (!(e instanceof TimerInfo ? ((TimerInfo)e).id == n : ((IdleInfo)e).id == n)) continue;
            return e;
        }
        return null;
    }

    class IdleInfo
    extends IdleHandler {
        Interp interp;
        TclObject command;
        int id;

        IdleInfo(Notifier notifier) {
            super(notifier);
        }

        @Override
        public void processIdleEvent() {
            try {
                int n = AfterCmd.this.assocData.handlers.indexOf(this);
                if (n == -1) {
                    throw new TclRuntimeError("this " + this + " has no handler");
                }
                if (AfterCmd.this.assocData.handlers.remove(n) == null) {
                    throw new TclRuntimeError("cound not remove handler " + n);
                }
                this.interp.eval(this.command, 131072);
            }
            catch (TclException tclException) {
                this.interp.addErrorInfo("\n    (\"after\" script)");
                this.interp.backgroundError();
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(super.toString());
            stringBuffer.append("AfterCmd.IdleInfo : " + this.command + "\n");
            return stringBuffer.toString();
        }
    }

    class TimerInfo
    extends TimerHandler {
        Interp interp;
        TclObject command;
        int id;

        TimerInfo(Notifier notifier, long l) {
            super(notifier, l);
        }

        @Override
        public void processTimerEvent() {
            try {
                int n = AfterCmd.this.assocData.handlers.indexOf(this);
                if (n == -1) {
                    throw new TclRuntimeError("this " + this + " has no handler");
                }
                if (AfterCmd.this.assocData.handlers.remove(n) == null) {
                    throw new TclRuntimeError("cound not remove handler " + n);
                }
                this.interp.eval(this.command, 131072);
            }
            catch (TclException tclException) {
                this.interp.addErrorInfo("\n    (\"after\" script)");
                this.interp.backgroundError();
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(super.toString());
            stringBuffer.append("AfterCmd.TimerInfo : " + this.command + "\n");
            return stringBuffer.toString();
        }
    }

    class AfterAssocData
    implements AssocData {
        ArrayList handlers = new ArrayList();
        int lastAfterId = 0;

        AfterAssocData() {
        }

        @Override
        public void disposeAssocData(Interp interp) {
            for (int i = AfterCmd.this.assocData.handlers.size() - 1; i >= 0; --i) {
                Object object;
                Object e = AfterCmd.this.assocData.handlers.get(i);
                if (AfterCmd.this.assocData.handlers.remove(i) == null) {
                    throw new TclRuntimeError("cound not remove handler " + i);
                }
                if (e instanceof TimerInfo) {
                    object = (TimerInfo)e;
                    ((TimerHandler)object).cancel();
                    ((TimerInfo)object).command.release();
                    continue;
                }
                object = (IdleInfo)e;
                ((IdleHandler)object).cancel();
                ((IdleInfo)object).command.release();
            }
            AfterCmd.this.assocData = null;
        }
    }
}

