/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.cmd.ClockRelTimespan;
import tcl.lang.cmd.ClockToken;

public class ClockCmd
implements Command {
    private static final String[] validCmds = new String[]{"clicks", "format", "scan", "seconds"};
    private static final int CMD_CLICKS = 0;
    private static final int CMD_FORMAT = 1;
    private static final int CMD_SCAN = 2;
    private static final int CMD_SECONDS = 3;
    private static final String[] clicksOpts = new String[]{"-milliseconds"};
    private static final int OPT_CLICKS_MILLISECONDS = 0;
    private static final String[] formatOpts = new String[]{"-format", "-gmt"};
    private static final int OPT_FORMAT_FORMAT = 0;
    private static final int OPT_FORMAT_GMT = 1;
    private static final String[] scanOpts = new String[]{"-base", "-gmt"};
    private static final int OPT_SCAN_BASE = 0;
    private static final int OPT_SCAN_GMT = 1;
    static final int EPOCH_YEAR = 1970;
    static final int MILLIS_PER_HOUR = 3600000;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string = null;
        boolean bl = false;
        TclObject tclObject = null;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length > 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-milliseconds?");
                }
                if (tclObjectArray.length == 3) {
                    TclIndex.get(interp, tclObjectArray[2], clicksOpts, "switch", 0);
                    if (tclObjectArray[2].toString().equals("-")) {
                        throw new TclException(interp, "bad switch \"-\": must be -milliseconds");
                    }
                }
                interp.setResult(System.currentTimeMillis());
                break;
            }
            case 1: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                int n2 = TclInteger.getInt(interp, tclObjectArray[2]);
                int n3 = 3;
                while (n3 + 1 < tclObjectArray.length) {
                    int n4 = TclIndex.get(interp, tclObjectArray[n3], formatOpts, "switch", 0);
                    switch (n4) {
                        case 0: {
                            string = tclObjectArray[n3 + 1].toString();
                            break;
                        }
                        case 1: {
                            bl = TclBoolean.get(interp, tclObjectArray[n3 + 1]);
                        }
                    }
                    n3 += 2;
                }
                if (n3 < tclObjectArray.length) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                this.FormatClock(interp, n2, bl, string);
                break;
            }
            case 2: {
                Date date;
                if (tclObjectArray.length < 3 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "dateString ?-base clockValue? ?-gmt boolean?");
                }
                String string2 = tclObjectArray[2].toString();
                if (string2.trim().length() == 0) {
                    long l = System.currentTimeMillis();
                    int n5 = (int)(l / 1000L);
                    interp.setResult(n5);
                    break;
                }
                int n6 = 3;
                while (n6 + 1 < tclObjectArray.length) {
                    int n7 = TclIndex.get(interp, tclObjectArray[n6], scanOpts, "switch", 0);
                    switch (n7) {
                        case 0: {
                            tclObject = tclObjectArray[n6 + 1];
                            break;
                        }
                        case 1: {
                            bl = TclBoolean.get(interp, tclObjectArray[n6 + 1]);
                        }
                    }
                    n6 += 2;
                }
                if (n6 < tclObjectArray.length) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                if (tclObject != null) {
                    long l = TclInteger.getLong(interp, tclObject);
                    date = new Date(l * 1000L);
                } else {
                    date = new Date();
                }
                Date date2 = this.GetDate(string2, date, bl);
                if (date2 == null) {
                    throw new TclException(interp, "unable to convert date-time string \"" + string2 + "\"");
                }
                int n8 = (int)(date2.getTime() / 1000L);
                interp.setResult(n8);
                break;
            }
            case 3: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                long l = System.currentTimeMillis();
                int n9 = (int)(l / 1000L);
                interp.setResult(n9);
                break;
            }
        }
    }

    private void FormatClock(Interp interp, int n, boolean bl, String string) throws TclException {
        Date date = new Date((long)n * 1000L);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            string = new String("%a %b %d %H:%M:%S %Z %Y");
        }
        if (bl) {
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            try {
                TclObject tclObject = interp.getVar("env", "TZ", 1);
                gregorianCalendar.setTimeZone(TimeZone.getTimeZone(tclObject.toString()));
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
        gregorianCalendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm.dd.yy", Locale.US);
        simpleDateFormat.setCalendar(gregorianCalendar);
        if (string.equals("%Q")) {
            int n2 = gregorianCalendar.get(1) + 377 - 2323;
            int n3 = gregorianCalendar.get(6) * 1000 / (gregorianCalendar.isLeapYear(gregorianCalendar.get(1)) ? 366 : 365);
            int n4 = (gregorianCalendar.get(11) * 60 + gregorianCalendar.get(12)) / 144;
            interp.setResult("Stardate " + (n2 < 10 ? "0" : "") + (n2 * 1000 + n3) + '.' + n4);
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && i + 1 < string.length()) {
                switch (string.charAt(++i)) {
                    case '%': {
                        stringBuffer.append('%');
                        break;
                    }
                    case 'a': {
                        simpleDateFormat.applyPattern("EEE");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'A': {
                        simpleDateFormat.applyPattern("EEEE");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        simpleDateFormat.applyPattern("MMM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'B': {
                        simpleDateFormat.applyPattern("MMMM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'c': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
                        simpleDateFormat2.setCalendar(gregorianCalendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'C': {
                        int n5 = gregorianCalendar.get(1) / 100;
                        stringBuffer.append((n5 < 10 ? "0" : "") + n5);
                        break;
                    }
                    case 'd': {
                        simpleDateFormat.applyPattern("dd");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'D': {
                        simpleDateFormat.applyPattern("MM/dd/yy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'e': {
                        simpleDateFormat.applyPattern("d");
                        String string2 = simpleDateFormat.format(date);
                        stringBuffer.append((string2.length() < 2 ? " " : "") + string2);
                        break;
                    }
                    case 'g': {
                        int n6 = this.getISO8601Year(gregorianCalendar);
                        stringBuffer.append((n6 % 1000 < 10 ? "0" : "") + n6 % 1000);
                        break;
                    }
                    case 'G': {
                        int n6 = this.getISO8601Year(gregorianCalendar);
                        if (n6 < 1000) {
                            stringBuffer.append("0");
                        } else if (n6 < 100) {
                            stringBuffer.append("00");
                        } else if (n6 < 10) {
                            stringBuffer.append("000");
                        }
                        stringBuffer.append(n6);
                        break;
                    }
                    case 'H': {
                        simpleDateFormat.applyPattern("HH");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'I': {
                        simpleDateFormat.applyPattern("hh");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'j': {
                        simpleDateFormat.applyPattern("DDD");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'k': {
                        simpleDateFormat.applyPattern("H");
                        String string3 = simpleDateFormat.format(date);
                        stringBuffer.append((string3.length() < 2 ? " " : "") + string3);
                        break;
                    }
                    case 'l': {
                        simpleDateFormat.applyPattern("h");
                        String string4 = simpleDateFormat.format(date);
                        stringBuffer.append((string4.length() < 2 ? " " : "") + string4);
                        break;
                    }
                    case 'm': {
                        simpleDateFormat.applyPattern("MM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'M': {
                        simpleDateFormat.applyPattern("mm");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'p': {
                        simpleDateFormat.applyPattern("aa");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'r': {
                        simpleDateFormat.applyPattern("KK:mm:ss aaaa");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'R': {
                        simpleDateFormat.applyPattern("hh:mm");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 's': {
                        long l = gregorianCalendar.getTime().getTime();
                        if (bl) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(gregorianCalendar.getTime());
                            l -= (long)(calendar.get(15) + calendar.get(16));
                        }
                        stringBuffer.append((int)(l / 1000L));
                        break;
                    }
                    case 'S': {
                        simpleDateFormat.applyPattern("ss");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'T': {
                        simpleDateFormat.applyPattern("hh:mm:ss");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'u': {
                        int n7 = gregorianCalendar.get(7);
                        if (n7 == 1) {
                            stringBuffer.append(7);
                            break;
                        }
                        stringBuffer.append(n7 - 1);
                        break;
                    }
                    case 'U': {
                        int n8 = this.GetWeek(gregorianCalendar, 1, false);
                        stringBuffer.append((n8 < 10 ? "0" : "") + n8);
                        break;
                    }
                    case 'V': {
                        int n9 = this.GetWeek(gregorianCalendar, 2, true);
                        stringBuffer.append((n9 < 10 ? "0" : "") + n9);
                        break;
                    }
                    case 'w': {
                        int n10 = gregorianCalendar.get(7);
                        stringBuffer.append(n10 - 1);
                        break;
                    }
                    case 'W': {
                        int n11 = this.GetWeek(gregorianCalendar, 2, false);
                        stringBuffer.append((n11 < 10 ? "0" : "") + n11);
                        break;
                    }
                    case 'x': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateInstance(3);
                        simpleDateFormat2.setCalendar(gregorianCalendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'X': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getTimeInstance(3);
                        simpleDateFormat2.setCalendar(gregorianCalendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'y': {
                        simpleDateFormat.applyPattern("yy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'Y': {
                        simpleDateFormat.applyPattern("yyyy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'Z': {
                        simpleDateFormat.applyPattern("zzz");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    default: {
                        stringBuffer.append(string.charAt(i));
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        interp.setResult(stringBuffer.toString());
    }

    private int getISO8601Year(Calendar calendar) {
        int n = calendar.getFirstDayOfWeek();
        int n2 = calendar.getMinimalDaysInFirstWeek();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int n3 = calendar.get(3);
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        calendar.setFirstDayOfWeek(n);
        calendar.setMinimalDaysInFirstWeek(n2);
        calendar.setTime(calendar.getTime());
        if (n3 == 1 && n5 == 11) {
            return n4 + 1;
        }
        if ((n3 == 52 || n3 == 53) && n5 == 0) {
            return n4 - 1;
        }
        return n4;
    }

    private int GetWeek(Calendar calendar, int n, boolean bl) {
        if (bl) {
            n = 2;
        }
        int n2 = calendar.getFirstDayOfWeek();
        int n3 = calendar.getMinimalDaysInFirstWeek();
        calendar.setFirstDayOfWeek(n);
        calendar.setMinimalDaysInFirstWeek(bl ? 4 : 7);
        calendar.setTime(calendar.getTime());
        int n4 = calendar.get(3);
        if (!bl && calendar.get(2) == 0 && n4 > 50) {
            n4 = 0;
        }
        calendar.setFirstDayOfWeek(n2);
        calendar.setMinimalDaysInFirstWeek(n3);
        return n4;
    }

    private void SetWeekday(Calendar calendar, ClockRelTimespan clockRelTimespan) {
        int n = clockRelTimespan.getWeekday();
        int n2 = clockRelTimespan.getDayOrdinal();
        while (calendar.get(7) != n) {
            calendar.add(5, 1);
        }
        if (n2 > 1) {
            calendar.add(5, 7 * (n2 - 1));
        }
    }

    private void SetOrdMonth(Calendar calendar, ClockRelTimespan clockRelTimespan) {
        int n = clockRelTimespan.getMonths();
        int n2 = clockRelTimespan.getOrdMonth();
        calendar.add(2, 1);
        while (calendar.get(2) != n) {
            calendar.add(2, 1);
        }
        if (n2 > 1) {
            calendar.add(1, n2 - 1);
        }
        calendar.set(5, 1);
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
    }

    private Date GetDate(String string, Date date, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        gregorianCalendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        if (bl) {
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        ClockToken[] clockTokenArray = this.GetTokens(string, false);
        ParsePosition parsePosition = new ParsePosition(0);
        ClockRelTimespan clockRelTimespan = new ClockRelTimespan();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (parsePosition.getIndex() < clockTokenArray.length) {
            if (this.ParseTime(clockTokenArray, parsePosition, gregorianCalendar)) {
                ++n;
                continue;
            }
            if (this.ParseZone(clockTokenArray, parsePosition, gregorianCalendar)) {
                ++n2;
                continue;
            }
            if (this.ParseIso(clockTokenArray, parsePosition, gregorianCalendar)) {
                ++n3;
                continue;
            }
            if (this.ParseDate(clockTokenArray, parsePosition, gregorianCalendar)) {
                ++n3;
                continue;
            }
            if (this.ParseDay(clockTokenArray, parsePosition, clockRelTimespan)) {
                ++n4;
                continue;
            }
            if (this.ParseOrdMonth(clockTokenArray, parsePosition, clockRelTimespan)) {
                ++n5;
                continue;
            }
            if (this.ParseRelSpec(clockTokenArray, parsePosition, clockRelTimespan)) {
                ++n6;
                continue;
            }
            if (this.ParseNumber(clockTokenArray, parsePosition, gregorianCalendar, n3 > 0 && n > 0 && n6 == 0)) {
                if (n3 != 0 && n != 0 && n6 <= 0) continue;
                ++n;
                continue;
            }
            if (this.ParseTrek(clockTokenArray, parsePosition, gregorianCalendar)) {
                ++n3;
                ++n;
                continue;
            }
            return null;
        }
        if (n > 1 || n2 > 1 || n3 > 1 || n4 > 1 || n5 > 1) {
            return null;
        }
        int n7 = gregorianCalendar.get(1);
        if (n7 < 100) {
            if (n7 >= 69) {
                gregorianCalendar.set(1, n7 + 1900);
            } else {
                gregorianCalendar.set(1, n7 + 2000);
            }
        }
        if (n6 > 0) {
            int n8;
            if (n == 0 && n3 == 0 && n4 == 0) {
                gregorianCalendar.setTime(date);
            }
            boolean bl2 = (n8 = clockRelTimespan.getSeconds()) < 0;
            int n9 = 0;
            if (bl2) {
                n8 *= -1;
            }
            while (n8 >= 86400) {
                n8 -= 86400;
                ++n9;
            }
            if (bl2) {
                n8 *= -1;
                n9 *= -1;
            }
            if (n9 != 0) {
                gregorianCalendar.add(5, n9);
            }
            if (n8 != 0) {
                gregorianCalendar.add(13, n8);
            }
            gregorianCalendar.add(2, clockRelTimespan.getMonths());
        }
        if (n4 > 0 && n3 == 0) {
            this.SetWeekday(gregorianCalendar, clockRelTimespan);
        }
        if (n5 > 0) {
            this.SetOrdMonth(gregorianCalendar, clockRelTimespan);
        }
        return gregorianCalendar.getTime();
    }

    private boolean ParseTime(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        ClockToken clockToken;
        int n = parsePosition.getIndex();
        if (n + 6 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is(':') && clockTokenArray[n + 4].isUNumber() && clockTokenArray[n + 5].is('-') && clockTokenArray[n + 6].isUNumber() && (clockToken = this.GetTimeZoneFromRawOffset(-clockTokenArray[n + 6].getInt() / 100)) != null) {
            calendar.set(11, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            calendar.set(13, clockTokenArray[n + 4].getInt());
            calendar.setTimeZone(clockToken.getZone());
            parsePosition.setIndex(n + 7);
            return true;
        }
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is(':') && clockTokenArray[n + 4].isUNumber()) {
            parsePosition.setIndex(n + 5);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            calendar.set(13, clockTokenArray[n + 4].getInt());
            return true;
        }
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is('-') && clockTokenArray[n + 4].isUNumber() && (clockToken = this.GetTimeZoneFromRawOffset(-clockTokenArray[n + 4].getInt() / 100)) != null) {
            calendar.set(11, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            calendar.setTimeZone(clockToken.getZone());
            parsePosition.setIndex(n + 5);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber()) {
            parsePosition.setIndex(n + 3);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(15)) {
            parsePosition.setIndex(n + 1);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            return true;
        }
        return false;
    }

    private boolean ParseZone(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(12) && clockTokenArray[n + 1].is(14)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(12)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 1);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(13)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDay(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        int n = parsePosition.getIndex();
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is('+') && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n + 2].getInt(), clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is('-') && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n + 2].getInt(), -clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(16) && clockTokenArray[n + 1].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n + 1].getInt(), 2);
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(6) && clockTokenArray[n + 1].is(',')) {
            clockRelTimespan.setWeekday(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n + 1].getInt(), clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDate(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('/') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is('/') && clockTokenArray[n + 4].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 2].getInt());
            calendar.set(2, clockTokenArray[n].getInt() - 1);
            calendar.set(1, clockTokenArray[n + 4].getInt());
            parsePosition.setIndex(n + 5);
            return true;
        }
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('-') && clockTokenArray[n + 2].is(5) && clockTokenArray[n + 3].is('-') && clockTokenArray[n + 4].isUNumber()) {
            calendar.set(1, clockTokenArray[n + 4].getInt());
            calendar.set(2, clockTokenArray[n + 2].getInt());
            calendar.set(5, clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 5);
            return true;
        }
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('-') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is('-') && clockTokenArray[n + 4].isUNumber()) {
            calendar.set(1, clockTokenArray[n].getInt());
            calendar.set(2, clockTokenArray[n + 2].getInt() - 1);
            calendar.set(5, clockTokenArray[n + 4].getInt());
            parsePosition.setIndex(n + 5);
            return true;
        }
        if (n + 3 < clockTokenArray.length && clockTokenArray[n].is(5) && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is(',') && clockTokenArray[n + 3].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 1].getInt());
            calendar.set(2, clockTokenArray[n].getInt());
            calendar.set(1, clockTokenArray[n + 3].getInt());
            parsePosition.setIndex(n + 4);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('/') && clockTokenArray[n + 2].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 2].getInt());
            calendar.set(2, clockTokenArray[n].getInt() - 1);
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(5) && clockTokenArray[n + 2].isUNumber()) {
            calendar.set(5, clockTokenArray[n].getInt());
            calendar.set(2, clockTokenArray[n + 1].getInt());
            calendar.set(1, clockTokenArray[n + 2].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(5) && clockTokenArray[n + 1].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 1].getInt());
            calendar.set(2, clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(5)) {
            calendar.set(5, clockTokenArray[n].getInt());
            calendar.set(2, clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].isIsoBase()) {
            calendar.set(5, clockTokenArray[n].getInt() % 100);
            calendar.set(2, clockTokenArray[n].getInt() % 10000 / 100 - 1);
            calendar.set(1, clockTokenArray[n].getInt() / 10000);
            parsePosition.setIndex(n + 1);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(11)) {
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, 1970);
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseNumber(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar, boolean bl) {
        int n = parsePosition.getIndex();
        if (n < clockTokenArray.length && clockTokenArray[n].isUNumber()) {
            parsePosition.setIndex(n + 1);
            if (bl) {
                calendar.set(1, clockTokenArray[n].getInt());
            } else {
                calendar.set(11, clockTokenArray[n].getInt() / 100);
                calendar.set(12, clockTokenArray[n].getInt() % 100);
                calendar.set(13, 0);
            }
            return true;
        }
        return false;
    }

    private boolean ParseRelSpec(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        if (!this.ParseRelUnits(clockTokenArray, parsePosition, clockRelTimespan)) {
            return false;
        }
        int n = parsePosition.getIndex();
        if (n < clockTokenArray.length && clockTokenArray[n].is(10)) {
            clockRelTimespan.negate();
            parsePosition.setIndex(n + 1);
        }
        return true;
    }

    private boolean ParseRelUnits(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        int n = parsePosition.getIndex();
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is('+') && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n + 2], clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is('-') && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n + 2], -clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n + 1], clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is(16) && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n + 2], clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(16) && clockTokenArray[n + 1].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n + 1]);
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].isUnit()) {
            clockRelTimespan.addUnit(clockTokenArray[n]);
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseOrdMonth(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        int n = parsePosition.getIndex();
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].is(16) && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is(5)) {
            clockRelTimespan.addOrdMonth(clockTokenArray[n + 2].getInt(), clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(16) && clockTokenArray[n + 1].is(5)) {
            clockRelTimespan.addOrdMonth(clockTokenArray[n + 1].getInt(), 1);
            parsePosition.setIndex(n + 2);
            return true;
        }
        return false;
    }

    private boolean ParseIso(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 6 < clockTokenArray.length && clockTokenArray[n].isIsoBase() && clockTokenArray[n + 1].is(12) && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is(':') && clockTokenArray[n + 4].isUNumber() && clockTokenArray[n + 5].is(':') && clockTokenArray[n + 6].isUNumber()) {
            calendar.set(5, clockTokenArray[n].getInt() % 100);
            calendar.set(2, clockTokenArray[n].getInt() % 10000 / 100 - 1);
            calendar.set(1, clockTokenArray[n].getInt() / 10000);
            calendar.set(11, clockTokenArray[n + 2].getInt());
            calendar.set(12, clockTokenArray[n + 4].getInt());
            calendar.set(13, clockTokenArray[n + 6].getInt());
            parsePosition.setIndex(n + 7);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isIsoBase() && clockTokenArray[n + 1].is(12) && clockTokenArray[n + 1].getZone().getRawOffset() == -25200000 && clockTokenArray[n + 2].isIsoBase()) {
            calendar.set(5, clockTokenArray[n].getInt() % 100);
            calendar.set(2, clockTokenArray[n].getInt() % 10000 / 100 - 1);
            calendar.set(1, clockTokenArray[n].getInt() / 10000);
            calendar.set(11, clockTokenArray[n + 2].getInt() / 10000);
            calendar.set(12, clockTokenArray[n + 2].getInt() % 10000 / 100);
            calendar.set(13, clockTokenArray[n + 2].getInt() % 100);
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isIsoBase() && clockTokenArray[n + 1].isIsoBase()) {
            calendar.set(5, clockTokenArray[n].getInt() % 100);
            calendar.set(2, clockTokenArray[n].getInt() % 10000 / 100 - 1);
            calendar.set(1, clockTokenArray[n].getInt() / 10000);
            calendar.set(11, clockTokenArray[n + 1].getInt() / 10000);
            calendar.set(12, clockTokenArray[n + 1].getInt() % 10000 / 100);
            calendar.set(13, clockTokenArray[n + 1].getInt() % 100);
            parsePosition.setIndex(n + 2);
            return true;
        }
        return false;
    }

    private boolean ParseTrek(ClockToken[] clockTokenArray, ParsePosition parsePosition, GregorianCalendar gregorianCalendar) {
        int n = parsePosition.getIndex();
        if (n + 3 < clockTokenArray.length && clockTokenArray[n].is(17) && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is('.') && clockTokenArray[n + 3].isUNumber()) {
            int n2 = clockTokenArray[n + 1].getInt() / 1000 + 2323 - 377;
            int n3 = 1 + clockTokenArray[n + 1].getInt() % 1000 * (gregorianCalendar.isLeapYear(n2) ? 366 : 365) / 1000;
            int n4 = clockTokenArray[n + 3].getInt() * 144 * 60;
            gregorianCalendar.set(1, n2);
            gregorianCalendar.set(6, n3);
            gregorianCalendar.set(13, n4);
            parsePosition.setIndex(n + 4);
            return true;
        }
        return false;
    }

    private void ParseMeridianAndSetHour(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar, int n) {
        int n2;
        int n3 = parsePosition.getIndex();
        if (n3 < clockTokenArray.length && clockTokenArray[n3].is(15)) {
            calendar.set(9, clockTokenArray[n3].getInt());
            parsePosition.setIndex(n3 + 1);
            n2 = 10;
        } else {
            n2 = 11;
        }
        if (n2 == 10 && n == 12) {
            n = 0;
        }
        calendar.set(n2, n);
    }

    private ClockToken[] GetTokens(String string, boolean bl) {
        ClockToken clockToken;
        ParsePosition parsePosition = new ParsePosition(0);
        ArrayList<ClockToken> arrayList = new ArrayList<ClockToken>(string.length());
        while ((clockToken = this.GetNextToken(string, parsePosition)) != null) {
            arrayList.add(clockToken);
        }
        ClockToken[] clockTokenArray = new ClockToken[]{null};
        clockTokenArray = arrayList.toArray(clockTokenArray);
        if (bl) {
            for (int i = 0; i < clockTokenArray.length; ++i) {
                if (i != 0) {
                    System.err.print(",");
                }
                System.err.print(clockTokenArray[i].toString());
            }
            System.err.println("");
        }
        return clockTokenArray;
    }

    private ClockToken GetNextToken(String string, ParsePosition parsePosition) {
        int n;
        for (n = parsePosition.getIndex(); n < string.length() && Character.isSpaceChar(string.charAt(n)); ++n) {
        }
        if (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                int n2 = 0;
                int n3 = 0;
                while (n < string.length() && Character.isDigit(c = string.charAt(n))) {
                    n2 = 10 * n2 + c - 48;
                    ++n;
                    ++n3;
                }
                parsePosition.setIndex(n);
                return new ClockToken(n2, n3 >= 6);
            }
            if (Character.isLetter(c)) {
                int n4 = n;
                while (++n < string.length() && (Character.isLetter(c = string.charAt(n)) || c == '.')) {
                }
                parsePosition.setIndex(n);
                return this.LookupWord(string.substring(n4, n));
            }
            parsePosition.setIndex(n + 1);
            return new ClockToken(string.charAt(n));
        }
        parsePosition.setIndex(n + 1);
        return null;
    }

    private ClockToken LookupWord(String string) {
        int n;
        boolean bl;
        if (string.equalsIgnoreCase("am") || string.equalsIgnoreCase("a.m.")) {
            return new ClockToken(15, 0);
        }
        if (string.equalsIgnoreCase("pm") || string.equalsIgnoreCase("p.m.")) {
            return new ClockToken(15, 1);
        }
        if (string.length() == 3) {
            bl = true;
        } else if (string.length() == 4 && string.charAt(3) == '.') {
            bl = true;
            string = string.substring(0, 3);
        } else {
            bl = false;
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.US);
        String[] stringArray = bl ? dateFormatSymbols.getShortMonths() : dateFormatSymbols.getMonths();
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equalsIgnoreCase(stringArray[n])) continue;
            return new ClockToken(5, n);
        }
        stringArray = bl ? dateFormatSymbols.getShortWeekdays() : dateFormatSymbols.getWeekdays();
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equalsIgnoreCase(stringArray[n])) continue;
            return new ClockToken(6, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '.') continue;
            stringBuffer.append(string.charAt(n));
        }
        String string2 = new String(stringBuffer);
        String[][] stringArray2 = dateFormatSymbols.getZoneStrings();
        for (n = 0; n < stringArray2.length; ++n) {
            if (!string2.equalsIgnoreCase(stringArray2[n][2]) && !string2.equalsIgnoreCase(stringArray2[n][4])) continue;
            TimeZone timeZone = TimeZone.getTimeZone(stringArray2[n][0]);
            return new ClockToken(12, timeZone);
        }
        if (string2.equalsIgnoreCase("dst")) {
            return new ClockToken(14, null);
        }
        String string3 = string.endsWith("s") ? string.substring(0, string.length() - 1) : string;
        if (string3.equalsIgnoreCase("year")) {
            return new ClockToken(7, 12);
        }
        if (string3.equalsIgnoreCase("month")) {
            return new ClockToken(7, 1);
        }
        if (string3.equalsIgnoreCase("fortnight")) {
            return new ClockToken(8, 20160);
        }
        if (string3.equalsIgnoreCase("week")) {
            return new ClockToken(8, 10080);
        }
        if (string3.equalsIgnoreCase("day")) {
            return new ClockToken(8, 1440);
        }
        if (string3.equalsIgnoreCase("hour")) {
            return new ClockToken(8, 60);
        }
        if (string3.equalsIgnoreCase("minute")) {
            return new ClockToken(8, 1);
        }
        if (string3.equalsIgnoreCase("min")) {
            return new ClockToken(8, 1);
        }
        if (string3.equalsIgnoreCase("second")) {
            return new ClockToken(9, 1);
        }
        if (string3.equalsIgnoreCase("sec")) {
            return new ClockToken(9, 1);
        }
        if (string3.equalsIgnoreCase("tomorrow")) {
            return new ClockToken(8, 1440);
        }
        if (string3.equalsIgnoreCase("yesterday")) {
            return new ClockToken(8, -1440);
        }
        if (string3.equalsIgnoreCase("today")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("now")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("last")) {
            return new ClockToken(-1, false);
        }
        if (string3.equalsIgnoreCase("this")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("next")) {
            return new ClockToken(16, 1);
        }
        if (string3.equalsIgnoreCase("ago")) {
            return new ClockToken(10, 1);
        }
        if (string3.equalsIgnoreCase("epoch")) {
            return new ClockToken(11, 0);
        }
        if (string3.equalsIgnoreCase("stardate")) {
            return new ClockToken(17, 0);
        }
        if (string2.length() == 1) {
            ClockToken clockToken;
            int n2 = 0;
            boolean bl2 = true;
            char c = Character.toLowerCase(string2.charAt(0));
            if (c >= 'a' && c <= 'm') {
                n2 = c - 97 + 1;
            } else if (c >= 'n' && c < 'z') {
                n2 = 110 - c - 1;
            } else if (c != 'z') {
                bl2 = false;
            }
            if (bl2 && (clockToken = this.GetTimeZoneFromRawOffset(n2)) != null) {
                return clockToken;
            }
        }
        return new ClockToken(string);
    }

    private ClockToken GetTimeZoneFromRawOffset(int n) {
        String[] stringArray = TimeZone.getAvailableIDs(n * 3600000);
        if (stringArray.length > 0) {
            TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
            return new ClockToken(12, timeZone);
        }
        return null;
    }
}

