/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.AbstractSocketChannel;
import tcl.lang.channel.Channel;
import tcl.lang.channel.SocketChannel;
import tcl.lang.cmd.EncodingCmd;

public class FconfigureCmd
implements Command {
    private static final String[] commonValidCommands = new String[]{"-blocking", "-buffering", "-buffersize", "-encoding", "-eofchar", "-translation"};
    private static final String[] socketValidCommands = new String[]{"-blocking", "-buffering", "-buffersize", "-encoding", "-eofchar", "-translation", "-peername", "-sockname"};
    static final int OPT_BLOCKING = 0;
    static final int OPT_BUFFERING = 1;
    static final int OPT_BUFFERSIZE = 2;
    static final int OPT_ENCODING = 3;
    static final int OPT_EOFCHAR = 4;
    static final int OPT_TRANSLATION = 5;
    static final int OPT_PEERNAME = 6;
    static final int OPT_SOCKNAME = 7;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Object object;
        char c;
        Object object2;
        String[] stringArray;
        if (tclObjectArray.length < 2 || tclObjectArray.length % 2 == 1 && tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId ?optionName? ?value? ?optionName value?...");
        }
        Channel channel = TclIO.getChannel(interp, tclObjectArray[1].toString());
        if (channel == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        String[] stringArray2 = stringArray = channel instanceof AbstractSocketChannel ? socketValidCommands : commonValidCommands;
        if (tclObjectArray.length == 2) {
            char c2;
            TclObject tclObject = TclList.newInstance();
            TclList.append(interp, tclObject, TclString.newInstance("-blocking"));
            TclList.append(interp, tclObject, TclBoolean.newInstance(channel.getBlocking()));
            TclList.append(interp, tclObject, TclString.newInstance("-buffering"));
            TclList.append(interp, tclObject, TclString.newInstance(TclIO.getBufferingString(channel.getBuffering())));
            TclList.append(interp, tclObject, TclString.newInstance("-buffersize"));
            TclList.append(interp, tclObject, TclInteger.newInstance(channel.getBufferSize()));
            TclList.append(interp, tclObject, TclString.newInstance("-encoding"));
            object2 = channel.getEncoding();
            String string = object2 == null ? "binary" : EncodingCmd.getTclName((String)object2);
            TclList.append(interp, tclObject, TclString.newInstance(string));
            TclList.append(interp, tclObject, TclString.newInstance("-eofchar"));
            if (channel.isReadOnly()) {
                c2 = channel.getInputEofChar();
                TclList.append(interp, tclObject, c2 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c2));
            } else if (channel.isWriteOnly()) {
                c2 = channel.getOutputEofChar();
                TclList.append(interp, tclObject, c2 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c2));
            } else if (channel.isReadWrite()) {
                c2 = channel.getInputEofChar();
                c = channel.getOutputEofChar();
                object = TclList.newInstance();
                TclList.append(interp, (TclObject)object, c2 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c2));
                TclList.append(interp, (TclObject)object, c == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c));
                TclList.append(interp, tclObject, (TclObject)object);
            } else {
                c2 = channel.getInputEofChar();
                TclList.append(interp, tclObject, c2 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c2));
            }
            TclList.append(interp, tclObject, TclString.newInstance("-translation"));
            if (channel.isReadOnly()) {
                TclList.append(interp, tclObject, TclString.newInstance(TclIO.getTranslationString(channel.getInputTranslation())));
            } else if (channel.isWriteOnly()) {
                TclList.append(interp, tclObject, TclString.newInstance(TclIO.getTranslationString(channel.getOutputTranslation())));
            } else if (channel.isReadWrite()) {
                TclObject tclObject2 = TclList.newInstance();
                TclList.append(interp, tclObject2, TclString.newInstance(TclIO.getTranslationString(channel.getInputTranslation())));
                TclList.append(interp, tclObject2, TclString.newInstance(TclIO.getTranslationString(channel.getOutputTranslation())));
                TclList.append(interp, tclObject, tclObject2);
            } else {
                TclList.append(interp, tclObject, TclString.newInstance(TclIO.getTranslationString(channel.getInputTranslation())));
            }
            if (channel instanceof SocketChannel) {
                TclList.append(interp, tclObject, TclString.newInstance("-peername"));
                TclList.append(interp, tclObject, ((AbstractSocketChannel)channel).getPeerName(interp));
            }
            if (channel instanceof AbstractSocketChannel) {
                TclList.append(interp, tclObject, TclString.newInstance("-sockname"));
                TclList.append(interp, tclObject, ((AbstractSocketChannel)channel).getSockName(interp));
            }
            interp.setResult(tclObject);
        }
        if (tclObjectArray.length == 3) {
            if (channel instanceof AbstractSocketChannel && tclObjectArray[2].toString().equals("-error")) {
                interp.setResult(((AbstractSocketChannel)channel).getError(interp));
                return;
            }
            int n = 0;
            try {
                n = TclIndex.get(interp, tclObjectArray[2], stringArray, "option", 0);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad option \"" + tclObjectArray[2] + "\": should be one of -blocking, -buffering, -buffersize, -encoding, -eofchar, or -translation");
            }
            switch (n) {
                case 0: {
                    interp.setResult(channel.getBlocking());
                    break;
                }
                case 1: {
                    interp.setResult(TclIO.getBufferingString(channel.getBuffering()));
                    break;
                }
                case 2: {
                    interp.setResult(channel.getBufferSize());
                    break;
                }
                case 3: {
                    object2 = channel.getEncoding();
                    if (object2 == null) {
                        interp.setResult("binary");
                        break;
                    }
                    interp.setResult(EncodingCmd.getTclName((String)object2));
                    break;
                }
                case 4: {
                    if (channel.isReadOnly()) {
                        char c3 = channel.getInputEofChar();
                        interp.setResult(c3 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c3));
                        break;
                    }
                    if (channel.isWriteOnly()) {
                        char c4 = channel.getOutputEofChar();
                        interp.setResult(c4 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c4));
                        break;
                    }
                    if (channel.isReadWrite()) {
                        char c5 = channel.getInputEofChar();
                        char c6 = channel.getOutputEofChar();
                        TclObject tclObject = TclList.newInstance();
                        TclList.append(interp, tclObject, c5 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c5));
                        TclList.append(interp, tclObject, c6 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c6));
                        interp.setResult(tclObject);
                        break;
                    }
                    object2 = TclList.newInstance();
                    char c7 = channel.getOutputEofChar();
                    TclList.append(interp, (TclObject)object2, c7 == '\u0000' ? TclString.newInstance("") : TclString.newInstance(c7));
                    interp.setResult((TclObject)object2);
                    break;
                }
                case 5: {
                    if (channel.isReadOnly()) {
                        interp.setResult(TclIO.getTranslationString(channel.getInputTranslation()));
                        break;
                    }
                    if (channel.isWriteOnly()) {
                        interp.setResult(TclIO.getTranslationString(channel.getOutputTranslation()));
                        break;
                    }
                    if (channel.isReadWrite()) {
                        object2 = TclList.newInstance();
                        TclList.append(interp, (TclObject)object2, TclString.newInstance(TclIO.getTranslationString(channel.getInputTranslation())));
                        TclList.append(interp, (TclObject)object2, TclString.newInstance(TclIO.getTranslationString(channel.getOutputTranslation())));
                        interp.setResult((TclObject)object2);
                        break;
                    }
                    interp.setResult(TclIO.getTranslationString(channel.getInputTranslation()));
                    break;
                }
                case 6: {
                    interp.setResult(((AbstractSocketChannel)channel).getPeerName(interp));
                    break;
                }
                case 7: {
                    interp.setResult(((AbstractSocketChannel)channel).getSockName(interp));
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
        block22: for (int i = 3; i < tclObjectArray.length; i += 2) {
            int n;
            try {
                n = TclIndex.get(interp, tclObjectArray[i - 1], commonValidCommands, "option", 0);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad option \"" + tclObjectArray[i - 1] + "\": should be one of -blocking, -buffering, -buffersize, -encoding, -eofchar, or -translation");
            }
            switch (n) {
                case 0: {
                    channel.setBlocking(TclBoolean.get(interp, tclObjectArray[i]));
                    continue block22;
                }
                case 1: {
                    int n2 = TclIO.getBufferingID(tclObjectArray[i].toString());
                    if (n2 == -1) {
                        throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                    }
                    channel.setBuffering(n2);
                    continue block22;
                }
                case 2: {
                    channel.setBufferSize(TclInteger.getInt(interp, tclObjectArray[i]));
                    continue block22;
                }
                case 3: {
                    String string = tclObjectArray[i].toString();
                    if (string.equals("") || string.equals("binary") || string.equals("identity")) {
                        channel.setEncoding(null);
                        continue block22;
                    }
                    String string2 = EncodingCmd.getJavaName(string);
                    if (string2 == null) {
                        throw new TclException(interp, "unknown encoding \"" + string + "\"");
                    }
                    if (!EncodingCmd.isSupported(string2)) {
                        throw new TclException(interp, "unsupported encoding \"" + string + "\"");
                    }
                    channel.setEncoding(string2);
                    continue block22;
                }
                case 4: {
                    char c8;
                    int n3 = TclList.getLength(interp, tclObjectArray[i]);
                    if (n3 > 2) {
                        throw new TclException(interp, "bad value for -eofchar: should be a list of zero, one, or two elements");
                    }
                    if (n3 == 0) {
                        c = '\u0000';
                        c8 = '\u0000';
                    } else if (n3 == 1) {
                        object = TclList.index(interp, tclObjectArray[i], 0).toString();
                        c8 = c = ((String)object).charAt(0);
                    } else {
                        object = TclList.index(interp, tclObjectArray[i], 0).toString();
                        c8 = ((String)object).charAt(0);
                        object = TclList.index(interp, tclObjectArray[i], 1).toString();
                        c = ((String)object).charAt(0);
                    }
                    channel.setInputEofChar(c8);
                    channel.setOutputEofChar(c);
                    continue block22;
                }
                case 5: {
                    int n4;
                    String string;
                    int n5;
                    String string3;
                    int n6 = TclList.getLength(interp, tclObjectArray[i]);
                    if (n6 < 1 || n6 > 2) {
                        throw new TclException(interp, "bad value for -translation: must be a one or two element list");
                    }
                    if (n6 == 2) {
                        string3 = TclList.index(interp, tclObjectArray[i], 0).toString();
                        n5 = TclIO.getTranslationID(string3);
                        string = TclList.index(interp, tclObjectArray[i], 1).toString();
                        n4 = TclIO.getTranslationID(string);
                    } else {
                        string = string3 = tclObjectArray[i].toString();
                        n4 = n5 = TclIO.getTranslationID(string);
                    }
                    if (n5 == -1 || n4 == -1) {
                        throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                    }
                    if (channel.isReadOnly()) {
                        channel.setInputTranslation(n5);
                        if (!string3.equals("binary")) continue block22;
                        channel.setEncoding(null);
                        continue block22;
                    }
                    if (channel.isWriteOnly()) {
                        channel.setOutputTranslation(n4);
                        if (!string.equals("binary")) continue block22;
                        channel.setEncoding(null);
                        continue block22;
                    }
                    if (!channel.isReadWrite()) continue block22;
                    channel.setInputTranslation(n5);
                    channel.setOutputTranslation(n4);
                    if (!string3.equals("binary") && !string.equals("binary")) continue block22;
                    channel.setEncoding(null);
                    continue block22;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
    }
}

