/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class FileCmd
implements Command {
    private static final String[] validCmds = new String[]{"atime", "attributes", "channels", "copy", "delete", "dirname", "executable", "exists", "extension", "isdirectory", "isfile", "join", "link", "lstat", "mtime", "mkdir", "nativename", "normalize", "owned", "pathtype", "readable", "readlink", "rename", "rootname", "separator", "size", "split", "stat", "system", "tail", "type", "volumes", "writable"};
    private static final int OPT_ATIME = 0;
    private static final int OPT_ATTRIBUTES = 1;
    private static final int OPT_CHANNELS = 2;
    private static final int OPT_COPY = 3;
    private static final int OPT_DELETE = 4;
    private static final int OPT_DIRNAME = 5;
    private static final int OPT_EXECUTABLE = 6;
    private static final int OPT_EXISTS = 7;
    private static final int OPT_EXTENSION = 8;
    private static final int OPT_ISDIRECTORY = 9;
    private static final int OPT_ISFILE = 10;
    private static final int OPT_JOIN = 11;
    private static final int OPT_LINK = 12;
    private static final int OPT_LSTAT = 13;
    private static final int OPT_MTIME = 14;
    private static final int OPT_MKDIR = 15;
    private static final int OPT_NATIVENAME = 16;
    private static final int OPT_NORMALIZE = 17;
    private static final int OPT_OWNED = 18;
    private static final int OPT_PATHTYPE = 19;
    private static final int OPT_READABLE = 20;
    private static final int OPT_READLINK = 21;
    private static final int OPT_RENAME = 22;
    private static final int OPT_ROOTNAME = 23;
    private static final int OPT_SEPARATOR = 24;
    private static final int OPT_SIZE = 25;
    private static final int OPT_SPLIT = 26;
    private static final int OPT_STAT = 27;
    private static final int OPT_SYSTEM = 28;
    private static final int OPT_TAIL = 29;
    private static final int OPT_TYPE = 30;
    private static final int OPT_VOLUMES = 31;
    private static final int OPT_WRITABLE = 32;
    private static final String[] validOptions = new String[]{"-force", "--"};
    private static final int OPT_FORCE = 0;
    private static final int OPT_LAST = 1;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        File file = null;
        switch (n) {
            case 0: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name ?time?");
                }
                if (!FileUtil.getNewFileObj(interp, tclObjectArray[2].toString()).exists() || tclObjectArray[2].toString().length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + tclObjectArray[2] + "\"");
                }
                if (tclObjectArray.length == 4) {
                    try {
                        int n2 = Integer.parseInt(tclObjectArray[3].toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TclException(interp, "expected integer but got \"" + tclObjectArray[3] + "\"");
                    }
                }
                throw new TclException(interp, "sorry, \"file atime\" is not available due to JVM restrictions.");
            }
            case 1: {
                file = null;
                if (tclObjectArray.length >= 3) {
                    String string = tclObjectArray[2].toString();
                    file = FileUtil.getNewFileObj(interp, string);
                    if (string.length() == 0 || !file.exists()) {
                        throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
                    }
                }
                switch (tclObjectArray.length) {
                    case 3: {
                        interp.setResult("-JTCL_DOES_NOT_SUPPORT_ATTRIBUTES FILE_ATTRIBUTES_NOT_SUPPORTED");
                        return;
                    }
                    case 4: 
                    case 5: {
                        if (!tclObjectArray[3].toString().equals("-JTCL_DOES_NOT_SUPPORT_ATTRIBUTES")) break;
                        if (tclObjectArray.length == 4) {
                            interp.setResult("FILE_ATTRIBUTES_NOT_SUPPORTED");
                        }
                        return;
                    }
                }
                throw new TclException(interp, "Sorry, \"file attributes\" is not available to due JVM restrictions");
            }
            case 2: {
                if (tclObjectArray.length > 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                try {
                    TclIO.getChannelNames(interp, tclObjectArray.length == 2 ? null : TclString.newInstance(tclObjectArray[2]));
                }
                catch (TclException tclException) {
                    throw new TclException(interp, "Could not get channel names.");
                }
                return;
            }
            case 3: {
                FileCmd.fileCopyRename(interp, tclObjectArray, true);
                return;
            }
            case 4: {
                FileCmd.fileDelete(interp, tclObjectArray);
                return;
            }
            case 5: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = tclObjectArray[2].toString();
                TclObject[] tclObjectArray2 = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, string));
                if (tclObjectArray2.length > 1) {
                    interp.setResult(FileUtil.joinPath(interp, tclObjectArray2, 0, tclObjectArray2.length - 1));
                } else if (tclObjectArray2.length == 0 || FileUtil.getPathType(string) == 0) {
                    if (JACL.PLATFORM == 2) {
                        interp.setResult(":");
                    } else {
                        interp.setResult(".");
                    }
                } else {
                    interp.setResult(tclObjectArray2[0].toString());
                }
                return;
            }
            case 6: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    interp.setResult(FileUtil.isExecutable(FileUtil.getNewFileObj(interp, tclObjectArray[2].toString())));
                }
                return;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    try {
                        file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                        interp.setResult(file.exists());
                    }
                    catch (TclException tclException) {
                        interp.setResult(false);
                    }
                }
                return;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                interp.setResult(FileCmd.getExtension(tclObjectArray[2].toString()));
                return;
            }
            case 9: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                    interp.setResult(file.isDirectory());
                }
                return;
            }
            case 10: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                interp.setResult(file.isFile());
                return;
            }
            case 11: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name ?name ...?");
                }
                interp.setResult(FileUtil.joinPath(interp, tclObjectArray, 2, tclObjectArray.length));
                return;
            }
            case 12: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-linktype? linkname ?target?");
                }
                String string = null;
                String string2 = null;
                if ("-symbolic".equals(tclObjectArray[2].toString()) || "-hard".equals(tclObjectArray[2].toString())) {
                    string = tclObjectArray[3].toString();
                    string2 = tclObjectArray.length == 5 ? tclObjectArray[4].toString() : null;
                    throw new TclException(interp, "sorry, creating links with \"file link\" is not available due to JVM restrictions.");
                }
                if (tclObjectArray.length == 5) {
                    throw new TclException(interp, "bad switch \"" + tclObjectArray[2] + "\": must be -symbolic or -hard");
                }
                string = tclObjectArray[2].toString();
                string2 = tclObjectArray.length == 4 ? tclObjectArray[3].toString() : null;
                File file2 = FileUtil.getNewFileObj(interp, string);
                if (string2 != null) {
                    if (file2.exists()) {
                        throw new TclException(interp, "could not create new link \"" + string + "\": that path already exists");
                    }
                    File file3 = FileUtil.getNewFileObj(interp, string2);
                    if (!file3.exists()) {
                        throw new TclException(interp, "could not create new link \"" + string + "\" since target \"" + string2 + "\" doesn't exist");
                    }
                    throw new TclException(interp, "sorry, creating a link with \"file link\" is not available due to JVM restrictions.");
                }
                if (!file2.exists() || string.length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not read link \"" + string + "\"");
                }
                File file4 = FileUtil.getLinkTarget(file2);
                if (file4 == null) {
                    throw new TclException(interp, "could not read link \"" + string + "\": invalid argument");
                }
                interp.setResult(file4.getAbsolutePath());
                return;
            }
            case 14: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name ?time?");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (tclObjectArray.length == 4) {
                    long l = TclInteger.getLong(interp, tclObjectArray[3]) * 1000L;
                    file.setLastModified(l);
                } else {
                    interp.setResult(FileCmd.getMtime(interp, tclObjectArray[2].toString(), file));
                }
                return;
            }
            case 15: {
                FileCmd.fileMakeDirs(interp, tclObjectArray);
                return;
            }
            case 16: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                interp.setResult(FileUtil.translateFileName(interp, tclObjectArray[2].toString()));
                return;
            }
            case 17: {
                TclObject tclObject = null;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "filename");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult("");
                } else {
                    tclObject = FileUtil.getNormalizedPath(interp, tclObjectArray[2]);
                    if (tclObject == null) {
                        throw new TclException(interp, "Cannot normalize this path!");
                    }
                    interp.setResult(tclObject);
                }
                return;
            }
            case 18: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                    interp.setResult(FileCmd.isOwner(interp, file));
                }
                return;
            }
            case 19: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                switch (FileUtil.getPathType(tclObjectArray[2].toString())) {
                    case 0: {
                        interp.setResult("relative");
                        return;
                    }
                    case 1: {
                        interp.setResult("volumerelative");
                        return;
                    }
                    case 2: {
                        interp.setResult("absolute");
                    }
                }
                return;
            }
            case 20: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                    interp.setResult(file.canRead());
                }
                return;
            }
            case 21: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (!file.exists() || tclObjectArray[2].toString().length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not readlink \"" + tclObjectArray[2] + "\"");
                }
                File file5 = FileUtil.getLinkTarget(file);
                if (file5 == null) {
                    throw new TclException(interp, "could not readlink \"" + tclObjectArray[2] + "\": invalid argument");
                }
                interp.setResult(file5.getPath());
                return;
            }
            case 22: {
                FileCmd.fileCopyRename(interp, tclObjectArray, false);
                return;
            }
            case 23: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = tclObjectArray[2].toString();
                String string3 = FileCmd.getExtension(string);
                int n3 = string.length() - string3.length();
                interp.setResult(string.substring(0, n3));
                return;
            }
            case 24: {
                String string;
                if (tclObjectArray.length > 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray.length == 2) {
                    string = null;
                } else {
                    string = tclObjectArray[2].toString();
                    if (string.length() == 0) {
                        throw new TclException(interp, "Unrecognised path");
                    }
                }
                String string4 = FileUtil.getSeparators(string);
                interp.setResult(string4);
                return;
            }
            case 25: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (!file.exists()) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + tclObjectArray[2].toString() + "\"");
                }
                interp.setResult(file.length());
                return;
            }
            case 26: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                interp.setResult(FileUtil.splitPath(interp, tclObjectArray[2].toString()));
                return;
            }
            case 13: 
            case 27: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name varName");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                FileCmd.getAndStoreStatData(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString(), n == 13);
                return;
            }
            case 28: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (!FileUtil.getNewFileObj(interp, tclObjectArray[2].toString()).exists() || tclObjectArray[2].toString().length() == 0) {
                    throw new TclException(interp, "Unrecognised path");
                }
                interp.setResult("native");
                return;
            }
            case 29: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                interp.setResult(FileCmd.getTail(interp, tclObjectArray[2].toString()));
                return;
            }
            case 30: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                interp.setResult(FileCmd.getType(interp, tclObjectArray[2].toString(), file));
                return;
            }
            case 31: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                File[] fileArray = File.listRoots();
                if (fileArray != null) {
                    TclObject tclObject = TclList.newInstance();
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string = fileArray[i].getPath();
                        TclList.append(interp, tclObject, TclString.newInstance(string));
                    }
                    interp.setResult(tclObject);
                }
                return;
            }
            case 32: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                if (tclObjectArray[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                    interp.setResult(file.canWrite());
                }
                return;
            }
        }
        throw new TclRuntimeError("file command with opt " + tclObjectArray[1].toString() + " is not implemented");
    }

    private static boolean isOwner(Interp interp, File file) throws TclException {
        if (!file.exists()) {
            return false;
        }
        boolean bl = true;
        if (Util.isUnix()) {
            // empty if block
        }
        return bl;
    }

    private static int getMtime(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        return (int)(file.lastModified() / 1000L);
    }

    private static String getType(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        if (FileUtil.getLinkTarget(file) != null) {
            return "link";
        }
        if (file.isFile()) {
            return "file";
        }
        if (file.isDirectory()) {
            return "directory";
        }
        return "link";
    }

    private static void getAndStoreStatData(Interp interp, String string, String string2, boolean bl) throws TclException {
        TclObject tclObject;
        File file;
        File file2 = FileUtil.getNewFileObj(interp, string);
        if (bl && (file = FileUtil.getLinkTarget(file2)) != null) {
            file2 = file;
        }
        if (!file2.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        try {
            int n = FileCmd.getMtime(interp, string, file2);
            TclObject tclObject2 = TclInteger.newInstance(n);
            TclObject tclObject3 = TclInteger.newInstance(n);
            TclObject tclObject4 = TclInteger.newInstance(n);
            interp.setVar(string2, "ctime", tclObject4, 0);
            interp.setVar(string2, "mtime", tclObject2, 0);
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        catch (TclException tclException) {
            throw new TclException(interp, "can't set \"" + string2 + "(dev)\": variable isn't array");
        }
        try {
            tclObject = TclInteger.newInstance(file2.length());
            interp.setVar(string2, "size", tclObject, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tclObject = TclString.newInstance(FileCmd.getType(interp, string, file2));
            interp.setVar(string2, "type", tclObject, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tclObject = TclBoolean.newInstance(FileCmd.isOwner(interp, file2));
            interp.setVar(string2, "uid", tclObject, 0);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    private static String getExtension(String string) {
        String string2;
        if (string.length() < 1) {
            return "";
        }
        int n = -1;
        switch (JACL.PLATFORM) {
            case 1: {
                string2 = string.replace('\\', '/').replace(':', '/');
                n = string2.lastIndexOf(47);
                break;
            }
            case 2: {
                n = string.lastIndexOf(58);
                if (n != -1) break;
                n = string.lastIndexOf(47);
                break;
            }
            default: {
                n = string.lastIndexOf(47);
            }
        }
        if (++n >= string.length()) {
            return "";
        }
        string2 = string.substring(n);
        int n2 = string2.lastIndexOf(46);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(n2);
    }

    private static String getTail(Interp interp, String string) throws TclException {
        TclObject tclObject = FileUtil.splitAndTranslate(interp, string);
        int n = TclList.getLength(interp, tclObject) - 1;
        if (n >= 0 && (n > 0 || FileUtil.getPathType(string) == 0)) {
            TclObject tclObject2 = TclList.index(interp, tclObject, n);
            return tclObject2.toString();
        }
        return "";
    }

    private static void fileMakeDirs(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        for (int i = 2; i < tclObjectArray.length; ++i) {
            String string = tclObjectArray[i].toString();
            if (string.length() == 0) {
                throw new TclPosixException(interp, 2, true, "can't create directory \"\"");
            }
            File file = FileUtil.getNewFileObj(interp, string);
            if (file.exists()) {
                if (file.isDirectory()) continue;
                throw new TclPosixException(interp, 17, true, "can't create directory \"" + string + "\"");
            }
            try {
                bl = file.mkdir();
                if (!bl) {
                    bl = file.mkdirs();
                }
            }
            catch (SecurityException securityException) {
                throw new TclException(interp, securityException.getMessage());
            }
            if (bl) continue;
            throw new TclPosixException(interp, 13, true, "can't create directory \"" + string + "\":  best guess at reason");
        }
    }

    private static void fileDelete(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl = false;
        int n2 = 0;
        block6: for (n = 2; n < tclObjectArray.length && n2 == 0 && tclObjectArray[n].toString().startsWith("-"); ++n) {
            int n3;
            try {
                n3 = TclIndex.get(interp, tclObjectArray[n], validOptions, "option", 1);
            }
            catch (TclException tclException) {
                throw new TclException(interp, tclException.getMessage().replace("must", "should"));
            }
            switch (n3) {
                case 0: {
                    bl = true;
                    continue block6;
                }
                case 1: {
                    n2 = 1;
                    continue block6;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n3 + " index to validOptions");
                }
            }
        }
        if (n >= tclObjectArray.length) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?options? file ?file ...?");
        }
        for (n2 = n; n2 < tclObjectArray.length; ++n2) {
            if (tclObjectArray[n2].toString().length() <= 0) continue;
            FileCmd.deleteOneFile(interp, FileUtil.getNewFileObj(interp, tclObjectArray[n2].toString()), bl);
        }
    }

    private static void deleteOneFile(Interp interp, File file, boolean bl) throws TclException {
        boolean bl2 = true;
        String string = file.getPath();
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && file.list().length > 0) {
            if (bl) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    FileCmd.deleteOneFile(interp, new File(file, stringArray[i]), bl);
                }
            } else {
                throw new TclPosixException(interp, 66, "error deleting \"" + file.getName() + "\": directory not empty");
            }
        }
        try {
            bl2 = file.delete();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        if (!bl2) {
            throw new TclPosixException(interp, 13, true, "error deleting \"" + string + "\":  best guess at reason");
        }
    }

    private static void fileCopyRename(Interp interp, TclObject[] tclObjectArray, boolean bl) throws TclException {
        int n;
        boolean bl2 = false;
        int n2 = 0;
        block6: for (n = 2; n < tclObjectArray.length && n2 == 0 && tclObjectArray[n].toString().startsWith("-"); ++n) {
            int n3;
            try {
                n3 = TclIndex.get(interp, tclObjectArray[n], validOptions, "option", 1);
            }
            catch (TclException tclException) {
                throw new TclException(interp, tclException.getMessage().replace("must", "should"));
            }
            switch (n3) {
                case 0: {
                    bl2 = true;
                    continue block6;
                }
                case 1: {
                    n2 = 1;
                    continue block6;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n3 + " index to validOptions");
                }
            }
        }
        if (n >= tclObjectArray.length - 1) {
            throw new TclNumArgsException(interp, n, tclObjectArray, "?options? source ?source ...? target");
        }
        n2 = tclObjectArray.length - 1;
        String string = tclObjectArray[n2].toString();
        File file = FileUtil.getNewFileObj(interp, string);
        if (file.isDirectory()) {
            for (int i = n; i < n2; ++i) {
                String string2 = tclObjectArray[i].toString();
                if (string.length() == 0) {
                    FileCmd.copyRenameOneFile(interp, string2, string, bl, bl2);
                    continue;
                }
                String string3 = FileCmd.getTail(interp, string2);
                TclObject[] tclObjectArray2 = new TclObject[]{TclString.newInstance(string), TclString.newInstance(string3)};
                String string4 = FileUtil.joinPath(interp, tclObjectArray2, 0, 2);
                FileCmd.copyRenameOneFile(interp, string2, string4, bl, bl2);
            }
        } else {
            if (n + 1 != n2) {
                String string5 = bl ? "copying" : "renaming";
                throw new TclPosixException(interp, 20, "error " + string5 + ": target \"" + tclObjectArray[n2].toString() + "\" is not a directory");
            }
            String string6 = tclObjectArray[n].toString();
            FileCmd.copyRenameOneFile(interp, string6, string, bl, bl2);
        }
    }

    private static void copyRenameOneFile(Interp interp, String string, String string2, boolean bl, boolean bl2) throws TclException {
        if (bl2 && string.equals(string2)) {
            return;
        }
        String string3 = bl ? "copying" : "renaming";
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists() || string.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\"");
        }
        if (string2.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        File file2 = FileUtil.getNewFileObj(interp, string2);
        if (file2.exists() && !bl2) {
            throw new TclPosixException(interp, 17, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        if (file.isDirectory() && !file2.isDirectory() && file2.exists()) {
            throw new TclPosixException(interp, 21, "can't overwrite file \"" + string2 + "\" with directory \"" + string + "\"");
        }
        if (file2.isDirectory() && !file.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite directory \"" + string2 + "\" with file \"" + string + "\"");
        }
        if (file2.getParent() != null && !file2.getParentFile().exists()) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        if (!bl) {
            if (!file.renameTo(file2)) {
                if (file2.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "error renaming \"" + string + "\" to \"" + string2 + "\"");
                }
                throw new TclPosixException(interp, 13, true, "error renaming \"" + string + "\" to \"" + string2 + "\":  best guess at reason");
            }
        } else if (file.isDirectory()) {
            if (!file2.mkdir()) {
                throw new TclPosixException(interp, 13, true, "error copying \"" + string + "\" to \"" + string2 + "\":  best guess at reason");
            }
            for (File file3 : file.listFiles()) {
                FileCmd.copyRenameOneFile(interp, file3.getPath(), new File(file2, file3.getName()).getPath(), true, bl2);
            }
        } else {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                int n = bufferedInputStream.read(byArray, 0, 1024);
                while (n != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                    n = bufferedInputStream.read(byArray, 0, 1024);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                throw new TclException(interp, "error copying: " + iOException.getMessage());
            }
        }
    }
}

