/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEventScript;

public class FileeventCmd
implements Command {
    String[] eventType = new String[]{"readable", "writable"};
    static final int READABLE_TYPE = 0;
    static final int WRITABLE_TYPE = 1;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId event ?script?");
        }
        int n = TclIndex.get(interp, tclObjectArray[2], this.eventType, "event name", 0);
        n = n == 0 ? 0 : 1;
        Channel channel = TclIO.getChannel(interp, tclObjectArray[1].toString());
        if (channel == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1] + "\"");
        }
        if (tclObjectArray.length == 3) {
            FileEventScript fileEventScript = FileEventScript.find(interp, channel, n);
            if (fileEventScript == null) {
                interp.setResult("");
            } else {
                interp.setResult(fileEventScript.getScript());
            }
        } else {
            if (tclObjectArray[3].toString().length() == 0) {
                FileEventScript.dispose(interp, channel, n);
            } else {
                FileEventScript.register(interp, channel, n, tclObjectArray[3]);
            }
            interp.setResult("");
        }
    }
}

