/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class FormatCmd
implements Command {
    private static final int LEFT_JUSTIFY = 1;
    private static final int SHOW_SIGN = 2;
    private static final int SPACE_OR_SIGN = 4;
    private static final int PAD_W_ZERO = 8;
    private static final int ALT_OUTPUT = 16;
    private static final int SIGNED_VALUE = 32;
    private static final int RADIX = 1;
    private static final int FLOAT = 2;
    private static final int EXP = 3;
    private static final int GENERIC = 4;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "formatString ?arg arg ...?");
        }
        int n = 2;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = tclObjectArray[1].toString().toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < cArray.length) {
            int n3;
            StrtoulResult strtoulResult;
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            int n8 = -1;
            if (cArray[n2] != '%') {
                for (n4 = n2; n4 < cArray.length; ++n4) {
                    if (cArray[n4] != '%') continue;
                    bl3 = false;
                    break;
                }
                stringBuffer.append(new String(cArray, n2, n4 - n2));
                n2 = n4;
                if (bl3) break;
            }
            if (n2 + 1 >= cArray.length) {
                FormatCmd.errorEndMiddle(interp);
            }
            FormatCmd.checkOverFlow(interp, cArray, n2 + 1);
            if (cArray[n2 + 1] == '%') {
                stringBuffer.append("%");
                n2 += 2;
                continue;
            }
            FormatCmd.checkOverFlow(interp, cArray, ++n2);
            if (Character.isDigit(cArray[n2])) {
                strtoulResult = FormatCmd.strtoul(interp, cArray, n2);
                n3 = (int)strtoulResult.value;
                int n9 = strtoulResult.index;
                strtoulResult = null;
                if (cArray[n9] == '$') {
                    if (n3 == 0) {
                        FormatCmd.errorBadIndex(interp, true);
                    }
                    if (bl) {
                        FormatCmd.errorMixedXPG(interp);
                    }
                    bl2 = true;
                    bl6 = true;
                    n6 = 2;
                    n2 = n9 + 1;
                    n = n3 + 1;
                    if (n < 2 || n >= tclObjectArray.length) {
                        FormatCmd.errorBadIndex(interp, bl2);
                    }
                } else {
                    if (bl2) {
                        FormatCmd.errorMixedXPG(interp);
                    }
                    bl = true;
                    if (cArray[n2] != '0') {
                        n2 = n9;
                        n5 = n3;
                        n6 = 4;
                    }
                }
            } else {
                if (bl2) {
                    FormatCmd.errorMixedXPG(interp);
                }
                bl = true;
            }
            if (n6 < 3) {
                FormatCmd.checkOverFlow(interp, cArray, n2);
                n4 = cArray[n2];
                boolean bl8 = true;
                while (bl8) {
                    switch (n4) {
                        case 45: {
                            n7 |= 1;
                            break;
                        }
                        case 35: {
                            n7 |= 0x10;
                            break;
                        }
                        case 48: {
                            n7 |= 8;
                            break;
                        }
                        case 32: {
                            n7 |= 4;
                            break;
                        }
                        case 43: {
                            n7 |= 2;
                            break;
                        }
                        default: {
                            bl8 = false;
                        }
                    }
                    if (!bl8) continue;
                    FormatCmd.checkOverFlow(interp, cArray, ++n2);
                    n4 = cArray[n2];
                }
                n6 = 3;
            }
            FormatCmd.checkOverFlow(interp, cArray, n2);
            if (Character.isDigit(cArray[n2])) {
                strtoulResult = FormatCmd.strtoul(interp, cArray, n2);
                n5 = (int)strtoulResult.value;
                n2 = strtoulResult.index;
                strtoulResult = null;
            } else if (cArray[n2] == '*' && tclObjectArray.length > n) {
                n5 = TclInteger.getInt(interp, tclObjectArray[n]);
                if (n5 < 0) {
                    n5 = -n5;
                    n7 |= 1;
                }
                ++n;
                ++n2;
            }
            FormatCmd.checkOverFlow(interp, cArray, n2);
            if (cArray[n2] == '.') {
                FormatCmd.checkOverFlow(interp, cArray, ++n2);
                if (Character.isDigit(cArray[n2])) {
                    bl5 = true;
                    strtoulResult = FormatCmd.strtoul(interp, cArray, n2);
                    n8 = (int)strtoulResult.value;
                    n2 = strtoulResult.index;
                    strtoulResult = null;
                } else if (cArray[n2] == '*') {
                    if (tclObjectArray.length > n) {
                        bl5 = true;
                        n8 = TclInteger.getInt(interp, tclObjectArray[n]);
                        ++n;
                        FormatCmd.checkOverFlow(interp, cArray, ++n2);
                    }
                } else {
                    n8 = 0;
                }
            }
            if (cArray[n2] == 'h') {
                FormatCmd.checkOverFlow(interp, cArray, ++n2);
                bl4 = true;
            } else if (cArray[n2] == 'l') {
                FormatCmd.checkOverFlow(interp, cArray, ++n2);
                bl7 = true;
            }
            if (n < 2 || n >= tclObjectArray.length) {
                FormatCmd.errorBadIndex(interp, bl2);
            }
            String string = "";
            char c = cArray[n2];
            switch (c) {
                case 'X': 
                case 'd': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'x': {
                    long l = TclInteger.getLong(interp, tclObjectArray[n]);
                    if (c != 'u') {
                        n7 |= 0x20;
                    }
                    if (bl4) {
                        l &= 0xFFFFL;
                    }
                    if (c == 'o') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 8, "01234567".toCharArray(), "0"));
                        break;
                    }
                    if (c == 'x') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 16, "0123456789abcdef".toCharArray(), "0x"));
                        break;
                    }
                    if (c == 'X') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 16, "0123456789ABCDEF".toCharArray(), "0X"));
                        break;
                    }
                    stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 10, "0123456789".toCharArray(), ""));
                    break;
                }
                case 'c': {
                    n3 = 0;
                    char[] cArray2 = new char[]{(char)TclInteger.getInt(interp, tclObjectArray[n])};
                    string = new String(cArray2);
                    stringBuffer.append(FormatCmd.cvtStrToStr(string, n5, n8, n7));
                    break;
                }
                case 's': {
                    string = tclObjectArray[n].toString();
                    stringBuffer.append(FormatCmd.cvtStrToStr(string, n5, n8, n7));
                    break;
                }
                case 'f': {
                    double d = TclDouble.get(interp, tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "0123456789".toCharArray(), "", 2));
                    break;
                }
                case 'e': {
                    double d = TclDouble.get(interp, tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "e".toCharArray(), "", 3));
                    break;
                }
                case 'E': {
                    double d = TclDouble.get(interp, tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "E".toCharArray(), "", 3));
                    break;
                }
                case 'g': {
                    double d = TclDouble.get(interp, tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "e".toCharArray(), "", 4));
                    break;
                }
                case 'G': {
                    double d = TclDouble.get(interp, tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "E".toCharArray(), "", 4));
                    break;
                }
                default: {
                    FormatCmd.errorBadField(interp, cArray[n2]);
                }
            }
            ++n2;
            ++n;
        }
        interp.setResult(stringBuffer.toString());
    }

    private String cvtLngToStr(long l, int n, int n2, int n3, int n4, char[] cArray, String string) {
        int n5;
        int n6;
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        int n7 = 0;
        char c = '\u0000';
        if (l == 0L) {
            n3 |= 0x10;
        }
        if ((n3 & 0x20) != 0) {
            if (l < 0L) {
                if (n4 != 8 && n4 != 16) {
                    l = -l;
                    c = '-';
                    n7 = 1;
                }
            } else if ((n3 & 2) != 0) {
                c = '+';
                n7 = 1;
            } else if ((n3 & 4) != 0) {
                c = ' ';
                n7 = 1;
            }
        }
        if ((8 & n3) != 0 && n2 < n - n7) {
            n2 = n - n7;
        }
        do {
            int n8;
            switch (n4) {
                case 8: {
                    n8 = (int)(l & 7L);
                    break;
                }
                case 16: {
                    n8 = (int)(l & 0xFL);
                    break;
                }
                default: {
                    n8 = (int)(l % (long)n4);
                }
            }
            stringBuffer.insert(0, cArray[n8]);
            switch (n4) {
                case 8: {
                    l >>>= 3;
                    break;
                }
                case 16: {
                    l >>>= 4;
                    break;
                }
                default: {
                    l /= (long)n4;
                }
            }
        } while (l != 0L);
        int n9 = stringBuffer.length();
        for (n6 = n2 - n9; n6 > 0; --n6) {
            stringBuffer.insert(0, '0');
        }
        if (c != '\u0000') {
            stringBuffer.insert(0, c);
        }
        if ((n3 & 0x10) != 0 && string.length() > 0 && stringBuffer.charAt(0) != string.charAt(0)) {
            stringBuffer.insert(0, string);
        }
        if ((n5 = n - stringBuffer.length()) > 0) {
            stringBuffer2.ensureCapacity(n5);
            for (n6 = 0; n6 < n5; ++n6) {
                stringBuffer2.append(' ');
            }
        }
        if ((1 & n3) != 0) {
            stringBuffer.append(stringBuffer2);
            return stringBuffer.toString();
        }
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }

    public static String toString(double d, int n, int n2) {
        return FormatCmd.cvtDblToStr(d, 0, n, 0, n2, "e".toCharArray(), null, 4);
    }

    private static String cvtDblToStr(double d, int n, int n2, int n3, int n4, char[] cArray, String string, int n5) {
        int n6;
        int n7;
        int n8;
        StringBuffer stringBuffer = new StringBuffer(100);
        int n9 = 0;
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (n2 < 0) {
            n2 = 6;
        }
        if (d < 0.0) {
            d = -d;
            c = '-';
            n9 = 1;
        } else if (d == 0.0 && new Double(d).equals(new Double(-0.0))) {
            d = -d;
            c = '-';
            n9 = 1;
        } else if ((n3 & 2) != 0) {
            c = '+';
            n9 = 1;
        } else if ((n3 & 4) != 0) {
            c = ' ';
            n9 = 1;
        }
        if (n5 == 4 && n2 > 0) {
            --n2;
        }
        int n10 = n2;
        double d2 = 0.4999;
        while (n10 > 0) {
            --n10;
            d2 *= 0.1;
        }
        if (n5 == 2) {
            d += d2;
        }
        int n11 = 0;
        if (d > 0.0) {
            n8 = 0;
            while (d >= 1.0E8 && n8++ < 100) {
                d *= 1.0E-8;
                n11 += 8;
            }
            while (d >= 10.0 && n8++ < 100) {
                d *= 0.1;
                ++n11;
            }
            while (d < 1.0E-8 && n8++ < 100) {
                d *= 1.0E8;
                n11 -= 8;
            }
            while (d < 1.0 && n8++ < 100) {
                d *= 10.0;
                --n11;
            }
            if (n8 >= 100) {
                return "NaN";
            }
        }
        boolean bl4 = bl = n5 == 3;
        if (n5 != 2 && (d += d2) >= 10.0) {
            d *= 0.1;
            ++n11;
        }
        if (n5 == 4) {
            boolean bl5 = bl2 = (n3 & 0x10) == 0;
            if (n11 < -4 || n11 > n2) {
                n5 = 3;
            } else {
                n2 -= n11;
                n5 = 2;
            }
        } else {
            bl2 = false;
        }
        int n12 = 0;
        if (n5 == 2) {
            boolean bl6 = bl3 = n2 > 0 || (n3 & 0x10) != 0;
            if (n9 > 0) {
                stringBuffer.append(c);
            }
            if (n11 < 0) {
                stringBuffer.append('0');
            }
            while (n11 >= 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                } else {
                    n7 = (int)d;
                    d = (d - (double)n7) * 10.0;
                    stringBuffer.append(n7);
                }
                --n11;
            }
            if (bl3) {
                stringBuffer.append('.');
            }
            ++n11;
            while (n11 < 0 && n2 > 0) {
                stringBuffer.append('0');
                --n2;
                ++n11;
            }
            while (n2-- > 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                    continue;
                }
                n7 = (int)d;
                d = (d - (double)n7) * 10.0;
                stringBuffer.append(n7);
            }
            if (bl2 && bl3) {
                int n13 = 0;
                n8 = stringBuffer.length() - 1;
                while (n8 >= 0 && stringBuffer.charAt(n8) == '0') {
                    --n8;
                    ++n13;
                }
                if (n8 >= 0 && stringBuffer.charAt(n8) == '.') {
                    ++n13;
                }
                if (n13 > 0) {
                    stringBuffer.setLength(stringBuffer.length() - n13);
                }
            }
        } else {
            boolean bl7 = bl3 = n2 > 0 || (n3 & 0x10) != 0;
            if (n9 > 0) {
                stringBuffer.append(c);
            }
            n7 = (int)d;
            d = (d - (double)n7) * 10.0;
            stringBuffer.append(n7);
            if (bl3) {
                stringBuffer.append('.');
            }
            while (n2-- > 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                    continue;
                }
                n7 = (int)d;
                d = (d - (double)n7) * 10.0;
                stringBuffer.append(n7);
            }
            if (bl2 && bl3) {
                n10 = 0;
                n6 = stringBuffer.length() - 1;
                while (n6 >= 0 && stringBuffer.charAt(n6) == '0') {
                    --n6;
                    ++n10;
                }
                if (n6 >= 0 && stringBuffer.charAt(n6) == '.') {
                    ++n10;
                }
                if (n10 > 0) {
                    stringBuffer.setLength(stringBuffer.length() - n10);
                }
            }
            if (n11 != 0 || bl) {
                stringBuffer.append(cArray[0]);
                if (n11 < 0) {
                    stringBuffer.append('-');
                    n11 = -n11;
                } else {
                    stringBuffer.append('+');
                }
                if (n11 >= 100) {
                    stringBuffer.append(n11 / 100);
                    n11 %= 100;
                } else {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n11 / 10);
                stringBuffer.append(n11 % 10);
            }
        }
        n6 = stringBuffer.length();
        if ((8 & n3) != 0 && (1 & n3) == 0) {
            n8 = n - n6;
            n10 = n9;
            while (n8-- > 0) {
                stringBuffer.insert(n9, '0');
            }
            n6 = n;
        }
        n8 = n - n6;
        StringBuffer stringBuffer2 = new StringBuffer(100 + n8);
        if (n8 > 0) {
            for (n10 = 0; n10 < n8; ++n10) {
                stringBuffer2.append(' ');
            }
        }
        if ((1 & n3) != 0) {
            stringBuffer.append(stringBuffer2);
            return stringBuffer.toString();
        }
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }

    private static String cvtStrToStr(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer(100);
        if (n2 >= 0 && n2 < string.length()) {
            string = string.substring(0, n2);
        }
        if (n > string.length()) {
            stringBuffer.setLength(0);
            int n4 = n - string.length();
            for (int i = 0; i < n4; ++i) {
                if ((n3 & 8) != 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(' ');
            }
            if ((1 & n3) != 0) {
                string3 = stringBuffer.toString();
            } else {
                string2 = stringBuffer.toString();
            }
        }
        stringBuffer.setLength(0);
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private static StrtoulResult strtoul(Interp interp, char[] cArray, int n) {
        StrtoulResult strtoulResult = interp.strtoulResult;
        int n2 = n;
        while (n < cArray.length && Character.isDigit(cArray[n])) {
            ++n;
        }
        long l = Long.parseLong(new String(cArray, n2, n - n2));
        strtoulResult.update(l, n, 0);
        return strtoulResult;
    }

    private static void checkOverFlow(Interp interp, char[] cArray, int n) throws TclException {
        if (n >= cArray.length || n < 0) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
    }

    private static void errorMixedXPG(Interp interp) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
    }

    private static void errorBadIndex(Interp interp, boolean bl) throws TclException {
        if (bl) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
        throw new TclException(interp, "not enough arguments for all format specifiers");
    }

    private static void errorBadField(Interp interp, char c) throws TclException {
        throw new TclException(interp, "bad field specifier \"" + c + "\"");
    }

    private static void errorEndMiddle(Interp interp) throws TclException {
        throw new TclException(interp, "format string ended in middle of field specifier");
    }
}

