/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

public class GlobCmd
implements Command {
    private static final int TYPE_BLOCKSPECIAL = 1;
    private static final int TYPE_CHARSPECIAL = 2;
    private static final int TYPE_DIRECTORY = 4;
    private static final int TYPE_REGULARFILE = 8;
    private static final int TYPE_LINK = 16;
    private static final int TYPE_PIPE = 32;
    private static final int TYPE_SOCKET = 64;
    private static final int TYPE_PERM_R = 128;
    private static final int TYPE_PERM_W = 256;
    private static final int TYPE_PERM_X = 512;
    private static final int TYPE_READONLY = 1024;
    private static final int TYPE_HIDDEN = 2048;
    private static final int TYPE_MACINTOSH = 4096;
    private static final String[] validOptions = new String[]{"-directory", "-join", "-nocomplain", "-path", "-tails", "-types", "--"};
    private static final int OPT_DIRECTORY = 0;
    private static final int OPT_JOIN = 1;
    private static final int OPT_NOCOMPLAIN = 2;
    private static final int OPT_PATH = 3;
    private static final int OPT_TAILS = 4;
    private static final int OPT_TYPES = 5;
    private static final int OPT_LAST = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Object object;
        Object object2;
        TclObject[] tclObjectArray2;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        File file = null;
        String string = "";
        String string2 = "";
        if (tclObjectArray.length == 1) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? name ?name ...?");
        }
        boolean bl6 = false;
        block26: for (n = 1; n < tclObjectArray.length && !bl6 && tclObjectArray[n].toString().startsWith("-"); ++n) {
            int n3 = TclIndex.get(interp, tclObjectArray[n], validOptions, "option", 0);
            switch (n3) {
                case 2: {
                    bl = true;
                    continue block26;
                }
                case 0: {
                    if (tclObjectArray.length < 3) {
                        throw new TclException(interp, "missing argument to \"-directory\"");
                    }
                    if (bl4) {
                        throw new TclException(interp, "\"-directory\" cannot be used with \"-path\"");
                    }
                    bl3 = true;
                    file = new File(FileUtil.translateFileName(interp, tclObjectArray[++n].toString()));
                    continue block26;
                }
                case 1: {
                    bl2 = true;
                    continue block26;
                }
                case 3: {
                    if (n == tclObjectArray.length - 1) {
                        throw new TclException(interp, "missing argument to \"-path\"");
                    }
                    if (bl3) {
                        throw new TclException(interp, "\"-path\" cannot be used with \"-directory\"");
                    }
                    bl4 = true;
                    File file2 = new File(FileUtil.translateFileName(interp, tclObjectArray[++n].toString()));
                    file = file2.getParentFile();
                    string = file2.getName();
                    continue block26;
                }
                case 4: {
                    bl5 = true;
                    continue block26;
                }
                case 5: {
                    if (n == tclObjectArray.length - 1) {
                        throw new TclException(interp, "missing argument to \"-types\"");
                    }
                    TclObject[] tclObjectArray3 = tclObjectArray2 = TclList.getElements(interp, tclObjectArray[++n]);
                    int n4 = tclObjectArray3.length;
                    block27: for (int i = 0; i < n4; ++i) {
                        TclObject tclObject = tclObjectArray3[i];
                        String string3 = tclObject.toString();
                        if (string3.length() == 1) {
                            switch (string3.charAt(0)) {
                                case 'd': {
                                    n2 |= 4;
                                    continue block27;
                                }
                                case 'b': {
                                    n2 |= 1;
                                    continue block27;
                                }
                                case 'c': {
                                    n2 |= 2;
                                    continue block27;
                                }
                                case 'f': {
                                    n2 |= 8;
                                    continue block27;
                                }
                                case 'l': {
                                    n2 |= 0x10;
                                    continue block27;
                                }
                                case 'p': {
                                    n2 |= 0x20;
                                    continue block27;
                                }
                                case 's': {
                                    n2 |= 0x40;
                                    continue block27;
                                }
                                case 'r': {
                                    n2 |= 0x80;
                                    continue block27;
                                }
                                case 'w': {
                                    n2 |= 0x100;
                                    continue block27;
                                }
                                case 'x': {
                                    n2 |= 0x200;
                                    continue block27;
                                }
                                default: {
                                    throw new TclException(interp, "bad argument to \"-types\": " + string3);
                                }
                            }
                        }
                        if ("hidden".equals(string3)) {
                            n2 |= 0x800;
                            continue;
                        }
                        if ("readonly".equals(string3)) {
                            n2 |= 0x400;
                            continue;
                        }
                        if (string3.contains("macintosh")) {
                            if ((n2 & 0x1000) != 0) {
                                throw new TclException(interp, "only one MacOS type or creator argument to \"-types\" allowed");
                            }
                            n2 |= 0x1000;
                            continue;
                        }
                        if (tclObjectArray2.length > 1) {
                            throw new TclException(interp, "only one MacOS type or creator argument to \"-types\" allowed");
                        }
                        throw new TclException(interp, "bad argument to \"-types\": " + string3);
                    }
                    continue block26;
                }
                case 6: {
                    bl6 = true;
                    continue block26;
                }
                default: {
                    throw new TclException(interp, "GlobCmd.cmdProc: bad option " + n3 + " index to validOptions");
                }
            }
        }
        if (n >= tclObjectArray.length) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? name ?name ...?");
        }
        if (bl5 && !bl3 && !bl4) {
            throw new TclException(interp, "\"-tails\" must be used with either \"-directory\" or \"-path\"");
        }
        TclObject tclObject = TclList.newInstance();
        tclObject.preserve();
        try {
            object2 = new ArrayList<StringBuffer>();
            if (bl2) {
                string2 = FileUtil.joinPath(interp, tclObjectArray, n, tclObjectArray.length);
                if (tclObjectArray[n].toString().length() == 0) {
                    string2 = "/" + string2;
                }
                ((ArrayList)object2).add(new StringBuffer());
                this.expandBraceExpressions(interp, string2, 0, (ArrayList<StringBuffer>)object2, false);
            } else {
                for (int i = n; i < tclObjectArray.length; ++i) {
                    tclObjectArray2 = new ArrayList();
                    tclObjectArray2.add(new StringBuffer());
                    this.expandBraceExpressions(interp, tclObjectArray[i].toString(), 0, (ArrayList<StringBuffer>)tclObjectArray2, false);
                    ((ArrayList)object2).addAll((Collection<StringBuffer>)tclObjectArray2);
                }
            }
            object = new String[((ArrayList)object2).size()];
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                object[i] = ((StringBuffer)((ArrayList)object2).get(i)).toString();
                if (object[i].length() == 0) {
                    object[i] = ".";
                }
                if (file != null) continue;
                boolean bl7 = object[i].endsWith(File.separator);
                object[i] = FileUtil.translateFileName(interp, (String)object[i]) + (bl7 ? File.separator : "");
            }
            for (String string4 : object) {
                this.getResultsForOnePattern(interp, string4, n2, file, string, bl5, tclObject);
            }
        }
        catch (TclException tclException) {
            tclObject.release();
            if (bl) {
                interp.setResult("");
                return;
            }
            throw tclException;
        }
        try {
            if (TclList.getLength(interp, tclObject) == 0 && !bl) {
                object2 = "";
                object = new StringBuffer();
                ((StringBuffer)object).append("no files matched glob pattern");
                ((StringBuffer)object).append(bl2 || tclObjectArray.length - n == 1 ? " \"" : "s \"");
                if (bl2) {
                    ((StringBuffer)object).append(string2);
                } else {
                    for (int i = n; i < tclObjectArray.length; ++i) {
                        ((StringBuffer)object).append((String)object2 + tclObjectArray[i].toString());
                        if (i != n) continue;
                        object2 = " ";
                    }
                }
                ((StringBuffer)object).append("\"");
                throw new TclException(interp, ((StringBuffer)object).toString());
            }
            if (TclList.getLength(interp, tclObject) > 0) {
                interp.setResult(tclObject);
            }
        }
        finally {
            tclObject.release();
        }
    }

    private static void stringBufferListAppend(ArrayList<StringBuffer> arrayList, char c) {
        for (StringBuffer stringBuffer : arrayList) {
            stringBuffer.append(c);
        }
    }

    private int expandBraceExpressions(Interp interp, String string, int n, ArrayList<StringBuffer> arrayList, boolean bl) throws TclException {
        boolean bl2 = false;
        block5: while (n < string.length()) {
            char c = string.charAt(n++);
            if (bl2) {
                bl2 = false;
                GlobCmd.stringBufferListAppend(arrayList, c);
                continue;
            }
            switch (c) {
                case '{': {
                    ArrayList<StringBuffer> arrayList2;
                    ArrayList<StringBuffer> arrayList3 = new ArrayList<StringBuffer>();
                    --n;
                    while (n < string.length() && string.charAt(n) != '}') {
                        arrayList2 = new ArrayList<StringBuffer>();
                        arrayList2.add(new StringBuffer());
                        n = this.expandBraceExpressions(interp, string, n + 1, arrayList2, true);
                        arrayList3.addAll(arrayList2);
                    }
                    ++n;
                    arrayList2 = new ArrayList(arrayList.size() * arrayList3.size());
                    for (StringBuffer stringBuffer : arrayList3) {
                        for (StringBuffer stringBuffer2 : arrayList) {
                            arrayList2.add(new StringBuffer(stringBuffer2.toString() + stringBuffer.toString()));
                        }
                    }
                    arrayList.clear();
                    arrayList.addAll(arrayList2);
                    break;
                }
                case ',': 
                case '}': {
                    if (bl) {
                        return n - 1;
                    }
                    if (c != '}') continue block5;
                    throw new TclException(interp, "unmatched close-brace in file name");
                }
                case '\\': {
                    if (n < string.length() && string.charAt(n) == File.separatorChar) break;
                    bl2 = true;
                    GlobCmd.stringBufferListAppend(arrayList, c);
                    break;
                }
                default: {
                    GlobCmd.stringBufferListAppend(arrayList, c);
                }
            }
        }
        if (n >= string.length() && bl) {
            throw new TclException(interp, "unmatched open-brace in file name");
        }
        return n;
    }

    private void getResultsForOnePattern(Interp interp, String string, int n, File file, String string2, boolean bl, TclObject tclObject) throws TclException {
        Stack<GlobPair> stack = new Stack<GlobPair>();
        boolean bl2 = string.endsWith(File.separator);
        if (file == null) {
            string = FileUtil.translateFileName(interp, string);
        }
        TclObject tclObject2 = FileUtil.splitPath(interp, string);
        boolean bl3 = false;
        boolean bl4 = false;
        if (FileUtil.getPathType(string) == 2) {
            if (file == null) {
                bl3 = true;
                if (TclList.getLength(interp, tclObject2) == 1) {
                    TclList.append(interp, tclObject, TclString.newInstance(string));
                    return;
                }
            } else {
                bl3 = false;
                bl4 = true;
            }
        }
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject2);
        GlobFilter[] globFilterArray = new GlobFilter[tclObjectArray.length];
        for (int i = 0; i < globFilterArray.length; ++i) {
            globFilterArray[i] = new GlobFilter(string2, tclObjectArray[i].toString(), n, bl2 || i != globFilterArray.length - 1);
        }
        if (bl3) {
            stack.push(new GlobPair(new File(tclObjectArray[0].toString()), 1));
        } else {
            stack.push(new GlobPair(file, bl4 ? 1 : 0));
        }
        while (!stack.empty()) {
            String[] stringArray;
            GlobPair globPair = (GlobPair)stack.pop();
            if (globPair.dir == null) {
                stringArray = globFilterArray[globPair.componentIndex].list(interp.getWorkingDir());
            } else {
                File file2;
                if (globPair.dir.isAbsolute()) {
                    file2 = globPair.dir;
                } else {
                    Object[] objectArray = new TclObject[]{TclString.newInstance(interp.getWorkingDir().getAbsolutePath()), TclString.newInstance(globPair.dir.getPath())};
                    file2 = new File(FileUtil.joinPath(interp, (TclObject[])objectArray, 0, 2));
                }
                stringArray = globFilterArray[globPair.componentIndex].list(file2);
            }
            if (stringArray == null) {
                return;
            }
            boolean bl5 = globPair.componentIndex == globFilterArray.length - 1;
            for (String string3 : stringArray) {
                File file3 = new File(globPair.dir, string3);
                if (bl5) {
                    String string4;
                    String string5 = string4 = bl ? file3.getName() : file3.getPath();
                    if (bl2) {
                        string4 = string4 + File.separator;
                    }
                    TclList.append(interp, tclObject, TclString.newInstance(string4));
                    continue;
                }
                stack.push(new GlobPair(file3, globPair.componentIndex + 1));
            }
        }
    }

    final class GlobFilter
    implements FilenameFilter {
        private String prefix;
        private String pattern;
        private boolean caseSensitive = true;
        private int types = 0;

        GlobFilter(String string, String string2, int n, boolean bl) {
            this.prefix = string;
            this.caseSensitive = JACL.PLATFORM != 1;
            this.pattern = this.caseSensitive ? string2 : string2.toUpperCase();
            this.types = n;
            if (bl) {
                this.types = 4;
            }
        }

        public String[] list(File file) {
            String[] stringArray = file.list(this);
            boolean bl = this.accept(file, ".");
            boolean bl2 = this.accept(file, "..");
            int n = 0;
            if (bl) {
                ++n;
            }
            if (bl2) {
                ++n;
            }
            if (n == 0) {
                return stringArray;
            }
            String[] stringArray2 = new String[stringArray.length + n];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            n = stringArray.length;
            if (bl) {
                stringArray2[n++] = ".";
            }
            if (bl2) {
                stringArray2[n++] = "..";
            }
            return stringArray2;
        }

        @Override
        public boolean accept(File file, String string) {
            boolean bl;
            if (!this.caseSensitive) {
                string = string.toUpperCase();
            }
            if (this.prefix.length() > 0 && !string.startsWith(this.prefix)) {
                return false;
            }
            if (string.startsWith(".")) {
                if (JACL.PLATFORM == 0) {
                    if ((this.types & 0x800) == 0 && !this.pattern.startsWith(".")) {
                        return false;
                    }
                } else {
                    if (string.equals(".") && !this.pattern.startsWith(".")) {
                        return false;
                    }
                    if (string.equals("..") && !this.pattern.startsWith("..")) {
                        return false;
                    }
                }
            }
            if (!Util.stringMatch(string.substring(this.prefix.length()), this.pattern)) {
                return false;
            }
            if (this.types == 0) {
                return true;
            }
            File file2 = string.equals(".") ? file.getAbsoluteFile() : (string.equals("..") ? file.getAbsoluteFile().getParentFile() : new File(file, string));
            if ((this.types & 0x7F) != 0) {
                bl = false;
                if ((this.types & 0x63) != 0) {
                    boolean bl2 = bl = bl || !file2.isFile() && !file2.isDirectory();
                }
                if ((this.types & 4) != 0) {
                    boolean bl3 = bl = bl || file2.isDirectory();
                }
                if ((this.types & 8) != 0) {
                    boolean bl4 = bl = bl || file2.isFile();
                }
                if ((this.types & 0x10) != 0) {
                    bl = bl || FileUtil.getLinkTarget(file2) != null;
                }
            } else {
                bl = true;
            }
            if ((this.types & 0x80) != 0) {
                boolean bl5 = bl = bl && file2.canRead();
            }
            if ((this.types & 0x100) != 0) {
                boolean bl6 = bl = bl && file2.canWrite();
            }
            if ((this.types & 0x200) != 0) {
                boolean bl7 = bl = bl && FileUtil.isExecutable(file2);
            }
            if ((this.types & 0x400) != 0) {
                boolean bl8 = bl = bl && file2.canRead() && !file2.canWrite();
            }
            if ((this.types & 0x800) != 0) {
                bl = bl && file2.isHidden();
            }
            return bl;
        }
    }

    private final class GlobPair {
        File dir;
        int componentIndex;

        GlobPair(File file, int n) {
            this.dir = file;
            this.componentIndex = n;
        }
    }
}

