/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.cmd.InterpAliasCmd;
import tcl.lang.cmd.InterpSlaveCmd;

public class InterpCmd
implements Command {
    private static final String[] options = new String[]{"alias", "aliases", "create", "delete", "eval", "exists", "expose", "hide", "hidden", "issafe", "invokehidden", "marktrusted", "recursionlimit", "slaves", "share", "target", "transfer"};
    private static final int OPT_ALIAS = 0;
    private static final int OPT_ALIASES = 1;
    private static final int OPT_CREATE = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXISTS = 5;
    private static final int OPT_EXPOSE = 6;
    private static final int OPT_HIDE = 7;
    private static final int OPT_HIDDEN = 8;
    private static final int OPT_ISSAFE = 9;
    private static final int OPT_INVOKEHIDDEN = 10;
    private static final int OPT_MARKTRUSTED = 11;
    private static final int OPT_RECURSIONLMT = 12;
    private static final int OPT_SLAVES = 13;
    private static final int OPT_SHARE = 14;
    private static final int OPT_TARGET = 15;
    private static final int OPT_TRANSFER = 16;
    private static final String[] createOptions = new String[]{"-safe", "--"};
    private static final int OPT_CREATE_SAFE = 0;
    private static final int OPT_CREATE_LAST = 1;
    private static final String[] hiddenOptions = new String[]{"-global", "--"};
    private static final int OPT_HIDDEN_GLOBAL = 0;
    private static final int OPT_HIDDEN_LAST = 1;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "cmd ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], options, "option", 0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length >= 4) {
                    Interp interp2 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                    if (tclObjectArray.length == 4) {
                        InterpAliasCmd.describe(interp, interp2, tclObjectArray[3]);
                        return;
                    }
                    if (tclObjectArray.length == 5 && "".equals(tclObjectArray[4].toString())) {
                        InterpAliasCmd.delete(interp, interp2, tclObjectArray[3]);
                        return;
                    }
                    if (tclObjectArray.length > 5) {
                        Interp interp3 = InterpCmd.getInterp(interp, tclObjectArray[4]);
                        if ("".equals(tclObjectArray[5].toString())) {
                            if (tclObjectArray.length == 6) {
                                InterpAliasCmd.delete(interp, interp2, tclObjectArray[3]);
                                return;
                            }
                        } else {
                            InterpAliasCmd.create(interp, interp2, interp3, tclObjectArray[3], tclObjectArray[5], 6, tclObjectArray);
                            return;
                        }
                    }
                }
                throw new TclNumArgsException(interp, 2, tclObjectArray, "slavePath slaveCmd ?masterPath masterCmd? ?args ..?");
            }
            case 1: {
                Interp interp4 = InterpCmd.getInterp(interp, tclObjectArray);
                InterpAliasCmd.list(interp, interp4);
                break;
            }
            case 2: {
                int n2;
                boolean bl = interp.isSafe;
                TclObject tclObject = null;
                boolean bl2 = false;
                for (n2 = 2; n2 < tclObjectArray.length; ++n2) {
                    if (!bl2 && tclObjectArray[n2].toString().charAt(0) == '-') {
                        int n3 = TclIndex.get(interp, tclObjectArray[n2], createOptions, "option", 0);
                        switch (n3) {
                            case 0: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                bl2 = true;
                            }
                        }
                        continue;
                    }
                    if (tclObject != null) {
                        throw new TclNumArgsException(interp, 2, tclObjectArray, "?-safe? ?--? ?path?");
                    }
                    tclObject = tclObjectArray[n2];
                }
                if (tclObject == null) {
                    n2 = 0;
                    while (interp.getCommand("interp" + n2) != null) {
                        ++n2;
                    }
                    tclObject = TclString.newInstance("interp" + n2);
                }
                InterpSlaveCmd.create(interp, tclObject, bl);
                interp.setResult(tclObject);
                break;
            }
            case 3: {
                for (int i = 2; i < tclObjectArray.length; ++i) {
                    Interp interp5 = InterpCmd.getInterp(interp, tclObjectArray[i]);
                    if (interp5 == interp) {
                        throw new TclException(interp, "cannot delete the current interpreter");
                    }
                    InterpSlaveCmd interpSlaveCmd = interp5.slave;
                    interpSlaveCmd.masterInterp.deleteCommandFromToken(interpSlaveCmd.interpCmd);
                }
                break;
            }
            case 4: {
                if (tclObjectArray.length < 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path arg ?arg ...?");
                }
                Interp interp6 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.eval(interp, interp6, 3, tclObjectArray);
                break;
            }
            case 5: {
                boolean bl = true;
                try {
                    InterpCmd.getInterp(interp, tclObjectArray);
                }
                catch (TclException tclException) {
                    if (tclObjectArray.length > 3) {
                        throw tclException;
                    }
                    bl = false;
                }
                interp.setResult(bl);
                break;
            }
            case 6: {
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path hiddenCmdName ?cmdName?");
                }
                Interp interp7 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.expose(interp, interp7, 3, tclObjectArray);
                break;
            }
            case 7: {
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path cmdName ?hiddenCmdName?");
                }
                Interp interp8 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.hide(interp, interp8, 3, tclObjectArray);
                break;
            }
            case 8: {
                Interp interp9 = InterpCmd.getInterp(interp, tclObjectArray);
                InterpSlaveCmd.hidden(interp, interp9);
                break;
            }
            case 9: {
                Interp interp10 = InterpCmd.getInterp(interp, tclObjectArray);
                interp.setResult(interp10.isSafe);
                break;
            }
            case 10: {
                int n4;
                boolean bl = false;
                for (n4 = 3; n4 < tclObjectArray.length && tclObjectArray[n4].toString().charAt(0) == '-'; ++n4) {
                    int n5 = TclIndex.get(interp, tclObjectArray[n4], hiddenOptions, "option", 0);
                    if (n5 != 0) {
                        ++n4;
                        break;
                    }
                    bl = true;
                }
                if (tclObjectArray.length - n4 < 1) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path ?-global? ?--? cmd ?arg ..?");
                }
                Interp interp11 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.invokeHidden(interp, interp11, bl, n4, tclObjectArray);
                break;
            }
            case 11: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path");
                }
                Interp interp12 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.markTrusted(interp, interp12);
                break;
            }
            case 12: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path ?newlimit?");
                }
                Interp interp13 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                InterpSlaveCmd.recursionLimit(interp, interp13, tclObjectArray.length - 3, tclObjectArray);
                break;
            }
            case 13: {
                Interp interp14 = InterpCmd.getInterp(interp, tclObjectArray);
                TclObject tclObject = TclList.newInstance();
                for (Map.Entry entry : interp14.slaveTable.entrySet()) {
                    String string = (String)entry.getKey();
                    TclList.append(interp, tclObject, TclString.newInstance(string));
                }
                interp.setResult(tclObject);
                break;
            }
            case 14: {
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "srcPath channelId destPath");
                }
                TclIO.giveChannel(InterpCmd.getInterp(interp, tclObjectArray[2]), InterpCmd.getInterp(interp, tclObjectArray[4]), tclObjectArray[3].toString(), false);
                break;
            }
            case 15: {
                String string;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "path alias");
                }
                Interp interp15 = InterpCmd.getInterp(interp, tclObjectArray[2]);
                Interp interp16 = InterpAliasCmd.getTargetInterp(interp15, string = tclObjectArray[3].toString());
                if (interp16 == null) {
                    throw new TclException(interp, "alias \"" + string + "\" in path \"" + tclObjectArray[2].toString() + "\" not found");
                }
                if (InterpCmd.getInterpPath(interp, interp16)) break;
                throw new TclException(interp, "target interpreter for alias \"" + string + "\" in path \"" + tclObjectArray[2].toString() + "\" is not my descendant");
            }
            case 16: {
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "srcPath channelId destPath");
                }
                TclIO.giveChannel(InterpCmd.getInterp(interp, tclObjectArray[2]), InterpCmd.getInterp(interp, tclObjectArray[4]), tclObjectArray[3].toString(), true);
            }
        }
    }

    private static Interp getInterp(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 2) {
            return interp;
        }
        if (tclObjectArray.length == 3) {
            return InterpCmd.getInterp(interp, tclObjectArray[2]);
        }
        throw new TclNumArgsException(interp, 2, tclObjectArray, "?path?");
    }

    private static boolean getInterpPath(Interp interp, Interp interp2) throws TclException {
        if (interp2 == interp) {
            return true;
        }
        if (interp2 == null || interp2.slave == null) {
            return false;
        }
        if (!InterpCmd.getInterpPath(interp, interp2.slave.masterInterp)) {
            return false;
        }
        interp.appendElement(interp2.slave.path);
        return true;
    }

    static Interp getInterp(Interp interp, TclObject tclObject) throws TclException {
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        Interp interp2 = interp;
        for (int i = 0; i < tclObjectArray.length; ++i) {
            String string = tclObjectArray[i].toString();
            if (!interp2.slaveTable.containsKey(string)) {
                interp2 = null;
                break;
            }
            InterpSlaveCmd interpSlaveCmd = (InterpSlaveCmd)interp2.slaveTable.get(string);
            interp2 = interpSlaveCmd.slaveInterp;
            if (interp2 == null) break;
        }
        if (interp2 == null) {
            throw new TclException(interp, "could not find interpreter \"" + tclObject.toString() + "\"");
        }
        return interp2;
    }
}

