/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class NamespaceCmd
implements InternalRep,
Command {
    Namespace.ResolvedNsName otherValue = null;
    private static final String[] validCmds = new String[]{"children", "code", "current", "delete", "eval", "exists", "export", "forget", "import", "inscope", "origin", "parent", "qualifiers", "tail", "which"};
    private static final int OPT_CHILDREN = 0;
    private static final int OPT_CODE = 1;
    private static final int OPT_CURRENT = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXISTS = 5;
    private static final int OPT_EXPORT = 6;
    private static final int OPT_FORGET = 7;
    private static final int OPT_IMPORT = 8;
    private static final int OPT_INSCOPE = 9;
    private static final int OPT_ORIGIN = 10;
    private static final int OPT_PARENT = 11;
    private static final int OPT_QUALIFIERS = 12;
    private static final int OPT_TAIL = 13;
    private static final int OPT_WHICH = 14;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "subcommand ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                NamespaceCmd.childrenCmd(interp, tclObjectArray);
                return;
            }
            case 1: {
                NamespaceCmd.codeCmd(interp, tclObjectArray);
                return;
            }
            case 2: {
                NamespaceCmd.currentCmd(interp, tclObjectArray);
                return;
            }
            case 3: {
                NamespaceCmd.deleteCmd(interp, tclObjectArray);
                return;
            }
            case 4: {
                NamespaceCmd.evalCmd(interp, tclObjectArray);
                return;
            }
            case 5: {
                NamespaceCmd.existsCmd(interp, tclObjectArray);
                return;
            }
            case 6: {
                NamespaceCmd.exportCmd(interp, tclObjectArray);
                return;
            }
            case 7: {
                NamespaceCmd.forgetCmd(interp, tclObjectArray);
                return;
            }
            case 8: {
                NamespaceCmd.importCmd(interp, tclObjectArray);
                return;
            }
            case 9: {
                NamespaceCmd.inscopeCmd(interp, tclObjectArray);
                return;
            }
            case 10: {
                NamespaceCmd.originCmd(interp, tclObjectArray);
                return;
            }
            case 11: {
                NamespaceCmd.parentCmd(interp, tclObjectArray);
                return;
            }
            case 12: {
                NamespaceCmd.qualifiersCmd(interp, tclObjectArray);
                return;
            }
            case 13: {
                NamespaceCmd.tailCmd(interp, tclObjectArray);
                return;
            }
            case 14: {
                NamespaceCmd.whichCmd(interp, tclObjectArray);
                return;
            }
        }
    }

    private static void childrenCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        Namespace namespace2 = Namespace.getGlobalNamespace(interp);
        String string = null;
        if (tclObjectArray.length == 2) {
            namespace = Namespace.getCurrentNamespace(interp);
        } else if (tclObjectArray.length == 3 || tclObjectArray.length == 4) {
            namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in namespace children command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name? ?pattern?");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (tclObjectArray.length == 4) {
            String string2 = tclObjectArray[3].toString();
            if (string2.startsWith("::")) {
                string = string2;
            } else {
                stringBuffer.append(namespace.fullName);
                if (namespace != namespace2) {
                    stringBuffer.append("::");
                }
                stringBuffer.append(string2);
                string = stringBuffer.toString();
            }
        }
        TclObject tclObject = TclList.newInstance();
        for (Map.Entry entry : namespace.childTable.entrySet()) {
            Namespace namespace3 = (Namespace)entry.getValue();
            if (string != null && !Util.stringMatch(namespace3.fullName, string)) continue;
            TclObject tclObject2 = TclString.newInstance(namespace3.fullName);
            TclList.append(interp, tclObject, tclObject2);
        }
        interp.setResult(tclObject);
    }

    private static void codeCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "arg");
        }
        String string = tclObjectArray[2].toString();
        int n = string.length();
        if (n > 17 && string.charAt(0) == 'n' && string.startsWith("namespace")) {
            int n2;
            for (n2 = 9; n2 < n && string.charAt(n2) == ' '; ++n2) {
            }
            if (n - n2 >= 7 && string.charAt(n2) == 'i' && string.startsWith("inscope", n2)) {
                interp.setResult(tclObjectArray[2]);
                return;
            }
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance("::namespace"));
        TclList.append(interp, tclObject, TclString.newInstance("inscope"));
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        TclObject tclObject2 = namespace == Namespace.getGlobalNamespace(interp) ? TclString.newInstance("::") : TclString.newInstance(namespace.fullName);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObjectArray[2]);
        interp.setResult(tclObject);
    }

    private static void currentCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        if (namespace == Namespace.getGlobalNamespace(interp)) {
            interp.setResult("::");
        } else {
            interp.setResult(namespace.fullName);
        }
    }

    private static void deleteCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        String string;
        int n;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name name...?");
        }
        for (n = 2; n < tclObjectArray.length; ++n) {
            string = tclObjectArray[n].toString();
            namespace = Namespace.findNamespace(interp, string, null, 0);
            if (namespace != null) continue;
            throw new TclException(interp, "unknown namespace \"" + tclObjectArray[n].toString() + "\" in namespace delete command");
        }
        for (n = 2; n < tclObjectArray.length; ++n) {
            string = tclObjectArray[n].toString();
            namespace = Namespace.findNamespace(interp, string, null, 0);
            if (namespace == null) continue;
            Namespace.deleteNamespace(namespace);
        }
    }

    private static void evalCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        if (tclObjectArray.length < 4) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
        if (namespace == null && (namespace = Namespace.createNamespace(interp, string = tclObjectArray[2].toString(), null)) == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        CallFrame callFrame = interp.newCallFrame();
        callFrame.objv = new TclObject[tclObjectArray.length];
        System.arraycopy(tclObjectArray, 0, callFrame.objv, 0, tclObjectArray.length);
        Namespace.pushCallFrame(interp, callFrame, namespace, false);
        try {
            if (tclObjectArray.length == 4) {
                interp.eval(tclObjectArray[3], 0);
            } else {
                TclObject tclObject = Util.concat(3, tclObjectArray.length, tclObjectArray);
                interp.eval(tclObject, 0);
            }
        }
        catch (TclException tclException) {
            if (tclException.getCompletionCode() == 1) {
                interp.addErrorInfo("\n    (in namespace eval \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                interp.errAlreadyLogged = false;
            }
            throw tclException;
        }
        finally {
            Namespace.popCallFrame(interp);
        }
    }

    private static void existsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
        interp.setResult(namespace != null);
    }

    private static void exportCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        String string;
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-clear? ?pattern pattern...?");
        }
        int n2 = 2;
        if (n2 < tclObjectArray.length && (string = tclObjectArray[n2].toString()).equals("-clear")) {
            bl = true;
            ++n2;
        }
        if ((n = tclObjectArray.length - n2) == 0) {
            if (n2 > 2) {
                return;
            }
            TclObject tclObject = TclList.newInstance();
            Namespace.appendExportList(interp, namespace, tclObject);
            interp.setResult(tclObject);
            return;
        }
        for (int i = n2; i < tclObjectArray.length; ++i) {
            String string2 = tclObjectArray[i].toString();
            Namespace.exportList(interp, namespace, string2, i == n2 ? bl : false);
        }
    }

    private static void forgetCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern pattern...?");
        }
        for (int i = 2; i < tclObjectArray.length; ++i) {
            String string = tclObjectArray[i].toString();
            Namespace.forgetImport(interp, null, string);
        }
    }

    private static void importCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        boolean bl = false;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-force? ?pattern pattern...?");
        }
        int n = 2;
        if (n < tclObjectArray.length && (string = tclObjectArray[n].toString()).equals("-force")) {
            bl = true;
            ++n;
        }
        for (int i = n; i < tclObjectArray.length; ++i) {
            String string2 = tclObjectArray[i].toString();
            Namespace.importList(interp, null, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inscopeCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        block15: {
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "name arg ?arg...?");
            }
            Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in inscope namespace command");
            }
            CallFrame callFrame = interp.newCallFrame();
            callFrame.objv = new TclObject[tclObjectArray.length];
            System.arraycopy(tclObjectArray, 0, callFrame.objv, 0, tclObjectArray.length);
            Namespace.pushCallFrame(interp, callFrame, namespace, false);
            try {
                if (tclObjectArray.length == 4) {
                    interp.eval(tclObjectArray[3], 0);
                    break block15;
                }
                TclObject[] tclObjectArray2 = new TclObject[2];
                TclObject tclObject = TclList.newInstance();
                for (int i = 4; i < tclObjectArray.length; ++i) {
                    try {
                        TclList.append(interp, tclObject, tclObjectArray[i]);
                        continue;
                    }
                    catch (TclException tclException) {
                        tclObject.release();
                        throw tclException;
                    }
                }
                tclObjectArray2[0] = tclObjectArray[3];
                tclObjectArray2[1] = tclObject;
                tclObject.preserve();
                TclObject tclObject2 = Util.concat(0, 1, tclObjectArray2);
                try {
                    interp.eval(tclObject2, 0);
                }
                finally {
                    tclObject.release();
                }
            }
            catch (TclException tclException) {
                if (tclException.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (in namespace inscope \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                }
                throw tclException;
            }
            finally {
                Namespace.popCallFrame(interp);
            }
        }
    }

    private static void originCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
        }
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, tclObjectArray[2].toString(), null, 0);
        if (wrappedCommand == null) {
            throw new TclException(interp, "invalid command name \"" + tclObjectArray[2].toString() + "\"");
        }
        WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
        if (wrappedCommand2 == null) {
            interp.setResult(interp.getCommandFullName(wrappedCommand));
        } else {
            interp.setResult(interp.getCommandFullName(wrappedCommand2));
        }
    }

    private static void parentCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        if (tclObjectArray.length == 2) {
            namespace = Namespace.getCurrentNamespace(interp);
        } else if (tclObjectArray.length == 3) {
            namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in namespace parent command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name?");
        }
        if (namespace.parent != null) {
            interp.setResult(namespace.parent.fullName);
        }
    }

    private static void qualifiersCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
        }
        String string = tclObjectArray[2].toString();
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ':' || n <= 0 || string.charAt(n - 1) != ':') continue;
            n -= 2;
            while (n >= 0 && string.charAt(n) == ':') {
                --n;
            }
            break block0;
        }
        if (n >= 0) {
            interp.setResult(string.substring(0, n + 1));
        }
    }

    private static void tailCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
        }
        String string = tclObjectArray[2].toString();
        String string2 = NamespaceCmd.tail(string);
        interp.setResult(string2);
    }

    public static String tail(String string) {
        int n = string.lastIndexOf("::");
        String string2 = n == -1 ? string : ((n += 2) >= string.length() ? "" : string.substring(n));
        return string2;
    }

    private static void whichCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
        }
        int n = 2;
        int n2 = 0;
        String string = tclObjectArray[2].toString();
        if (string.length() > 1 && string.charAt(0) == '-') {
            if (string.equals("-command")) {
                n2 = 0;
            } else if (string.equals("-variable")) {
                n2 = 1;
            } else {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
            }
            n = 3;
        }
        if (tclObjectArray.length != n + 1) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
        }
        switch (n2) {
            case 0: {
                string = tclObjectArray[n].toString();
                WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, null, 0);
                if (wrappedCommand == null) {
                    return;
                }
                interp.setResult(interp.getCommandFullName(wrappedCommand));
                return;
            }
            case 1: {
                string = tclObjectArray[n].toString();
                Var var = Namespace.findNamespaceVar(interp, string, null, 0);
                if (var != null) {
                    interp.setResult(Var.getVariableFullName(interp, var));
                }
                return;
            }
        }
    }

    @Override
    public void dispose() {
        Namespace.ResolvedNsName resolvedNsName = this.otherValue;
        if (resolvedNsName != null) {
            --resolvedNsName.refCount;
            if (resolvedNsName.refCount == 0) {
                Namespace namespace = resolvedNsName.ns;
                --namespace.refCount;
                if (namespace.refCount == 0 && (namespace.flags & 2) != 0) {
                    Namespace.free(namespace);
                }
                this.otherValue = null;
            }
        }
    }

    @Override
    public InternalRep duplicate() {
        Namespace.ResolvedNsName resolvedNsName = this.otherValue;
        if (resolvedNsName != null) {
            ++resolvedNsName.refCount;
        }
        return this;
    }

    static void setNsNameFromAny(Interp interp, TclObject tclObject) throws TclException {
        Namespace.ResolvedNsName resolvedNsName;
        Object object;
        String string = tclObject.toString();
        Namespace.GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, null, 4096, getNamespaceForQualNameResult);
        Namespace namespace = getNamespaceForQualNameResult.ns;
        if (namespace != null) {
            object = Namespace.getCurrentNamespace(interp);
            ++namespace.refCount;
            resolvedNsName = new Namespace.ResolvedNsName();
            resolvedNsName.ns = namespace;
            resolvedNsName.nsId = namespace.nsId;
            resolvedNsName.refNs = object;
            resolvedNsName.refCount = 1;
        } else {
            resolvedNsName = null;
        }
        object = new NamespaceCmd();
        ((NamespaceCmd)object).otherValue = resolvedNsName;
        tclObject.setInternalRep((InternalRep)object);
    }

    static Namespace getNamespaceFromObj(Interp interp, TclObject tclObject) throws TclException {
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        if (!(tclObject.getInternalRep() instanceof NamespaceCmd)) {
            NamespaceCmd.setNsNameFromAny(interp, tclObject);
        }
        Namespace.ResolvedNsName resolvedNsName = ((NamespaceCmd)tclObject.getInternalRep()).otherValue;
        Namespace namespace2 = null;
        if (resolvedNsName != null && resolvedNsName.refNs == namespace && resolvedNsName.nsId == resolvedNsName.ns.nsId) {
            namespace2 = resolvedNsName.ns;
            if ((namespace2.flags & 2) != 0) {
                namespace2 = null;
            }
        }
        if (namespace2 == null) {
            NamespaceCmd.setNsNameFromAny(interp, tclObject);
            resolvedNsName = ((NamespaceCmd)tclObject.getInternalRep()).otherValue;
            if (resolvedNsName != null) {
                namespace2 = resolvedNsName.ns;
                if ((namespace2.flags & 2) != 0) {
                    namespace2 = null;
                }
            }
        }
        return namespace2;
    }

    public String toString() {
        Namespace.ResolvedNsName resolvedNsName = this.otherValue;
        String string = "";
        if (resolvedNsName != null && resolvedNsName.nsId == resolvedNsName.ns.nsId) {
            Namespace namespace = resolvedNsName.ns;
            if ((namespace.flags & 2) != 0) {
                namespace = null;
            }
            if (namespace != null) {
                string = namespace.fullName;
            }
        }
        return string;
    }
}

