/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public class SeekCmd
implements Command {
    private static final String[] validOrigins = new String[]{"start", "current", "end"};
    static final int OPT_START = 0;
    static final int OPT_CURRENT = 1;
    static final int OPT_END = 2;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Channel channel;
        if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId offset ?origin?");
        }
        int n = 1;
        if (tclObjectArray.length == 4) {
            int n2 = TclIndex.get(interp, tclObjectArray[3], validOrigins, "origin", 0);
            switch (n2) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                }
            }
        }
        if ((channel = TclIO.getChannel(interp, tclObjectArray[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        long l = TclInteger.getLong(interp, tclObjectArray[2]);
        try {
            channel.seek(interp, l, n);
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("SeekCmd.cmdProc() Error: IOException when seeking " + channel.getChanName() + ":" + iOException.toString());
        }
    }
}

