/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.ExecutionTrace;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclString;
import tcl.lang.TraceRecord;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.cmd.VarTraceProc;

public class TraceCmd
implements Command {
    private static final String[] validCmds = new String[]{"add", "info", "remove", "variable", "vdelete", "vinfo"};
    private static final int OPT_ADD = 0;
    private static final int OPT_INFO = 1;
    private static final int OPT_REMOVE = 2;
    private static final int OPT_VARIABLE = 3;
    private static final int OPT_VDELETE = 4;
    private static final int OPT_VINFO = 5;
    private static final String[] subCmds = new String[]{"variable", "command", "execution"};
    private static final int TYPE_VARIABLE = 0;
    private static final int TYPE_COMMAND = 1;
    private static final int TYPE_EXECUTION = 2;
    private static final String[] commandOps = new String[]{"delete", "rename"};
    private static final int OP_RENAME = 1;
    private static final int OP_DELETE = 0;
    private static final String[] executionOps = new String[]{"enter", "leave", "enterstep", "leavestep"};
    private static final int OP_ENTER = 0;
    private static final int OP_LEAVE = 1;
    private static final int OP_ENTERSTEP = 2;
    private static final int OP_LEAVESTEP = 3;
    private static TclObject[] opStr = TraceCmd.initOptStr();
    private static TclObject[] opArrayStr = TraceCmd.initOptArrayStr();
    private static TclObject[] opNewStyleStr = TraceCmd.initOptNewStyleStr();
    private static TclObject[] opNewStyleArrayStr = TraceCmd.initOptNewStyleArrayStr();

    private static TclObject[] initOptStr() {
        TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("error"), TclString.newInstance("r"), TclString.newInstance("w"), TclString.newInstance("rw"), TclString.newInstance("u"), TclString.newInstance("ru"), TclString.newInstance("wu"), TclString.newInstance("rwu")};
        for (int i = 0; i < 8; ++i) {
            tclObjectArray[i].preserve();
        }
        return tclObjectArray;
    }

    private static TclObject[] initOptArrayStr() {
        TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("a"), TclString.newInstance("ra"), TclString.newInstance("wa"), TclString.newInstance("rwa"), TclString.newInstance("ua"), TclString.newInstance("rua"), TclString.newInstance("wua"), TclString.newInstance("rwua")};
        for (int i = 0; i < 8; ++i) {
            tclObjectArray[i].preserve();
        }
        return tclObjectArray;
    }

    private static TclObject[] initOptNewStyleStr() {
        TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("error"), TclString.newInstance("read"), TclString.newInstance("write"), TclString.newInstance("read write"), TclString.newInstance("unset"), TclString.newInstance("read unset"), TclString.newInstance("write unset"), TclString.newInstance("read write unset")};
        for (int i = 0; i < 8; ++i) {
            tclObjectArray[i].preserve();
        }
        return tclObjectArray;
    }

    private static TclObject[] initOptNewStyleArrayStr() {
        TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("array"), TclString.newInstance("array read"), TclString.newInstance("array write"), TclString.newInstance("array read write"), TclString.newInstance("array unset"), TclString.newInstance("array read unset"), TclString.newInstance("array write unset"), TclString.newInstance("array read write unset")};
        for (int i = 0; i < 8; ++i) {
            tclObjectArray[i].preserve();
        }
        return tclObjectArray;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "type ?arg arg ...?");
                }
                if (n == 1) {
                    if (tclObjectArray.length != 4) {
                        throw new TclNumArgsException(interp, 3, tclObjectArray, "name");
                    }
                } else if (tclObjectArray.length != 6) {
                    throw new TclNumArgsException(interp, 3, tclObjectArray, "name opList command");
                }
                int n2 = TclIndex.get(interp, tclObjectArray[2], subCmds, "option", 0);
                switch (n2) {
                    case 0: {
                        this.traceVariable(interp, n, tclObjectArray, 3);
                        break;
                    }
                    case 1: {
                        this.traceCommand(interp, n, tclObjectArray);
                        break;
                    }
                    case 2: {
                        this.traceExecution(interp, n, tclObjectArray);
                    }
                }
                break;
            }
            case 3: {
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "variable name ops command");
                }
                this.traceVariable(interp, 0, tclObjectArray, 2);
                break;
            }
            case 4: {
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "vdelete name ops command");
                }
                this.traceVariable(interp, 2, tclObjectArray, 2);
                break;
            }
            case 5: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                this.traceVariable(interp, 5, tclObjectArray, 2);
            }
        }
    }

    private void traceExecution(Interp interp, int n, TclObject[] tclObjectArray) throws TclException {
        String string;
        String string2 = string = tclObjectArray.length >= 4 ? tclObjectArray[3].toString() : null;
        if (n == 1) {
            interp.setResult(interp.traceExecutionInfo(string));
        }
        if (n == 0 || n == 2) {
            TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[4]);
            if (tclObjectArray2.length == 0) {
                throw new TclException(interp, "bad operation list \"\": must be one or more of enter, leave, enterstep, or leavestep");
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            block10: for (TclObject tclObject : tclObjectArray2) {
                int n2 = TclIndex.get(interp, tclObject, executionOps, "operation", 1);
                switch (n2) {
                    case 0: {
                        bl = true;
                        continue block10;
                    }
                    case 1: {
                        bl2 = true;
                        continue block10;
                    }
                    case 2: {
                        bl3 = true;
                        continue block10;
                    }
                    case 3: {
                        bl4 = true;
                    }
                }
            }
            switch (n) {
                case 0: {
                    if (bl) {
                        ExecutionTrace executionTrace = new ExecutionTrace(interp, 0, tclObjectArray[5]);
                        interp.traceExecution(string, executionTrace);
                    }
                    if (bl2) {
                        ExecutionTrace executionTrace = new ExecutionTrace(interp, 1, tclObjectArray[5]);
                        interp.traceExecution(string, executionTrace);
                    }
                    if (bl3) {
                        ExecutionTrace executionTrace = new ExecutionTrace(interp, 2, tclObjectArray[5]);
                        interp.traceExecution(string, executionTrace);
                    }
                    if (!bl4) break;
                    ExecutionTrace executionTrace = new ExecutionTrace(interp, 3, tclObjectArray[5]);
                    interp.traceExecution(string, executionTrace);
                    break;
                }
                case 2: {
                    if (bl) {
                        interp.untraceExecution(string, 0, tclObjectArray[5]);
                    }
                    if (bl2) {
                        interp.untraceExecution(string, 1, tclObjectArray[5]);
                    }
                    if (bl3) {
                        interp.untraceExecution(string, 2, tclObjectArray[5]);
                    }
                    if (!bl4) break;
                    interp.untraceExecution(string, 3, tclObjectArray[5]);
                }
            }
        }
    }

    private void traceCommand(Interp interp, int n, TclObject[] tclObjectArray) throws TclException {
        String string;
        String string2 = string = tclObjectArray.length >= 4 ? tclObjectArray[3].toString() : null;
        if (n == 1) {
            interp.setResult(interp.traceCommandInfo(string));
        }
        if (n == 0 || n == 2) {
            TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[4]);
            if (tclObjectArray2.length == 0) {
                throw new TclException(interp, "bad operation list \"\": must be one or more of delete or rename");
            }
            boolean bl = false;
            boolean bl2 = false;
            block8: for (TclObject tclObject : tclObjectArray2) {
                int n2 = TclIndex.get(interp, tclObject, commandOps, "operation", 1);
                switch (n2) {
                    case 1: {
                        bl = true;
                        continue block8;
                    }
                    case 0: {
                        bl2 = true;
                    }
                }
            }
            switch (n) {
                case 0: {
                    if (bl) {
                        CommandTrace commandTrace = new CommandTrace(interp, 1, tclObjectArray[5]);
                        interp.traceCommand(string, commandTrace);
                    }
                    if (!bl2) break;
                    CommandTrace commandTrace = new CommandTrace(interp, 0, tclObjectArray[5]);
                    interp.traceCommand(string, commandTrace);
                    break;
                }
                case 2: {
                    if (bl) {
                        interp.untraceCommand(string, 1, tclObjectArray[5]);
                    }
                    if (!bl2) break;
                    interp.untraceCommand(string, 0, tclObjectArray[5]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceVariable(Interp interp, int n, TclObject[] tclObjectArray, int n2) throws TclException {
        block1 : switch (n) {
            case 0: 
            case 2: {
                int n3;
                int n4;
                Object object;
                int n5 = 0;
                boolean bl = false;
                if (n2 == 3) {
                    bl = true;
                    object = TclList.getElements(interp, tclObjectArray[n2 + 1]);
                    for (n4 = 0; n4 < ((TclObject[])object).length; ++n4) {
                        if ("read".equals(object[n4].toString())) {
                            n5 |= 0x10;
                            continue;
                        }
                        if ("write".equals(object[n4].toString())) {
                            n5 |= 0x20;
                            continue;
                        }
                        if ("unset".equals(((TclObjectBase)object[n4]).toString())) {
                            n5 |= 0x40;
                            continue;
                        }
                        if ("array".equals(((TclObjectBase)object[n4]).toString())) {
                            n5 |= 0x800;
                            continue;
                        }
                        throw new TclException(interp, "bad operation \"" + ((TclObjectBase)object[n4]).toString() + "\": must be array, read, unset, or write");
                    }
                    if (n5 == 0) {
                        throw new TclException(interp, "bad operation list \"" + tclObjectArray[n2 + 1] + "\": must be one or more of array, read, unset, or write");
                    }
                } else {
                    object = tclObjectArray[3].toString();
                    n3 = ((String)object).length();
                    block14: for (n4 = 0; n4 < n3; ++n4) {
                        switch (((String)object).charAt(n4)) {
                            case 'r': {
                                n5 |= 0x10;
                                continue block14;
                            }
                            case 'w': {
                                n5 |= 0x20;
                                continue block14;
                            }
                            case 'u': {
                                n5 |= 0x40;
                                continue block14;
                            }
                            case 'a': {
                                n5 |= 0x800;
                                continue block14;
                            }
                            default: {
                                n5 = 0;
                                break block14;
                            }
                        }
                    }
                    if (n5 == 0) {
                        throw new TclException(interp, "bad operations \"" + tclObjectArray[3] + "\": should be one or more of rwua");
                    }
                }
                if (n == 0) {
                    object = new VarTraceProc(tclObjectArray[n2 + 2].toString(), n5, bl);
                    Var.traceVar(interp, tclObjectArray[n2].toString(), null, n5, (VarTrace)object);
                    break;
                }
                object = Var.getTraces(interp, tclObjectArray[n2].toString(), null, 0);
                if (object == null) break;
                n3 = ((ArrayList)object).size();
                for (n4 = 0; n4 < n3; ++n4) {
                    TraceRecord traceRecord = (TraceRecord)((ArrayList)object).get(n4);
                    if (!(traceRecord.trace instanceof VarTraceProc)) continue;
                    VarTraceProc varTraceProc = (VarTraceProc)traceRecord.trace;
                    if (varTraceProc.flags != n5 || !varTraceProc.command.toString().equals(tclObjectArray[n2 + 2].toString())) continue;
                    Var.untraceVar(interp, tclObjectArray[n2].toString(), null, n5, varTraceProc);
                    break block1;
                }
                break;
            }
            case 1: 
            case 5: {
                ArrayList arrayList = Var.getTraces(interp, tclObjectArray[n2].toString(), null, 0);
                if (arrayList == null) break;
                int n6 = arrayList.size();
                TclObject tclObject = TclList.newInstance();
                TclObject tclObject2 = null;
                tclObject.preserve();
                try {
                    for (int i = 0; i < n6; ++i) {
                        TraceRecord traceRecord = (TraceRecord)arrayList.get(i);
                        if (!(traceRecord.trace instanceof VarTraceProc)) continue;
                        VarTraceProc varTraceProc = (VarTraceProc)traceRecord.trace;
                        int n7 = varTraceProc.flags;
                        boolean bl = (n7 & 0x800) == 2048;
                        n7 &= 0x70;
                        TclObject[] tclObjectArray2 = bl ? (n == 1 ? opNewStyleArrayStr : opArrayStr) : (n == 1 ? opNewStyleStr : opStr);
                        tclObject2 = TclList.newInstance();
                        TclList.append(interp, tclObject2, tclObjectArray2[n7 /= 16]);
                        TclList.append(interp, tclObject2, TclString.newInstance(varTraceProc.command));
                        TclList.append(interp, tclObject, tclObject2);
                    }
                    interp.setResult(tclObject);
                    break;
                }
                finally {
                    tclObject.release();
                }
            }
        }
    }
}

