/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Var;
import tcl.lang.cmd.NamespaceCmd;

public class VariableCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 1) {
            throw new TclException(interp, "wrong # args: should be \"variable ?name value...? name ?value?\"");
        }
        for (int i = 1; i < tclObjectArray.length; i += 2) {
            TclObject tclObject;
            String string = tclObjectArray[i].toString();
            if (string.endsWith(")") && string.contains("(")) {
                throw new TclException(interp, "can't define \"" + string + "\": name refers to an element in an array");
            }
            Var[] varArray = Var.lookupVar(interp, string, null, 514, "define", true, false);
            if (varArray == null) {
                throw new TclException(interp, "");
            }
            Var var = varArray[0];
            Var var2 = varArray[1];
            if (!var.isVarNamespace()) {
                var.setVarNamespace();
                ++var.refCount;
            }
            if (i + 1 < tclObjectArray.length && (tclObject = Var.setVar(interp, tclObjectArray[i].toString(), null, tclObjectArray[i + 1], 514)) == null) {
                throw new TclException(interp, "");
            }
            if (interp.varFrame == null || !interp.varFrame.isProcCallFrame) continue;
            String string2 = NamespaceCmd.tail(string);
            Var.makeUpvar(interp, null, string, null, 2, string2, 0, -1);
        }
    }
}

