/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.process.Redirect;
import tcl.lang.process.TclProcess;

public class JavaProcess
extends TclProcess {
    protected Process process = null;
    protected ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
    protected InputStream stdinStream = null;
    protected OutputStream stdoutStream = null;
    protected OutputStream stderrStream = null;
    protected Coupler stdoutCoupler = null;
    protected Coupler stderrCoupler = null;

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    @Override
    public int exitValue() throws IllegalThreadStateException {
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        return this.process.exitValue();
    }

    private void initializeEnv(ProcessBuilder processBuilder) {
        Map<String, String> map = processBuilder.environment();
        map.clear();
        map.putAll(this.getenv());
    }

    @Override
    public void start() throws IOException {
        Object object;
        this.processBuilder.command(this.command);
        this.initializeEnv(this.processBuilder);
        if (this.stderrRedirect != null && this.stderrRedirect.type == Redirect.Type.MERGE_ERROR) {
            this.processBuilder.redirectErrorStream(true);
        }
        this.process = this.processBuilder.start();
        if (this.stdinRedirect != null) {
            switch (this.stdinRedirect.type) {
                case FILE: {
                    this.stdinStream = new BufferedInputStream(new FileInputStream(this.stdinRedirect.file));
                    break;
                }
                case PIPE: {
                    object = (JavaProcess)this.stdinRedirect.pipePartner;
                    this.stdinStream = ((JavaProcess)object).getInputStream();
                    break;
                }
                case INHERIT: {
                    this.stdinStream = new ManagedSystemInStream();
                    break;
                }
                case STREAM: {
                    this.stdinStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    this.stdinStream = new InputStream(){
                        TclObject tclbuf = TclByteArray.newInstance();

                        @Override
                        public int read() throws IOException {
                            try {
                                if (JavaProcess.this.stdinRedirect.channel.eof()) {
                                    return -1;
                                }
                                int n = JavaProcess.this.stdinRedirect.channel.read(JavaProcess.this.interp, this.tclbuf, 3, 1);
                                if (n > 0) {
                                    return TclByteArray.getBytes(JavaProcess.this.interp, this.tclbuf)[0];
                                }
                                return -1;
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                        }
                    };
                }
            }
        }
        if (this.stdinStream != null) {
            object = new Coupler(this.stdinStream, this.process.getOutputStream(), true, true);
            ((Thread)object).setDaemon(true);
            ((Thread)object).setName("JavaProcess Coupler stdin");
            ((Thread)object).start();
        } else if (this.stdinRedirect != null && this.stdinRedirect.getType() == Redirect.Type.STREAM) {
            this.stdinRedirect.setOutputStream(this.process.getOutputStream());
        } else {
            this.process.getOutputStream().close();
        }
        boolean bl = true;
        if (this.stdoutRedirect != null) {
            switch (this.stdoutRedirect.type) {
                case FILE: {
                    this.stdoutStream = new BufferedOutputStream(new FileOutputStream(this.stdoutRedirect.file, this.stdoutRedirect.appendToFile));
                    break;
                }
                case INHERIT: {
                    this.stdoutStream = new FileOutputStream(FileDescriptor.out);
                    bl = false;
                    break;
                }
                case STREAM: {
                    this.stdoutStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    this.stdoutStream = new OutputStream(){
                        byte[] buf = new byte[1];
                        TclObject tclbuf;

                        @Override
                        public void write(int n) throws IOException {
                            this.buf[0] = (byte)(n & 0xFF);
                            this.tclbuf = TclByteArray.newInstance(this.buf);
                            try {
                                JavaProcess.this.stdoutRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            super.flush();
                            try {
                                JavaProcess.this.stdoutRedirect.channel.flush(JavaProcess.this.interp);
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                        }
                    };
                }
            }
        }
        if (this.stdoutStream != null) {
            this.stdoutCoupler = new Coupler(this.process.getInputStream(), this.stdoutStream, bl, this.stdoutRedirect.type == Redirect.Type.INHERIT);
            this.stdoutCoupler.setDaemon(true);
            this.stdoutCoupler.setName("JavaProcess Coupler stdout");
            this.stdoutCoupler.start();
        } else if (this.stdoutRedirect != null && this.stdoutRedirect.getType() == Redirect.Type.STREAM) {
            this.stdoutRedirect.setInputStream(this.process.getInputStream());
        }
        bl = true;
        if (this.stderrRedirect != null && this.stderrRedirect.type != Redirect.Type.MERGE_ERROR) {
            switch (this.stderrRedirect.type) {
                case FILE: {
                    this.stderrStream = new BufferedOutputStream(new FileOutputStream(this.stderrRedirect.file, this.stderrRedirect.appendToFile));
                    break;
                }
                case INHERIT: {
                    this.stderrStream = new FileOutputStream(FileDescriptor.err);
                    bl = false;
                    break;
                }
                case STREAM: {
                    this.stderrStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    bl = false;
                    this.stderrStream = new OutputStream(){
                        byte[] buf = new byte[1];
                        TclObject tclbuf;

                        @Override
                        public void write(int n) throws IOException {
                            this.buf[0] = (byte)(n & 0xFF);
                            this.tclbuf = TclByteArray.newInstance(this.buf);
                            try {
                                try {
                                    JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                JavaProcess.this.stderrRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }

                        @Override
                        public void write(byte[] byArray, int n, int n2) throws IOException {
                            this.tclbuf = TclByteArray.newInstance(byArray, n, n2);
                            try {
                                try {
                                    JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                JavaProcess.this.stderrRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            super.flush();
                            try {
                                try {
                                    JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                JavaProcess.this.stderrRedirect.channel.flush(JavaProcess.this.interp);
                            }
                            catch (TclException tclException) {
                                throw new IOException(tclException.getMessage());
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }
                    };
                }
            }
        }
        if (this.stderrStream != null) {
            this.stderrCoupler = new Coupler(this.process.getErrorStream(), this.stderrStream, bl, true);
            this.stderrCoupler.setDaemon(true);
            this.stderrCoupler.setName("JavaProcess Coupler stderr");
            this.stderrCoupler.start();
        } else if (this.stderrRedirect != null && this.stderrRedirect.getType() == Redirect.Type.STREAM) {
            this.stderrRedirect.setInputStream(this.process.getErrorStream());
        }
    }

    @Override
    protected int implWaitFor() throws InterruptedException, IOException {
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        int n = this.process.waitFor();
        if (this.stdinRedirect != null && this.stdinRedirect.type == Redirect.Type.INHERIT && this.stdinStream != null) {
            this.stdinStream.close();
        }
        if (this.stdoutCoupler != null) {
            this.stdoutCoupler.join();
        }
        if (this.stderrCoupler != null) {
            this.stderrCoupler.join();
        }
        return n;
    }

    @Override
    public int getPid() throws IllegalThreadStateException {
        String[] stringArray;
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        for (String string : stringArray = new String[]{"pid", "handle"}) {
            try {
                Field field = this.process.getClass().getDeclaredField(string);
                field.setAccessible(true);
                return field.getInt(this.process);
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    @Override
    public boolean isStarted() {
        return this.process != null;
    }

    @Override
    public void setWorkingDir(File file) {
        this.processBuilder.directory(file);
    }

    @Override
    public void destroy() {
        if (this.stdinRedirect != null && this.stdinRedirect.type == Redirect.Type.INHERIT) {
            try {
                this.stdinStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.process.destroy();
    }

    @Override
    public boolean canInheritFileDescriptors() {
        return false;
    }

    private class Coupler
    extends Thread {
        InputStream in = null;
        OutputStream out = null;
        boolean closeOut;
        boolean flushOut;

        public Coupler(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) {
            this.in = inputStream;
            this.out = outputStream;
            this.closeOut = bl;
            this.flushOut = bl2;
        }

        @Override
        public void run() {
            byte[] byArray = new byte[256];
            while (true) {
                int n = -1;
                try {
                    int n2 = this.in.available();
                    n2 = n2 > byArray.length ? byArray.length : n2;
                    n2 = n2 == 0 ? 1 : n2;
                    n = this.in.read(byArray, 0, n2);
                    if (n == -1) {
                        if (!this.closeOut) break;
                        this.out.close();
                        break;
                    }
                    this.out.write(byArray, 0, n);
                    if (!this.flushOut) continue;
                    this.out.flush();
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().toLowerCase().contains("pipe closed")) {
                        JavaProcess.this.saveIOException(iOException);
                    }
                    try {
                        if (this.closeOut) {
                            this.out.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException3) {}
                    break;
                }
            }
        }
    }
}

