/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.BiMethod;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Ensemble;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberCode;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Linkage;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Objects;
import tcl.pkg.itcl.Util;

class BiCmds {
    private static BiMethod[] BiMethodList = new BiMethod[]{new BiMethod("cget", "-option", "@itcl-builtin-cget", new BiCgetCmd()), new BiMethod("configure", "?-option? ?value -option value...?", "@itcl-builtin-configure", new BiConfigureCmd()), new BiMethod("isa", "className", "@itcl-builtin-isa", new BiIsaCmd())};
    private static final int BiMethodListLen = BiMethodList.length;

    BiCmds() {
    }

    public static void BiInit(Interp interp) throws TclException {
        for (int i = 0; i < BiMethodListLen; ++i) {
            Linkage.RegisterObjC(interp, BiCmds.BiMethodList[i].registration.substring(1), BiCmds.BiMethodList[i].proc);
        }
        interp.createCommand("::itcl::builtin::chain", new BiChainCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::builtin::info");
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "class", "", (Command)new BiInfoClassCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "inherit", "", (Command)new BiInfoInheritCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "heritage", "", (Command)new BiInfoHeritageCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "function", "?name? ?-protection? ?-type? ?-name? ?-args? ?-body?", (Command)new BiInfoFunctionCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "variable", "?name? ?-protection? ?-type? ?-name? ?-init? ?-value? ?-config?", (Command)new BiInfoVariableCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "args", "procname", (Command)new BiInfoArgsCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "body", "procname", (Command)new BiInfoBodyCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "@error", "", (Command)new DefaultInfoCmd());
        Namespace namespace = Namespace.findNamespace(interp, "::itcl::builtin", null, 512);
        if (namespace == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        Namespace.exportList(interp, namespace, "*", true);
    }

    public static void InstallBiMethods(Interp interp, ItclClass itclClass) throws TclException {
        boolean bl = false;
        for (int i = 0; i < BiMethodListLen; ++i) {
            ItclHierIter itclHierIter = new ItclHierIter();
            Class.InitHierIter(itclHierIter, itclClass);
            ItclClass itclClass2 = Class.AdvanceHierIter(itclHierIter);
            while (itclClass2 != null) {
                if (itclClass2.functions.containsKey(BiCmds.BiMethodList[i].name)) {
                    bl = true;
                    break;
                }
                itclClass2 = Class.AdvanceHierIter(itclHierIter);
            }
            Class.DeleteHierIter(itclHierIter);
            if (bl) continue;
            Methods.CreateMethod(interp, itclClass, BiCmds.BiMethodList[i].name, BiCmds.BiMethodList[i].usage, BiCmds.BiMethodList[i].registration);
        }
    }

    private static TclObject ReportPublicOpt(Interp interp, ItclVarDefn itclVarDefn, ItclObject itclObject) {
        TclObject tclObject = TclList.newInstance();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("-");
        ItclClass itclClass = itclObject.classDefn;
        ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(itclVarDefn.member.fullname);
        Util.Assert(itclVarLookup != null, "vlookup != null");
        stringBuffer.append(itclVarLookup.leastQualName);
        TclObject tclObject2 = TclString.newInstance(stringBuffer.toString());
        try {
            TclList.append(interp, tclObject, tclObject2);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException " + tclException.getMessage());
        }
        stringBuffer = null;
        tclObject2 = itclVarDefn.init != null ? TclString.newInstance(itclVarDefn.init) : TclString.newInstance("<undefined>");
        try {
            TclList.append(interp, tclObject, tclObject2);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException " + tclException.getMessage());
        }
        String string = Objects.GetInstanceVar(interp, itclVarDefn.member.fullname, itclObject, itclObject.classDefn);
        tclObject2 = string != null ? TclString.newInstance(string) : TclString.newInstance("<undefined>");
        try {
            TclList.append(interp, tclObject, tclObject2);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException " + tclException.getMessage());
        }
        return tclObject;
    }

    static class DefaultInfoCmd
    implements Command {
        DefaultInfoCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            block5: {
                WrappedCommand wrappedCommand = Namespace.findCommand(interp, "::info", null, 0);
                if (wrappedCommand == null) {
                    String string = tclObjectArray[0].toString();
                    interp.resetResult();
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append("bad option \"" + string + "\" should be one of...\n");
                    Ensemble.GetEnsembleUsageForObj(interp, tclObjectArray[0], stringBuffer);
                    throw new TclException(interp, stringBuffer.toString());
                }
                Command command = wrappedCommand.cmd;
                try {
                    if (wrappedCommand.mustCallInvoke(interp)) {
                        wrappedCommand.invoke(interp, tclObjectArray);
                    } else {
                        command.cmdProc(interp, tclObjectArray);
                    }
                }
                catch (TclException tclException) {
                    String string = interp.getResult().toString();
                    if (!string.startsWith("bad option")) break block5;
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append(string);
                    stringBuffer.append("\nor");
                    Ensemble.GetEnsembleUsageForObj(interp, tclObjectArray[0], stringBuffer);
                    throw new TclException(interp, stringBuffer.toString());
                }
            }
        }
    }

    static class BiInfoArgsCmd
    implements Command {
        BiInfoArgsCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "function");
            }
            String string = tclObjectArray[1].toString();
            if (!Class.IsClassNamespace(Namespace.getCurrentNamespace(interp))) {
                string = tclObjectArray[1].toString();
                interp.eval("::info args {" + string + "}");
                return;
            }
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                ItclObject itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                string = tclObjectArray[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string + "... }");
            }
            ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.resolveCmds.get(string);
            if (itclMemberFunc == null) {
                throw new TclException(interp, "\"" + string + "\" isn't a procedure");
            }
            ItclMemberCode itclMemberCode = itclMemberFunc.member.code;
            TclObject tclObject = itclMemberCode != null && itclMemberCode.arglist != null ? Methods.ArgList(itclMemberCode.argcount, itclMemberCode.arglist) : ((itclMemberFunc.member.flags & ItclInt.ARG_SPEC) != 0 ? Methods.ArgList(itclMemberFunc.argcount, itclMemberFunc.arglist) : TclString.newInstance("<undefined>"));
            interp.setResult(tclObject);
        }
    }

    static class BiInfoBodyCmd
    implements Command {
        BiInfoBodyCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "function");
            }
            if (!Class.IsClassNamespace(Namespace.getCurrentNamespace(interp))) {
                String string = tclObjectArray[1].toString();
                interp.eval("::info body {" + string + "}");
                return;
            }
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                ItclObject itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                String string = tclObjectArray[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string + "... }");
            }
            String string = tclObjectArray[1].toString();
            ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.resolveCmds.get(string);
            if (itclMemberFunc == null) {
                throw new TclException(interp, "\"" + string + "\" isn't a procedure");
            }
            ItclMemberCode itclMemberCode = itclMemberFunc.member.code;
            TclObject tclObject = itclMemberCode != null && Methods.IsMemberCodeImplemented(itclMemberCode) ? TclString.newInstance(itclMemberCode.body) : TclString.newInstance("<undefined>");
            interp.setResult(tclObject);
        }
    }

    static class BiInfoVariableCmd
    implements Command {
        static String[] options = new String[]{"-config", "-init", "-name", "-protection", "-type", "-value"};
        private static final int BIvConfigIdx = 0;
        private static final int BIvInitIdx = 1;
        private static final int BIvNameIdx = 2;
        private static final int BIvProtectIdx = 3;
        private static final int BIvTypeIdx = 4;
        private static final int BIvValueIdx = 5;
        static int[] DefInfoVariable = new int[]{3, 4, 2, 1, 5};
        static int[] DefInfoPubVariable = new int[]{3, 4, 2, 1, 0, 5};

        BiInfoVariableCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObject itclObject;
            ItclClass itclClass;
            String string = null;
            TclObject tclObject = null;
            TclObject tclObject2 = null;
            int[] nArray = new int[6];
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                String string2 = tclObjectArray[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string2 + "... }");
            }
            int n = tclObjectArray.length;
            int n2 = 0;
            ++n2;
            if (--n > 0) {
                string = tclObjectArray[n2].toString();
                --n;
                ++n2;
            }
            if (string != null) {
                int n3;
                int[] nArray2;
                ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string);
                if (itclVarLookup == null) {
                    throw new TclException(interp, "\"" + string + "\" isn't a variable in class \"" + itclClass.namesp.fullName + "\"");
                }
                ItclMember itclMember = itclVarLookup.vdefn.member;
                if (n == 0) {
                    if (itclMember.protection == 1 && (itclMember.flags & ItclInt.COMMON) == 0) {
                        nArray2 = DefInfoPubVariable;
                        n = 6;
                    } else {
                        nArray2 = DefInfoVariable;
                        n = 5;
                    }
                } else {
                    nArray2 = nArray;
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray2[n3] = TclIndex.get(interp, tclObjectArray[n3 + n2], options, "option", 0);
                    }
                }
                if (n > 1) {
                    tclObject = TclList.newInstance();
                }
                for (n3 = 0; n3 < n; ++n3) {
                    switch (nArray2[n3]) {
                        case 0: {
                            if (itclMember.code != null && Methods.IsMemberCodeImplemented(itclMember.code)) {
                                tclObject2 = TclString.newInstance(itclMember.code.body);
                                break;
                            }
                            tclObject2 = TclString.newInstance("");
                            break;
                        }
                        case 1: {
                            if ((itclMember.flags & ItclInt.THIS_VAR) != 0) {
                                if (itclObject != null && itclObject.accessCmd != null) {
                                    String string3 = itclObject.classDefn.interp.getCommandFullName(itclObject.w_accessCmd);
                                    tclObject2 = TclString.newInstance(string3);
                                    break;
                                }
                                tclObject2 = TclString.newInstance("<objectName>");
                                break;
                            }
                            if (itclVarLookup.vdefn.init != null) {
                                tclObject2 = TclString.newInstance(itclVarLookup.vdefn.init);
                                break;
                            }
                            tclObject2 = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 2: {
                            tclObject2 = TclString.newInstance(itclMember.fullname);
                            break;
                        }
                        case 3: {
                            String string4 = Util.ProtectionStr(itclMember.protection);
                            tclObject2 = TclString.newInstance(string4);
                            break;
                        }
                        case 4: {
                            String string4 = (itclMember.flags & ItclInt.COMMON) != 0 ? "common" : "variable";
                            tclObject2 = TclString.newInstance(string4);
                            break;
                        }
                        case 5: {
                            String string4;
                            if ((itclMember.flags & ItclInt.COMMON) != 0) {
                                string4 = Class.GetCommonVar(interp, itclMember.fullname, itclMember.classDefn);
                            } else {
                                if (itclObject == null) {
                                    interp.resetResult();
                                    throw new TclException(interp, "cannot access object-specific info without an object context");
                                }
                                string4 = Objects.GetInstanceVar(interp, itclMember.fullname, itclObject, itclMember.classDefn);
                            }
                            if (string4 == null) {
                                string4 = "<undefined>";
                            }
                            tclObject2 = TclString.newInstance(string4);
                        }
                    }
                    if (n == 1) {
                        tclObject = tclObject2;
                        continue;
                    }
                    TclList.append(interp, tclObject, tclObject2);
                }
                interp.setResult(tclObject);
            } else {
                ItclClass itclClass2;
                tclObject = TclList.newInstance();
                ItclHierIter itclHierIter = new ItclHierIter();
                Class.InitHierIter(itclHierIter, itclClass);
                while ((itclClass2 = Class.AdvanceHierIter(itclHierIter)) != null) {
                    for (Map.Entry entry : itclClass2.variables.entrySet()) {
                        String string5 = (String)entry.getKey();
                        ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
                        if ((itclVarDefn.member.flags & ItclInt.THIS_VAR) != 0) {
                            if (itclClass2 != itclClass) continue;
                            tclObject2 = TclString.newInstance(itclVarDefn.member.fullname);
                            TclList.append(interp, tclObject, tclObject2);
                            continue;
                        }
                        tclObject2 = TclString.newInstance(itclVarDefn.member.fullname);
                        TclList.append(interp, tclObject, tclObject2);
                    }
                }
                Class.DeleteHierIter(itclHierIter);
                interp.setResult(tclObject);
            }
        }
    }

    static class BiInfoFunctionCmd
    implements Command {
        static String[] options = new String[]{"-args", "-body", "-name", "-protection", "-type"};
        private static final int BIfArgsIdx = 0;
        private static final int BIfBodyIdx = 1;
        private static final int BIfNameIdx = 2;
        private static final int BIfProtectIdx = 3;
        private static final int BIfTypeIdx = 4;
        static int[] DefInfoFunction = new int[]{3, 4, 2, 0, 1};

        BiInfoFunctionCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            String string = null;
            TclObject tclObject = null;
            TclObject tclObject2 = null;
            int[] nArray = new int[5];
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                ItclObject itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                String string2 = tclObjectArray[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string2 + "... }");
            }
            int n = tclObjectArray.length;
            int n2 = 0;
            ++n2;
            if (--n > 0) {
                string = tclObjectArray[n2].toString();
                --n;
                ++n2;
            }
            if (string != null) {
                int n3;
                int[] nArray2;
                ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.resolveCmds.get(string);
                if (itclMemberFunc == null) {
                    throw new TclException(interp, "\"" + string + "\" isn't a member function in class \"" + itclClass.namesp.fullName + "\"");
                }
                ItclMemberCode itclMemberCode = itclMemberFunc.member.code;
                if (n == 0) {
                    n = 5;
                    nArray2 = DefInfoFunction;
                } else {
                    nArray2 = nArray;
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray2[n3] = TclIndex.get(interp, tclObjectArray[n3 + n2], options, "option", 0);
                    }
                }
                if (n > 1) {
                    tclObject = TclList.newInstance();
                }
                for (n3 = 0; n3 < n; ++n3) {
                    switch (nArray2[n3]) {
                        case 0: {
                            if (itclMemberCode != null && itclMemberCode.arglist != null) {
                                tclObject2 = Methods.ArgList(itclMemberCode.argcount, itclMemberCode.arglist);
                                break;
                            }
                            if ((itclMemberFunc.member.flags & ItclInt.ARG_SPEC) != 0) {
                                tclObject2 = Methods.ArgList(itclMemberFunc.argcount, itclMemberFunc.arglist);
                                break;
                            }
                            tclObject2 = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 1: {
                            if (itclMemberCode != null && Methods.IsMemberCodeImplemented(itclMemberCode)) {
                                tclObject2 = TclString.newInstance(itclMemberCode.body);
                                break;
                            }
                            tclObject2 = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 2: {
                            tclObject2 = TclString.newInstance(itclMemberFunc.member.fullname);
                            break;
                        }
                        case 3: {
                            String string3 = Util.ProtectionStr(itclMemberFunc.member.protection);
                            tclObject2 = TclString.newInstance(string3);
                            break;
                        }
                        case 4: {
                            String string3 = (itclMemberFunc.member.flags & ItclInt.COMMON) != 0 ? "proc" : "method";
                            tclObject2 = TclString.newInstance(string3);
                        }
                    }
                    if (n == 1) {
                        tclObject = tclObject2;
                        continue;
                    }
                    TclList.append(interp, tclObject, tclObject2);
                }
                interp.setResult(tclObject);
            } else {
                ItclClass itclClass2;
                tclObject = TclList.newInstance();
                ItclHierIter itclHierIter = new ItclHierIter();
                Class.InitHierIter(itclHierIter, itclClass);
                while ((itclClass2 = Class.AdvanceHierIter(itclHierIter)) != null) {
                    for (Map.Entry entry : itclClass2.functions.entrySet()) {
                        String string4 = (String)entry.getKey();
                        ItclMemberFunc itclMemberFunc = (ItclMemberFunc)entry.getValue();
                        tclObject2 = TclString.newInstance(itclMemberFunc.member.fullname);
                        TclList.append(interp, tclObject, tclObject2);
                    }
                }
                Class.DeleteHierIter(itclHierIter);
                interp.setResult(tclObject);
            }
        }
    }

    static class BiInfoHeritageCmd
    implements Command {
        BiInfoHeritageCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            ItclClass itclClass2;
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            if (tclObjectArray.length != 1) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "");
            }
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass2 = getContextResult.cdefn;
                ItclObject itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                String string = tclObjectArray[0].toString();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string + "... }");
            }
            TclObject tclObject = TclList.newInstance();
            ItclHierIter itclHierIter = new ItclHierIter();
            Class.InitHierIter(itclHierIter, itclClass2);
            while ((itclClass = Class.AdvanceHierIter(itclHierIter)) != null) {
                TclObject tclObject2 = itclClass.namesp.parent == namespace ? TclString.newInstance(itclClass.namesp.name) : TclString.newInstance(itclClass.namesp.fullName);
                TclList.append(interp, tclObject, tclObject2);
            }
            Class.DeleteHierIter(itclHierIter);
            interp.setResult(tclObject);
        }
    }

    static class BiInfoInheritCmd
    implements Command {
        BiInfoInheritCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            if (tclObjectArray.length != 1) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "");
            }
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                ItclObject itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                String string = tclObjectArray[0].toString();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + string + "... }");
            }
            TclObject tclObject = TclList.newInstance();
            Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.bases);
            while (itcl_ListElem != null) {
                ItclClass itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
                TclObject tclObject2 = itclClass2.namesp.parent == namespace ? TclString.newInstance(itclClass2.namesp.name) : TclString.newInstance(itclClass2.namesp.fullName);
                TclList.append(interp, tclObject, tclObject2);
                itcl_ListElem = Util.NextListElem(itcl_ListElem);
            }
            interp.setResult(tclObject);
        }
    }

    static class BiInfoClassCmd
    implements Command {
        BiInfoClassCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObject itclObject;
            ItclClass itclClass;
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            Namespace namespace2 = null;
            if (tclObjectArray.length != 1) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "");
            }
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass = getContextResult.cdefn;
                itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + tclObjectArray[0] + "... }");
            }
            if (itclObject != null) {
                namespace2 = itclObject.classDefn.namesp;
            } else {
                Util.Assert(itclClass != null, "contextClass != null");
                Util.Assert(itclClass.namesp != null, "contextClass.namesp != null");
                namespace2 = itclClass.namesp;
            }
            String string = namespace2 == null ? namespace.fullName : (namespace2.parent == namespace ? namespace2.name : namespace2.fullName);
            interp.setResult(string);
        }
    }

    static class BiChainCmd
    implements Command {
        BiChainCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            ItclHierIter itclHierIter;
            ItclObject itclObject;
            ItclClass itclClass2;
            try {
                Methods.GetContextResult getContextResult = Methods.GetContext(interp);
                itclClass2 = getContextResult.cdefn;
                itclObject = getContextResult.odefn;
            }
            catch (TclException tclException) {
                interp.resetResult();
                throw new TclException(interp, "cannot chain functions outside of a class context");
            }
            CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
            TclObject[] tclObjectArray2 = ItclAccess.getCallFrameObjv(callFrame);
            if (callFrame == null || tclObjectArray2 == null) {
                return;
            }
            String string = tclObjectArray2[0].toString();
            Util.ParseNamespPathResult parseNamespPathResult = Util.ParseNamespPath(string);
            String string2 = parseNamespPathResult.head;
            string = parseNamespPathResult.tail;
            if (itclObject != null) {
                itclHierIter = new ItclHierIter();
                Class.InitHierIter(itclHierIter, itclObject.classDefn);
                while ((itclClass = Class.AdvanceHierIter(itclHierIter)) != null && itclClass != itclClass2) {
                }
            } else {
                itclHierIter = new ItclHierIter();
                Class.InitHierIter(itclHierIter, itclClass2);
                Class.AdvanceHierIter(itclHierIter);
            }
            while ((itclClass = Class.AdvanceHierIter(itclHierIter)) != null) {
                TclObject[] tclObjectArray3;
                ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.functions.get(string);
                if (itclMemberFunc == null) continue;
                TclObject tclObject = Util.CreateArgs(interp, itclMemberFunc.member.fullname, tclObjectArray, 1);
                try {
                    tclObjectArray3 = TclList.getElements(interp, tclObject);
                }
                catch (TclException tclException) {
                    throw new TclRuntimeError("unexpected TclException " + tclException.getMessage());
                }
                Util.EvalArgs(interp, tclObjectArray3);
                break;
            }
            Class.DeleteHierIter(itclHierIter);
        }
    }

    static class BiCgetCmd
    implements Command {
        BiCgetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Methods.GetContextResult getContextResult = Methods.GetContext(interp);
            ItclClass itclClass = getContextResult.cdefn;
            ItclObject itclObject = getContextResult.odefn;
            if (itclObject == null || tclObjectArray.length != 2) {
                throw new TclException(interp, "improper usage: should be \"object cget -option\"");
            }
            itclClass = itclObject.classDefn;
            String string = tclObjectArray[1].toString();
            ItclVarLookup itclVarLookup = null;
            itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string.substring(1));
            if (itclVarLookup == null || itclVarLookup.vdefn.member.protection != 1) {
                throw new TclException(interp, "unknown option \"" + string + "\"");
            }
            String string2 = Objects.GetInstanceVar(interp, itclVarLookup.vdefn.member.fullname, itclObject, itclObject.classDefn);
            if (string2 != null) {
                interp.setResult(string2);
            } else {
                interp.setResult("<undefined>");
            }
        }
    }

    static class BiConfigureCmd
    implements Command {
        BiConfigureCmd() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Methods.GetContextResult getContextResult = Methods.GetContext(interp);
            ItclClass itclClass = getContextResult.cdefn;
            ItclObject itclObject = getContextResult.odefn;
            if (itclObject == null) {
                throw new TclException(interp, "improper usage: should be \"object configure ?-option? ?value -option value...?\"");
            }
            itclClass = itclObject.classDefn;
            if (tclObjectArray.length == 1) {
                ItclClass itclClass2;
                TclObject tclObject = TclList.newInstance();
                ItclHierIter itclHierIter = new ItclHierIter();
                Class.InitHierIter(itclHierIter, itclClass);
                while ((itclClass2 = Class.AdvanceHierIter(itclHierIter)) != null) {
                    for (Map.Entry entry : itclClass2.variables.entrySet()) {
                        String string = (String)entry.getKey();
                        ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
                        if (itclVarDefn.member.protection != 1) continue;
                        TclObject tclObject2 = BiCmds.ReportPublicOpt(interp, itclVarDefn, itclObject);
                        TclList.append(interp, tclObject, tclObject2);
                    }
                }
                Class.DeleteHierIter(itclHierIter);
                interp.setResult(tclObject);
                return;
            }
            if (tclObjectArray.length == 2) {
                String string = tclObjectArray[1].toString();
                if (string.length() < 2 || string.charAt(0) != '-') {
                    throw new TclException(interp, "improper usage: should be \"object configure ?-option? ?value -option value...?\"");
                }
                ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string.substring(1));
                if (itclVarLookup != null && itclVarLookup.vdefn.member.protection != 1) {
                    itclVarLookup = null;
                }
                if (itclVarLookup == null) {
                    throw new TclException(interp, "unknown option \"" + string + "\"");
                }
                TclObject tclObject = BiCmds.ReportPublicOpt(interp, itclVarLookup.vdefn, itclObject);
                interp.setResult(tclObject);
                return;
            }
            ItclContext itclContext = new ItclContext(interp);
            Methods.PushContext(interp, null, itclObject.classDefn, itclObject, itclContext);
            try {
                StringBuffer stringBuffer = new StringBuffer(64);
                for (int i = 1; i < tclObjectArray.length; i += 2) {
                    ItclVarLookup itclVarLookup = null;
                    String string = tclObjectArray[i].toString();
                    if (string.length() >= 2 && string.charAt(0) == '-') {
                        itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string.substring(1));
                    }
                    if (itclVarLookup == null || itclVarLookup.vdefn.member.protection != 1) {
                        throw new TclException(interp, "unknown option \"" + string + "\"");
                    }
                    if (i == tclObjectArray.length - 1) {
                        throw new TclException(interp, "value for \"" + string + "\" missing");
                    }
                    ItclMember itclMember = itclVarLookup.vdefn.member;
                    TclObject tclObject = interp.getVar(itclMember.fullname, 0);
                    stringBuffer.setLength(0);
                    if (tclObject != null) {
                        String string2 = tclObject.toString();
                        stringBuffer.append(string2);
                    }
                    string = tclObjectArray[i + 1].toString();
                    try {
                        interp.setVar(itclMember.fullname, TclString.newInstance(string), 0);
                    }
                    catch (TclException tclException) {
                        interp.addErrorInfo("\n    (error in configuration of public variable \"" + itclMember.fullname + "\")");
                        throw tclException;
                    }
                    ItclMemberCode itclMemberCode = itclMember.code;
                    if (itclMemberCode == null || !Methods.IsMemberCodeImplemented(itclMemberCode)) continue;
                    String string3 = itclMemberCode.body;
                    CallFrame callFrame = Migrate.GetCallFrame(interp, 1);
                    CallFrame callFrame2 = Migrate.ActivateCallFrame(interp, callFrame);
                    try {
                        Methods.EvalMemberCode(interp, null, itclMember, itclObject, null);
                        interp.resetResult();
                        continue;
                    }
                    catch (TclException tclException) {
                        String string4 = "\n    (error in configuration of public variable \"" + itclMember.fullname + "\")";
                        interp.addErrorInfo(string4);
                        interp.setVar(itclMember.fullname, TclString.newInstance(stringBuffer.toString()), 0);
                        throw tclException;
                    }
                    finally {
                        Migrate.ActivateCallFrame(interp, callFrame2);
                    }
                }
            }
            finally {
                Methods.PopContext(interp, itclContext);
            }
        }
    }

    static class BiIsaCmd
    implements Command {
        BiIsaCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Methods.GetContextResult getContextResult = Methods.GetContext(interp);
            ItclClass itclClass = getContextResult.cdefn;
            ItclObject itclObject = getContextResult.odefn;
            if (itclObject == null) {
                throw new TclException(interp, "improper usage: should be \"object isa className\"");
            }
            if (tclObjectArray.length != 2) {
                String string = tclObjectArray[0].toString();
                throw new TclException(interp, "wrong # args: should be \"object " + string + " className\"");
            }
            String string = tclObjectArray[1].toString();
            ItclClass itclClass2 = Class.FindClass(interp, string, true);
            if (itclClass2 == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            if (Objects.ObjectIsa(itclObject, itclClass2)) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }
}

