/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Cmds;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_InterpState;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Util;

class Objects {
    static HashMap dangleTable = new HashMap();

    Objects() {
    }

    static ItclObject CreateObject(Interp interp, String string, ItclClass itclClass, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        TclException tclException = null;
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, null, 2);
        if (wrappedCommand != null && !Cmds.IsStub(wrappedCommand)) {
            throw new TclException(interp, "command \"" + string + "\" already exists in namespace \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
        }
        Util.ParseNamespPathResult parseNamespPathResult = Util.ParseNamespPath(string);
        String string2 = parseNamespPathResult.head;
        String string3 = parseNamespPathResult.tail;
        if (string2 != null) {
            namespace = Class.FindClassNamespace(interp, string2);
            if (namespace == null) {
                throw new TclException(interp, "namespace \"" + string2 + "\" not found in context \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
            }
        } else {
            namespace = Namespace.getCurrentNamespace(interp);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (namespace != Namespace.getGlobalNamespace(interp)) {
            stringBuffer.append(namespace.fullName);
        }
        stringBuffer.append("::");
        stringBuffer.append(string3);
        ItclObject itclObject = new ItclObject();
        itclObject.classDefn = itclClass;
        Util.PreserveData(itclClass);
        itclObject.dataSize = itclClass.numInstanceVars;
        itclObject.data = new Var[itclObject.dataSize];
        itclObject.constructed = new HashMap();
        itclObject.destructed = null;
        Util.PreserveData(itclObject);
        interp.createCommand(stringBuffer.toString(), new HandleInstanceCmd(itclObject));
        itclObject.w_accessCmd = wrappedCommand = Namespace.findCommand(interp, string, null, 2);
        itclObject.accessCmd = wrappedCommand.cmd;
        Util.PreserveData(itclObject);
        ItclContext itclContext = new ItclContext(interp);
        Methods.PushContext(interp, null, itclClass, itclObject, itclContext);
        ItclHierIter itclHierIter = new ItclHierIter();
        Class.InitHierIter(itclHierIter, itclClass);
        ItclClass itclClass2 = Class.AdvanceHierIter(itclHierIter);
        while (itclClass2 != null) {
            for (Map.Entry entry : itclClass2.variables.entrySet()) {
                ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
                if ((itclVarDefn.member.flags & ItclInt.THIS_VAR) != 0) {
                    if (itclClass2 != itclClass) continue;
                    Objects.CreateObjVar(interp, itclVarDefn, itclObject);
                    interp.setVar("this", TclString.newInstance(""), 0);
                    interp.traceVar("this", (VarTrace)itclObject, 48);
                    continue;
                }
                if ((itclVarDefn.member.flags & ItclInt.COMMON) != 0) continue;
                Objects.CreateObjVar(interp, itclVarDefn, itclObject);
            }
            itclClass2 = Class.AdvanceHierIter(itclHierIter);
        }
        Class.DeleteHierIter(itclHierIter);
        Methods.PopContext(interp, itclContext);
        boolean bl = true;
        try {
            Methods.InvokeMethodIfExists(interp, "constructor", itclClass, itclObject, tclObjectArray);
            bl = false;
        }
        catch (TclException tclException2) {
            tclException = tclException2;
        }
        if (itclClass.functions.get("constructor") == null) {
            bl = true;
            try {
                Methods.ConstructBase(interp, itclObject, itclClass);
                bl = false;
            }
            catch (TclException tclException3) {
                tclException = tclException3;
            }
        }
        if (bl) {
            Itcl_InterpState itcl_InterpState = Util.SaveInterpState(interp, 0);
            if (itclObject.accessCmd != null) {
                if (interp.deleteCommandFromToken(itclObject.w_accessCmd) != 0) {
                    throw new TclRuntimeError("could not delete instance command from token");
                }
                itclObject.accessCmd = null;
            }
            int n = Util.RestoreInterpState(interp, itcl_InterpState);
        }
        itclObject.constructed.clear();
        itclObject.constructed = null;
        if (!bl && itclObject.accessCmd != null) {
            itclClass.info.objects.put(itclObject.accessCmd, itclObject);
        }
        Util.ReleaseData(itclObject);
        if (bl) {
            throw tclException;
        }
        return itclObject;
    }

    static void DeleteObject(Interp interp, ItclObject itclObject) throws TclException {
        ItclClass itclClass = itclObject.classDefn;
        Util.PreserveData(itclObject);
        try {
            Objects.DestructObject(interp, itclObject, 0);
        }
        catch (TclException tclException) {
            Util.ReleaseData(itclObject);
            throw tclException;
        }
        itclClass.info.objects.remove(itclObject.accessCmd);
        ((HandleInstanceCmd)itclObject.accessCmd).deleteToken = true;
        if (interp.deleteCommandFromToken(itclObject.w_accessCmd) != 0) {
            throw new TclRuntimeError("could not delete instance command from token");
        }
        itclObject.accessCmd = null;
        Util.ReleaseData(itclObject);
    }

    static void DestructObject(Interp interp, ItclObject itclObject, int n) throws TclException {
        if (itclObject.destructed != null) {
            if ((n & ItclInt.IGNORE_ERRS) == 0) {
                throw new TclException(interp, "can't delete an object while it is being destructed");
            }
            return;
        }
        itclObject.destructed = new HashMap();
        TclException tclException = null;
        try {
            Objects.DestructBase(interp, itclObject, itclObject.classDefn, n);
        }
        catch (TclException tclException2) {
            tclException = tclException2;
        }
        if (tclException == null) {
            interp.resetResult();
        }
        itclObject.destructed.clear();
        itclObject.destructed = null;
        if (tclException != null) {
            throw tclException;
        }
    }

    static void DestructBase(Interp interp, ItclObject itclObject, ItclClass itclClass, int n) throws TclException {
        if (itclObject.destructed.get(itclClass.name) == null) {
            Methods.InvokeMethodIfExists(interp, "destructor", itclClass, itclObject, null);
        }
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.bases);
        while (itcl_ListElem != null) {
            ItclClass itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
            Objects.DestructBase(interp, itclObject, itclClass2, n);
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
        }
        interp.resetResult();
    }

    static ItclObject FindObject(Interp interp, String string) throws TclException {
        WrappedCommand wrappedCommand;
        Namespace namespace = null;
        Util.DecodeScopedCommandResult decodeScopedCommandResult = Util.DecodeScopedCommand(interp, string);
        namespace = decodeScopedCommandResult.rNS;
        String string2 = decodeScopedCommandResult.rCmd;
        try {
            wrappedCommand = Namespace.findCommand(interp, string2, namespace, 0);
        }
        catch (TclException tclException) {
            wrappedCommand = null;
        }
        if (wrappedCommand != null && Objects.IsObject(wrappedCommand)) {
            return Objects.GetContextFromObject(wrappedCommand);
        }
        return null;
    }

    static boolean IsObject(WrappedCommand wrappedCommand) {
        if (wrappedCommand.cmd instanceof HandleInstanceCmd) {
            return true;
        }
        return (wrappedCommand = Namespace.getOriginalCommand(wrappedCommand)) != null && wrappedCommand.cmd instanceof HandleInstanceCmd;
    }

    static ItclObject GetContextFromObject(WrappedCommand wrappedCommand) {
        return ((HandleInstanceCmd)wrappedCommand.cmd).contextObj;
    }

    static boolean ObjectIsa(ItclObject itclObject, ItclClass itclClass) {
        return itclObject.classDefn.heritage.get(itclClass) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String GetInstanceVar(Interp interp, String string, ItclObject itclObject, ItclClass itclClass) {
        TclObject tclObject = null;
        if (itclObject == null) {
            interp.setResult("cannot access object-specific info without an object context");
            return null;
        }
        ItclContext itclContext = new ItclContext(interp);
        try {
            Methods.PushContext(interp, null, itclClass, itclObject, itclContext);
        }
        catch (TclException tclException) {
            return null;
        }
        try {
            tclObject = interp.getVar(string, 512);
        }
        catch (TclException tclException) {
        }
        finally {
            Methods.PopContext(interp, itclContext);
        }
        if (tclObject != null) {
            return tclObject.toString();
        }
        return null;
    }

    static String ReportObjectUsage(Interp interp, ItclObject itclObject) {
        Itcl_ListElem itcl_ListElem;
        ItclMemberFunc itclMemberFunc;
        ItclClass itclClass = itclObject.classDefn;
        int n = ItclInt.CONSTRUCTOR | ItclInt.DESTRUCTOR | ItclInt.COMMON;
        Itcl_List itcl_List = new Itcl_List();
        Util.InitList(itcl_List);
        for (Map.Entry entry : itclClass.resolveCmds.entrySet()) {
            Namespace namespace;
            String string = (String)entry.getKey();
            itclMemberFunc = (ItclMemberFunc)entry.getValue();
            if (string.indexOf("::") != -1 || (itclMemberFunc.member.flags & n) != 0) {
                itclMemberFunc = null;
            } else if (itclMemberFunc.member.protection != 1 && !Util.CanAccessFunc(itclMemberFunc, namespace = Util.GetTrueNamespace(interp, itclMemberFunc.member.classDefn.info))) {
                itclMemberFunc = null;
            }
            if (itclMemberFunc == null) continue;
            itcl_ListElem = Util.FirstListElem(itcl_List);
            while (itcl_ListElem != null) {
                ItclMemberFunc itclMemberFunc2 = (ItclMemberFunc)Util.GetListValue(itcl_ListElem);
                int n2 = itclMemberFunc.member.name.compareTo(itclMemberFunc2.member.name);
                if (n2 < 0) {
                    Util.InsertListElem(itcl_ListElem, itclMemberFunc);
                    itclMemberFunc = null;
                    break;
                }
                if (n2 == 0) {
                    itclMemberFunc = null;
                    break;
                }
                itcl_ListElem = Util.NextListElem(itcl_ListElem);
            }
            if (itclMemberFunc == null) continue;
            Util.AppendList(itcl_List, itclMemberFunc);
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        itcl_ListElem = Util.FirstListElem(itcl_List);
        while (itcl_ListElem != null) {
            itclMemberFunc = (ItclMemberFunc)Util.GetListValue(itcl_ListElem);
            stringBuffer.append("\n  ");
            Methods.GetMemberFuncUsage(itclMemberFunc, itclObject, stringBuffer);
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
        }
        Util.DeleteList(itcl_List);
        return stringBuffer.toString();
    }

    static void TraceThisVar(ItclObject itclObject, Interp interp, String string, String string2, int n) throws TclException {
        if ((n & 0x10) != 0) {
            String string3 = itclObject.accessCmd != null ? interp.getCommandFullName(itclObject.w_accessCmd) : "";
            interp.setVar(string, TclString.newInstance(string3), 0);
            return;
        }
        if ((n & 0x20) != 0) {
            throw new TclException(interp, "variable \"this\" cannot be modified");
        }
    }

    static void DestroyObject(ItclObject itclObject) {
        ItclClass itclClass = itclObject.classDefn;
        Itcl_InterpState itcl_InterpState = Util.SaveInterpState(itclClass.interp, 0);
        try {
            Objects.DestructObject(itclClass.interp, itclObject, ItclInt.IGNORE_ERRS);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        Util.RestoreInterpState(itclClass.interp, itcl_InterpState);
        if (itclObject.accessCmd != null) {
            itclClass.info.objects.remove(itclObject.accessCmd);
            itclObject.accessCmd = null;
        }
        Util.ReleaseData(itclObject);
    }

    static void FreeObject(ItclObject itclObject) {
        int n;
        Interp interp = itclObject.classDefn.interp;
        Itcl_InterpState itcl_InterpState = Util.SaveInterpState(interp, 0);
        ItclHierIter itclHierIter = new ItclHierIter();
        Class.InitHierIter(itclHierIter, itclObject.classDefn);
        ItclClass itclClass = Class.AdvanceHierIter(itclHierIter);
        while (itclClass != null) {
            n = 0;
            ItclContext itclContext = new ItclContext(interp);
            try {
                Methods.PushContext(interp, null, itclClass, itclObject, itclContext);
            }
            catch (TclException tclException) {
                n = 1;
            }
            if (n == 0) {
                for (Map.Entry entry : itclClass.variables.entrySet()) {
                    String string = (String)entry.getKey();
                    ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
                    if ((itclVarDefn.member.flags & ItclInt.THIS_VAR) != 0) {
                        if (itclClass != itclObject.classDefn) continue;
                        try {
                            interp.unsetVar(itclVarDefn.member.fullname, 0);
                        }
                        catch (TclException tclException) {}
                        continue;
                    }
                    if ((itclVarDefn.member.flags & ItclInt.COMMON) != 0) continue;
                    try {
                        interp.unsetVar(itclVarDefn.member.fullname, 0);
                    }
                    catch (TclException tclException) {}
                }
                Methods.PopContext(interp, itclContext);
            }
            itclClass = Class.AdvanceHierIter(itclHierIter);
        }
        Class.DeleteHierIter(itclHierIter);
        for (n = 0; n < itclObject.dataSize; ++n) {
            if (itclObject.data[n] == null) continue;
            itclObject.data[n] = null;
        }
        Util.RestoreInterpState(interp, itcl_InterpState);
        itclObject.data = null;
        if (itclObject.constructed != null) {
            itclObject.constructed.clear();
            itclObject.constructed = null;
        }
        if (itclObject.destructed != null) {
            itclObject.destructed.clear();
            itclObject.destructed = null;
        }
        Util.ReleaseData(itclObject.classDefn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void CreateObjVar(Interp interp, ItclVarDefn itclVarDefn, ItclObject itclObject) {
        Var var = Migrate.NewVar();
        ItclAccess.createObjVar(var, itclVarDefn.member.name, itclVarDefn.member.classDefn.namesp, dangleTable);
        ItclVarLookup itclVarLookup = (ItclVarLookup)itclObject.classDefn.resolveVars.get(itclVarDefn.member.fullname);
        if (itclVarLookup != null) {
            itclObject.data[itclVarLookup.index] = var;
        }
        if (itclVarDefn.init != null) {
            ItclContext itclContext = new ItclContext(interp);
            try {
                Methods.PushContext(interp, null, itclVarDefn.member.classDefn, itclObject, itclContext);
                interp.setVar(itclVarDefn.member.fullname, TclString.newInstance(itclVarDefn.init), 0);
            }
            catch (TclException tclException) {
            }
            finally {
                Methods.PopContext(interp, itclContext);
            }
        }
    }

    static Var ScopedVarResolver(Interp interp, String string, Namespace namespace, int n) throws TclException {
        if (!string.startsWith("@itcl")) {
            return null;
        }
        TclObject tclObject = TclString.newInstance(string);
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        if (tclObjectArray.length != 3) {
            throw new TclException(interp, "scoped variable \"" + string + "\" is malformed: should be: @itcl object variable");
        }
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, tclObjectArray[1].toString(), null, 0);
        if (!Objects.IsObject(wrappedCommand)) {
            throw new TclException(interp, "can't resolve scoped variable \"" + string + "\": can't find object " + tclObjectArray[1]);
        }
        ItclObject itclObject = Objects.GetContextFromObject(wrappedCommand);
        ItclVarLookup itclVarLookup = (ItclVarLookup)itclObject.classDefn.resolveVars.get(tclObjectArray[2].toString());
        if (itclVarLookup == null) {
            throw new TclException(interp, "can't resolve scoped variable \"" + string + "\": no such data member " + tclObjectArray[2]);
        }
        return itclObject.data[itclVarLookup.index];
    }

    static class ScopedVarResolverImpl
    implements Resolver {
        ScopedVarResolverImpl() {
        }

        @Override
        public WrappedCommand resolveCmd(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return null;
        }

        @Override
        public Var resolveVar(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return Objects.ScopedVarResolver(interp, string, namespace, n);
        }
    }

    static class HandleInstanceCmd
    implements CommandWithDispose {
        ItclObject contextObj;
        boolean deleteToken;

        HandleInstanceCmd(ItclObject itclObject) {
            this.contextObj = itclObject;
            this.deleteToken = false;
        }

        @Override
        public void disposeCmd() {
            if (!this.deleteToken) {
                Objects.DestroyObject(this.contextObj);
            } else {
                Util.ReleaseData(this.contextObj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Object object;
            if (tclObjectArray.length < 2) {
                throw new TclException(interp, "wrong # args: should be one of..." + Objects.ReportObjectUsage(interp, this.contextObj));
            }
            String string = tclObjectArray[1].toString();
            ItclMemberFunc itclMemberFunc = (ItclMemberFunc)this.contextObj.classDefn.resolveCmds.get(string);
            if (itclMemberFunc != null) {
                if ((itclMemberFunc.member.flags & ItclInt.COMMON) != 0) {
                    itclMemberFunc = null;
                } else if (itclMemberFunc.member.protection != 1 && !Util.CanAccessFunc(itclMemberFunc, (Namespace)(object = Util.GetTrueNamespace(interp, itclMemberFunc.member.classDefn.info)))) {
                    itclMemberFunc = null;
                }
            }
            if (itclMemberFunc == null && !string.equals("info")) {
                throw new TclException(interp, "bad option \"" + string + "\": should be one of..." + Objects.ReportObjectUsage(interp, this.contextObj));
            }
            ItclObjectInfo itclObjectInfo = this.contextObj.classDefn.info;
            ItclContext itclContext = new ItclContext(interp);
            Methods.PushContext(interp, null, this.contextObj.classDefn, this.contextObj, itclContext);
            try {
                CallFrame callFrame = itclContext.frame;
                Util.PushStack(callFrame, itclObjectInfo.transparentFrames);
                if (string.equals("info")) {
                    ItclAccess.setProcCallFrameFalse(callFrame);
                }
                object = Util.CreateArgs(interp, null, tclObjectArray, 1);
                TclObject[] tclObjectArray2 = TclList.getElements(interp, (TclObject)object);
                Util.EvalArgs(interp, tclObjectArray2);
            }
            finally {
                Util.PopStack(itclObjectInfo.transparentFrames);
                Methods.PopContext(interp, itclContext);
            }
        }
    }
}

