/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.BiCmds;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Itcl_Stack;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.ProtectionCmdInfo;
import tcl.pkg.itcl.Util;

class Parse {
    Parse() {
    }

    public static void ParseInit(Interp interp, ItclObjectInfo itclObjectInfo) throws TclException {
        Namespace namespace = Namespace.createNamespace(interp, "::itcl::parser", null);
        if (namespace == null) {
            throw new TclException(interp, "  (cannot initialize itcl parser)");
        }
        interp.createCommand("::itcl::parser::inherit", new ClassInheritCmd());
        interp.createCommand("::itcl::parser::constructor", new ClassConstructorCmd());
        interp.createCommand("::itcl::parser::destructor", new ClassDestructorCmd());
        interp.createCommand("::itcl::parser::method", new ClassMethodCmd());
        interp.createCommand("::itcl::parser::proc", new ClassProcCmd());
        interp.createCommand("::itcl::parser::common", new ClassCommonCmd());
        interp.createCommand("::itcl::parser::variable", new ClassVariableCmd());
        ProtectionCmdInfo protectionCmdInfo = new ProtectionCmdInfo();
        protectionCmdInfo.pLevel = 1;
        protectionCmdInfo.info = itclObjectInfo;
        interp.createCommand("::itcl::parser::public", new ClassProtectionCmd(protectionCmdInfo));
        protectionCmdInfo = new ProtectionCmdInfo();
        protectionCmdInfo.pLevel = 2;
        protectionCmdInfo.info = itclObjectInfo;
        interp.createCommand("::itcl::parser::protected", new ClassProtectionCmd(protectionCmdInfo));
        protectionCmdInfo = new ProtectionCmdInfo();
        protectionCmdInfo.pLevel = 3;
        protectionCmdInfo.info = itclObjectInfo;
        interp.createCommand("::itcl::parser::private", new ClassProtectionCmd(protectionCmdInfo));
        ParseVarResolverImpl parseVarResolverImpl = new ParseVarResolverImpl();
        Namespace.setNamespaceResolver(namespace, parseVarResolverImpl);
        interp.createCommand("::itcl::class", new ClassCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
    }

    static void ClassInheritCmdInheritError(Interp interp, ItclClass itclClass, String string) throws TclException {
        Namespace.popCallFrame(interp);
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.bases);
        while (itcl_ListElem != null) {
            ItclClass itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
            Util.ReleaseData(itclClass2);
            itcl_ListElem = Util.DeleteListElem(itcl_ListElem);
        }
        throw new TclException(interp, string);
    }

    static Var ParseVarResolver(Interp interp, String string, Namespace namespace, int n) throws TclException {
        ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
        ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
        ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string);
        if (itclVarLookup != null && (itclVarLookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
            if (!itclVarLookup.accessible) {
                throw new TclException(interp, "can't access \"" + string + "\": " + Util.ProtectionStr(itclVarLookup.vdefn.member.protection) + " variable");
            }
            return itclVarLookup.common;
        }
        return null;
    }

    static void FreeParserCommandData(Object object) {
    }

    public static class ParseVarResolverImpl
    implements Resolver {
        @Override
        public WrappedCommand resolveCmd(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return null;
        }

        @Override
        public Var resolveVar(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return Parse.ParseVarResolver(interp, string, namespace, n);
        }
    }

    public static class ClassCommonCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject;
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            if (tclObjectArray.length < 2 || tclObjectArray.length > 3) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "varname ?init?");
            }
            String string = tclObjectArray[1].toString();
            if (string.indexOf("::") != -1) {
                throw new TclException(interp, "bad variable name \"" + string + "\"");
            }
            String string2 = null;
            if (tclObjectArray.length >= 3) {
                string2 = tclObjectArray[2].toString();
            }
            ItclVarDefn itclVarDefn = Class.CreateVarDefn(interp, itclClass, string, string2, null);
            itclVarDefn.member.flags |= ItclInt.COMMON;
            Namespace namespace = itclClass.namesp;
            Var var = Migrate.NewVar();
            ItclAccess.createCommonVar(var, itclVarDefn.member.name, namespace, namespace.varTable);
            namespace.varTable.put(itclVarDefn.member.name, var);
            Class.BuildVirtualTables(itclClass);
            if (string2 != null && (tclObject = interp.setVar(itclVarDefn.member.name.toString(), TclString.newInstance(string2), 2)) == null) {
                throw new TclException(interp, "cannot initialize common variable \"" + itclVarDefn.member.name + "\"");
            }
        }
    }

    public static class ClassVariableCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            String string;
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            int n = Util.Protection(interp, 0);
            if (n == 1) {
                if (tclObjectArray.length < 2 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "name ?init? ?config?");
                }
            } else if (tclObjectArray.length < 2 || tclObjectArray.length > 3) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name ?init?");
            }
            if ((string = tclObjectArray[1].toString()).indexOf("::") != -1) {
                throw new TclException(interp, "bad variable name \"" + string + "\"");
            }
            String string2 = null;
            String string3 = null;
            if (tclObjectArray.length >= 3) {
                string2 = tclObjectArray[2].toString();
            }
            if (tclObjectArray.length >= 4) {
                string3 = tclObjectArray[3].toString();
            }
            ItclVarDefn itclVarDefn = Class.CreateVarDefn(interp, itclClass, string, string2, string3);
        }
    }

    public static class ClassProcCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            if (tclObjectArray.length < 2 || tclObjectArray.length > 4) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name ?args? ?body?");
            }
            String string = tclObjectArray[1].toString();
            String string2 = null;
            String string3 = null;
            if (tclObjectArray.length >= 3) {
                string2 = tclObjectArray[2].toString();
            }
            if (tclObjectArray.length >= 4) {
                string3 = tclObjectArray[3].toString();
            }
            Methods.CreateProc(interp, itclClass, string, string2, string3);
        }
    }

    public static class ClassMethodCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            if (tclObjectArray.length < 2 || tclObjectArray.length > 4) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name ?args? ?body?");
            }
            String string = tclObjectArray[1].toString();
            String string2 = null;
            String string3 = null;
            if (tclObjectArray.length >= 3) {
                string2 = tclObjectArray[2].toString();
            }
            if (tclObjectArray.length == 4) {
                string3 = tclObjectArray[3].toString();
            }
            Methods.CreateMethod(interp, itclClass, string, string2, string3);
        }
    }

    public static class ClassDestructorCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "body");
            }
            String string = tclObjectArray[0].toString();
            String string2 = tclObjectArray[1].toString();
            if (itclClass.functions.get(string) != null) {
                throw new TclException(interp, "\"" + string + "\" already defined in class \"" + itclClass.fullname + "\"");
            }
            Methods.CreateMethod(interp, itclClass, string, null, string2);
        }
    }

    public static class ClassConstructorCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            String string;
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "args ?init? body");
            }
            String string2 = tclObjectArray[0].toString();
            if (itclClass.functions.get(string2) != null) {
                throw new TclException(interp, "\"" + string2 + "\" already defined in class \"" + itclClass.fullname + "\"");
            }
            String string3 = tclObjectArray[1].toString();
            if (tclObjectArray.length == 3) {
                string = tclObjectArray[2].toString();
            } else {
                itclClass.initCode = tclObjectArray[2];
                itclClass.initCode.preserve();
                string = tclObjectArray[3].toString();
            }
            Methods.CreateMethod(interp, itclClass, string2, string3, string);
        }
    }

    public static class ClassProtectionCmd
    implements CommandWithDispose {
        ProtectionCmdInfo pInfo;

        public ClassProtectionCmd(ProtectionCmdInfo protectionCmdInfo) {
            this.pInfo = protectionCmdInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "command ?arg arg...?");
            }
            int n = Util.Protection(interp, this.pInfo.pLevel);
            try {
                if (tclObjectArray.length == 2) {
                    interp.eval(tclObjectArray[1].toString());
                } else {
                    TclObject tclObject = Util.CreateArgs(interp, null, tclObjectArray, 1);
                    TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObject);
                    Util.EvalArgs(interp, tclObjectArray2);
                }
            }
            catch (TclException tclException) {
                interp.addErrorInfo("\n    (" + tclObjectArray[0].toString() + " body line " + interp.getErrorLine() + ")");
            }
            finally {
                Util.Protection(interp, n);
            }
        }

        @Override
        public void disposeCmd() {
            Parse.FreeParserCommandData(this.pInfo);
        }
    }

    public static class ClassInheritCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            ItclClass itclClass2;
            ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass itclClass3 = (ItclClass)Util.PeekStack(itclObjectInfo.cdefnStack);
            boolean bl = true;
            if (tclObjectArray.length < 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "class ?class...?");
            }
            Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass3.bases);
            if (itcl_ListElem != null) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("inheritance \"");
                while (itcl_ListElem != null) {
                    ItclClass itclClass4 = (ItclClass)Util.GetListValue(itcl_ListElem);
                    stringBuffer.append(itclClass4.name);
                    stringBuffer.append(" ");
                    itcl_ListElem = Util.NextListElem(itcl_ListElem);
                }
                stringBuffer.append("\" already defined for class \"");
                stringBuffer.append(itclClass3.fullname);
                stringBuffer.append("\"");
                throw new TclException(interp, stringBuffer.toString());
            }
            CallFrame callFrame = ItclAccess.newCallFrame(interp);
            Namespace.pushCallFrame(interp, callFrame, itclClass3.namesp.parent, false);
            for (int i = 1; i < tclObjectArray.length; ++i) {
                String string = tclObjectArray[i].toString();
                itclClass2 = Class.FindClass(interp, string, true);
                if (itclClass2 == null) {
                    String string2 = interp.getResult().toString();
                    interp.resetResult();
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append("cannot inherit from \"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                    if (string2.length() > 0) {
                        stringBuffer.append(" (");
                        stringBuffer.append(string2);
                        stringBuffer.append(")");
                    }
                    Parse.ClassInheritCmdInheritError(interp, itclClass3, stringBuffer.toString());
                }
                if (itclClass2 == itclClass3) {
                    Parse.ClassInheritCmdInheritError(interp, itclClass3, "class \"" + itclClass3.name + "\" cannot inherit from itself");
                }
                Util.AppendList(itclClass3.bases, itclClass2);
                Util.PreserveData(itclClass2);
            }
            itcl_ListElem = Util.FirstListElem(itclClass3.bases);
            while (itcl_ListElem != null) {
                Itcl_ListElem itcl_ListElem2 = Util.NextListElem(itcl_ListElem);
                while (itcl_ListElem2 != null) {
                    if (Util.GetListValue(itcl_ListElem) == Util.GetListValue(itcl_ListElem2)) {
                        itclClass = (ItclClass)Util.GetListValue(itcl_ListElem);
                        String string = "class \"" + itclClass3.fullname + "\" cannot inherit base class \"" + itclClass.fullname + "\" more than once";
                        Parse.ClassInheritCmdInheritError(interp, itclClass3, string);
                    }
                    itcl_ListElem2 = Util.NextListElem(itcl_ListElem2);
                }
                itcl_ListElem = Util.NextListElem(itcl_ListElem);
            }
            ItclHierIter itclHierIter = new ItclHierIter();
            Class.InitHierIter(itclHierIter, itclClass3);
            itclClass = Class.AdvanceHierIter(itclHierIter);
            itclClass = Class.AdvanceHierIter(itclHierIter);
            while (itclClass != null) {
                String string = itclClass3.heritage.put(itclClass, "");
                boolean bl2 = bl = string == null;
                if (!bl) break;
                itclClass = Class.AdvanceHierIter(itclHierIter);
            }
            Class.DeleteHierIter(itclHierIter);
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer(64);
                ItclClass itclClass5 = itclClass;
                stringBuffer.append("class \"");
                stringBuffer.append(itclClass3.fullname);
                stringBuffer.append("\" inherits base class \"");
                stringBuffer.append(itclClass5.fullname);
                stringBuffer.append("\" more than once:");
                itclClass = itclClass3;
                Itcl_Stack itcl_Stack = new Itcl_Stack();
                Util.InitStack(itcl_Stack);
                Util.PushStack(itclClass, itcl_Stack);
                while (Util.GetStackSize(itcl_Stack) > 0) {
                    itclClass = (ItclClass)Util.PopStack(itcl_Stack);
                    if (itclClass == itclClass5) {
                        stringBuffer.append("\n  ");
                        for (int i = 0; i < Util.GetStackSize(itcl_Stack); ++i) {
                            if (Util.GetStackValue(itcl_Stack, i) != null) continue;
                            itclClass = (ItclClass)Util.GetStackValue(itcl_Stack, i - 1);
                            stringBuffer.append(itclClass.name);
                            stringBuffer.append("->");
                        }
                        stringBuffer.append(itclClass5.name);
                        continue;
                    }
                    if (itclClass == null) {
                        Util.PopStack(itcl_Stack);
                        continue;
                    }
                    itcl_ListElem = Util.LastListElem(itclClass.bases);
                    if (itcl_ListElem == null) continue;
                    Util.PushStack(itclClass, itcl_Stack);
                    Util.PushStack(null, itcl_Stack);
                    while (itcl_ListElem != null) {
                        Util.PushStack(Util.GetListValue(itcl_ListElem), itcl_Stack);
                        itcl_ListElem = Util.PrevListElem(itcl_ListElem);
                    }
                }
                Util.DeleteStack(itcl_Stack);
                Parse.ClassInheritCmdInheritError(interp, itclClass3, stringBuffer.toString());
            }
            itcl_ListElem = Util.FirstListElem(itclClass3.bases);
            while (itcl_ListElem != null) {
                itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
                Util.AppendList(itclClass2.derived, itclClass3);
                Util.PreserveData(itclClass3);
                itcl_ListElem = Util.NextListElem(itcl_ListElem);
            }
            Namespace.popCallFrame(interp);
        }
    }

    public static class ClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        ClassCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 3) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name { definition }");
            }
            String string = tclObjectArray[1].toString();
            if (string.length() == 0) {
                throw new TclException(interp, "invalid class name \"\"");
            }
            Namespace namespace = Namespace.findNamespace(interp, "::itcl::parser", null, 512);
            if (namespace == null) {
                interp.addErrorInfo("\n    (while parsing class definition for \"" + string + "\")");
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclClass itclClass = Class.CreateClass(interp, string, this.info);
            try {
                Namespace.importList(interp, itclClass.namesp, "::itcl::builtin::*", true);
            }
            catch (TclException tclException) {
                interp.addErrorInfo("\n    (while installing built-in commands for class \"" + string + "\")");
                Namespace.deleteNamespace(itclClass.namesp);
                throw tclException;
            }
            Util.PushStack(itclClass, this.info.cdefnStack);
            TclException tclException = null;
            boolean bl = false;
            try {
                CallFrame callFrame = ItclAccess.newCallFrame(interp);
                Namespace.pushCallFrame(interp, callFrame, namespace, false);
                bl = true;
                interp.eval(tclObjectArray[2].toString());
            }
            catch (TclException tclException2) {
                tclException = tclException2;
            }
            finally {
                if (bl) {
                    Namespace.popCallFrame(interp);
                }
            }
            Util.PopStack(this.info.cdefnStack);
            if (tclException != null) {
                interp.addErrorInfo("\n    (class \"" + string + "\" body line " + interp.getErrorLine() + ")");
                Namespace.deleteNamespace(itclClass.namesp);
                throw tclException;
            }
            try {
                BiCmds.InstallBiMethods(interp, itclClass);
            }
            catch (TclException tclException3) {
                Namespace.deleteNamespace(itclClass.namesp);
                throw tclException3;
            }
            Class.BuildVirtualTables(itclClass);
            interp.resetResult();
        }
    }
}

