/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.Hashtable;
import java.util.Stack;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclEventuallyFreed;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclPreservedData;
import tcl.pkg.itcl.Itcl_InterpState;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Itcl_Stack;
import tcl.pkg.itcl.Migrate;

class Util {
    static Itcl_ListElem listPool = null;
    static int listPoolLen = 0;
    static Hashtable ItclPreservedList = new Hashtable();
    static int VALID_LIST = 33213968;
    static int LIST_POOL_SIZE = 200;
    static int STATE_VALID = 19083792;

    Util() {
    }

    static void Assert(boolean bl, String string) {
        if (!bl) {
            throw new TclRuntimeError("Itcl Assertion failed: \"" + string + "\"");
        }
    }

    static void InitStack(Itcl_Stack itcl_Stack) {
        itcl_Stack.s = new Stack();
    }

    static void DeleteStack(Itcl_Stack itcl_Stack) {
        itcl_Stack.s.clear();
        itcl_Stack.s = null;
    }

    static void PushStack(Object object, Itcl_Stack itcl_Stack) {
        itcl_Stack.s.push(object);
    }

    static Object PopStack(Itcl_Stack itcl_Stack) {
        if (itcl_Stack.s != null && !itcl_Stack.s.empty()) {
            return itcl_Stack.s.pop();
        }
        return null;
    }

    static Object PeekStack(Itcl_Stack itcl_Stack) {
        if (itcl_Stack.s == null) {
            return null;
        }
        return itcl_Stack.s.peek();
    }

    static Object GetStackValue(Itcl_Stack itcl_Stack, int n) {
        if (itcl_Stack.s == null) {
            return null;
        }
        return itcl_Stack.s.elementAt(n);
    }

    static int GetStackSize(Itcl_Stack itcl_Stack) {
        if (itcl_Stack.s == null) {
            return 0;
        }
        return itcl_Stack.s.size();
    }

    static void InitList(Itcl_List itcl_List) {
        itcl_List.validate = VALID_LIST;
        itcl_List.num = 0;
        itcl_List.head = null;
        itcl_List.tail = null;
    }

    static void DeleteList(Itcl_List itcl_List) {
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem itcl_ListElem = itcl_List.head;
        while (itcl_ListElem != null) {
            itcl_ListElem = Util.DeleteListElem(itcl_ListElem);
        }
        itcl_List.validate = 0;
    }

    static Itcl_ListElem CreateListElem(Itcl_List itcl_List) {
        Itcl_ListElem itcl_ListElem;
        if (listPoolLen > 0) {
            itcl_ListElem = listPool;
            listPool = itcl_ListElem.next;
            --listPoolLen;
        } else {
            itcl_ListElem = new Itcl_ListElem();
        }
        itcl_ListElem.owner = itcl_List;
        itcl_ListElem.value = null;
        itcl_ListElem.next = null;
        itcl_ListElem.prev = null;
        return itcl_ListElem;
    }

    static Itcl_ListElem DeleteListElem(Itcl_ListElem itcl_ListElem) {
        Itcl_ListElem itcl_ListElem2 = itcl_ListElem.next;
        if (itcl_ListElem.prev != null) {
            itcl_ListElem.prev.next = itcl_ListElem.next;
        }
        if (itcl_ListElem.next != null) {
            itcl_ListElem.next.prev = itcl_ListElem.prev;
        }
        Itcl_List itcl_List = itcl_ListElem.owner;
        if (itcl_ListElem == itcl_List.head) {
            itcl_List.head = itcl_ListElem.next;
        }
        if (itcl_ListElem == itcl_List.tail) {
            itcl_List.tail = itcl_ListElem.prev;
        }
        --itcl_List.num;
        if (listPoolLen < LIST_POOL_SIZE) {
            itcl_ListElem.next = listPool;
            listPool = itcl_ListElem;
            ++listPoolLen;
        } else {
            itcl_ListElem = null;
        }
        return itcl_ListElem2;
    }

    static Itcl_ListElem InsertList(Itcl_List itcl_List, Object object) {
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem itcl_ListElem = Util.CreateListElem(itcl_List);
        itcl_ListElem.value = object;
        itcl_ListElem.next = itcl_List.head;
        itcl_ListElem.prev = null;
        if (itcl_List.head != null) {
            itcl_List.head.prev = itcl_ListElem;
        }
        itcl_List.head = itcl_ListElem;
        if (itcl_List.tail == null) {
            itcl_List.tail = itcl_ListElem;
        }
        ++itcl_List.num;
        return itcl_ListElem;
    }

    static Itcl_ListElem InsertListElem(Itcl_ListElem itcl_ListElem, Object object) {
        Itcl_List itcl_List = itcl_ListElem.owner;
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem itcl_ListElem2 = Util.CreateListElem(itcl_List);
        itcl_ListElem2.value = object;
        itcl_ListElem2.prev = itcl_ListElem.prev;
        if (itcl_ListElem2.prev != null) {
            itcl_ListElem2.prev.next = itcl_ListElem2;
        }
        itcl_ListElem2.next = itcl_ListElem;
        itcl_ListElem.prev = itcl_ListElem2;
        if (itcl_List.head == itcl_ListElem) {
            itcl_List.head = itcl_ListElem2;
        }
        if (itcl_List.tail == null) {
            itcl_List.tail = itcl_ListElem2;
        }
        ++itcl_List.num;
        return itcl_ListElem2;
    }

    static Itcl_ListElem AppendList(Itcl_List itcl_List, Object object) {
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem itcl_ListElem = Util.CreateListElem(itcl_List);
        itcl_ListElem.value = object;
        itcl_ListElem.prev = itcl_List.tail;
        itcl_ListElem.next = null;
        if (itcl_List.tail != null) {
            itcl_List.tail.next = itcl_ListElem;
        }
        itcl_List.tail = itcl_ListElem;
        if (itcl_List.head == null) {
            itcl_List.head = itcl_ListElem;
        }
        ++itcl_List.num;
        return itcl_ListElem;
    }

    static Itcl_ListElem AppendListElem(Itcl_ListElem itcl_ListElem, Object object) {
        Itcl_List itcl_List = itcl_ListElem.owner;
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem itcl_ListElem2 = Util.CreateListElem(itcl_List);
        itcl_ListElem2.value = object;
        itcl_ListElem2.next = itcl_ListElem.next;
        if (itcl_ListElem2.next != null) {
            itcl_ListElem2.next.prev = itcl_ListElem2;
        }
        itcl_ListElem2.prev = itcl_ListElem;
        itcl_ListElem.next = itcl_ListElem2;
        if (itcl_List.tail == itcl_ListElem) {
            itcl_List.tail = itcl_ListElem2;
        }
        if (itcl_List.head == null) {
            itcl_List.head = itcl_ListElem2;
        }
        ++itcl_List.num;
        return itcl_ListElem2;
    }

    static void SetListValue(Itcl_ListElem itcl_ListElem, Object object) {
        Itcl_List itcl_List = itcl_ListElem.owner;
        Util.Assert(itcl_List.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Util.Assert(itcl_ListElem != null, "elem != null");
        itcl_ListElem.value = object;
    }

    static Itcl_ListElem NextListElem(Itcl_ListElem itcl_ListElem) {
        return itcl_ListElem.next;
    }

    static Itcl_ListElem PrevListElem(Itcl_ListElem itcl_ListElem) {
        return itcl_ListElem.prev;
    }

    static Itcl_ListElem FirstListElem(Itcl_List itcl_List) {
        return itcl_List.head;
    }

    static Itcl_ListElem LastListElem(Itcl_List itcl_List) {
        return itcl_List.tail;
    }

    static int GetListLength(Itcl_List itcl_List) {
        return itcl_List.num;
    }

    static Object GetListValue(Itcl_ListElem itcl_ListElem) {
        return itcl_ListElem.value;
    }

    static void EventuallyFree(ItclEventuallyFreed itclEventuallyFreed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void PreserveData(ItclEventuallyFreed itclEventuallyFreed) {
        if (itclEventuallyFreed == null) {
            return;
        }
        Hashtable hashtable = ItclPreservedList;
        synchronized (hashtable) {
            ItclPreservedData itclPreservedData = (ItclPreservedData)ItclPreservedList.get(itclEventuallyFreed);
            if (itclPreservedData == null) {
                itclPreservedData = new ItclPreservedData();
                itclPreservedData.fobj = itclEventuallyFreed;
                itclPreservedData.usage = 0;
                ItclPreservedList.put(itclEventuallyFreed, itclPreservedData);
            }
            if (itclPreservedData.usage >= 0) {
                ++itclPreservedData.usage;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ReleaseData(ItclEventuallyFreed itclEventuallyFreed) {
        boolean bl = false;
        if (itclEventuallyFreed == null) {
            return;
        }
        Hashtable hashtable = ItclPreservedList;
        synchronized (hashtable) {
            ItclPreservedData itclPreservedData = (ItclPreservedData)ItclPreservedList.get(itclEventuallyFreed);
            Util.Assert(itclPreservedData != null, "chunk != null");
            if (itclPreservedData.usage > 0 && --itclPreservedData.usage == 0) {
                itclPreservedData.usage = -1;
                bl = true;
            }
        }
        if (bl) {
            itclEventuallyFreed.eventuallyFreed();
            hashtable = ItclPreservedList;
            synchronized (hashtable) {
                ItclPreservedList.remove(itclEventuallyFreed);
            }
        }
    }

    static Itcl_InterpState SaveInterpState(Interp interp, int n) {
        TclObjectBase tclObjectBase = null;
        Itcl_InterpState itcl_InterpState = new Itcl_InterpState();
        itcl_InterpState.validate = STATE_VALID;
        itcl_InterpState.status = n;
        itcl_InterpState.errorInfo = null;
        itcl_InterpState.errorCode = null;
        itcl_InterpState.objResult = interp.getResult();
        itcl_InterpState.objResult.preserve();
        try {
            tclObjectBase = null;
            tclObjectBase = interp.getVar("errorInfo", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObjectBase != null && tclObjectBase.toString().length() > 0) {
            itcl_InterpState.errorInfo = tclObjectBase;
            itcl_InterpState.errorInfo.preserve();
        }
        try {
            tclObjectBase = null;
            tclObjectBase = interp.getVar("errorCode", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObjectBase != null && tclObjectBase.toString().length() > 0) {
            itcl_InterpState.errorCode = tclObjectBase;
            itcl_InterpState.errorCode.preserve();
        }
        interp.resetResult();
        return itcl_InterpState;
    }

    static int RestoreInterpState(Interp interp, Itcl_InterpState itcl_InterpState) {
        Itcl_InterpState itcl_InterpState2 = itcl_InterpState;
        Util.Assert(itcl_InterpState2.validate == STATE_VALID, "info.validate == Util.STATE_VALID");
        interp.resetResult();
        if (itcl_InterpState2.errorInfo != null) {
            interp.addErrorInfo(itcl_InterpState2.errorInfo.toString());
            itcl_InterpState2.errorInfo.release();
            itcl_InterpState2.errorInfo = null;
        }
        if (itcl_InterpState2.errorCode != null) {
            interp.setErrorCode(itcl_InterpState2.errorCode);
            itcl_InterpState2.errorCode.release();
            itcl_InterpState2.errorCode = null;
        }
        interp.setResult(itcl_InterpState2.objResult);
        itcl_InterpState2.objResult.release();
        itcl_InterpState2.objResult = null;
        int n = itcl_InterpState2.status;
        itcl_InterpState2.validate = 0;
        itcl_InterpState2 = null;
        return n;
    }

    static void DiscardInterpState(Itcl_InterpState itcl_InterpState) {
        Itcl_InterpState itcl_InterpState2 = itcl_InterpState;
        Util.Assert(itcl_InterpState2.validate == STATE_VALID, "info.validate == Util.STATE_VALID");
        if (itcl_InterpState2.errorInfo != null) {
            itcl_InterpState2.errorInfo.release();
            itcl_InterpState2.errorInfo = null;
        }
        if (itcl_InterpState2.errorCode != null) {
            itcl_InterpState2.errorCode.release();
            itcl_InterpState2.errorCode = null;
        }
        itcl_InterpState2.objResult.release();
        itcl_InterpState2.objResult = null;
        itcl_InterpState2.validate = 0;
        itcl_InterpState2 = null;
    }

    static int Protection(Interp interp, int n) {
        ItclObjectInfo itclObjectInfo = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
        Util.Assert(itclObjectInfo != null, "info != null");
        int n2 = itclObjectInfo.protection;
        if (n != 0) {
            Util.Assert(n == 1 || n == 2 || n == 3 || n == 4, "newLevel Protection");
            itclObjectInfo.protection = n;
        }
        return n2;
    }

    static String ProtectionStr(int n) {
        switch (n) {
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "private";
            }
        }
        return "<bad-protection-code>";
    }

    static boolean CanAccess(ItclMember itclMember, Namespace namespace) {
        if (itclMember.protection == 1) {
            return true;
        }
        if (itclMember.protection == 3) {
            return itclMember.classDefn.namesp == namespace;
        }
        Util.Assert(itclMember.protection == 2, "member.protection == Itcl.PROTECTED");
        if (Class.IsClassNamespace(namespace)) {
            ItclClass itclClass = Class.GetClassFromNamespace(namespace);
            Object v = itclClass.heritage.get(itclMember.classDefn);
            if (v != null) {
                return true;
            }
        }
        return false;
    }

    static boolean CanAccessFunc(ItclMemberFunc itclMemberFunc, Namespace namespace) {
        if (Util.CanAccess(itclMemberFunc.member, namespace)) {
            return true;
        }
        if ((itclMemberFunc.member.flags & ItclInt.COMMON) == 0 && Class.IsClassNamespace(namespace)) {
            Object v;
            ItclClass itclClass = itclMemberFunc.member.classDefn;
            ItclClass itclClass2 = Class.GetClassFromNamespace(namespace);
            if (itclClass.heritage.get(itclClass2) != null && (v = itclClass2.resolveCmds.get(itclMemberFunc.member.name)) != null) {
                ItclMemberFunc itclMemberFunc2 = (ItclMemberFunc)v;
                if ((itclMemberFunc2.member.flags & ItclInt.COMMON) == 0 && itclMemberFunc2.member.protection < 3) {
                    return true;
                }
            }
        }
        return false;
    }

    static Namespace GetTrueNamespace(Interp interp, ItclObjectInfo itclObjectInfo) {
        boolean bl = false;
        CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
        for (int i = Util.GetStackSize(itclObjectInfo.transparentFrames) - 1; i >= 0; --i) {
            CallFrame callFrame2 = (CallFrame)Util.GetStackValue(itclObjectInfo.transparentFrames, i);
            if (callFrame != callFrame2) continue;
            bl = true;
            break;
        }
        Namespace namespace = bl ? ((callFrame = Migrate.GetCallFrame(interp, 1)) != null ? ItclAccess.getCallFrameNamespace(callFrame) : Namespace.getGlobalNamespace(interp)) : Namespace.getCurrentNamespace(interp);
        return namespace;
    }

    static ParseNamespPathResult ParseNamespPath(String string) {
        String string2;
        String string3;
        int n = string.length();
        while (--n > 0 && (string.charAt(n) != ':' || string.charAt(n - 1) != ':')) {
        }
        if (n > 0) {
            string3 = string.substring(n + 1);
            while (n > 0 && string.charAt(n - 1) == ':') {
                --n;
            }
            string2 = string.substring(0, n);
        } else {
            string3 = string;
            string2 = null;
        }
        return new ParseNamespPathResult(string2, string3);
    }

    static DecodeScopedCommandResult DecodeScopedCommand(Interp interp, String string) throws TclException {
        Object object;
        Namespace namespace = null;
        int n = string.length();
        TclObject[] tclObjectArray = null;
        TclException tclException = null;
        String string2 = string;
        if (n > 17 && string.startsWith("namespace ")) {
            int n2;
            for (n2 = 9; n2 < n && string.charAt(n2) == ' '; ++n2) {
            }
            if (n2 + 8 <= n && string.charAt(n2) == 'i' && string.substring(n2, n2 + 8).equals("inscope ")) {
                try {
                    tclObjectArray = TclList.getElements(interp, TclString.newInstance(string));
                }
                catch (TclException tclException2) {
                    tclException = tclException2;
                }
                if (tclException == null) {
                    if (tclObjectArray.length != 4) {
                        tclException = new TclException(interp, "malformed command \"" + string + "\": should be \"namespace inscope namesp command\"");
                    } else {
                        object = tclObjectArray[2].toString();
                        namespace = Namespace.findNamespace(interp, (String)object, null, 512);
                        if (namespace == null) {
                            tclException = new TclException(interp, interp.getResult().toString());
                        } else {
                            string2 = tclObjectArray[3].toString();
                        }
                    }
                }
                if (tclException != null) {
                    object = "\n    (while decoding scoped command \"" + string + "\")";
                    interp.addErrorInfo((String)object);
                    throw tclException;
                }
            }
        }
        object = new DecodeScopedCommandResult();
        ((DecodeScopedCommandResult)object).rNS = namespace;
        ((DecodeScopedCommandResult)object).rCmd = string2;
        return object;
    }

    static void EvalArgs(Interp interp, TclObject[] tclObjectArray) throws TclException {
        TclObject tclObject = null;
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, tclObjectArray[0].toString(), null, 0);
        TclObject[] tclObjectArray2 = tclObjectArray;
        if (wrappedCommand == null) {
            wrappedCommand = Namespace.findCommand(interp, "unknown", null, 1);
            if (wrappedCommand == null) {
                interp.resetResult();
                throw new TclException(interp, "invalid command name \"" + tclObjectArray[0].toString() + "\"");
            }
            tclObject = Util.CreateArgs(interp, "unknown", tclObjectArray, 0);
            tclObjectArray2 = TclList.getElements(interp, tclObject);
        }
        interp.resetResult();
        if (wrappedCommand.mustCallInvoke(interp)) {
            wrappedCommand.invoke(interp, tclObjectArray2);
        } else {
            wrappedCommand.cmd.cmdProc(interp, tclObjectArray2);
        }
    }

    static TclObject CreateArgs(Interp interp, String string, TclObject[] tclObjectArray, int n) throws TclException {
        TclObject tclObject = TclList.newInstance();
        if (string != null) {
            TclList.append(interp, tclObject, TclString.newInstance(string));
        }
        if (tclObjectArray != null) {
            for (int i = n; i < tclObjectArray.length; ++i) {
                TclList.append(interp, tclObject, tclObjectArray[i]);
            }
        }
        tclObject.preserve();
        return tclObject;
    }

    static void StartSublist(StringBuffer stringBuffer) {
        if (Util.NeedSpace(stringBuffer)) {
            stringBuffer.append(" {");
        } else {
            stringBuffer.append('{');
        }
    }

    static void EndSublist(StringBuffer stringBuffer) {
        stringBuffer.append('}');
    }

    static void AppendElement(StringBuffer stringBuffer, String string) {
        if (Util.NeedSpace(stringBuffer)) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
    }

    static boolean NeedSpace(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        while (stringBuffer.charAt(n2) == '{') {
            if (n2 == 0) {
                return false;
            }
            --n2;
        }
        return !Character.isSpaceChar(stringBuffer.charAt(n2)) || n2 != 0 && stringBuffer.charAt(n2 - 1) == '\\';
    }

    static class DecodeScopedCommandResult {
        Namespace rNS;
        String rCmd;

        DecodeScopedCommandResult() {
        }
    }

    static class ParseNamespPathResult {
        String head;
        String tail;

        ParseNamespPathResult(String string, String string2) {
            this.head = string;
            this.tail = string2;
        }
    }
}

