/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.pkg.java.FuncSig;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.reflect.PkgInvoker;

class ArraySig
implements InternalRep {
    Class arrayType;
    int dimensions;

    ArraySig(Class clazz, int n) {
        this.arrayType = clazz;
        this.dimensions = n;
    }

    @Override
    public InternalRep duplicate() {
        return new ArraySig(this.arrayType, this.dimensions);
    }

    @Override
    public void dispose() {
    }

    static boolean looksLikeArraySig(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof FuncSig) {
            return false;
        }
        if (internalRep instanceof ArraySig) {
            return true;
        }
        int n = TclList.getLength(interp, tclObject);
        if (n < 1) {
            return false;
        }
        String string = n == 1 ? tclObject.toString() : TclList.index(interp, tclObject, 0).toString();
        return string.endsWith("[]") || string.startsWith("[");
    }

    static ArraySig get(Interp interp, TclObject tclObject) throws TclException {
        String string;
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof ArraySig) {
            return (ArraySig)internalRep;
        }
        if (TclList.getLength(interp, tclObject) == 1 && ((string = tclObject.toString()).endsWith("[]") || string.startsWith("["))) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = JavaInvoke.getClassByName(interp, string);
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            if (!PkgInvoker.isAccessible(clazz2)) {
                JavaInvoke.notAccessibleError(interp, clazz2);
            }
            int n = 0;
            if (string.charAt(0) == '[') {
                while (string.charAt(++n) == '[') {
                }
            } else {
                for (int i = string.length() - 1; i > 0 && string.charAt(i - 1) == '[' && string.charAt(i) == ']'; i -= 2) {
                    ++n;
                }
            }
            ArraySig arraySig = new ArraySig(clazz, n);
            tclObject.setInternalRep(arraySig);
            return arraySig;
        }
        throw new TclException(interp, "bad array signature \"" + tclObject + "\"");
    }
}

