/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.pkg.java.BeanEventMgr;
import tcl.pkg.java.BeanEventParamSet;
import tcl.pkg.java.JavaInvoke;

public class JavaEventCmd
implements Command {
    BeanEventMgr eventMgr = null;
    private static final String[] validOpts = new String[]{"-index"};
    static final int OPT_INDEX = 0;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        BeanEventParamSet beanEventParamSet;
        int n;
        if (tclObjectArray.length > 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-index num? ?propertyName?");
        }
        if (tclObjectArray.length <= 2) {
            n = 0;
        } else {
            TclIndex.get(interp, tclObjectArray[1], validOpts, "option", 0);
            n = TclInteger.getInt(interp, tclObjectArray[2]);
        }
        TclObject tclObject = tclObjectArray.length == 2 ? tclObjectArray[1] : (tclObjectArray.length == 4 ? tclObjectArray[3] : null);
        if (this.eventMgr == null) {
            this.eventMgr = BeanEventMgr.getBeanEventMgr(interp);
        }
        if ((beanEventParamSet = this.eventMgr.peekEventParamSet()) == null) {
            throw new TclException(interp, "\"" + tclObjectArray[0] + "\" cannot be invoked outside of an event handler");
        }
        if (n < 0 || n >= beanEventParamSet.params.length) {
            throw new TclException(interp, "event parameter #" + n + " doesn't exist");
        }
        TclObject tclObject2 = JavaInvoke.convertJavaObject(interp, beanEventParamSet.paramTypes[n], beanEventParamSet.params[n]);
        if (tclObject == null) {
            interp.setResult(tclObject2);
        } else {
            interp.setResult(JavaInvoke.getProperty(interp, tclObject2, tclObject, true));
        }
    }
}

