/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.java.ClassRep;
import tcl.pkg.java.FieldSig;
import tcl.pkg.java.FuncSig;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.ReflectObject;
import tcl.pkg.java.reflect.PkgInvoker;

public class JavaInfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"class", "baseclass", "dimensions", "events", "fields", "methods", "constructors", "properties", "superclass"};
    private static final int CLASS = 0;
    private static final int BASECLASS = 1;
    private static final int DIMENSIONS = 2;
    private static final int EVENTS = 3;
    private static final int FIELDS = 4;
    private static final int METHODS = 5;
    private static final int CONSTRUCTORS = 6;
    private static final int PROPERTIES = 7;
    private static final int SUPERCLASS = 8;
    private static final String[] propOpts = new String[]{"-type"};
    private static final String[] methOpts = new String[]{"-type", "-static"};
    static final int TYPE_OPT = 0;
    static final int STATIC_OPT = 1;

    /*
     * Unable to fully structure code
     */
    @Override
    public void cmdProc(Interp var1_1, TclObject[] var2_2) throws TclException {
        var3_3 = var2_2.length - 1;
        var4_4 = false;
        var5_5 = false;
        if (var2_2.length < 2) {
            throw new TclNumArgsException(var1_1, 1, var2_2, "option ?arg arg ...?");
        }
        var8_6 = TclIndex.get(var1_1, var2_2[1], JavaInfoCmd.validCmds, "option", 0);
        switch (var8_6) {
            case 1: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_7 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_7 != null) {
                    var1_1.setResult(JavaInfoCmd.getBaseNameFromClass(var7_7));
                }
                return;
            }
            case 0: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var7_8 = ReflectObject.getClass(var1_1, var2_2[2]);
                if (var7_8 != null) {
                    var1_1.setResult(JavaInfoCmd.getNameFromClass(var7_8));
                }
                return;
            }
            case 2: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_9 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_9 == null) {
                    var1_1.setResult(0L);
                } else {
                    var1_1.setResult(JavaInfoCmd.getNumDimsFromClass(var7_9));
                }
                return;
            }
            case 3: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var7_10 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_10 == null) {
                    var1_1.resetResult();
                    return;
                }
                if (!PkgInvoker.isAccessible(var7_10)) {
                    JavaInvoke.notAccessibleError(var1_1, var7_10);
                }
                try {
                    var9_16 = Introspector.getBeanInfo(var7_10);
                }
                catch (IntrospectionException var10_19) {
                    ** GOTO lbl53
                }
                var10_20 = var9_16.getEventSetDescriptors();
                if (var10_20 != null) {
                    var11_21 = TclList.newInstance();
                    for (var12_22 = 0; var12_22 < var10_20.length; ++var12_22) {
                        TclList.append(var1_1, var11_21, TclString.newInstance(JavaInfoCmd.getNameFromClass(var10_20[var12_22].getListenerType())));
                    }
                    var1_1.setResult(var11_21);
                    return;
                }
lbl53:
                // 3 sources

                var1_1.resetResult();
                return;
            }
            case 4: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                block22: for (var9_17 = 2; var9_17 < var3_3; ++var9_17) {
                    var8_6 = TclIndex.get(var1_1, var2_2[var9_17], JavaInfoCmd.methOpts, "option", 0);
                    switch (var8_6) {
                        case 1: {
                            var4_4 = true;
                            continue block22;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                }
                var7_11 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_11 != null) {
                    if (!PkgInvoker.isAccessible(var7_11)) {
                        JavaInvoke.notAccessibleError(var1_1, var7_11);
                    }
                    var6_23 = JavaInfoCmd.getFieldInfoList(var1_1, var7_11, var4_4, var5_5);
                    var1_1.setResult(var6_23);
                }
                return;
            }
            case 5: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                block23: for (var9_18 = 2; var9_18 < var3_3; ++var9_18) {
                    var8_6 = TclIndex.get(var1_1, var2_2[var9_18], JavaInfoCmd.methOpts, "option", 0);
                    switch (var8_6) {
                        case 1: {
                            var4_4 = true;
                            continue block23;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                }
                var7_12 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_12 != null) {
                    if (!PkgInvoker.isAccessible(var7_12)) {
                        JavaInvoke.notAccessibleError(var1_1, var7_12);
                    }
                    var6_24 = JavaInfoCmd.getMethodInfoList(var1_1, var7_12, var4_4, var5_5);
                    var1_1.setResult(var6_24);
                }
                return;
            }
            case 6: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_13 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_13 != null) {
                    if (!PkgInvoker.isAccessible(var7_13)) {
                        JavaInvoke.notAccessibleError(var1_1, var7_13);
                    }
                    var6_25 = JavaInfoCmd.getConstructorInfoList(var1_1, var7_13);
                    var1_1.setResult(var6_25);
                }
                return;
            }
            case 7: {
                if (var3_3 < 2 || var3_3 > 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? objOrClass");
                }
                if (var3_3 == 3) {
                    var8_6 = TclIndex.get(var1_1, var2_2[2], JavaInfoCmd.propOpts, "option", 0);
                    var5_5 = true;
                }
                if ((var7_14 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3])) != null) {
                    if (!PkgInvoker.isAccessible(var7_14)) {
                        JavaInvoke.notAccessibleError(var1_1, var7_14);
                    }
                    var6_26 = JavaInfoCmd.getPropInfoList(var1_1, var7_14, var5_5);
                    var1_1.setResult(var6_26);
                }
                return;
            }
            case 8: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_15 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                var1_1.resetResult();
                if (var7_15 != null && (var7_15 = var7_15.getSuperclass()) != null) {
                    var1_1.setResult(JavaInfoCmd.getNameFromClass(var7_15));
                }
                return;
            }
        }
    }

    private static Class getClassFromObj(Interp interp, TclObject tclObject) throws TclException {
        Class clazz;
        try {
            clazz = ReflectObject.getClass(interp, tclObject);
        }
        catch (TclException tclException) {
            try {
                clazz = ClassRep.get(interp, tclObject);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "unknown java class or object \"" + tclObject + "\"");
            }
        }
        return clazz;
    }

    private static TclObject getPropInfoList(Interp interp, Class clazz, boolean bl) throws TclException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new TclException(interp, introspectionException.toString());
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            TclObject tclObject2;
            TclObject tclObject3 = TclList.newInstance();
            if (bl && (tclObject2 = TclString.newInstance(JavaInfoCmd.getNameFromClass(propertyDescriptorArray[i].getPropertyType()))) != null) {
                TclList.append(interp, tclObject3, tclObject2);
            }
            tclObject2 = TclString.newInstance(propertyDescriptorArray[i].getName());
            TclList.append(interp, tclObject3, tclObject2);
            TclList.append(interp, tclObject, tclObject3);
        }
        return tclObject;
    }

    private static TclObject getFieldInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Field[] fieldArray = FieldSig.getAccessibleFields(clazz);
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < fieldArray.length; ++i) {
            boolean bl3;
            boolean bl4 = bl3 = (fieldArray[i].getModifiers() & 8) > 0;
            if (bl3 != bl) continue;
            TclObject tclObject2 = TclList.newInstance();
            String string = fieldArray[i].getName();
            TclObject tclObject3 = TclString.newInstance(string);
            TclList.append(interp, tclObject2, tclObject3);
            Class<?> clazz2 = fieldArray[i].getDeclaringClass();
            if (!clazz2.equals(clazz)) {
                for (int j = 0; j < fieldArray.length; ++j) {
                    Class<?> clazz3;
                    if (j == i || !string.equals(fieldArray[j].getName()) || !clazz2.isAssignableFrom(clazz3 = fieldArray[j].getDeclaringClass())) continue;
                    tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(clazz2));
                    TclList.append(interp, tclObject2, tclObject3);
                    break;
                }
            }
            if (bl2) {
                TclObject tclObject4 = TclList.newInstance();
                tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(fieldArray[i].getType()));
                TclList.append(interp, tclObject4, tclObject3);
                TclList.append(interp, tclObject4, tclObject2);
                TclList.append(interp, tclObject, tclObject4);
                continue;
            }
            TclList.append(interp, tclObject, tclObject2);
        }
        return tclObject;
    }

    private static TclObject getMethodInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Method[] methodArray = bl ? FuncSig.getAccessibleStaticMethods(clazz) : FuncSig.getAccessibleInstanceMethods(clazz);
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < methodArray.length; ++i) {
            TclObject tclObject2 = TclList.newInstance();
            TclObject tclObject3 = TclString.newInstance(methodArray[i].getName());
            TclList.append(interp, tclObject2, tclObject3);
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(classArray[j]));
                TclList.append(interp, tclObject2, tclObject3);
            }
            if (bl2) {
                TclObject tclObject4 = TclList.newInstance();
                TclObject tclObject5 = TclList.newInstance();
                Class<?>[] classArray2 = methodArray[i].getExceptionTypes();
                for (int j = 0; j < classArray2.length; ++j) {
                    TclList.append(interp, tclObject5, TclString.newInstance(JavaInfoCmd.getNameFromClass(classArray2[j])));
                }
                TclList.append(interp, tclObject4, TclString.newInstance(JavaInfoCmd.getNameFromClass(methodArray[i].getReturnType())));
                TclList.append(interp, tclObject4, tclObject2);
                TclList.append(interp, tclObject4, tclObject5);
                TclList.append(interp, tclObject, tclObject4);
                continue;
            }
            TclList.append(interp, tclObject, tclObject2);
        }
        return tclObject;
    }

    private static TclObject getConstructorInfoList(Interp interp, Class clazz) throws TclException {
        Constructor[] constructorArray = FuncSig.getAccessibleConstructors(clazz);
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < constructorArray.length; ++i) {
            TclObject tclObject2 = TclList.newInstance();
            TclObject tclObject3 = TclString.newInstance(constructorArray[i].getName());
            TclList.append(interp, tclObject2, tclObject3);
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(classArray[j]));
                TclList.append(interp, tclObject2, tclObject3);
            }
            TclList.append(interp, tclObject, tclObject2);
        }
        return tclObject;
    }

    static int getNumDimsFromClass(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        return n;
    }

    static String getNameFromClass(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append("[]");
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName().replace('$', '.');
        stringBuffer.insert(0, string);
        return stringBuffer.toString();
    }

    private static String getBaseNameFromClass(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.getName().toString().replace('$', '.');
    }
}

