/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class JavaLoadCmd
implements Command {
    private static final String[] validOpts = new String[]{"-classpath"};

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Class clazz;
        TclClassLoader tclClassLoader;
        String string;
        TclObject tclObject;
        Extension extension = null;
        boolean bl = false;
        if (tclObjectArray.length != 2 && tclObjectArray.length != 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-classpath arg? packageName");
        }
        if (tclObjectArray.length == 4) {
            TclIndex.get(interp, tclObjectArray[1], validOpts, "switch", 0);
            tclObject = tclObjectArray[2];
            string = tclObjectArray[3].toString();
        } else {
            tclObject = null;
            string = tclObjectArray[1].toString();
        }
        String string2 = "load \"" + string + "\" failed: ";
        if (string.endsWith(".class")) {
            string = string.substring(0, string.lastIndexOf(".class"));
        }
        if (tclObject == null) {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
        } else {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
            tclClassLoader = new TclClassLoader(interp, tclObject, tclClassLoader);
        }
        try {
            bl = false;
            clazz = tclClassLoader.loadClass(string);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TclException(interp, "package \"" + string + "\" not found");
        }
        catch (ClassFormatError classFormatError) {
            throw new TclException(interp, string2 + "use the fully qualified package name");
        }
        catch (PackageNameException packageNameException) {
            throw new TclException(interp, string2 + packageNameException);
        }
        finally {
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
        }
        try {
            bl = false;
            extension = (Extension)clazz.newInstance();
            extension.init(interp);
            bl = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclException(interp, string2 + "class or initializer is not accessible");
        }
        catch (InstantiationException instantiationException) {
            throw new TclException(interp, string2 + "object instantiation failure");
        }
        catch (ClassCastException classCastException) {
            throw new TclException(interp, string2 + "not a subclass of tcl.lang.Extension");
        }
        catch (Exception exception) {
            throw new TclException(interp, string2 + "can't find class \"" + exception.getMessage() + "\"");
        }
        catch (LinkageError linkageError) {
            throw new TclException(interp, "Extension \"" + string + "\" contains a dependency \"" + linkageError.getMessage() + "\" that could not be resolved.");
        }
        finally {
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
        }
    }
}

