/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.tjc.TJC;

public class TJCBench
extends TJC.CompiledCommand {
    static long RESULT_INT = 0L;
    static Object RESULT_OBJ = null;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "testname");
        }
        String string = tclObjectArray[1].toString();
        if (string.equals("InternalTclObjectPreserve")) {
            this.InternalTclObjectPreserve(interp);
        } else if (string.equals("InternalTclObjectPreserveRelease")) {
            this.InternalTclObjectPreserveRelease(interp);
        } else if (string.equals("InternalExprParseIntValue")) {
            this.InternalExprParseIntValue(interp);
        } else if (string.equals("InternalExprParseDoubleValue")) {
            this.InternalExprParseDoubleValue(interp);
        } else if (string.equals("InternalExprGetBooleanInt")) {
            this.InternalExprGetBooleanInt(interp);
        } else if (string.equals("InternalExprGetBooleanDouble")) {
            this.InternalExprGetBooleanDouble(interp);
        } else if (string.equals("InternalExprGetBooleanString")) {
            this.InternalExprGetBooleanString(interp);
        } else if (string.equals("InternalIncr")) {
            this.InternalIncr(interp);
        } else if (string.equals("InternalTclListAppend")) {
            this.InternalTclListAppend(interp);
        } else if (string.equals("InternalTclListLength")) {
            this.InternalTclListLength(interp);
        } else if (string.equals("InternalTclListLindex")) {
            this.InternalTclListLindex(interp);
        } else if (string.equals("InternalTclStringNewInstance")) {
            this.InternalTclStringNewInstance(interp);
        } else if (string.equals("InternalTclIntegerNewInstance")) {
            this.InternalTclIntegerNewInstance(interp);
        } else if (string.equals("InternalTclDoubleNewInstance")) {
            this.InternalTclDoubleNewInstance(interp);
        } else if (string.equals("InternalTclListNewInstance")) {
            this.InternalTclListNewInstance(interp);
        } else if (string.equals("InternalTclStringDuplicate")) {
            this.InternalTclStringDuplicate(interp);
        } else if (string.equals("InternalTclIntegerDuplicate")) {
            this.InternalTclIntegerDuplicate(interp);
        } else if (string.equals("InternalTclDoubleDuplicate")) {
            this.InternalTclDoubleDuplicate(interp);
        } else if (string.equals("InternalTclListDuplicate")) {
            this.InternalTclListDuplicate(interp);
        } else if (string.equals("InternalTclIntegerType")) {
            this.InternalTclIntegerType(interp);
        } else if (string.equals("InternalTclDoubleType")) {
            this.InternalTclDoubleType(interp);
        } else if (string.equals("InternalTclStringType")) {
            this.InternalTclStringType(interp);
        } else if (string.equals("InternalTclListType")) {
            this.InternalTclListType(interp);
        } else if (string.equals("InternalTclIntegerGet")) {
            this.InternalTclIntegerGet(interp);
        } else if (string.equals("InternalExprGetKnownInt")) {
            this.InternalExprGetKnownInt(interp);
        } else if (string.equals("InternalExprInlineGetInt")) {
            this.InternalExprInlineGetInt(interp);
        } else if (string.equals("InternalTclDoubleGet")) {
            this.InternalTclDoubleGet(interp);
        } else if (string.equals("InternalExprGetKnownDouble")) {
            this.InternalExprGetKnownDouble(interp);
        } else if (string.equals("InternalExprInlinedIntNotOperator")) {
            this.InternalExprInlinedIntNotOperator(interp);
        } else if (string.equals("InternalExprInlinedIntNotBitwiseOperator")) {
            this.InternalExprInlinedIntNotBitwiseOperator(interp);
        } else if (string.equals("InternalExprValueIntNotOperator")) {
            this.InternalExprValueIntNotOperator(interp);
        } else if (string.equals("InternalExprValueIntNotNstrOperator")) {
            this.InternalExprValueIntNotNstrOperator(interp);
        } else if (string.equals("InternalSetTclObjectResult")) {
            this.InternalSetTclObjectResult(interp);
        } else if (string.equals("InternalSetSameTclObjectResult")) {
            this.InternalSetSameTclObjectResult(interp);
        } else if (string.equals("InternalResetResult")) {
            this.InternalResetResult(interp);
        } else if (string.equals("InternalSetBooleanResult")) {
            this.InternalSetBooleanResult(interp);
        } else if (string.equals("InternalSetIntResult")) {
            this.InternalSetIntResult(interp);
        } else if (string.equals("InternalSetUncommonIntResult")) {
            this.InternalSetUncommonIntResult(interp);
        } else if (string.equals("InternalSetUncommonDoubleResult")) {
            this.InternalSetUncommonDoubleResult(interp);
        } else if (string.equals("InternalSetUncommonStringResult")) {
            this.InternalSetUncommonStringResult(interp);
        } else if (string.equals("InternalSetIntResultViaExprValue")) {
            this.InternalSetIntResultViaExprValue(interp);
        } else if (string.equals("InternalExprSetIntResult")) {
            this.InternalExprSetIntResult(interp);
        } else if (string.equals("InternalExprOpIntNot")) {
            this.InternalExprOpIntNot(interp);
        } else if (string.equals("InternalExprOpIntNotGrabReleaseResult")) {
            this.InternalExprOpIntNotGrabReleaseResult(interp);
        } else if (string.equals("InternalExprOpIntNotStackValueResult")) {
            this.InternalExprOpIntNotStackValueResult(interp);
        } else if (string.equals("InternalExprOpIntNotStackValueIntResult")) {
            this.InternalExprOpIntNotStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntNotStackValueBooleanResult")) {
            this.InternalExprOpIntNotStackValueBooleanResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotStackValueResult")) {
            this.InternalExprOpIntInlinedNotStackValueResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrStackValueResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrStackValueIntResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrStackValueBooleanResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueBooleanResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotKnownIntResult")) {
            this.InternalExprOpIntInlinedNotKnownIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotKnownIntInlineResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotKnownIntInlineBooleanResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrAsBoolean(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrKnownIntAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(interp);
        } else if (string.equals("InternalExprOpIntInlinedNotNstrLocalAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrLocalAsBoolean(interp);
        } else if (string.equals("InternalExprOpIntPlus")) {
            this.InternalExprOpIntPlus(interp);
        } else if (string.equals("InternalExprOpIntPlusGrabReleaseResult")) {
            this.InternalExprOpIntPlusGrabReleaseResult(interp);
        } else if (string.equals("InternalExprOpIntPlusStackValueResult")) {
            this.InternalExprOpIntPlusStackValueResult(interp);
        } else if (string.equals("InternalExprOpIntPlusStackValueIntResult")) {
            this.InternalExprOpIntPlusStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedPlusStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedPlusNBStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusNBStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedPlusIMStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpIntInlinedPlusIMRStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMRStackValueIntResult(interp);
        } else if (string.equals("InternalExprOpDoublePlus")) {
            this.InternalExprOpDoublePlus(interp);
        } else if (string.equals("InternalExprOpLogicalOrResult")) {
            this.InternalExprOpLogicalOrResult(interp);
        } else if (string.equals("InternalExprOpInlinedLogicalOrResult")) {
            this.InternalExprOpInlinedLogicalOrResult(interp);
        } else if (string.equals("InternalExprOpInlinedIntLogicalOrResult")) {
            this.InternalExprOpInlinedIntLogicalOrResult(interp);
        } else if (string.equals("InternalExprOpInlinedNoExprLogicalOrResult")) {
            this.InternalExprOpInlinedNoExprLogicalOrResult(interp);
        } else if (string.equals("InternalObjvInvoke")) {
            this.InternalObjvInvoke(interp);
        } else if (string.equals("InternalObjvInvokeOnStack")) {
            this.InternalObjvInvokeOnStack(interp);
        } else if (string.equals("InternalObjvInvokeOnStackAssigned")) {
            this.InternalObjvInvokeOnStackAssigned(interp);
        } else if (string.equals("InternalObjvInvokeOnStackAssignedIndex")) {
            this.InternalObjvInvokeOnStackAssignedIndex(interp);
        } else if (string.equals("InternalObjvInvokeOnStackStack")) {
            this.InternalObjvInvokeOnStackStack(interp);
        } else if (string.equals("InternalObjvInvokeOnStackTryStack")) {
            this.InternalObjvInvokeOnStackTryStack(interp);
        } else {
            throw new TclException(interp, "unknown test name \"" + string + "\"");
        }
    }

    void InternalTclObjectPreserve(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        for (int i = 0; i < 5000; ++i) {
            tclObject.preserve();
        }
        RESULT_INT = tclObject.getRefCount();
    }

    void InternalTclObjectPreserveRelease(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        tclObject.preserve();
        tclObject.preserve();
        for (int i = 0; i < 5000; ++i) {
            tclObject.preserve();
            tclObject.release();
        }
        RESULT_INT = tclObject.getRefCount();
    }

    void InternalExprParseIntValue(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        ExprValue exprValue = new ExprValue(0L, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.ExprParseObject(interp, tclObject, exprValue);
        }
        RESULT_INT = TclInteger.getLong(interp, tclObject);
    }

    void InternalExprParseDoubleValue(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        ExprValue exprValue = new ExprValue(0L, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.ExprParseObject(interp, tclObject, exprValue);
        }
        RESULT_INT = (long)TclDouble.get(interp, tclObject);
    }

    void InternalExprGetBooleanInt(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = TJC.getBoolean(interp, tclObject);
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalExprGetBooleanDouble(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = TJC.getBoolean(interp, tclObject);
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalExprGetBooleanString(Interp interp) throws TclException {
        TclObject tclObject = TclString.newInstance("true");
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = TJC.getBoolean(interp, tclObject);
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalIncr(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(0L);
        for (int i = 0; i < 5000; ++i) {
            TclInteger.incr(interp, tclObject, 1L);
        }
        RESULT_INT = TclInteger.getLong(interp, tclObject);
    }

    void InternalTclListLength(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        TclObject tclObject2 = interp.checkCommonString(null);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        int n = 0;
        for (int i = 0; i < 5000; ++i) {
            n += TclList.getLength(interp, tclObject);
        }
        RESULT_INT = n;
    }

    void InternalTclListLindex(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        TclObject tclObject2 = interp.checkCommonString(null);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObject2);
        for (int i = 0; i < 5000; ++i) {
            tclObject2 = TclList.index(interp, tclObject, 6);
        }
        RESULT_OBJ = tclObject2;
    }

    void InternalTclListAppend(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        TclObject tclObject2 = interp.checkCommonString(null);
        for (int i = 0; i < 5000; ++i) {
            TclList.append(interp, tclObject, tclObject2);
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclStringNewInstance(Interp interp) throws TclException {
        TclObject tclObject = null;
        for (int i = 0; i < 5000; ++i) {
            tclObject = TclString.newInstance("foo");
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclIntegerNewInstance(Interp interp) throws TclException {
        TclObject tclObject = null;
        for (int i = 0; i < 5000; ++i) {
            tclObject = TclInteger.newInstance(1L);
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclDoubleNewInstance(Interp interp) throws TclException {
        TclObject tclObject = null;
        for (int i = 0; i < 5000; ++i) {
            tclObject = TclDouble.newInstance(1.0);
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclListNewInstance(Interp interp) throws TclException {
        TclObject tclObject = null;
        for (int i = 0; i < 5000; ++i) {
            tclObject = TclList.newInstance();
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclStringDuplicate(Interp interp) throws TclException {
        TclObject tclObject = TclString.newInstance("foo");
        for (int i = 0; i < 5000; ++i) {
            tclObject = tclObject.duplicate();
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclIntegerDuplicate(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        for (int i = 0; i < 5000; ++i) {
            tclObject = tclObject.duplicate();
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclDoubleDuplicate(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        for (int i = 0; i < 5000; ++i) {
            tclObject = tclObject.duplicate();
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclListDuplicate(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < 5000; ++i) {
            tclObject = tclObject.duplicate();
        }
        RESULT_OBJ = tclObject;
    }

    void InternalTclIntegerType(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = tclObject.isIntType();
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalTclDoubleType(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = tclObject.isDoubleType();
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalTclStringType(Interp interp) throws TclException {
        TclObject tclObject = TclString.newInstance("foo");
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = tclObject.isStringType();
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalTclListType(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        boolean bl = false;
        for (int i = 0; i < 5000; ++i) {
            bl = tclObject.isListType();
        }
        RESULT_INT = bl ? 1 : 0;
    }

    void InternalTclIntegerGet(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        long l = 0L;
        for (int i = 0; i < 5000; ++i) {
            l = TclInteger.getLong(interp, tclObject);
        }
        RESULT_INT = l;
    }

    void InternalExprGetKnownInt(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        long l = 0L;
        for (int i = 0; i < 5000; ++i) {
            l = TJC.exprGetKnownInt(tclObject);
        }
        RESULT_INT = l;
    }

    void InternalExprInlineGetInt(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        long l = 0L;
        for (int i = 0; i < 5000; ++i) {
            l = tclObject.ivalue;
        }
        RESULT_INT = l;
    }

    void InternalTclDoubleGet(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        double d = 0.0;
        for (int i = 0; i < 5000; ++i) {
            d = TclDouble.get(interp, tclObject);
        }
        RESULT_INT = (long)d;
    }

    void InternalExprGetKnownDouble(Interp interp) throws TclException {
        TclObject tclObject = TclDouble.newInstance(1.0);
        double d = 0.0;
        for (int i = 0; i < 5000; ++i) {
            d = TJC.exprGetKnownDouble(tclObject);
        }
        RESULT_INT = (long)d;
    }

    void InternalExprInlinedIntNotOperator(Interp interp) throws TclException {
        int n = 1;
        for (int i = 0; i < 5000; ++i) {
            n = n == 0 ? 1 : 0;
        }
        RESULT_INT = n;
    }

    void InternalExprInlinedIntNotBitwiseOperator(Interp interp) throws TclException {
        int n = 1;
        for (int i = 0; i < 5000; ++i) {
            n = (n | -n) >>> 31 ^ 1;
        }
        RESULT_INT = n;
    }

    void InternalExprValueIntNotOperator(Interp interp) throws TclException {
        ExprValue exprValue = new ExprValue(1L, null);
        for (int i = 0; i < 5000; ++i) {
            exprValue.optIntUnaryNot();
        }
        RESULT_INT = exprValue.getIntValue();
    }

    void InternalExprValueIntNotNstrOperator(Interp interp) throws TclException {
        ExprValue exprValue = new ExprValue(1L, null);
        for (int i = 0; i < 5000; ++i) {
            exprValue.optIntUnaryNotNstr();
        }
        RESULT_INT = exprValue.getIntValue();
    }

    void InternalSetTclObjectResult(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        TclObject tclObject2 = TclInteger.newInstance(2L);
        tclObject.preserve();
        tclObject.preserve();
        tclObject2.preserve();
        tclObject2.preserve();
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(tclObject);
            interp.setResult(tclObject2);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalSetSameTclObjectResult(Interp interp) throws TclException {
        TclObject tclObject = TclInteger.newInstance(1L);
        tclObject.preserve();
        tclObject.preserve();
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(tclObject);
            interp.setResult(tclObject);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalResetResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.resetResult();
            interp.resetResult();
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetBooleanResult(Interp interp) throws TclException {
        boolean bl = true;
        boolean bl2 = false;
        if (RESULT_INT == 0L) {
            bl = false;
            bl2 = true;
        }
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(bl);
            interp.setResult(bl2);
        }
        RESULT_INT = TclBoolean.get(interp, interp.getResult()) ? 1 : 0;
    }

    void InternalSetIntResult(Interp interp) throws TclException {
        long l = 1L;
        long l2 = 0L;
        if (RESULT_INT == 0L) {
            l = 0L;
            l2 = 1L;
        }
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(l);
            interp.setResult(l2);
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalSetUncommonIntResult(Interp interp) throws TclException {
        for (long i = 0L; i < 5000L; ++i) {
            interp.setResult(i * 2L);
            interp.setResult(i * 3L);
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalSetUncommonDoubleResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.setResult((double)i * 2.0);
            interp.setResult((double)i * 3.0);
        }
        RESULT_INT = (long)TclDouble.get(interp, interp.getResult());
    }

    void InternalSetUncommonStringResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.setResult("2" + i);
            interp.setResult("3" + i);
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetIntResultViaExprValue(Interp interp) throws TclException {
        long l = 1L;
        long l2 = 0L;
        if (RESULT_INT == 0L) {
            l = 0L;
            l2 = 1L;
        }
        ExprValue exprValue = TJC.exprGetValue(interp, l, null);
        ExprValue exprValue2 = TJC.exprGetValue(interp, l2, null);
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(exprValue.getIntValue());
            interp.setResult(exprValue2.getIntValue());
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalExprSetIntResult(Interp interp) throws TclException {
        long l = 1L;
        long l2 = 0L;
        if (RESULT_INT == 0L) {
            l = 0L;
            l2 = 1L;
        }
        ExprValue exprValue = TJC.exprGetValue(interp, l, null);
        ExprValue exprValue2 = TJC.exprGetValue(interp, l2, null);
        for (int i = 0; i < 5000; ++i) {
            TJC.exprSetResult(interp, exprValue);
            TJC.exprSetResult(interp, exprValue2);
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalExprOpIntNot(Interp interp) throws TclException {
        ExprValue exprValue = new ExprValue(1L, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalUnaryOperator(interp, 32, exprValue);
        }
        RESULT_INT = exprValue.getIntValue();
    }

    void InternalExprOpIntNotGrabReleaseResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue = TJC.exprGetValue(interp, 1L, null);
            TJC.exprUnaryOperator(interp, 32, exprValue);
            TJC.exprSetResult(interp, exprValue);
            TJC.exprReleaseValue(interp, exprValue);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, exprValue2);
            TJC.exprSetResult(interp, exprValue2);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, exprValue2);
            interp.setResult(exprValue2.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, exprValue2);
            interp.setResult(exprValue2.getIntValue() != 0L);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotStackValueResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            if (!exprValue2.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.optIntUnaryNot();
            TJC.exprSetResult(interp, exprValue2);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            if (!exprValue2.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.optIntUnaryNotNstr();
            TJC.exprSetResult(interp, exprValue2);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            if (!exprValue2.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.optIntUnaryNotNstr();
            interp.setResult(exprValue2.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(0L);
            if (!exprValue2.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.optIntUnaryNotNstr();
            interp.setResult(exprValue2.getIntValue() != 0L);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        TclObject tclObject = TclInteger.newInstance(1L);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            if (!tclObject.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            TJC.exprUnaryNotOperatorKnownInt(exprValue2, tclObject);
            interp.setResult(exprValue2.getIntValue() != 0L);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        TclObject tclObject = TclInteger.newInstance(1L);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            if (!tclObject.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.setIntValue(TJC.exprGetKnownInt(tclObject) == 0L ? 1L : 0L);
            interp.setResult(exprValue2.getIntValue() != 0L);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        TclObject tclObject = TclInteger.newInstance(1L);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            if (!tclObject.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue2.setIntValue(TJC.exprGetKnownInt(tclObject) == 0L);
            interp.setResult(exprValue2.getIntValue() != 0L);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrAsBoolean(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            exprValue2.optIntUnaryNotNstr();
            boolean bl = exprValue2.getBooleanValue(interp);
            RESULT_INT = bl ? 1L : 0L;
        }
    }

    void InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            exprValue2.optIntUnaryNotNstr();
            boolean bl = exprValue2.getIntValue() != 0L;
            RESULT_INT = bl ? 1L : 0L;
        }
    }

    void InternalExprOpIntInlinedNotNstrLocalAsBoolean(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(1L);
            boolean bl = exprValue2.getIntValue() != 0L;
            RESULT_INT = bl ? 1L : 0L;
        }
    }

    void InternalExprOpIntPlus(Interp interp) throws TclException {
        ExprValue exprValue = new ExprValue(1L, null);
        ExprValue exprValue2 = new ExprValue(2L, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalBinaryOperator(interp, 11, exprValue, exprValue2);
        }
        RESULT_INT = exprValue.getIntValue();
    }

    void InternalExprOpIntPlusGrabReleaseResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue = TJC.exprGetValue(interp, 1L, null);
            ExprValue exprValue2 = TJC.exprGetValue(interp, 2L, null);
            TJC.exprBinaryOperator(interp, 11, exprValue, exprValue2);
            TJC.exprReleaseValue(interp, exprValue2);
            TJC.exprSetResult(interp, exprValue);
            TJC.exprReleaseValue(interp, exprValue);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntPlusStackValueResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        ExprValue exprValue2 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue3 = exprValue;
            exprValue3.setIntValue(1L);
            ExprValue exprValue4 = exprValue2;
            exprValue4.setIntValue(2L);
            TJC.exprBinaryOperator(interp, 11, exprValue3, exprValue4);
            TJC.exprSetResult(interp, exprValue3);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        ExprValue exprValue2 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue3 = exprValue;
            exprValue3.setIntValue(1L);
            ExprValue exprValue4 = exprValue2;
            exprValue4.setIntValue(2L);
            TJC.exprBinaryOperator(interp, 11, exprValue3, exprValue4);
            interp.setResult(exprValue3.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        ExprValue exprValue2 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue3 = exprValue;
            exprValue3.setIntValue(1L);
            ExprValue exprValue4 = exprValue2;
            exprValue4.setIntValue(2L);
            if (!exprValue3.isIntType() || !exprValue4.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            exprValue3.optIntPlus(exprValue4);
            interp.setResult(exprValue3.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusNBStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        ExprValue exprValue2 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue3 = exprValue;
            exprValue3.setIntValue(1L);
            ExprValue exprValue4 = exprValue2;
            exprValue4.setIntValue(2L);
            exprValue3.optIntPlus(exprValue4);
            interp.setResult(exprValue3.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMStackValueIntResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(3L);
            interp.setResult(exprValue2.getIntValue());
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMRStackValueIntResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            int n = 3;
            interp.setResult(n);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpDoublePlus(Interp interp) throws TclException {
        ExprValue exprValue = new ExprValue(1.0, null);
        ExprValue exprValue2 = new ExprValue(2.0, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalBinaryOperator(interp, 11, exprValue, exprValue2);
        }
        RESULT_INT = (int)exprValue.getDoubleValue();
    }

    void InternalExprOpLogicalOrResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        ExprValue exprValue2 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue3 = exprValue;
            exprValue3.setIntValue(0L);
            if (!exprValue3.getBooleanValue(interp)) {
                ExprValue exprValue4 = exprValue2;
                exprValue4.setIntValue(1L);
                exprValue3.setIntValue(exprValue4.getBooleanValue(interp));
            } else {
                exprValue3.setIntValue(1L);
            }
            TJC.exprSetResult(interp, exprValue3);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedLogicalOrResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(0L);
            boolean bl = exprValue2.getBooleanValue(interp);
            if (!bl) {
                ExprValue exprValue3 = exprValue;
                exprValue3.setIntValue(1L);
                bl = exprValue3.getBooleanValue(interp);
            }
            interp.setResult(bl);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedIntLogicalOrResult(Interp interp) throws TclException {
        ExprValue exprValue = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            boolean bl;
            ExprValue exprValue2 = exprValue;
            exprValue2.setIntValue(0L);
            boolean bl2 = bl = exprValue2.getIntValue() != 0L;
            if (!bl) {
                ExprValue exprValue3 = exprValue;
                exprValue3.setIntValue(1L);
                bl = exprValue3.getIntValue() != 0L;
            }
            interp.setResult(bl);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedNoExprLogicalOrResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = bl2;
            if (!bl) {
                bl2 = true;
                bl = bl2;
            }
            interp.setResult(bl);
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvoke(Interp interp) throws TclException {
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tclObject5;
            TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
            try {
                tclObjectArray[0] = tclObject;
                tclObject5 = tclObject2;
                tclObject5.preserve();
                tclObjectArray[1] = tclObject5;
                tclObjectArray[2] = tclObject3;
                tclObject5 = tclObject4;
                tclObject5.preserve();
                tclObjectArray[3] = tclObject5;
                RESULT_OBJ = tclObjectArray;
                continue;
            }
            finally {
                tclObject5 = tclObjectArray[1];
                if (tclObject5 != null) {
                    tclObject5.release();
                }
                if ((tclObject5 = tclObjectArray[3]) != null) {
                    tclObject5.release();
                }
                TJC.releaseObjv(interp, tclObjectArray, 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStack(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tclObject5;
            TclObject[] tclObjectArray2 = tclObjectArray;
            try {
                tclObjectArray2[0] = tclObject;
                tclObject5 = tclObject2;
                tclObject5.preserve();
                tclObjectArray2[1] = tclObject5;
                tclObjectArray2[2] = tclObject3;
                tclObject5 = tclObject4;
                tclObject5.preserve();
                tclObjectArray2[3] = tclObject5;
                RESULT_OBJ = tclObjectArray2;
                continue;
            }
            finally {
                tclObjectArray2[0] = null;
                tclObject5 = tclObjectArray2[1];
                if (tclObject5 != null) {
                    tclObject5.release();
                }
                tclObjectArray2[1] = null;
                tclObjectArray2[2] = null;
                tclObject5 = tclObjectArray2[3];
                if (tclObject5 != null) {
                    tclObject5.release();
                }
                tclObjectArray2[3] = null;
            }
        }
        TJC.releaseObjv(interp, tclObjectArray, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackAssigned(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        TclObject tclObject5 = TclString.newInstance("");
        for (int i = 0; i < 5000; ++i) {
            TclObject[] tclObjectArray2 = tclObjectArray;
            TclObject tclObject6 = null;
            try {
                tclObjectArray2[0] = tclObject;
                tclObject6 = tclObject2;
                tclObject6.preserve();
                tclObjectArray2[1] = tclObject6;
                tclObjectArray2[2] = tclObject3;
                tclObject6 = tclObject4;
                tclObject6.preserve();
                tclObjectArray2[3] = tclObject6;
                tclObject6 = tclObject5;
                RESULT_OBJ = tclObjectArray2;
                continue;
            }
            finally {
                tclObjectArray2[0] = null;
                tclObjectArray2[2] = null;
                if (tclObject6 != tclObject5) {
                    tclObject6 = tclObjectArray2[1];
                    if (tclObject6 != null) {
                        tclObject6.release();
                    }
                    tclObjectArray2[1] = null;
                    tclObject6 = tclObjectArray2[3];
                    if (tclObject6 != null) {
                        tclObject6.release();
                    }
                    tclObjectArray2[3] = null;
                } else {
                    tclObjectArray2[1].release();
                    tclObjectArray2[1] = null;
                    tclObjectArray2[3].release();
                    tclObjectArray2[3] = null;
                }
            }
        }
        TJC.releaseObjv(interp, tclObjectArray, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackAssignedIndex(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tclObject5;
            TclObject[] tclObjectArray2 = tclObjectArray;
            int n = -1;
            try {
                tclObjectArray2[0] = tclObject;
                n = 0;
                tclObject5 = tclObject2;
                tclObject5.preserve();
                tclObjectArray2[1] = tclObject5;
                n = 1;
                tclObjectArray2[2] = tclObject3;
                n = 2;
                tclObject5 = tclObject4;
                tclObject5.preserve();
                tclObjectArray2[3] = tclObject5;
                n = 3;
                RESULT_OBJ = tclObjectArray2;
                continue;
            }
            finally {
                if (n < 3) {
                    tclObjectArray2[0] = null;
                    tclObjectArray2[2] = null;
                    for (int j = 0; j <= n; ++j) {
                        tclObject5 = tclObjectArray2[j];
                        if (tclObject5 == null) continue;
                        tclObject5.release();
                    }
                } else {
                    tclObjectArray2[1].release();
                    tclObjectArray2[3].release();
                }
            }
        }
        TJC.releaseObjv(interp, tclObjectArray, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackStack(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tclObject5 = null;
            TclObject tclObject6 = null;
            try {
                tclObjectArray[0] = tclObject;
                tclObject5 = tclObject2;
                tclObject5.preserve();
                tclObjectArray[1] = tclObject5;
                tclObjectArray[2] = tclObject3;
                tclObject6 = tclObject4;
                tclObject6.preserve();
                tclObjectArray[3] = tclObject6;
                RESULT_OBJ = tclObjectArray;
                continue;
            }
            finally {
                if (tclObject5 != null) {
                    tclObject5.release();
                }
                if (tclObject6 != null) {
                    tclObject6.release();
                }
            }
        }
        TJC.releaseObjv(interp, tclObjectArray, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackTryStack(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 4);
        TclObject tclObject = TclString.newInstance("cmd");
        TclObject tclObject2 = TclString.newInstance("value1");
        tclObject2.preserve();
        TclObject tclObject3 = TclString.newInstance("const1");
        TclObject tclObject4 = TclString.newInstance("value2");
        tclObject4.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tclObject5 = null;
            TclObject tclObject6 = null;
            try {
                tclObjectArray[0] = tclObject;
                tclObject5 = tclObject2;
                tclObject5.preserve();
                tclObjectArray[1] = tclObject5;
                tclObjectArray[2] = tclObject3;
                tclObject6 = tclObject4;
                tclObject6.preserve();
                tclObjectArray[3] = tclObject6;
            }
            finally {
                if (tclObject6 == null && tclObject5 != null) {
                    tclObject5.release();
                }
            }
            try {
                RESULT_OBJ = tclObjectArray;
                continue;
            }
            finally {
                tclObject5.release();
                tclObject6.release();
            }
        }
        TJC.releaseObjv(interp, tclObjectArray, 4);
    }
}

