/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.tjc.TJCThread;

class TJCCompileJavaCmd
extends TclEvent
implements TJCThread.CompiledClassReady {
    final boolean debug = false;
    final Interp interp;
    final TclObject javaInfo;
    final String readyCmd;
    final String readyVar;
    boolean status;
    String errorMsg = "";
    ArrayList cnames;
    ArrayList cdata;

    TJCCompileJavaCmd(Interp interp, String string, String string2, String string3) {
        this.interp = interp;
        this.javaInfo = TclString.newInstance(string);
        this.readyCmd = string2;
        this.readyVar = string3;
    }

    @Override
    public void compiled(String string, String string2, String string3, ArrayList arrayList, ArrayList arrayList2, int n, String string4) {
        if (n == 0) {
            this.status = true;
        } else {
            this.status = false;
            this.errorMsg = string4;
        }
        if (arrayList2 != null) {
            this.cnames = arrayList;
            this.cdata = arrayList2;
        }
        this.interp.getNotifier().queueEvent(this, 0);
    }

    @Override
    public int processEvent(int n) {
        if (!this.status) {
            this.readyReport();
            return 1;
        }
        TclClassLoader tclClassLoader = (TclClassLoader)this.interp.getClassLoader();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.cdata.size(); ++i) {
            byte[] byArray;
            Class clazz;
            String string = null;
            if (this.cnames != null && (string = (String)this.cnames.get(i)).length() == 0) {
                string = null;
            }
            if ((clazz = tclClassLoader.defineClass(string, byArray = (byte[])this.cdata.get(i))) == null) {
                this.status = false;
                this.errorMsg = string != null ? "class \"" + string + "\" not loaded by TclClassLoader" : "class not loaded by TclClassLoader";
                this.readyReport();
                return 1;
            }
            if (string == null) {
                string = clazz.getName();
            }
            arrayList.add(string);
        }
        this.cnames = arrayList;
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tclObject = TclList.newInstance();
                if (this.status) {
                    TclList.append(this.interp, tclObject, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tclObject, TclString.newInstance("FAIL"));
                }
                TclObject tclObject2 = TclList.newInstance();
                if (this.cnames != null) {
                    for (int i = 0; i < this.cnames.size(); ++i) {
                        String string = (String)this.cnames.get(i);
                        TclList.append(this.interp, tclObject2, TclString.newInstance(string));
                    }
                }
                TclList.append(this.interp, tclObject, tclObject2);
                TclList.append(this.interp, tclObject, TclString.newInstance(this.errorMsg));
                this.interp.setVar(this.readyVar, null, tclObject, 1);
            } else if (this.readyCmd != null) {
                TclObject tclObject = TclList.newInstance();
                TclList.append(this.interp, tclObject, TclString.newInstance(this.readyCmd));
                if (this.status) {
                    TclList.append(this.interp, tclObject, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tclObject, TclString.newInstance("FAIL"));
                }
                TclObject tclObject3 = TclList.newInstance();
                if (this.cnames != null) {
                    for (int i = 0; i < this.cnames.size(); ++i) {
                        String string = (String)this.cnames.get(i);
                        TclList.append(this.interp, tclObject3, TclString.newInstance(string));
                    }
                }
                TclList.append(this.interp, tclObject, tclObject3);
                TclList.append(this.interp, tclObject, TclString.newInstance(this.errorMsg));
                this.interp.eval(tclObject, 131072);
            }
        }
        catch (TclException tclException) {
            tclException.printStackTrace(System.err);
        }
    }

    String getJavaFileName() throws TclException {
        TclObject tclObject = TclList.index(this.interp, this.javaInfo, 0);
        String string = tclObject.toString();
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string.indexOf(46) == -1) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string.replace('.', '/'));
        }
        stringBuffer.append(".java");
        return stringBuffer.toString();
    }

    String getJavaSource() throws TclException {
        TclObject tclObject = TclList.index(this.interp, this.javaInfo, 1);
        return tclObject.toString();
    }
}

