/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class TJCShell {
    public static void main(String[] stringArray) {
        int n;
        String string = "resource:/tcl/pkg/tjc/library/tjc.tcl";
        int n2 = 0;
        Interp interp = new Interp();
        if (stringArray.length > 0 && (stringArray[0].equals("-s") || stringArray[0].equals("-shell"))) {
            n2 = 1;
        }
        TclObject tclObject = TclList.newInstance();
        tclObject.preserve();
        try {
            if (n2 == 1) {
                interp.setVar("argv0", "tjc", 1);
                interp.setVar("tcl_interactive", "1", 1);
            } else {
                interp.setVar("argv0", "tjc.tcl", 1);
                interp.setVar("tcl_interactive", "0", 1);
            }
            for (n = n2; n < stringArray.length; ++n) {
                TclList.append(interp, tclObject, TclString.newInstance(stringArray[n]));
            }
            interp.setVar("argv", tclObject, 1);
            interp.setVar("argc", TclInteger.newInstance(TclList.getLength(interp, tclObject)), 1);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        finally {
            tclObject.release();
        }
        if (string != null) {
            n = 0;
            try {
                interp.eval("package require TJC");
                interp.eval("source " + string);
            }
            catch (TclException tclException) {
                int n3 = tclException.getCompletionCode();
                if (n3 == 2) {
                    n3 = interp.updateReturnInfo();
                    if (n3 != 0) {
                        System.err.println("command returned bad code: " + n3);
                        n = 2;
                    }
                }
                if (n3 == 1) {
                    System.err.println(interp.getResult().toString());
                    n = 1;
                }
                System.err.println("command returned bad code: " + n3);
                n = 2;
            }
            if (n2 == 0) {
                interp.dispose();
                System.exit(n);
            }
        }
        if (n2 == 1) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            Notifier notifier = interp.getNotifier();
            while (true) {
                notifier.doOneEvent(-3);
            }
        }
    }
}

