/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.soartech.soarls.SoarDocumentService;
import com.soartech.soarls.SoarFile;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Documents {
    private static final Logger LOG = LoggerFactory.getLogger(Documents.class);
    private final ConcurrentHashMap<URI, SoarFile> documents = new ConcurrentHashMap();
    private final Set<URI> openDocuments = new HashSet<URI>();

    public SoarFile get(URI uri) {
        return this.documents.computeIfAbsent(uri, Documents::readFile);
    }

    public ImmutableSet<URI> openUris() {
        return ImmutableSet.copyOf(this.openDocuments);
    }

    public SoarFile open(TextDocumentItem doc) {
        URI uri = SoarDocumentService.uri(doc.getUri());
        SoarFile soarFile = new SoarFile(uri, doc.getText());
        this.documents.put(soarFile.uri, soarFile);
        this.openDocuments.add(soarFile.uri);
        return soarFile;
    }

    public void close(URI uri) {
        this.openDocuments.remove(uri);
    }

    public void applyChanges(DidChangeTextDocumentParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        this.documents.compute(uri, (k, file) -> file.withChanges(params.getContentChanges()));
    }

    private static SoarFile readFile(URI uri) {
        try {
            Path path = Paths.get(uri);
            List<String> lines = Files.readAllLines(path);
            String contents = Joiner.on((String)"\n").join(lines);
            return new SoarFile(uri, contents);
        }
        catch (Exception e) {
            LOG.error("Failed to open file", (Throwable)e);
            return null;
        }
    }
}

