/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls;

import com.soartech.soarls.SoarDocumentService;
import com.soartech.soarls.SoarWorkspaceService;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements LanguageServer,
LanguageClientAware {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageServer.class);
    private final SoarDocumentService documentService = new SoarDocumentService();
    private final SoarWorkspaceService workspaceService = new SoarWorkspaceService(this.documentService);

    public Server() {
        System.setProperty("jsoar.agent.interpreter", "tcl");
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public TextDocumentService getTextDocumentService() {
        return this.documentService;
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(null);
    }

    public void exit() {
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        LOG.info("Initializing server");
        this.workspaceService.setWorkspaceRoot(params.getRootUri().replaceAll("([^/])$", "$1/"));
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        capabilities.setFoldingRangeProvider(Boolean.valueOf(true));
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.valueOf(false), Arrays.asList("$", "[")));
        capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList(" ")));
        capabilities.setHoverProvider(Boolean.valueOf(true));
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setCodeActionProvider(Boolean.valueOf(true));
        capabilities.setExecuteCommandProvider(new ExecuteCommandOptions());
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        capabilities.setDocumentLinkProvider(new DocumentLinkOptions());
        capabilities.setRenameProvider(Boolean.valueOf(true));
        return CompletableFuture.completedFuture(new InitializeResult(capabilities));
    }

    public void connect(LanguageClient client) {
        this.documentService.connect(client);
    }
}

