/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.soartech.soarls.Configuration;
import com.soartech.soarls.Documents;
import com.soartech.soarls.EntryPoints;
import com.soartech.soarls.SoarFile;
import com.soartech.soarls.analysis.Analysis;
import com.soartech.soarls.analysis.FileAnalysis;
import com.soartech.soarls.analysis.ProcedureCall;
import com.soartech.soarls.analysis.ProcedureDefinition;
import com.soartech.soarls.analysis.ProjectAnalysis;
import com.soartech.soarls.analysis.VariableRetrieval;
import com.soartech.soarls.tcl.TclAstNode;
import com.soartech.soarls.util.Debouncer;
import java.io.PrintStream;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoarDocumentService
implements TextDocumentService {
    private static final Logger LOG = LoggerFactory.getLogger(SoarDocumentService.class);
    public final Documents documents = new Documents();
    private final ConcurrentHashMap<URI, ProjectAnalysis> analyses = new ConcurrentHashMap();
    private final ConcurrentHashMap<URI, CompletableFuture<ProjectAnalysis>> pendingAnalyses = new ConcurrentHashMap();
    private final Debouncer debouncer = new Debouncer(Duration.ofMillis(1000L));
    private EntryPoints projectConfig = null;
    private URI activeEntryPoint = null;
    private URI workspaceRootUri = null;
    private LanguageClient client;
    private Configuration config = new Configuration();

    public CompletableFuture<ProjectAnalysis> getAnalysis() {
        return this.getAnalysis(this.activeEntryPoint);
    }

    public CompletableFuture<ProjectAnalysis> getAnalysis(URI uri) {
        ProjectAnalysis analysis;
        CompletableFuture<ProjectAnalysis> pending = this.pendingAnalyses.get(uri);
        if (pending != null && pending.isDone()) {
            try {
                this.analyses.put(uri, pending.get());
                this.pendingAnalyses.remove(uri, pending);
            }
            catch (Exception e) {
                LOG.error("Retrieving result of analysis", (Throwable)e);
            }
        }
        return (analysis = this.analyses.get(uri)) == null ? pending : CompletableFuture.completedFuture(analysis);
    }

    private URI tclExpansionUri() {
        URI uri = URI.create(this.workspaceRootUri.toString() + this.config.tclExpansionFile);
        return uri;
    }

    private CompletableFuture<SoarFile> tclExpansionFile() {
        return Optional.ofNullable(this.documents.get(this.tclExpansionUri())).map(f -> CompletableFuture.completedFuture(f)).orElseGet(() -> {
            CreateFile createFile = new CreateFile(this.tclExpansionUri().toString(), new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)));
            WorkspaceEdit edit = new WorkspaceEdit(Arrays.asList(Either.forRight((Object)createFile)));
            ApplyWorkspaceEditParams params = new ApplyWorkspaceEditParams(edit, "create expansion file");
            return this.client.applyEdit(params).thenApply(response -> this.documents.get(this.tclExpansionUri()));
        });
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        TextDocumentItem doc = params.getTextDocument();
        SoarFile soarFile = this.documents.open(doc);
        if (this.activeEntryPoint == null) {
            this.activeEntryPoint = soarFile.uri;
            this.scheduleAnalysis();
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didClose(DidCloseTextDocumentParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        this.documents.close(uri);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        this.documents.applyChanges(params);
        boolean changeAffectsAnalysis = Optional.ofNullable(this.getAnalysis(this.activeEntryPoint).getNow(null)).map(analysis -> analysis.files.containsKey((Object)uri)).orElse(false);
        if (changeAffectsAnalysis) {
            this.scheduleAnalysis();
        }
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        Function<FileAnalysis, String> concatSelectedProductions = fileAnalysis -> {
            int startOffset = fileAnalysis.file.offset(params.getRange().getStart());
            int endOffset = fileAnalysis.file.offset(params.getRange().getEnd());
            return fileAnalysis.productions.entrySet().stream().filter(entry -> ((TclAstNode)entry.getKey()).getStart() <= endOffset).filter(entry -> ((TclAstNode)entry.getKey()).getEnd() >= startOffset).sorted((a, b) -> ((TclAstNode)a.getKey()).getStart() - ((TclAstNode)b.getKey()).getStart()).flatMap(entry -> ((ImmutableList)entry.getValue()).stream()).map(production -> "sp {" + production.body + "}\n").collect(Collectors.joining("\n"));
        };
        BiFunction<SoarFile, String, ApplyWorkspaceEditParams> makeParams = (file, contents) -> new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(file.uri.toString(), Arrays.asList(new TextEdit(file.rangeForNode(file.ast), contents)))));
        Function<String, CompletableFuture> editFile = contents -> this.tclExpansionFile().thenCompose(file -> this.client.applyEdit((ApplyWorkspaceEditParams)makeParams.apply((SoarFile)file, (String)contents)));
        return ((CompletableFuture)this.getAnalysis(this.activeEntryPoint).thenComposeAsync(analysis -> analysis.file(uri).map(concatSelectedProductions).map(editFile).orElse(CompletableFuture.completedFuture(null)))).thenApply(response -> Arrays.asList(Either.forLeft((Object)new Command("Log source tree", "log-source-tree"))));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(TextDocumentPositionParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        Function<ProjectAnalysis, List> findDefinition = analysis -> analysis.file(uri).map(file -> file.file).flatMap(file -> {
            TclAstNode node = file.tclNode(params.getPosition());
            switch (node.getType()) {
                case 3: {
                    return this.goToDefinitionProcedure((ProjectAnalysis)analysis, (SoarFile)file, node);
                }
                case 7: 
                case 8: {
                    return this.goToDefinitionVariable((ProjectAnalysis)analysis, (SoarFile)file, node);
                }
            }
            return Optional.empty();
        }).map(location -> Collections.singletonList(location)).orElseGet(ArrayList::new);
        return this.getAnalysis().thenApply(findDefinition.andThen(Either::forLeft));
    }

    private Optional<Location> goToDefinitionProcedure(ProjectAnalysis projectAnalysis, SoarFile file, TclAstNode node) {
        String name = file.getNodeInternalText(node);
        return Optional.ofNullable(projectAnalysis.procedureDefinitions.get((Object)name)).map(def -> def.location);
    }

    private Optional<Location> goToDefinitionVariable(ProjectAnalysis projectAnalysis, SoarFile file, TclAstNode node) {
        FileAnalysis fileAnalysis = projectAnalysis.file(file.uri).orElse(null);
        LOG.trace("Looking up definition of variable at node {}", (Object)node);
        return fileAnalysis.variableRetrieval(node).flatMap(r -> r.definition).map(def -> def.location);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.getAnalysis(this.activeEntryPoint).thenApply(analysis -> {
            URI thisFileUri = SoarDocumentService.uri(params.getTextDocument().getUri());
            FileAnalysis thisFileAnalysis = analysis.file(thisFileUri).orElse(null);
            SoarFile file = thisFileAnalysis.file;
            TclAstNode node = file.tclNode(params.getPosition());
            String oldName = file.contents.substring(node.getStart(), node.getEnd());
            HashMap textEdits = new HashMap();
            for (FileAnalysis otherFileAnalysis : analysis.files.values()) {
                SoarFile otherFile = otherFileAnalysis.file;
                String otherFileUriString = otherFile.uri.toString();
                TclAstNode root = otherFile.ast;
                String contents = otherFile.contents;
                for (TclAstNode childNode : root.leafNodes()) {
                    int end;
                    int start = childNode.getStart();
                    if (!contents.substring(start, end = childNode.getEnd()).equals(oldName)) continue;
                    Range range = new Range(otherFile.position(start), otherFile.position(end));
                    textEdits.putIfAbsent(otherFileUriString, new ArrayList());
                    ((List)textEdits.get(otherFileUriString)).add(new TextEdit(range, params.getNewName()));
                }
            }
            return new WorkspaceEdit(textEdits);
        });
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.getAnalysis(this.activeEntryPoint).thenApply(analysis -> {
            URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
            SoarFile file = this.documents.get(uri);
            String line = file.line(params.getPosition().getLine());
            int cursor = params.getPosition().getCharacter();
            if (cursor >= line.length()) {
                return Either.forLeft(new ArrayList());
            }
            int start = -1;
            ImmutableSet source = null;
            CompletionItemKind kind = CompletionItemKind.Function;
            for (int i = cursor; i >= 0; --i) {
                switch (line.charAt(i)) {
                    case '$': {
                        source = analysis.variableDefinitions.keySet();
                        kind = CompletionItemKind.Constant;
                        break;
                    }
                    case ' ': 
                    case '[': {
                        source = analysis.procedureDefinitions.keySet();
                        kind = CompletionItemKind.Function;
                    }
                }
                if (source == null) continue;
                start = i + 1;
                break;
            }
            if (source == null) {
                source = analysis.procedureDefinitions.keySet();
                kind = CompletionItemKind.Function;
                start = 0;
            }
            CompletionItemKind itemKind = kind;
            if (start >= line.length()) {
                start = line.length() - 1;
            }
            if (start < 0) {
                start = 0;
            }
            if (cursor > line.length()) {
                cursor = line.length();
            }
            if (cursor < start) {
                cursor = start;
            }
            String prefix = line.substring(start, cursor);
            List completions = source.stream().filter(s -> s.startsWith(prefix)).map(CompletionItem::new).peek(item -> item.setKind(itemKind)).collect(Collectors.toList());
            return Either.forLeft(completions);
        });
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        SoarFile file = this.documents.get(uri);
        int offset = file.offset(params.getPosition());
        List highlights = file.ast.getChildren().stream().filter(node -> node.getType() != 1).filter(node -> node.getStart() <= offset && offset <= node.getEnd()).map(node -> new Range(file.position(node.getStart()), file.position(node.getEnd() + 1))).map(DocumentHighlight::new).collect(Collectors.toList());
        return CompletableFuture.completedFuture(highlights);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        SoarFile file = this.documents.get(uri);
        List ranges = file.ast.getChildren().stream().map(c -> {
            FoldingRange range = new FoldingRange(file.position(c.getStart()).getLine(), file.position(c.getStart() + c.getLength() - 1).getLine());
            if (c.getType() == 2) {
                range.setKind("region");
            } else if (c.getType() == 1) {
                range.setKind("comment");
            }
            return range;
        }).filter(r -> r.getStartLine() < r.getEndLine()).collect(Collectors.toList());
        return CompletableFuture.completedFuture(ranges);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        Function<FileAnalysis, Hover> getHover = analysis -> {
            Function<TclAstNode, Hover> hoverVariable = node -> {
                VariableRetrieval retrieval = (VariableRetrieval)analysis.variableRetrievals.get(node);
                if (retrieval == null) {
                    return null;
                }
                String value = retrieval.definition.map(def -> def.value).orElse("");
                Range range = analysis.file.rangeForNode((TclAstNode)node);
                return new Hover(new MarkupContent("plaintext", value), range);
            };
            String prefix = this.config.renderHoverVerbatim != false ? "    " : "";
            Function<ProcedureCall, Optional> hoverText = call -> call.definition.flatMap(def -> def.commentText).map(comment -> Arrays.stream(comment.split("\n")).map(line -> line.replaceAll("\\s*#\\s?", "")).map(line -> prefix + line)).flatMap(lines -> this.config.fullCommentHover != false ? Optional.of(lines.collect(Collectors.joining("\n"))) : lines.filter(line -> !line.isEmpty()).findFirst());
            Function<TclAstNode, Hover> hoverProcedureCall = node -> analysis.procedureCall((TclAstNode)node).filter(call -> call.callSiteAst.getChildren().get(0) == node).map(call -> {
                SoarFile file = analysis.file;
                String value = ((Optional)hoverText.apply((ProcedureCall)call)).orElse(file.getNodeInternalText((TclAstNode)node));
                List<TclAstNode> callChildren = call.callSiteAst.getChildren();
                Range range = new Range(file.position(callChildren.get(0).getStart()), file.position(callChildren.get(0).getEnd()));
                return new Hover(new MarkupContent("markdown", value), range);
            }).orElse(null);
            SoarFile file = analysis.file;
            TclAstNode hoveredNode = file.tclNode(params.getPosition());
            switch (hoveredNode.getType()) {
                case 7: {
                    return hoverVariable.apply(hoveredNode);
                }
                case 8: {
                    return hoverVariable.apply(hoveredNode.getParent());
                }
            }
            return hoverProcedureCall.apply(hoveredNode);
        };
        return this.getAnalysis(this.activeEntryPoint).thenApply(projectAnalysis -> {
            URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
            return projectAnalysis.file(uri).map(getHover).orElse(null);
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.getAnalysis(this.activeEntryPoint).thenApply(analysis -> {
            URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
            FileAnalysis fileAnalysis = analysis.file(uri).orElse(null);
            TclAstNode astNode = fileAnalysis.file.tclNode(params.getPosition());
            ArrayList references = new ArrayList();
            Optional<Object> procDef = fileAnalysis.procedureCall(astNode).flatMap(call -> call.definition);
            if (!procDef.isPresent()) {
                procDef = fileAnalysis.procedureDefinitions.stream().filter(def -> def.ast.containsChild(astNode)).findFirst();
            }
            procDef.ifPresent(def -> {
                for (ProcedureCall call : (ImmutableList)analysis.procedureCalls.get(def)) {
                    references.add(call.callSiteLocation);
                }
            });
            Optional<Object> varDef = fileAnalysis.variableRetrieval(astNode).flatMap(ret -> ret.definition);
            if (!varDef.isPresent()) {
                varDef = analysis.variableRetrievals.keySet().stream().filter(def -> def.ast.containsChild(astNode)).findFirst();
            }
            varDef.ifPresent(def -> {
                for (VariableRetrieval ret : (ImmutableList)analysis.variableRetrievals.get(def)) {
                    references.add(ret.readSiteLocation);
                }
            });
            return references;
        });
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        BiFunction<ProcedureDefinition, Integer, SignatureInformation> makeSignatureInfo = (def, argsIncluded) -> {
            String label = def.name + " " + def.arguments.stream().limit(argsIncluded.intValue()).map(arg -> arg.name).collect(Collectors.joining(" "));
            List parameters = def.arguments.stream().limit(argsIncluded.intValue()).map(arg -> new ParameterInformation(arg.name)).collect(Collectors.toList());
            return new SignatureInformation(label, "", parameters);
        };
        BiFunction<ProcedureCall, Integer, Optional> makeSignatureHelp = (call, cursorOffset) -> {
            ProcedureDefinition def = call.definition.orElse(null);
            if (def == null) {
                return Optional.empty();
            }
            long requiredArgs = def.arguments.stream().filter(arg -> !arg.defaultValue.isPresent()).count();
            int totalArgs = def.arguments.size();
            List signatures = IntStream.rangeClosed((int)requiredArgs, totalArgs).mapToObj(argsIncluded -> (SignatureInformation)makeSignatureInfo.apply(def, argsIncluded)).collect(Collectors.toList());
            int argumentsFilledIn = call.callSiteAst.getChildren().size() - 1;
            int activeSignature = Math.min(argumentsFilledIn, totalArgs) - (int)requiredArgs;
            Supplier<Integer> getActiveParameter = () -> {
                List<TclAstNode> children = call.callSiteAst.getChildren();
                for (int i = 1; i < children.size(); ++i) {
                    TclAstNode param = children.get(i);
                    if (param.getStart() > cursorOffset || cursorOffset > param.getEnd()) continue;
                    return i - 1;
                }
                return children.size();
            };
            Integer activeParameter = getActiveParameter.get();
            return Optional.of(new SignatureHelp(signatures, Integer.valueOf(activeSignature), activeParameter));
        };
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        return ((CompletableFuture)this.getAnalysis(this.activeEntryPoint).thenApply(project -> project.file(uri).orElse(null))).thenApply(analysis -> {
            TclAstNode cursorNode = analysis.file.tclNode(params.getPosition());
            int cursorOffset = analysis.file.offset(params.getPosition());
            return analysis.procedureCall(cursorNode).flatMap(call -> (Optional)makeSignatureHelp.apply((ProcedureCall)call, cursorOffset)).orElseGet(SignatureHelp::new);
        });
    }

    void connect(LanguageClient client) {
        this.client = client;
    }

    void setWorkspaceRootUri(URI workspaceRootUri) {
        this.workspaceRootUri = workspaceRootUri;
    }

    void setProjectConfig(EntryPoints projectConfig) {
        this.projectConfig = projectConfig;
        this.activeEntryPoint = this.workspaceRootUri.resolve(projectConfig.activeEntryPoint().path);
        this.scheduleAnalysis();
    }

    void setConfiguration(Configuration config) {
        this.config = config;
        if (config.debounceTime != null) {
            LOG.info("Updating debounce time");
            this.debouncer.setDelay(Duration.ofMillis(config.debounceTime.intValue()));
            this.scheduleAnalysis();
        }
    }

    private void scheduleAnalysis() {
        if (this.activeEntryPoint == null) {
            return;
        }
        CompletableFuture future = this.pendingAnalyses.computeIfAbsent(this.activeEntryPoint, key -> new CompletableFuture());
        if (future.isDone()) {
            return;
        }
        this.debouncer.submit(() -> {
            try {
                ProjectAnalysis analysis = Analysis.analyse(this.projectConfig, this.documents, this.activeEntryPoint);
                this.reportDiagnostics(analysis);
                future.complete(analysis);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
    }

    private void reportDiagnostics(ProjectAnalysis projectAnalysis) {
        for (FileAnalysis fileAnalysis : projectAnalysis.files.values()) {
            ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
            diagnosticList.addAll((Collection<Diagnostic>)fileAnalysis.diagnostics);
            diagnosticList.addAll(fileAnalysis.file.getDiagnostics());
            PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams(fileAnalysis.uri.toString(), diagnosticList);
            this.client.publishDiagnostics(diagnostics);
        }
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        URI uri = SoarDocumentService.uri(params.getTextDocument().getUri());
        Function<FileAnalysis, List> collectLinks = fileAnalysis -> {
            SoarFile file = fileAnalysis.file;
            return fileAnalysis.productions.keySet().stream().map(key -> key.getChild(3)).map(node -> new DocumentLink(file.rangeForNode((TclAstNode)node))).peek(link -> link.setTarget(this.tclExpansionUri().toString())).collect(Collectors.toList());
        };
        if (this.config.hyperlinkExpansionFile.booleanValue()) {
            return this.getAnalysis(this.activeEntryPoint).thenApply(analysis -> analysis.file(uri).map(collectLinks).orElse(null));
        }
        return CompletableFuture.completedFuture(new ArrayList());
    }

    static URI uri(String uriString) {
        try {
            return new URI(uriString).normalize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void printAnalysisTree(ProjectAnalysis analysis, PrintStream stream, URI uri, String prefix) {
        String linePrefix = prefix.substring(0, prefix.length() - 4) + "|-- ";
        stream.print(linePrefix + this.workspaceRootUri.relativize(uri));
        FileAnalysis fileAnalysis = analysis.file(uri).orElse(null);
        if (fileAnalysis == null) {
            stream.println(" MISSING");
        } else {
            stream.println();
            for (int i = 0; i != fileAnalysis.filesSourced.size(); ++i) {
                boolean isLast = i == fileAnalysis.filesSourced.size() - 1;
                URI sourcedUri = (URI)fileAnalysis.filesSourced.get(i);
                this.printAnalysisTree(analysis, stream, sourcedUri, prefix + (isLast ? "    " : "|   "));
            }
        }
    }
}

