/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.soartech.soarls.Configuration;
import com.soartech.soarls.EntryPoints;
import com.soartech.soarls.SoarDocumentService;
import com.soartech.soarls.analysis.ProjectAnalysis;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SoarWorkspaceService
implements WorkspaceService {
    private static final Logger LOG = LoggerFactory.getLogger(SoarWorkspaceService.class);
    private static final String SOAR_AGENTS_FILE = "soarAgents.json";
    private final SoarDocumentService documentService;
    private URI workspaceRootUri;
    private EntryPoints soarAgentEntryPoints;

    SoarWorkspaceService(SoarDocumentService documentService) {
        this.documentService = documentService;
    }

    public void setWorkspaceRoot(String workspaceRootUri) {
        LOG.info("Setting workspace root: {}", (Object)workspaceRootUri);
        this.workspaceRootUri = URI.create(workspaceRootUri);
        this.processEntryPoints();
    }

    public void processEntryPoints() {
        LOG.info("Processing entry points: workspace path: " + this.workspaceRootUri);
        this.documentService.setWorkspaceRootUri(this.workspaceRootUri);
        Path soarAgentsPath = Paths.get(this.workspaceRootUri).resolve(SOAR_AGENTS_FILE);
        if (!Files.exists(soarAgentsPath, new LinkOption[0])) {
            LOG.info("Not found: {} -- using default entry point", (Object)soarAgentsPath);
            return;
        }
        try {
            String soarAgentsJson = new String(Files.readAllBytes(soarAgentsPath));
            this.soarAgentEntryPoints = (EntryPoints)new Gson().fromJson(soarAgentsJson, EntryPoints.class);
            if (this.soarAgentEntryPoints.entryPoints.size() == 0) {
                return;
            }
            this.documentService.setProjectConfig(this.soarAgentEntryPoints);
        }
        catch (JsonSyntaxException | IOException e) {
            LOG.error("Error trying to read {}", (Object)soarAgentsPath, (Object)e);
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        JsonObject settings = (JsonObject)params.getSettings();
        Configuration config = (Configuration)new Gson().fromJson(settings.get("soar"), Configuration.class);
        this.documentService.setConfiguration(config);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Gson gson = new Gson();
        if (params.getCommand().equals("log-source-tree")) {
            return ((CompletableFuture)this.documentService.getAnalysis().thenAccept(analysis -> this.documentService.printAnalysisTree((ProjectAnalysis)analysis, System.err, analysis.entryPointUri, "    "))).thenApply(result -> result);
        }
        LOG.warn("Unsupported command: {}", (Object)params.getCommand());
        return CompletableFuture.completedFuture(null);
    }
}

